/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private ImagePlus iplus;
    private ImageJ ij;
    private Thread thread;

    public Executer(String cmd) {
        this.command = cmd;
        this.iplus = WindowManager.getCurrentImage();
        this.ij = IJ.getInstance();
    }

    public Executer(String cmd, ImagePlus imp) {
        this.iplus = imp;
        if (cmd.startsWith("Repeat")) {
            this.command = previousCommand;
        } else {
            this.command = cmd;
            if (!cmd.equals("Undo") && !cmd.equals("Close")) {
                previousCommand = cmd;
            }
        }
        this.ij = IJ.getInstance();
        IJ.resetEscape();
        this.thread = new Thread((Runnable)this, cmd);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block11: {
            if (this.command == null) {
                return;
            }
            ImagePlus imp = this.iplus;
            this.iplus = null;
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command, imp);
                    if (this.command != null) {
                        Recorder.saveCommand();
                    }
                } else {
                    this.runCommand(this.command, imp);
                }
            }
            catch (Throwable e) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                if (imp != null) {
                    imp.unlock();
                }
                String msg = e.getMessage();
                if (e instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (e instanceof RuntimeException && msg != null && msg.equals("Macro canceled")) break block11;
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.isMacintosh()) {
                    if (s.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    s = Tools.fixNewLines(s);
                }
                if (this.ij != null) {
                    new TextWindow("Exception", s, 350, 250);
                }
                IJ.log(s);
            }
        }
    }

    public void runCommand(String cmd, ImagePlus imp) {
        if (cmd.equals("New...")) {
            new NewImage();
        } else if (cmd.equals("Open...")) {
            if (Prefs.useJFileChooser && !IJ.macroRunning()) {
                new Opener().openMultiple();
            } else {
                new Opener().open();
            }
        } else if (cmd.equals("Close")) {
            this.close(imp);
        } else if (cmd.equals("Cut")) {
            this.copy(imp, true);
        } else if (cmd.equals("Copy")) {
            this.copy(imp, false);
        } else if (cmd.equals("ImageJ [enter]")) {
            this.ij.toFront();
        } else if (cmd.equals("Put Behind [tab]")) {
            WindowManager.putBehind();
        } else if (cmd.equals("Quit")) {
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                ij.quit();
            }
        } else {
            Hashtable table = Menus.getCommands();
            String plugIn = (String)table.get(cmd);
            if (plugIn != null) {
                this.runPlugIn(cmd, plugIn);
            } else {
                this.runImageCommand(cmd, imp);
            }
        }
    }

    public void runImageCommand(String cmd, ImagePlus imp) {
        Object win = null;
        if (imp != null && !imp.lock()) {
            return;
        }
        if (cmd.equals("Revert")) {
            if (imp != null) {
                imp.revert();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals("Save")) {
            if (imp != null) {
                new FileSaver(imp).save();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals("Paste")) {
            if (imp != null) {
                imp.paste();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals("Undo")) {
            if (imp != null) {
                Undo.undo();
            } else {
                IJ.noImage();
            }
        } else {
            IJ.error("Unrecognized command: " + cmd);
        }
        if (imp != null) {
            imp.unlock();
        }
    }

    void runPlugIn(String cmd, String className) {
        int argStart;
        String arg = "";
        if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
            arg = className.substring(argStart + 2, className.length() - 2);
            className = className.substring(0, argStart);
        }
        IJ.runPlugIn(cmd, className, arg);
    }

    void roiRequired() {
        IJ.error("Selection required");
    }

    void copy(ImagePlus imp, boolean cut) {
        if (imp == null) {
            IJ.noImage();
            return;
        }
        imp.copy(cut);
    }

    void close(ImagePlus imp) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame == null || Interpreter.isBatchMode() && frame instanceof ImageWindow) {
            this.closeImage(imp);
        } else if (frame instanceof PlugInFrame) {
            ((PlugInFrame)frame).close();
        } else if (frame instanceof TextWindow) {
            ((TextWindow)frame).close();
        } else {
            this.closeImage(imp);
        }
    }

    void closeImage(ImagePlus imp) {
        if (imp == null) {
            IJ.noImage();
            return;
        }
        imp.close();
        if (Recorder.record) {
            Recorder.record("close");
            this.command = null;
        }
    }

    public static String getCommand() {
        return previousCommand;
    }
}

