/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.HTMLDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.MessageDialog;
import ij.gui.NewImage;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.io.PluginClassLoader;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.Macro_Runner;
import ij.plugin.Memory;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class IJ {
    public static boolean debugMode;
    public static boolean hideProcessStackDialog;
    public static final char micronSymbol = '\u00b5';
    public static final char angstromSymbol = '\u00c5';
    public static final char degreeSymbol = '\u00b0';
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static String osname;
    private static boolean isMac;
    private static boolean isWin;
    private static boolean isJava2;
    private static boolean isJava14;
    private static boolean altDown;
    private static boolean spaceDown;
    private static boolean shiftDown;
    private static boolean macroRunning;
    private static Thread previousThread;
    private static TextPanel logPanel;
    private static boolean notVerified;
    private static PluginClassLoader classLoader;
    private static boolean memMessageDisplayed;
    private static long maxMemory;
    private static boolean escapePressed;
    private static boolean redirectErrorMessages;
    private static boolean brokenNewPixels;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat df;
    private static int dfDigits;

    static void init(ImageJ imagej, Applet theApplet) {
        ij = imagej;
        applet = theApplet;
        progressBar = ij.getProgressBar();
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static String runMacro(String macro) {
        return IJ.runMacro(macro, "");
    }

    public static String runMacro(String macro, String arg) {
        Macro_Runner mr = new Macro_Runner();
        return mr.runMacro(macro, arg);
    }

    public static String runMacroFile(String name, String arg) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro_Runner mr = new Macro_Runner();
        return mr.runMacroFile(name, arg);
    }

    public static String runMacroFile(String name) {
        return IJ.runMacroFile(name, null);
    }

    public static Object runPlugIn(String className, String arg) {
        return IJ.runPlugIn("", className, arg);
    }

    static Object runPlugIn(String commandName, String className, String arg) {
        if (debugMode) {
            IJ.log("runPlugin: " + className + " " + arg);
        }
        if (!className.startsWith("ij") && applet == null) {
            boolean createNewClassLoader = IJ.altKeyDown();
            return IJ.runUserPlugIn(commandName, className, arg, createNewClassLoader);
        }
        Object thePlugIn = null;
        try {
            Class<?> c = Class.forName(className);
            thePlugIn = c.newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else {
                IJ.runFilterPlugIn(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException e) {
            if (IJ.getApplet() == null) {
                IJ.log("Plugin not found: " + className);
            }
        }
        catch (InstantiationException e) {
            IJ.log("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.log("Unable to load plugin, possibly \nbecause it is not public.");
        }
        redirectErrorMessages = false;
        return thePlugIn;
    }

    static void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        ImageWindow win;
        boolean doesStacks;
        ImagePlus imp = WindowManager.getCurrentImage();
        int capabilities = ((PlugInFilter)theFilter).setup(arg, imp);
        if ((capabilities & 0x1000) != 0) {
            return;
        }
        if ((capabilities & 0x200) != 0) {
            ((PlugInFilter)theFilter).run(null);
            return;
        }
        if (imp == null) {
            IJ.noImage();
            return;
        }
        Roi roi = imp.getRoi();
        if ((capabilities & 0x400) != 0 && roi == null) {
            IJ.error("Selection required");
            return;
        }
        if ((capabilities & 0x800) != 0 && imp.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        int type = imp.getType();
        switch (type) {
            case 0: {
                if ((capabilities & 1) != 0) break;
                IJ.wrongType(capabilities, cmd);
                return;
            }
            case 3: {
                if ((capabilities & 2) != 0) break;
                IJ.wrongType(capabilities, cmd);
                return;
            }
            case 1: {
                if ((capabilities & 4) != 0) break;
                IJ.wrongType(capabilities, cmd);
                return;
            }
            case 2: {
                if ((capabilities & 8) != 0) break;
                IJ.wrongType(capabilities, cmd);
                return;
            }
            case 4: {
                if ((capabilities & 0x10) != 0) break;
                IJ.wrongType(capabilities, cmd);
                return;
            }
        }
        if (roi != null) {
            roi.endPaste();
        }
        int slices = imp.getStackSize();
        boolean bl = doesStacks = (capabilities & 0x20) != 0;
        if (!imp.lock()) {
            return;
        }
        imp.startTiming();
        IJ.showStatus(cmd + "...");
        ImageStack stack = null;
        if (slices > 1) {
            stack = imp.getStack();
        }
        float[] cTable = imp.getCalibration().getCTable();
        ImageProcessor mask = imp.getMask();
        if (slices == 1 || !doesStacks) {
            ImageProcessor ip = imp.getProcessor();
            if ((capabilities & 0x100) != 0) {
                Undo.reset();
            } else {
                Undo.setup(1, imp);
                ip.snapshot();
            }
            ip.setCalibrationTable(cTable);
            ((PlugInFilter)theFilter).run(ip);
            if ((capabilities & 0x40) != 0) {
                ip.reset(ip.getMask());
            }
            IJ.showTime(imp, imp.getStartTime(), cmd + ": ", 1);
        } else {
            boolean doMasking;
            Undo.reset();
            int n = stack.getSize();
            int currentSlice = imp.getCurrentSlice();
            Rectangle r = null;
            if (roi != null && roi.isArea()) {
                r = roi.getBounds();
            }
            ImageProcessor ip = imp.getProcessor();
            double minThreshold = ip.getMinThreshold();
            double maxThreshold = ip.getMaxThreshold();
            ip = stack.getProcessor(1);
            ip.setLineWidth(Line.getWidth());
            boolean bl2 = doMasking = roi != null && roi.getType() != 0 && (capabilities & 0x40) != 0;
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            boolean doGarbageCollection = IJ.isWindows() && !IJ.isJava2();
            ip.setMask(mask);
            ip.setRoi(r);
            ip.setCalibrationTable(cTable);
            IJ.resetEscape();
            for (int i = 1; i <= n; ++i) {
                ip.setPixels(stack.getPixels(i));
                if (doMasking) {
                    ip.snapshot();
                }
                ((PlugInFilter)theFilter).run(ip);
                if (doMasking) {
                    ip.reset(ip.getMask());
                }
                if (doGarbageCollection && i % 10 == 0) {
                    System.gc();
                }
                IJ.showProgress(i, n);
                if (!IJ.escapePressed()) continue;
                IJ.beep();
                break;
            }
            if (roi != null) {
                imp.setRoi(roi);
            }
            IJ.showProgress(1.0);
            IJ.showTime(imp, imp.getStartTime(), cmd + ": ", n);
        }
        if ((capabilities & 0x80) == 0) {
            imp.changes = true;
            imp.updateAndDraw();
        }
        if ((win = imp.getWindow()) != null) {
            win.running = false;
            win.running2 = false;
        }
        imp.unlock();
    }

    static Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        PluginClassLoader loader;
        if (applet != null) {
            return null;
        }
        String pluginsDir = Menus.getPlugInsPath();
        if (pluginsDir == null) {
            return null;
        }
        if (notVerified) {
            IJ.runPlugIn("ij.plugin.ClassChecker", "");
            notVerified = false;
        }
        if (createNewLoader) {
            loader = new PluginClassLoader(pluginsDir);
        } else {
            if (classLoader == null) {
                classLoader = new PluginClassLoader(pluginsDir);
            }
            loader = classLoader;
        }
        Object thePlugIn = null;
        try {
            thePlugIn = loader.loadClass(className).newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else if (thePlugIn instanceof PlugInFilter) {
                IJ.runFilterPlugIn(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(95) != -1) {
                IJ.error("Plugin not found: " + className);
            }
        }
        catch (NoClassDefFoundError e) {
            if (className.indexOf(95) != -1) {
                IJ.error("Plugin not found: " + className);
            }
        }
        catch (InstantiationException e) {
            IJ.error("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.error("Unable to load plugin, possibly \nbecause it is not public.");
        }
        redirectErrorMessages = false;
        return thePlugIn;
    }

    static void wrongType(int capabilities, String cmd) {
        String s = "\"" + cmd + "\" requires an image of type:\n \n";
        if ((capabilities & 1) != 0) {
            s = s + "    8-bit grayscale\n";
        }
        if ((capabilities & 2) != 0) {
            s = s + "    8-bit color\n";
        }
        if ((capabilities & 4) != 0) {
            s = s + "    16-bit grayscale\n";
        }
        if ((capabilities & 8) != 0) {
            s = s + "    32-bit (float) grayscale\n";
        }
        if ((capabilities & 0x10) != 0) {
            s = s + "    RGB color\n";
        }
        IJ.error(s);
    }

    public static void doCommand(String command) {
        if (ij != null) {
            ij.doCommand(command);
        }
    }

    public static void run(String command) {
        IJ.run(command, null);
    }

    public static void run(String command, String options) {
        String name;
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Macro.abort = false;
        Macro.setOptions(options);
        Thread thread = Thread.currentThread();
        if (!(previousThread != null && thread == previousThread || (name = thread.getName()).startsWith("Run$_"))) {
            thread.setName("Run$_" + name);
        }
        if (command.equals("Miscellaneous...")) {
            command = "Misc...";
        }
        previousThread = thread;
        macroRunning = true;
        Executer e = new Executer(command);
        e.run();
        macroRunning = false;
        Macro.setOptions(null);
        IJ.testAbort();
    }

    static void init() {
        Menus m = new Menus(null, null);
        Prefs.load(m, null);
        m.addMenuBar();
    }

    private static void testAbort() {
        if (Macro.abort) {
            IJ.abort();
        }
    }

    public static boolean macroRunning() {
        return macroRunning;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String s) {
        if (ij != null) {
            ij.showStatus(s);
        }
    }

    public static void write(String s) {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        if (textPanel != null) {
            textPanel.append(s);
        } else {
            System.out.println(s);
        }
    }

    private static void showResults() {
        TextWindow resultsWindow = new TextWindow("Results", "", 300, 200);
        textPanel = resultsWindow.getTextPanel();
        if (ij != null) {
            textPanel.addKeyListener(ij);
        }
    }

    public static synchronized void log(String s) {
        if (s == null) {
            return;
        }
        if (logPanel == null && ij != null) {
            TextWindow logWindow = new TextWindow("Log", "", 300, 200);
            logPanel = logWindow.getTextPanel();
        }
        if (logPanel != null) {
            if (s.equals("$Closed")) {
                logPanel = null;
            } else {
                logPanel.append(s);
            }
        } else {
            System.out.println(s);
        }
    }

    public static void setColumnHeadings(String headings) {
        if (textPanel == null && ij != null) {
            IJ.showResults();
        }
        if (textPanel != null) {
            textPanel.setColumnHeadings(headings);
        } else {
            System.out.println(headings);
        }
    }

    public static boolean isResultsWindow() {
        return textPanel != null;
    }

    public static TextPanel getTextPanel() {
        if (textPanel == null) {
            IJ.showResults();
        }
        return textPanel;
    }

    public static void setTextPanel(TextPanel tp) {
        textPanel = tp;
    }

    public static void noImage() {
        IJ.error("No Image", "There are no images open.");
    }

    public static void outOfMemory(String name) {
        Undo.reset();
        System.gc();
        String tot = Runtime.getRuntime().totalMemory() / 0x100000L + "MB";
        if (!memMessageDisplayed) {
            IJ.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        IJ.log("<Out of memory>");
        if (!memMessageDisplayed) {
            IJ.log("<All available memory (" + tot + ") has been>");
            IJ.log("<used. Instructions for making more>");
            IJ.log("<available can be found in the \"Memory\" >");
            IJ.log("<sections of the installation notes at>");
            IJ.log("<http://rsb.info.nih.gov/ij/docs/install/>");
            IJ.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
            memMessageDisplayed = true;
        }
        Macro.abort();
    }

    public static void showProgress(double progress) {
        if (progressBar != null) {
            progressBar.show(progress);
        }
    }

    public static void showProgress(int currentIndex, int finalIndex) {
        if (progressBar != null) {
            progressBar.show(currentIndex, finalIndex);
        }
    }

    public static void showMessage(String msg) {
        IJ.showMessage("Message", msg);
    }

    public static void showMessage(String title, String msg) {
        if (redirectErrorMessages) {
            IJ.log(title + ": " + msg);
            redirectErrorMessages = false;
            return;
        }
        if (ij != null) {
            if (msg.startsWith("<html>") && IJ.isJava2()) {
                new HTMLDialog(title, msg);
            } else {
                new MessageDialog((Frame)ij, title, msg);
            }
        } else {
            System.out.println(msg);
        }
    }

    public static void error(String msg) {
        IJ.showMessage("ImageJ", msg);
        Macro.abort();
    }

    public static synchronized void error(String title, String msg) {
        IJ.showMessage(title, msg);
        Macro.abort();
    }

    public static boolean showMessageWithCancel(String title, String msg) {
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public static double getNumber(String prompt, double defaultValue) {
        GenericDialog gd = new GenericDialog("");
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 2;
        gd.addNumericField(prompt, defaultValue, decimalPlaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -2.147483648E9;
        }
        double v = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return defaultValue;
        }
        return v;
    }

    public static String getString(String prompt, String defaultString) {
        GenericDialog gd = new GenericDialog("");
        gd.addStringField(prompt, defaultString, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return "";
        }
        return gd.getNextString();
    }

    public static void wait(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        System.gc();
        long inUse = IJ.currentMemory();
        String inUseStr = inUse < 10240000L ? inUse / 1024L + "K" : inUse / 0x100000L + "MB";
        String maxStr = "";
        long max = IJ.maxMemory();
        if (max > 0L) {
            double percent = inUse * 100L / max;
            maxStr = " of " + max / 0x100000L + "MB (" + (percent < 1.0 ? "<1" : IJ.d2s(percent, 0)) + "%)";
        }
        return inUseStr + maxStr;
    }

    public static long currentMemory() {
        long freeMem = Runtime.getRuntime().freeMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        return totMem - freeMem;
    }

    public static long maxMemory() {
        Memory mem;
        if (maxMemory == 0L && (maxMemory = (mem = new Memory()).getMemorySetting()) == 0L) {
            maxMemory = mem.maxMemory();
        }
        return maxMemory;
    }

    public static void showTime(ImagePlus imp, long start, String str) {
        IJ.showTime(imp, start, str, 1);
    }

    static void showTime(ImagePlus imp, long start, String str, int nslices) {
        long elapsedTime = System.currentTimeMillis() - start;
        double seconds = (double)elapsedTime / 1000.0;
        long pixels = imp.getWidth() * imp.getHeight();
        int rate = (int)((double)pixels * (double)nslices / seconds);
        String str2 = rate > 1000000000 ? "" : (rate < 1000000 ? ", " + rate + " pixels/second" : ", " + IJ.d2s((double)rate / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(str + seconds + " seconds" + str2);
    }

    public static String d2s(double n) {
        return IJ.d2s(n, 2);
    }

    public static String d2s(double n, int decimalPlaces) {
        String s;
        boolean negative;
        if (n == 3.4028234663852886E38) {
            return "3.4e38";
        }
        double np = n;
        boolean bl = negative = n < 0.0;
        if (negative) {
            np = -n;
        }
        if (np < 0.001 && np != 0.0 && np < 1.0 / Math.pow(10.0, decimalPlaces)) {
            return Float.toString((float)n);
        }
        double whole = Math.round(np * Math.pow(10.0, decimalPlaces));
        double rounded = whole / Math.pow(10.0, decimalPlaces);
        if (negative) {
            rounded = -rounded;
        }
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        if (decimalPlaces != dfDigits) {
            switch (decimalPlaces) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                    break;
                }
                case 9: {
                    df.applyPattern("0.000000000");
                    dfDigits = 9;
                }
            }
        }
        if ((s = df.format(rounded)).length() > 12) {
            s = Float.toString((float)n);
        }
        return s;
    }

    public static void register(Class c) {
        if (ij != null) {
            ij.register(c);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    public static boolean shiftKeyDown() {
        return shiftDown;
    }

    public static void setKeyDown(int key) {
        switch (key) {
            case 18: {
                altDown = true;
                break;
            }
            case 16: {
                shiftDown = true;
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow win = WindowManager.getCurrentWindow();
                if (win == null) break;
                win.getCanvas().setCursor(-1, -1, -1, -1);
                break;
            }
            case 27: {
                escapePressed = true;
            }
        }
    }

    public static void setKeyUp(int key) {
        switch (key) {
            case 18: {
                altDown = false;
                break;
            }
            case 16: {
                shiftDown = false;
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow win = WindowManager.getCurrentWindow();
                if (win == null) break;
                win.getCanvas().setCursor(-1, -1, -1, -1);
                break;
            }
        }
    }

    public static void setInputEvent(InputEvent e) {
        altDown = e.isAltDown();
        shiftDown = e.isShiftDown();
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return IJ.isMacintosh() && IJ.isJava2();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isJava2() {
        return isJava2;
    }

    public static boolean isJava14() {
        return isJava14;
    }

    public static boolean versionLessThan(String version) {
        boolean lessThan;
        boolean bl = lessThan = "1.35q".compareTo(version) < 0;
        if (lessThan) {
            IJ.error("This plugin or macro requires ImageJ " + version + " or later.");
        }
        return lessThan;
    }

    public static int setupDialog(ImagePlus imp, int flags) {
        if (imp == null || ij != null && IJ.ij.hotkey || hideProcessStackDialog) {
            return flags;
        }
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                if (macroOptions.indexOf("stack ") >= 0) {
                    return flags + 32;
                }
                return flags;
            }
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + stackSize + " slices?  There is\n" + "no Undo if you select \"Yes\".");
            if (d.cancelPressed()) {
                return 4096;
            }
            if (d.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return flags + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return flags;
    }

    public static void makeRectangle(int x, int y, int width, int height) {
        if (width <= 0 || height < 0) {
            IJ.getImage().killRoi();
        } else {
            ImagePlus img = IJ.getImage();
            img.setRoi(x, y, width, height);
        }
    }

    public static void makeOval(int x, int y, int width, int height) {
        if (width <= 0 || height < 0) {
            IJ.getImage().killRoi();
        } else {
            ImagePlus img = IJ.getImage();
            img.setRoi(new OvalRoi(x, y, width, height));
        }
    }

    public static void makeLine(int x1, int y1, int x2, int y2) {
        IJ.getImage().setRoi(new Line(x1, y1, x2, y2));
    }

    public static void setMinAndMax(double min, double max) {
        ImagePlus img = IJ.getImage();
        if (img.getBitDepth() == 16) {
            Calibration cal = img.getCalibration();
            min = cal.getRawValue(min);
            max = cal.getRawValue(max);
        }
        img.getProcessor().setMinAndMax(min, max);
        img.updateAndDraw();
    }

    public static void resetMinAndMax() {
        ImagePlus img = IJ.getImage();
        img.getProcessor().resetMinAndMax();
        img.updateAndDraw();
    }

    public static void setThreshold(double lowerThreshold, double upperThresold) {
        IJ.setThreshold(lowerThreshold, upperThresold, null);
    }

    public static void setThreshold(double lowerThreshold, double upperThreshold, String displayMode) {
        ImagePlus img;
        int mode = 0;
        if (displayMode != null) {
            if ((displayMode = displayMode.toLowerCase(Locale.US)).indexOf("black") != -1) {
                mode = 1;
            } else if (displayMode.indexOf("over") != -1) {
                mode = 3;
            } else if (displayMode.indexOf("no") != -1) {
                mode = 2;
            }
        }
        if ((img = IJ.getImage()).getBitDepth() == 16) {
            Calibration cal = img.getCalibration();
            lowerThreshold = cal.getRawValue(lowerThreshold);
            upperThreshold = cal.getRawValue(upperThreshold);
        }
        img.getProcessor().setThreshold(lowerThreshold, upperThreshold, mode);
        if (mode != 2) {
            img.getProcessor().setLutAnimation(true);
            img.updateAndDraw();
        }
    }

    public static void resetThreshold() {
        ImagePlus img = IJ.getImage();
        ImageProcessor ip = img.getProcessor();
        ip.resetThreshold();
        ip.setLutAnimation(true);
        img.updateAndDraw();
    }

    public static void selectWindow(int id) {
        ImagePlus imp = WindowManager.getImage(id);
        if (imp == null) {
            IJ.error("Macro Error", "Image " + id + " not found or no images are open.");
        }
        String title = imp.getTitle();
        if (Interpreter.isBatchMode()) {
            ImagePlus imp2 = WindowManager.getCurrentImage();
            if (imp2 != null && imp2 != imp) {
                imp2.saveRoi();
            }
        } else {
            ImageWindow win = imp.getWindow();
            win.toFront();
            WindowManager.setWindow(win);
            long start = System.currentTimeMillis();
            String thread = Thread.currentThread().getName();
            int timeout = thread != null && thread.indexOf("EventQueue") != -1 ? 0 : 2000;
            do {
                IJ.wait(10);
                imp = WindowManager.getCurrentImage();
                if (imp == null || !imp.getTitle().equals(title)) continue;
                return;
            } while (System.currentTimeMillis() - start <= (long)timeout);
            WindowManager.setCurrentWindow(win);
            return;
        }
        WindowManager.setTempCurrentImage(imp);
        WindowManager.setWindow(null);
    }

    public static void selectWindow(String title) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 3000L) {
            Frame frame = WindowManager.getFrame(title);
            if (frame != null && !(frame instanceof ImageWindow)) {
                IJ.selectWindow(frame);
                return;
            }
            int[] wList = WindowManager.getIDList();
            int len = wList != null ? wList.length : 0;
            for (int i = 0; i < len; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp == null || !imp.getTitle().equals(title)) continue;
                IJ.selectWindow(imp.getID());
                return;
            }
            IJ.wait(10);
        }
        IJ.error("Macro Error", "No window with the title \"" + title + "\" found.");
    }

    static void selectWindow(Frame frame) {
        frame.toFront();
        long start = System.currentTimeMillis();
        do {
            IJ.wait(10);
            if (WindowManager.getFrontWindow() != frame) continue;
            return;
        } while (System.currentTimeMillis() - start <= 1000L);
        WindowManager.setWindow(frame);
    }

    public static void setForegroundColor(int red, int green, int blue) {
        IJ.setColor(red, green, blue, true);
    }

    public static void setBackgroundColor(int red, int green, int blue) {
        IJ.setColor(red, green, blue, false);
    }

    static void setColor(int red, int green, int blue, boolean foreground) {
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        Color c = new Color(red, green, blue);
        if (foreground) {
            Toolbar.setForegroundColor(c);
            ImagePlus img = WindowManager.getCurrentImage();
            if (img != null) {
                img.getProcessor().setColor(c);
            }
        } else {
            Toolbar.setBackgroundColor(c);
        }
    }

    public static void setTool(int id) {
        Toolbar.getInstance().setTool(id);
    }

    public static int doWand(int x, int y) {
        ImagePlus img = IJ.getImage();
        ImageProcessor ip = img.getProcessor();
        if (img.getType() == 2 && Double.isNaN(ip.getPixelValue(x, y))) {
            return 0;
        }
        Wand w = new Wand(ip);
        double t1 = ip.getMinThreshold();
        if (t1 == -808080.0) {
            w.autoOutline(x, y);
        } else {
            w.autoOutline(x, y, t1, ip.getMaxThreshold());
        }
        if (w.npoints > 0) {
            Roi previousRoi = img.getRoi();
            PolygonRoi roi = new PolygonRoi(w.xpoints, w.ypoints, w.npoints, 4);
            img.setRoi(roi);
            if (previousRoi != null && (IJ.shiftKeyDown() || IJ.altKeyDown())) {
                roi.addOrSubtract();
            }
        }
        return w.npoints;
    }

    public static void setPasteMode(String mode) {
        mode = mode.toLowerCase(Locale.US);
        int m = 0;
        if (mode.startsWith("ble") || mode.startsWith("ave")) {
            m = 7;
        } else if (mode.startsWith("diff")) {
            m = 8;
        } else if (mode.startsWith("tran")) {
            m = 2;
        } else if (mode.startsWith("and")) {
            m = 9;
        } else if (mode.startsWith("or")) {
            m = 10;
        } else if (mode.startsWith("xor")) {
            m = 11;
        } else if (mode.startsWith("sub")) {
            m = 4;
        } else if (mode.startsWith("add")) {
            m = 3;
        } else if (mode.startsWith("div")) {
            m = 6;
        } else if (mode.startsWith("mul")) {
            m = 5;
        }
        Roi.setPasteMode(m);
    }

    public static ImagePlus getImage() {
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            IJ.noImage();
            IJ.abort();
        }
        return img;
    }

    public static String getVersion() {
        return "1.35q";
    }

    public static String getDirectory(String title) {
        if (title.equals("plugins")) {
            return Menus.getPlugInsPath();
        }
        if (title.equals("macros")) {
            return Menus.getMacrosPath();
        }
        if (title.equals("home")) {
            return System.getProperty("user.home") + File.separator;
        }
        if (title.equals("startup")) {
            return System.getProperty("user.dir") + File.separator;
        }
        if (title.equals("temp")) {
            String dir = System.getProperty("java.io.tmpdir");
            if (dir != null && !dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            return dir;
        }
        if (title.equals("image")) {
            FileInfo fi;
            ImagePlus imp = WindowManager.getCurrentImage();
            FileInfo fileInfo = fi = imp != null ? imp.getOriginalFileInfo() : null;
            if (fi != null && fi.directory != null) {
                return fi.directory;
            }
            return null;
        }
        DirectoryChooser dc = new DirectoryChooser(title);
        String dir = dc.getDirectory();
        if (dir == null) {
            Macro.abort();
        }
        return dir;
    }

    public static void open() {
        IJ.open(null);
    }

    public static void open(String path) {
        if (ij == null && Menus.getCommands() == null) {
            IJ.init();
        }
        Opener o = new Opener();
        macroRunning = true;
        if (path == null || path.equals("")) {
            o.open();
        } else {
            o.open(path);
        }
        macroRunning = false;
    }

    public static ImagePlus openImage(String path) {
        return new Opener().openImage(path);
    }

    public static void save(String path) {
        int dotLoc = path.lastIndexOf(46);
        if (dotLoc != -1) {
            IJ.saveAs(path.substring(dotLoc + 1), path);
        } else {
            IJ.error("The save() macro function requires a file name extension.\n \n" + path);
        }
    }

    public static void saveAs(String format, String path) {
        if (format == null) {
            return;
        }
        if (path != null && path.length() == 0) {
            path = null;
        }
        if ((format = format.toLowerCase(Locale.US)).indexOf("tif") != -1) {
            path = IJ.updateExtension(path, ".tif");
            format = "Tiff...";
        } else if (format.indexOf("jpeg") != -1 || format.indexOf("jpg") != -1) {
            path = IJ.updateExtension(path, ".jpg");
            format = "Jpeg...";
        } else if (format.indexOf("gif") != -1) {
            path = IJ.updateExtension(path, ".gif");
            format = "Gif...";
        } else if (format.indexOf("text image") != -1) {
            path = IJ.updateExtension(path, ".txt");
            format = "Text Image...";
        } else if (format.indexOf("text") != -1 || format.indexOf("txt") != -1) {
            path = IJ.updateExtension(path, ".txt");
            format = "Text...";
        } else if (format.indexOf("zip") != -1) {
            path = IJ.updateExtension(path, ".zip");
            format = "ZIP...";
        } else if (format.indexOf("raw") != -1) {
            path = IJ.updateExtension(path, ".raw");
            format = "Raw Data...";
        } else if (format.indexOf("avi") != -1) {
            path = IJ.updateExtension(path, ".avi");
            format = "AVI... ";
        } else if (format.indexOf("bmp") != -1) {
            path = IJ.updateExtension(path, ".bmp");
            format = "BMP...";
        } else if (format.indexOf("lut") != -1) {
            path = IJ.updateExtension(path, ".lut");
            format = "LUT...";
        } else if (format.indexOf("measurements") != -1) {
            format = "Measurements...";
        } else if (format.indexOf("selection") != -1 || format.indexOf("roi") != -1) {
            path = IJ.updateExtension(path, ".roi");
            format = "Selection...";
        } else if (format.indexOf("xy") != -1 || format.indexOf("coordinates") != -1) {
            path = IJ.updateExtension(path, ".txt");
            format = "XY Coordinates...";
        } else {
            IJ.error("Unrecognized format: " + format);
        }
        if (path == null) {
            IJ.run(format);
        } else {
            IJ.run(format, "save=[" + path + "]");
        }
    }

    static String updateExtension(String path, String extension) {
        if (path == null) {
            return null;
        }
        int dotIndex = path.lastIndexOf(".");
        path = dotIndex >= 0 ? path.substring(0, dotIndex) + extension : path + extension;
        return path;
    }

    public static ImagePlus createImage(String title, String type, int width, int height, int depth) {
        type = type.toLowerCase(Locale.US);
        int bitDepth = 8;
        if (type.indexOf("16") != -1) {
            bitDepth = 16;
        }
        if (type.indexOf("rgb") != -1) {
            bitDepth = 24;
        }
        if (type.indexOf("32") != -1) {
            bitDepth = 32;
        }
        int options = 4;
        if (bitDepth == 16 || bitDepth == 32) {
            options = 1;
        }
        if (type.indexOf("white") != -1) {
            options = 4;
        } else if (type.indexOf("black") != -1) {
            options = 1;
        } else if (type.indexOf("ramp") != -1) {
            options = 2;
        }
        return NewImage.createImage(title, width, height, depth, bitDepth, options += 8);
    }

    public static void newImage(String title, String type, int width, int height, int depth) {
        ImagePlus imp = IJ.createImage(title, type, width, height, depth);
        if (imp != null) {
            macroRunning = true;
            imp.show();
            macroRunning = false;
        }
    }

    public static boolean escapePressed() {
        return escapePressed;
    }

    public static void resetEscape() {
        escapePressed = false;
    }

    public static void redirectErrorMessages() {
        redirectErrorMessages = true;
    }

    public static boolean brokenNewPixels() {
        return brokenNewPixels;
    }

    static void abort() {
        if (ij != null || Interpreter.isBatchMode()) {
            throw new RuntimeException("Macro canceled");
        }
    }

    static {
        notVerified = true;
        osname = System.getProperty("os.name");
        isWin = osname.startsWith("Windows");
        isMac = !isWin && osname.startsWith("Mac");
        String version = System.getProperty("java.version").substring(0, 3);
        isJava2 = version.compareTo("1.1") > 0 && version.compareTo("2.9") <= 0;
        isJava14 = version.compareTo("1.3") > 0 && version.compareTo("2.9") <= 0;
        brokenNewPixels = isMac && !isJava2 || version.startsWith("1.4") || osname.startsWith("Linux");
        df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        dfDigits = 2;
    }
}

