/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.Menus;
import ij.gui.NewImage;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.ImportDialog;
import ij.io.OpenDialog;
import ij.plugin.Animator;
import ij.plugin.GelAnalyzer;
import ij.plugin.JpegWriter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filters;
import ij.plugin.filter.ParticleAnalyzer;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class Prefs {
    public static final String PROPS_NAME = "IJ_Props.txt";
    public static final String PREFS_NAME = "IJ_Prefs.txt";
    public static final String DIR_IMAGE = "dir.image";
    public static final String FCOLOR = "fcolor";
    public static final String BCOLOR = "bcolor";
    public static final String ROICOLOR = "roicolor";
    public static final String JPEG = "jpeg";
    public static final String FPS = "fps";
    public static final String DIV_BY_ZERO_VALUE = "div-by-zero";
    public static final String NOISE_SD = "noise.sd";
    public static final String KEY_PREFIX = ".";
    private static final int USE_POINTER = 1;
    private static final int ANTIALIASING = 2;
    private static final int INTERPOLATE = 4;
    private static final int ONE_HUNDRED_PERCENT = 8;
    private static final int BLACK_BACKGROUND = 16;
    private static final int JFILE_CHOOSER = 32;
    private static final int UNUSED = 64;
    private static final int BLACK_CANVAS = 128;
    private static final int WEIGHTED = 256;
    private static final int AUTO_MEASURE = 512;
    private static final int REQUIRE_CONTROL = 1024;
    private static final int USE_INVERTING_LUT = 2048;
    public static final String OPTIONS = "prefs.options";
    public static String separator = System.getProperty("file.separator");
    public static boolean usePointerCursor;
    public static boolean antialiasedText;
    public static boolean interpolateScaledImages;
    public static boolean open100Percent;
    public static boolean blackBackground;
    public static boolean useJFileChooser;
    public static boolean weightedColor;
    public static boolean blackCanvas;
    public static boolean pointAutoMeasure;
    public static boolean pointAutoNextSlice;
    public static boolean requireControlKey;
    public static boolean useInvertingLut;
    static Properties ijPrefs;
    static Properties props;
    static String prefsDir;
    static String imagesURL;
    static String homeDir;

    public static String load(Object ij, Applet applet) {
        InputStream f = ij.getClass().getResourceAsStream("/IJ_Props.txt");
        if (applet != null) {
            return Prefs.loadAppletProps(f, applet);
        }
        if (homeDir == null) {
            homeDir = System.getProperty("user.dir");
        }
        String userHome = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows", 0) > -1) {
            prefsDir = homeDir;
        } else {
            prefsDir = userHome;
            if (IJ.isMacOSX()) {
                prefsDir = prefsDir + "/Library/Preferences";
            }
        }
        if (f == null) {
            try {
                f = new FileInputStream(homeDir + "/" + PROPS_NAME);
            }
            catch (FileNotFoundException e) {
                f = null;
            }
        }
        if (f == null) {
            return "IJ_Props.txt not found in ij.jar or in " + homeDir;
        }
        f = new BufferedInputStream(f);
        try {
            props.load(f);
            f.close();
        }
        catch (IOException e) {
            return "Error loading IJ_Props.txt";
        }
        imagesURL = props.getProperty("images.location");
        Prefs.loadPreferences();
        Prefs.loadOptions();
        return null;
    }

    static String loadAppletProps(InputStream f, Applet applet) {
        if (f == null) {
            return "IJ_Props.txt not found in ij.jar";
        }
        try {
            props.load(f);
            f.close();
        }
        catch (IOException e) {
            return "Error loading IJ_Props.txt";
        }
        try {
            URL url = new URL(applet.getDocumentBase(), "images/");
            imagesURL = url.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getImagesURL() {
        return imagesURL;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    static void setHomeDir(String path) {
        homeDir = path;
    }

    public static String getString(String key) {
        return props.getProperty(key);
    }

    public static String getString(String key, String defaultString) {
        if (props == null) {
            return defaultString;
        }
        String s = props.getProperty(key);
        if (s == null) {
            return defaultString;
        }
        return s;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s == null) {
            return defaultValue;
        }
        return s.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException e) {
                IJ.write("" + e);
            }
        }
        return defaultValue;
    }

    public static double getDouble(String key, double defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static Color getColor(String key, Color defaultColor) {
        int i = Prefs.getInt(key, 2730);
        if (i == 2730) {
            return defaultColor;
        }
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static String getFileSeparator() {
        return separator;
    }

    static void loadPreferences() {
        String path = prefsDir + separator + PREFS_NAME;
        boolean ok = Prefs.loadPrefs(path);
        if (!ok && IJ.isMacOSX() && (ok = Prefs.loadPrefs(path = System.getProperty("user.home") + separator + PREFS_NAME))) {
            new File(path).delete();
        }
    }

    static boolean loadPrefs(String path) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
            ijPrefs.load(is);
            ((InputStream)is).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static void savePreferences() {
        try {
            Properties prefs = new Properties();
            String dir = OpenDialog.getDefaultDirectory();
            if (dir != null) {
                prefs.put(DIR_IMAGE, Prefs.escapeBackSlashes(dir));
            }
            prefs.put(ROICOLOR, Tools.c2hex(Roi.getColor()));
            prefs.put(FCOLOR, Tools.c2hex(Toolbar.getForegroundColor()));
            prefs.put(BCOLOR, Tools.c2hex(Toolbar.getBackgroundColor()));
            prefs.put(JPEG, Integer.toString(JpegWriter.getQuality()));
            prefs.put(FPS, Double.toString(Animator.getFrameRate()));
            prefs.put(DIV_BY_ZERO_VALUE, Double.toString(FloatBlitter.divideByZeroValue));
            prefs.put(NOISE_SD, Double.toString(Filters.getSD()));
            Prefs.saveOptions(prefs);
            Prefs.savePluginPrefs(prefs);
            IJ.getInstance().savePreferences(prefs);
            Menus.savePreferences(prefs);
            ParticleAnalyzer.savePreferences(prefs);
            Analyzer.savePreferences(prefs);
            ImportDialog.savePreferences(prefs);
            PlotWindow.savePreferences(prefs);
            GelAnalyzer.savePreferences(prefs);
            NewImage.savePreferences(prefs);
            String path = prefsDir + separator + PREFS_NAME;
            Prefs.savePrefs(prefs, path);
        }
        catch (Exception e) {
            IJ.log("<Unable to save preferences>");
            IJ.wait(3000);
        }
    }

    static void loadOptions() {
        int options = Prefs.getInt(OPTIONS, 2);
        usePointerCursor = (options & 1) != 0;
        antialiasedText = (options & 2) != 0;
        interpolateScaledImages = (options & 4) != 0;
        open100Percent = (options & 8) != 0;
        open100Percent = (options & 8) != 0;
        blackBackground = (options & 0x10) != 0;
        useJFileChooser = (options & 0x20) != 0;
        boolean bl = weightedColor = (options & 0x100) != 0;
        if (weightedColor) {
            ColorProcessor.setWeightingFactors(0.299, 0.587, 0.114);
        }
        blackCanvas = (options & 0x80) != 0;
        pointAutoMeasure = (options & 0x200) != 0;
        requireControlKey = (options & 0x400) != 0;
        useInvertingLut = (options & 0x800) != 0;
    }

    static void saveOptions(Properties prefs) {
        int options = (usePointerCursor ? 1 : 0) + (antialiasedText ? 2 : 0) + (interpolateScaledImages ? 4 : 0) + (open100Percent ? 8 : 0) + (blackBackground ? 16 : 0) + (useJFileChooser ? 32 : 0) + (blackCanvas ? 128 : 0) + (weightedColor ? 256 : 0) + (pointAutoMeasure ? 512 : 0) + (requireControlKey ? 1024 : 0) + (useInvertingLut ? 2048 : 0);
        prefs.put(OPTIONS, Integer.toString(options));
    }

    public static void set(String key, String text) {
        if (key.indexOf(46) < 1) {
            throw new IllegalArgumentException("Key must have a prefix");
        }
        ijPrefs.put(KEY_PREFIX + key, text);
    }

    public static void set(String key, double value) {
        Prefs.set(key, "" + value);
    }

    public static void set(String key, boolean value) {
        Prefs.set(key, "" + value);
    }

    public static String get(String key, String defaultValue) {
        String value = ijPrefs.getProperty(KEY_PREFIX + key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static double get(String key, double defaultValue) {
        String s = ijPrefs.getProperty(KEY_PREFIX + key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static boolean get(String key, boolean defaultValue) {
        String value = ijPrefs.getProperty(KEY_PREFIX + key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    static void savePluginPrefs(Properties prefs) {
        Enumeration<Object> e = ijPrefs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(KEY_PREFIX) != 0) continue;
            prefs.put(key, Prefs.escapeBackSlashes(ijPrefs.getProperty(key)));
        }
    }

    public static void savePrefs(Properties prefs, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintWriter pw = new PrintWriter(bos);
        pw.println("# ImageJ 1.35q Preferences");
        pw.println("# " + new Date());
        pw.println("");
        Enumeration<Object> e = prefs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            pw.print(key);
            pw.write(61);
            pw.println((String)prefs.get(key));
        }
        pw.close();
    }

    static String escapeBackSlashes(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            sb.append(chars[i]);
            if (chars[i] != '\\') continue;
            sb.append('\\');
        }
        return sb.toString();
    }

    static {
        ijPrefs = new Properties();
        props = new Properties(ijPrefs);
    }
}

