/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Toolbar
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int LINE = 4;
    public static final int POLYLINE = 5;
    public static final int FREELINE = 6;
    public static final int POINT = 7;
    public static final int CROSSHAIR = 7;
    public static final int WAND = 8;
    public static final int TEXT = 9;
    public static final int SPARE1 = 10;
    public static final int MAGNIFIER = 11;
    public static final int HAND = 12;
    public static final int DROPPER = 13;
    public static final int ANGLE = 14;
    public static final int SPARE2 = 15;
    public static final int SPARE3 = 16;
    public static final int SPARE4 = 17;
    public static final int SPARE5 = 18;
    public static final int SPARE6 = 19;
    public static final int SPARE7 = 20;
    public static final int DOUBLE_CLICK_THRESHOLD = 650;
    private static final int NUM_TOOLS = 21;
    private static final int SIZE = 22;
    private static final int OFFSET = 3;
    private Dimension ps = new Dimension(462, 22);
    private boolean[] down;
    private static int current;
    private int previous;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String[] names = new String[21];
    private String[] icons = new String[21];
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private static Color foregroundColor;
    private static Color backgroundColor;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = this.gray.darker();
    private Color evenDarker = this.darker.darker();

    public Toolbar() {
        this.down = new boolean[21];
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(foregroundColor);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
    }

    public static int getToolId() {
        return current;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics g) {
        for (int i = 0; i < 21; ++i) {
            this.drawButton(g, i);
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (null == g) {
            return;
        }
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(raised ? this.brighter : this.evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void drawButton(Graphics g, int tool) {
        if (null == g) {
            return;
        }
        int index = this.toolIndex(tool);
        this.fill3DRect(g, index * 22 + 1, 1, 22, 21, !this.down[tool]);
        g.setColor(Color.black);
        int x = index * 22 + 3;
        int y = 3;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        if (tool >= 10 && tool <= 20 && this.icons[tool] != null) {
            this.drawIcon(g, this.icons[tool], x, y);
            return;
        }
        switch (tool) {
            case 0: {
                g.drawRect(x + 1, y + 2, 14, 11);
                return;
            }
            case 1: {
                g.drawOval(x + 1, y + 3, 14, 11);
                return;
            }
            case 2: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(4, 0);
                this.d(14, 0);
                this.d(14, 1);
                this.d(10, 5);
                this.d(10, 6);
                this.d(13, 9);
                this.d(13, 10);
                this.d(0, 10);
                this.d(0, 4);
                this.d(4, 0);
                return;
            }
            case 3: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(3, 0);
                this.d(5, 0);
                this.d(7, 2);
                this.d(9, 2);
                this.d(11, 0);
                this.d(13, 0);
                this.d(14, 1);
                this.d(15, 2);
                this.d(15, 4);
                this.d(14, 5);
                this.d(14, 6);
                this.d(12, 8);
                this.d(11, 8);
                this.d(10, 9);
                this.d(9, 9);
                this.d(8, 10);
                this.d(5, 10);
                this.d(3, 8);
                this.d(2, 8);
                this.d(1, 7);
                this.d(1, 6);
                this.d(0, 5);
                this.d(0, 2);
                this.d(1, 1);
                this.d(2, 1);
                return;
            }
            case 4: {
                this.xOffset = x;
                this.yOffset = y + 5;
                this.m(0, 0);
                this.d(16, 6);
                return;
            }
            case 5: {
                this.xOffset = x + 1;
                this.yOffset = y + 3;
                this.m(0, 3);
                this.d(3, 0);
                this.d(13, 0);
                this.d(13, 1);
                this.d(8, 6);
                this.d(12, 10);
                return;
            }
            case 6: {
                this.xOffset = x + 1;
                this.yOffset = y + 4;
                this.m(0, 1);
                this.d(2, 3);
                this.d(4, 3);
                this.d(7, 0);
                this.d(8, 0);
                this.d(10, 4);
                this.d(14, 8);
                this.d(15, 8);
                return;
            }
            case 7: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(1, 8);
                this.d(6, 8);
                this.d(6, 6);
                this.d(10, 6);
                this.d(10, 10);
                this.d(6, 10);
                this.d(6, 9);
                this.m(8, 1);
                this.d(8, 5);
                this.m(11, 8);
                this.d(15, 8);
                this.m(8, 11);
                this.d(8, 15);
                this.m(8, 8);
                this.d(8, 8);
                return;
            }
            case 8: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(4, 0);
                this.d(4, 0);
                this.m(2, 0);
                this.d(3, 1);
                this.d(4, 2);
                this.m(0, 0);
                this.d(1, 1);
                this.m(0, 2);
                this.d(1, 3);
                this.d(2, 4);
                this.m(0, 4);
                this.d(0, 4);
                this.m(3, 3);
                this.d(12, 12);
                return;
            }
            case 9: {
                this.xOffset = x + 2;
                this.yOffset = y + 1;
                this.m(0, 13);
                this.d(3, 13);
                this.m(1, 12);
                this.d(7, 0);
                this.d(12, 13);
                this.m(11, 13);
                this.d(14, 13);
                this.m(3, 8);
                this.d(10, 8);
                return;
            }
            case 11: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                return;
            }
            case 12: {
                this.xOffset = x + 1;
                this.yOffset = y + 1;
                this.m(5, 14);
                this.d(2, 11);
                this.d(2, 10);
                this.d(0, 8);
                this.d(0, 7);
                this.d(1, 6);
                this.d(2, 6);
                this.d(4, 8);
                this.d(4, 6);
                this.d(3, 5);
                this.d(3, 4);
                this.d(2, 3);
                this.d(2, 2);
                this.d(3, 1);
                this.d(4, 1);
                this.d(5, 2);
                this.d(5, 3);
                this.m(6, 5);
                this.d(6, 1);
                this.d(7, 0);
                this.d(8, 0);
                this.d(9, 1);
                this.d(9, 5);
                this.m(9, 1);
                this.d(11, 1);
                this.d(12, 2);
                this.d(12, 6);
                this.m(13, 4);
                this.d(14, 3);
                this.d(15, 4);
                this.d(15, 7);
                this.d(14, 8);
                this.d(14, 10);
                this.d(13, 11);
                this.d(13, 12);
                this.d(12, 13);
                this.d(12, 14);
                return;
            }
            case 13: {
                this.xOffset = x;
                this.yOffset = y;
                g.setColor(foregroundColor);
                this.m(12, 2);
                this.d(14, 2);
                this.m(11, 3);
                this.d(15, 3);
                this.m(11, 4);
                this.d(15, 4);
                this.m(8, 5);
                this.d(15, 5);
                this.m(9, 6);
                this.d(14, 6);
                this.m(10, 7);
                this.d(12, 7);
                this.d(12, 9);
                this.m(8, 7);
                this.d(2, 13);
                this.d(2, 15);
                this.d(4, 15);
                this.d(11, 8);
                g.setColor(backgroundColor);
                this.m(0, 0);
                this.d(16, 0);
                this.d(16, 16);
                this.d(0, 16);
                this.d(0, 0);
                g.setColor(Color.black);
                return;
            }
            case 14: {
                this.xOffset = x + 1;
                this.yOffset = y + 2;
                this.m(0, 11);
                this.d(11, 0);
                this.m(0, 11);
                this.d(15, 11);
                this.m(10, 11);
                this.d(10, 8);
                this.m(9, 7);
                this.d(9, 6);
                this.m(8, 5);
                this.d(8, 5);
                return;
            }
        }
    }

    void drawIcon(Graphics g, String icon, int x, int y) {
        if (null == g) {
            return;
        }
        this.icon = icon;
        int length = icon.length();
        this.pc = 0;
        block12: do {
            char command = icon.charAt(this.pc++);
            if (this.pc >= length) break;
            switch (command) {
                case 'B': {
                    x += this.v();
                    y += this.v();
                    break;
                }
                case 'R': {
                    g.drawRect(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'F': {
                    g.fillRect(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'O': {
                    g.drawOval(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'o': {
                    g.fillOval(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'C': {
                    g.setColor(new Color(this.v() * 16, this.v() * 16, this.v() * 16));
                    break;
                }
                case 'L': {
                    g.drawLine(x + this.v(), y + this.v(), x + this.v(), y + this.v());
                    break;
                }
                case 'D': {
                    int x1 = x + this.v();
                    int x2 = y + this.v();
                    g.drawLine(x1, x2, x1, x2);
                    break;
                }
                case 'P': {
                    int y2;
                    int x2;
                    int x1 = x + this.v();
                    int y1 = y + this.v();
                    while ((x2 = this.v()) != 0 && (y2 = this.v()) != 0) {
                        g.drawLine(x1, y1, x2 += x, y2 += y);
                        x1 = x2;
                        y1 = y2;
                    }
                    continue block12;
                }
                case 'T': {
                    int x2 = x + this.v();
                    int y2 = y + this.v();
                    int size = this.v() * 10 + this.v();
                    char[] c = new char[]{this.pc < icon.length() ? (char)icon.charAt(this.pc++) : (char)'e'};
                    g.setFont(new Font("SansSerif", 1, size));
                    g.drawString(new String(c), x2, y2);
                    break;
                }
            }
        } while (this.pc < length);
        g.setColor(Color.black);
    }

    int v() {
        if (this.pc >= this.icon.length()) {
            return 0;
        }
        char c = this.icon.charAt(this.pc++);
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private void showMessage(int tool) {
        if (tool >= 10 && tool <= 20 && this.names[tool] != null) {
            IJ.showStatus(this.names[tool]);
            return;
        }
        switch (tool) {
            case 0: {
                IJ.showStatus("Rectangular selections");
                return;
            }
            case 1: {
                IJ.showStatus("Elliptical selections");
                return;
            }
            case 2: {
                IJ.showStatus("Polygon selections");
                return;
            }
            case 3: {
                IJ.showStatus("Freehand selections");
                return;
            }
            case 4: {
                IJ.showStatus("Straight line selections");
                return;
            }
            case 5: {
                IJ.showStatus("Segmented line selections");
                return;
            }
            case 6: {
                IJ.showStatus("Freehand line selections");
                return;
            }
            case 7: {
                IJ.showStatus("Point selections");
                return;
            }
            case 8: {
                IJ.showStatus("Wand (tracing) tool");
                return;
            }
            case 9: {
                IJ.showStatus("Text tool");
                return;
            }
            case 11: {
                IJ.showStatus("Magnifying glass");
                return;
            }
            case 12: {
                IJ.showStatus("Scrolling tool");
                return;
            }
            case 13: {
                IJ.showStatus("Color picker (" + foregroundColor.getRed() + "," + foregroundColor.getGreen() + "," + foregroundColor.getBlue() + ")");
                return;
            }
            case 14: {
                IJ.showStatus("Angle tool");
                return;
            }
        }
        IJ.showStatus("");
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x;
        this.y = this.yOffset + y;
    }

    private void d(int x, int y) {
        this.g.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void resetButtons() {
        for (int i = 0; i < 21; ++i) {
            this.down[i] = false;
        }
    }

    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        this.drawButtons(g);
    }

    public void setTool(int tool) {
        if (tool == current || tool < 0 || tool >= 21) {
            return;
        }
        if ((tool == 10 || tool >= 15 && tool <= 20) && this.names[tool] == null) {
            this.names[tool] = "Spare tool";
        }
        this.setTool2(tool);
    }

    private void setTool2(int tool) {
        if (tool == current || tool < 0 || tool >= 21) {
            return;
        }
        if ((tool == 10 || tool >= 15 && tool <= 20) && this.names[tool] == null) {
            return;
        }
        current = tool;
        this.down[Toolbar.current] = true;
        this.down[this.previous] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, this.previous);
        this.drawButton(g, current);
        if (null == g) {
            return;
        }
        g.dispose();
        this.showMessage(current);
        this.previous = current;
        if (Recorder.record) {
            Recorder.record("setTool", current);
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color c) {
        if (c != null) {
            foregroundColor = c;
            this.drawButton(this.getGraphics(), 13);
        }
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color c) {
        if (c != null) {
            foregroundColor = c;
            Toolbar.updateColors();
        }
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color c) {
        if (c != null) {
            backgroundColor = c;
            Toolbar.updateColors();
        }
    }

    static void updateColors() {
        if (IJ.getInstance() != null) {
            Toolbar tb = Toolbar.getInstance();
            Graphics g = tb.getGraphics();
            tb.drawButton(g, 13);
            tb.drawButton(g, 7);
            if (g != null) {
                g.dispose();
            }
        }
    }

    int toolIndex(int tool) {
        if (tool <= 6 || tool > 14) {
            return tool;
        }
        if (tool == 14) {
            return 7;
        }
        return tool + 1;
    }

    int toolID(int index) {
        if (index <= 6 || index > 14) {
            return index;
        }
        if (index == 7) {
            return 14;
        }
        return index - 1;
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int newTool = 0;
        for (int i = 0; i < 21; ++i) {
            if (x <= i * 22 || x >= i * 22 + 22) continue;
            newTool = this.toolID(i);
        }
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick) {
            if (this.isMacroTool(newTool)) {
                String name = this.names[newTool].endsWith(" ") ? this.names[newTool] : this.names[newTool] + " ";
                this.macroInstaller.runMacroTool(name + "Selected");
            }
            this.mpPrevious = current;
            this.setTool2(newTool);
        } else {
            if (this.isMacroTool(current)) {
                String name = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(name + "Options");
                return;
            }
            ImagePlus imp = WindowManager.getCurrentImage();
            switch (current) {
                case 3: {
                    IJ.doCommand("Set Measurements...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
                case 11: {
                    ImageWindow win;
                    if (imp == null || (win = imp.getWindow()) == null) break;
                    win.getCanvas().unzoom();
                    break;
                }
                case 2: {
                    if (imp != null) {
                        IJ.doCommand("Calibrate...");
                    }
                    this.setTool2(this.mpPrevious);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    IJ.runPlugIn("ij.plugin.frame.LineWidthAdjuster", "");
                    break;
                }
                case 7: {
                    IJ.doCommand("Point Tool...");
                    break;
                }
                case 9: {
                    IJ.doCommand("Fonts...");
                    break;
                }
                case 13: {
                    IJ.doCommand("Color Picker...");
                    this.setTool2(this.mpPrevious);
                    break;
                }
            }
        }
    }

    public void restorePreviousTool() {
        this.setTool2(this.mpPrevious);
    }

    boolean isMacroTool(int tool) {
        return tool >= 10 && tool <= 20 && this.names[tool] != null && this.macroInstaller != null;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public Dimension getMinimumSize() {
        return this.ps;
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        x = this.toolID(x / 22);
        this.showMessage(x);
    }

    public int addTool(String toolTip) {
        boolean hasIcon;
        int index = toolTip.indexOf(45);
        boolean bl = hasIcon = index >= 0 && toolTip.length() - index > 4;
        if (!hasIcon) {
            this.names[10] = toolTip;
            return 10;
        }
        int tool = -1;
        if (this.names[10] == null) {
            tool = 10;
        }
        if (tool == -1) {
            for (int i = 15; i <= 20; ++i) {
                if (this.names[i] != null) continue;
                tool = i;
                break;
            }
        }
        if (tool == -1) {
            return -1;
        }
        this.icons[tool] = toolTip.substring(index + 1);
        this.names[tool] = toolTip.substring(0, index);
        return tool;
    }

    public void addMacroTool(String name, MacroInstaller macroInstaller, int id) {
        if (id == 0) {
            for (int i = 10; i < 21; ++i) {
                this.names[i] = null;
                this.icons[i] = null;
            }
        }
        int tool = this.addTool(name);
        this.macroInstaller = macroInstaller;
    }

    void runMacroTool(int id) {
        if (this.macroInstaller != null) {
            this.macroInstaller.runMacroTool(this.names[id]);
        }
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
    }
}

