/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.util.Java2;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class DirectoryChooser {
    private String directory;
    private static String defaultDir;

    public DirectoryChooser(String title) {
        if (IJ.isMacOSX() && IJ.isJava14()) {
            this.getDirectoryUsingFileDialog(title);
        } else if (IJ.isJava2()) {
            this.getDirectoryUsingJFileChooser(title);
        } else {
            OpenDialog od = new OpenDialog(title, null);
            this.directory = od.getDirectory();
        }
    }

    void getDirectoryUsingJFileChooser(final String title) {
        Java2.setSystemLookAndFeel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JFileChooser chooser = new JFileChooser();
                    if (defaultDir != null) {
                        chooser.setCurrentDirectory(new File(defaultDir));
                    }
                    chooser.setDialogTitle(title);
                    chooser.setFileSelectionMode(1);
                    chooser.setApproveButtonText("Select");
                    if (chooser.showOpenDialog(null) == 0) {
                        File dir = chooser.getCurrentDirectory();
                        File file = chooser.getSelectedFile();
                        DirectoryChooser.this.directory = dir.getPath();
                        if (!DirectoryChooser.this.directory.endsWith(File.separator)) {
                            DirectoryChooser.this.directory = DirectoryChooser.this.directory + File.separator;
                        }
                        defaultDir = DirectoryChooser.this.directory;
                        DirectoryChooser.this.directory = DirectoryChooser.this.directory + (file.getName() + File.separator);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getDirectoryUsingFileDialog(String title) {
        boolean saveUseJFC = Prefs.useJFileChooser;
        Prefs.useJFileChooser = false;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        OpenDialog od = new OpenDialog(title, null);
        this.directory = od.getDirectory() + od.getFileName() + "/";
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        Prefs.useJFileChooser = saveUseJFC;
    }

    public String getDirectory() {
        return this.directory;
    }
}

