/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.RoiDecoder;
import ij.io.TiffDecoder;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.text.TextWindow;
import ij.util.Java2;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class Opener {
    public static final int UNKNOWN = 0;
    public static final int TIFF = 1;
    public static final int DICOM = 2;
    public static final int FITS = 3;
    public static final int PGM = 4;
    public static final int JPEG = 5;
    public static final int GIF = 6;
    public static final int LUT = 7;
    public static final int BMP = 8;
    public static final int ZIP = 9;
    public static final int JAVA_OR_TEXT = 10;
    public static final int ROI = 11;
    public static final int TEXT = 12;
    public static final int PNG = 13;
    public static final int TIFF_AND_DICOM = 14;
    public static final int CUSTOM = 15;
    private static final String[] types = new String[]{"unknown", "tif", "dcm", "fits", "pgm", "jpg", "gif", "lut", "bmp", "zip", "java/txt", "roi", "txt", "png", "t&d"};
    private static String defaultDirectory = null;
    private static int fileType;
    private boolean error;
    private boolean isRGB48;
    private boolean silentMode;
    private String omDirectory;
    private File[] omFiles;

    public void open() {
        OpenDialog od = new OpenDialog("Open", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name != null) {
            String path = directory + name;
            this.error = false;
            this.open(path);
            if (!this.error) {
                Menus.addOpenRecentItem(path);
            }
        }
    }

    public void openMultiple() {
        if (!IJ.isJava2()) {
            return;
        }
        Java2.setSystemLookAndFeel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int returnVal;
                    JFileChooser fc = new JFileChooser();
                    fc.setMultiSelectionEnabled(true);
                    File dir = null;
                    String sdir = OpenDialog.getDefaultDirectory();
                    if (sdir != null) {
                        dir = new File(sdir);
                    }
                    if (dir != null) {
                        fc.setCurrentDirectory(dir);
                    }
                    if ((returnVal = fc.showOpenDialog(IJ.getInstance())) != 0) {
                        return;
                    }
                    Opener.access$002(Opener.this, fc.getSelectedFiles());
                    if (Opener.this.omFiles.length == 0) {
                        Opener.access$002(Opener.this, new File[1]);
                        ((Opener)Opener.this).omFiles[0] = fc.getSelectedFile();
                    }
                    Opener.this.omDirectory = fc.getCurrentDirectory().getPath() + File.separator;
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.omDirectory == null) {
            return;
        }
        OpenDialog.setDefaultDirectory(this.omDirectory);
        for (int i = 0; i < this.omFiles.length; ++i) {
            String path = this.omDirectory + this.omFiles[i].getName();
            this.open(path);
            if (i == 0 && Recorder.record) {
                Recorder.recordPath("open", path);
            }
            if (i != 0 || this.error) continue;
            Menus.addOpenRecentItem(path);
        }
    }

    public void open(String path) {
        boolean fullPath;
        boolean bl = fullPath = path.startsWith("/") || path.indexOf(":\\") == 1;
        if (!fullPath) {
            path = System.getProperty("user.dir") + File.separator + path;
        }
        if (!this.silentMode) {
            IJ.showStatus("Opening: " + path);
        }
        long start = System.currentTimeMillis();
        ImagePlus imp = this.openImage(path);
        if (imp != null) {
            WindowManager.checkForDuplicateName = true;
            if (this.isRGB48) {
                this.openRGB48(imp);
            } else {
                imp.show(IJ.d2s((double)(System.currentTimeMillis() - start) / 1000.0, 3) + " seconds");
            }
        } else {
            switch (fileType) {
                case 7: {
                    imp = (ImagePlus)IJ.runPlugIn("ij.plugin.LutLoader", path);
                    if (imp.getWidth() == 0) break;
                    imp.show();
                    break;
                }
                case 11: {
                    IJ.runPlugIn("ij.plugin.RoiReader", path);
                    break;
                }
                case 10: 
                case 12: {
                    String osName;
                    if (IJ.altKeyDown()) {
                        new TextWindow(path, 400, 450);
                        IJ.setKeyUp(18);
                        break;
                    }
                    File file = new File(path);
                    boolean betterTextArea = IJ.isJava2() || IJ.isMacintosh();
                    int maxSize = 250000;
                    long size = file.length();
                    if (size >= 28000L && betterTextArea && ((osName = System.getProperty("os.name")).equals("Windows 95") || osName.equals("Windows 98") || osName.equals("Windows Me"))) {
                        maxSize = 60000;
                    }
                    if (size < 28000L || betterTextArea && size < (long)maxSize) {
                        Editor ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
                        if (ed == null) break;
                        ed.open(this.getDir(path), this.getName(path));
                        break;
                    }
                    new TextWindow(path, 400, 450);
                    break;
                }
                case 0: {
                    String msg = "File is not in TIFF, JPEG, GIF, BMP, DICOM, FITS, PGM, \nZIP, LUT, ROI or text format, or it was not found.";
                    if (path != null && path.length() <= 64) {
                        msg = msg + " \n  \n   " + path;
                    }
                    IJ.error("Opener", msg);
                    this.error = true;
                }
            }
        }
    }

    public ImagePlus openImage(String directory, String name) {
        if (directory.length() > 0 && !directory.endsWith(Prefs.separator)) {
            directory = directory + Prefs.separator;
        }
        String path = directory + name;
        fileType = this.getFileType(path);
        if (IJ.debugMode) {
            IJ.log("openImage: \"" + types[fileType] + "\", " + path);
        }
        switch (fileType) {
            case 1: {
                ImagePlus imp = this.openTiff(directory, name);
                return imp;
            }
            case 2: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 14: {
                ImagePlus imp = this.openTiff(directory, name);
                ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", path);
                if (imp != null) {
                    imp.setProperty("Info", imp2.getProperty("Info"));
                }
                return imp;
            }
            case 3: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.FITS", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 4: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 5: 
            case 6: 
            case 13: {
                ImagePlus imp = this.openJpegOrGif(directory, name);
                if (imp != null && imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 8: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 9: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.Zip_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 0: 
            case 12: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("HandleExtraFileTypes", path);
                if (imp == null) {
                    return null;
                }
                if (imp.getWidth() > 0 && imp.getHeight() > 0) {
                    fileType = 15;
                    return imp;
                }
                if (imp.getWidth() == -1) {
                    fileType = 15;
                }
                return null;
            }
        }
        return null;
    }

    public ImagePlus openImage(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        ImagePlus img = null;
        img = path.indexOf("://") > 0 ? this.openURL(path) : this.openImage(this.getDir(path), this.getName(path));
        return img;
    }

    public ImagePlus openURL(String url) {
        try {
            String name = "";
            int index = url.lastIndexOf(47);
            if (index == -1) {
                index = url.lastIndexOf(92);
            }
            if (index <= 0) {
                throw new MalformedURLException("Invalid URL: " + url);
            }
            name = url.substring(index + 1);
            URL u = new URL(url);
            IJ.showStatus("" + url);
            ImagePlus imp = null;
            if (url.endsWith(".tif") || url.endsWith(".TIF")) {
                imp = this.openTiff(u.openStream(), name);
            } else if (url.endsWith(".zip")) {
                imp = this.openZip(u);
            } else if (url.endsWith(".dcm")) {
                imp = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", url);
                if (imp != null && imp.getWidth() == 0) {
                    imp = null;
                }
            } else {
                imp = this.openJpegOrGifUsingURL(name, u);
            }
            IJ.showStatus("");
            return imp;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("Open URL", msg + "\n \n" + url);
            return null;
        }
    }

    ImagePlus openZip(URL url) throws IOException {
        int len;
        IJ.showProgress(0.01);
        URLConnection uc = url.openConnection();
        int fileSize = uc.getContentLength();
        fileSize *= 2;
        InputStream in = uc.getInputStream();
        ZipInputStream zin = new ZipInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        ZipEntry entry = zin.getNextEntry();
        if (entry == null) {
            return null;
        }
        String name = entry.getName();
        if (!name.endsWith(".tif")) {
            throw new IOException("This ZIP archive does not appear to contain a TIFF file");
        }
        int byteCount = 0;
        boolean progress = false;
        while ((len = zin.read(buf)) >= 0) {
            out.write(buf, 0, len);
            IJ.showProgress((double)((byteCount += len) % fileSize) / (double)fileSize);
        }
        zin.close();
        byte[] bytes = out.toByteArray();
        IJ.showProgress(1.0);
        return this.openTiff(new ByteArrayInputStream(bytes), name);
    }

    ImagePlus openJpegOrGifUsingURL(String title, URL url) {
        Image img;
        if (url == null) {
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image image = img = IJ.isJava2() ? tk.createImage(url) : tk.getImage(url);
        if (img != null) {
            ImagePlus imp = new ImagePlus(title, img);
            return imp;
        }
        return null;
    }

    ImagePlus openJpegOrGif(String dir, String name) {
        Image img;
        ImagePlus imp = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image image = img = IJ.isJava2() ? tk.createImage(dir + name) : tk.getImage(dir + name);
        if (img != null) {
            try {
                imp = new ImagePlus(name, img);
            }
            catch (IllegalStateException e) {
                return null;
            }
            if (imp.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imp);
            }
            FileInfo fi = new FileInfo();
            fi.fileFormat = 3;
            fi.fileName = name;
            fi.directory = dir;
            imp.setFileInfo(fi);
        }
        return imp;
    }

    public static void convertGrayJpegTo8Bits(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int[] pixels = (int[])ip.getPixels();
        for (int y = 0; y < height - 8; ++y) {
            int offset = y * width;
            for (int x = 0; x < width - 8; ++x) {
                int c = pixels[offset + x];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                if (r == g && g == b) continue;
                return;
            }
        }
        IJ.showStatus("Converting to 8-bits");
        new ImageConverter(imp).convertToGray8();
    }

    boolean allSameSizeAndType(FileInfo[] info) {
        boolean sameSizeAndType = true;
        boolean contiguous = true;
        int startingOffset = info[0].offset;
        int size = info[0].width * info[0].height * info[0].getBytesPerPixel();
        for (int i = 1; i < info.length; ++i) {
            sameSizeAndType &= info[i].fileType == info[0].fileType && info[i].width == info[0].width && info[i].height == info[0].height;
            contiguous &= info[i].offset == startingOffset + i * size;
        }
        if (contiguous && info[0].fileType != 12) {
            info[0].nImages = info.length;
        }
        if (IJ.debugMode) {
            IJ.log("  sameSizeAndType: " + sameSizeAndType);
            IJ.log("  contiguous: " + contiguous);
        }
        return sameSizeAndType;
    }

    public ImagePlus openTiffStack(FileInfo[] info) {
        if (info.length > 1 && !this.allSameSizeAndType(info)) {
            return null;
        }
        FileInfo fi = info[0];
        if (fi.nImages > 1) {
            return new FileOpener(fi).open(false);
        }
        ColorModel cm = this.createColorModel(fi);
        ImageStack stack = new ImageStack(fi.width, fi.height, cm);
        int skip = fi.offset;
        int imageSize = fi.width * fi.height * fi.getBytesPerPixel();
        if (info[0].fileType == 13 && ((imageSize = (int)((double)(fi.width * fi.height) * 1.5)) & 1) == 1) {
            ++imageSize;
        }
        int loc = 0;
        try {
            InputStream is = this.createInputStream(fi);
            ImageReader reader = new ImageReader(fi);
            for (int i = 0; i < info.length; ++i) {
                IJ.showStatus("Reading: " + (i + 1) + "/" + info.length);
                Object pixels = reader.readPixels(is, skip);
                if (pixels == null) break;
                if (i < info.length - 1 && (skip = info[i + 1].offset - (loc += imageSize + skip)) < 0) {
                    throw new IOException("Images are not in order");
                }
                if (fi.fileType == 12) {
                    Object[] pixels2 = (Object[])pixels;
                    stack.addSlice(null, pixels2[0]);
                    stack.addSlice(null, pixels2[1]);
                    stack.addSlice(null, pixels2[2]);
                    this.isRGB48 = true;
                } else {
                    stack.addSlice(null, pixels);
                }
                IJ.showProgress((double)i / (double)info.length);
            }
            is.close();
        }
        catch (Exception e) {
            IJ.write("" + e);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(fi.fileName);
            stack.deleteLastSlice();
            stack.deleteLastSlice();
        }
        IJ.showProgress(1.0);
        if (stack.getSize() == 0) {
            return null;
        }
        if (fi.fileType == 2 || fi.fileType == 13 || fi.fileType == 4 || fi.fileType == 12) {
            ImageProcessor ip = stack.getProcessor(1);
            ip.resetMinAndMax();
            stack.update(ip);
        }
        if (fi.whiteIsZero) {
            new StackProcessor(stack, stack.getProcessor(1)).invert();
        }
        ImagePlus imp = new ImagePlus(fi.fileName, stack);
        new FileOpener(fi).setCalibration(imp);
        imp.setFileInfo(fi);
        IJ.showProgress(1.0);
        return imp;
    }

    public ImagePlus openTiff(String directory, String name) {
        TiffDecoder td = new TiffDecoder(directory, name);
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        FileInfo[] info = null;
        try {
            info = td.getTiffInfo();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("TiffDecoder", msg);
            return null;
        }
        if (info == null) {
            return null;
        }
        return this.openTiff2(info);
    }

    public ImagePlus openTiff(InputStream in, String name) {
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, name);
            if (IJ.debugMode) {
                td.enableDebugging();
            }
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.error("TiffDecoder", "File not found: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            IJ.error("TiffDecoder", "" + e);
            return null;
        }
        return this.openTiff2(info);
    }

    public String getName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(i + 1);
        }
        return path;
    }

    public String getDir(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(0, i + 1);
        }
        return "";
    }

    ImagePlus openTiff2(FileInfo[] info) {
        if (info == null) {
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.log(info[0].debugInfo);
        }
        if (info.length > 1 && (imp = this.openTiffStack(info)) != null) {
            return imp;
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        return imp;
    }

    public Roi openRoi(String path) {
        Roi roi = null;
        RoiDecoder rd = new RoiDecoder(path);
        try {
            roi = rd.getRoi();
        }
        catch (IOException e) {
            IJ.error("RoiDecoder", e.getMessage());
            return null;
        }
        return roi;
    }

    public int getFileType(String path) {
        File file = new File(path);
        String name = file.getName();
        byte[] buf = new byte[132];
        try {
            FileInputStream is = new FileInputStream(file);
            ((InputStream)is).read(buf, 0, 132);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return 0;
        }
        int b0 = buf[0] & 0xFF;
        int b1 = buf[1] & 0xFF;
        int b2 = buf[2] & 0xFF;
        int b3 = buf[3] & 0xFF;
        if (buf[128] == 68 && buf[129] == 73 && buf[130] == 67 && buf[131] == 77 && (b0 == 73 && b1 == 73 || b0 == 77 && b1 == 77)) {
            return 14;
        }
        if (name.endsWith(".lsm")) {
            return 0;
        }
        if (b0 == 73 && b1 == 73 && b2 == 42 && b3 == 0) {
            return 1;
        }
        if (b0 == 77 && b1 == 77 && b2 == 0 && b3 == 42) {
            return 1;
        }
        if (b0 == 255 && b1 == 216 && b2 == 255) {
            return 5;
        }
        if (b0 == 71 && b1 == 73 && b2 == 70 && b3 == 56) {
            return 6;
        }
        name = name.toLowerCase(Locale.US);
        if (buf[128] == 68 && buf[129] == 73 && buf[130] == 67 && buf[131] == 77 || name.endsWith(".dcm")) {
            return 2;
        }
        if (!(b0 != 8 && b0 != 2 || b1 != 0 || b3 != 0 || name.endsWith(".spe"))) {
            return 2;
        }
        if (b0 == 83 && b1 == 73 && b2 == 77 && b3 == 80) {
            return 3;
        }
        if (!(b0 != 80 || b1 != 49 && b1 != 52 && b1 != 50 && b1 != 53 && b1 != 51 && b1 != 54 || b2 != 10 && b2 != 13 && b2 != 32 && b2 != 9)) {
            return 4;
        }
        if (name.endsWith(".lut")) {
            return 7;
        }
        if (b0 == 66 && b1 == 77 && name.endsWith(".bmp")) {
            return 8;
        }
        if (b0 == 137 && b1 == 80 && b2 == 78 && b3 == 71 && IJ.isJava2()) {
            return 13;
        }
        if (name.endsWith(".zip")) {
            return 9;
        }
        if (name.endsWith(".java") || name.endsWith(".txt") || name.endsWith(".ijm")) {
            return 10;
        }
        if (b0 == 73 && b1 == 111) {
            return 11;
        }
        boolean isText = true;
        for (int i = 0; i < 10; ++i) {
            byte c = buf[i];
            if ((c >= 32 || c == 9 || c == 10 || c == 13) && c <= 126) continue;
            isText = false;
            break;
        }
        if (isText) {
            return 12;
        }
        return 0;
    }

    ColorModel createColorModel(FileInfo fi) {
        if (fi.fileType == 5 && fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        if (fi.inputStream != null) {
            return fi.inputStream;
        }
        if (fi.url != null && !fi.url.equals("")) {
            return new URL(fi.url + fi.fileName).openStream();
        }
        File f = new File(fi.directory + fi.fileName);
        if (f == null || f.isDirectory()) {
            return null;
        }
        return new FileInputStream(f);
    }

    void openRGB48(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        ImageStack stack1 = imp.createEmptyStack();
        ImageStack stack2 = imp.createEmptyStack();
        ImageStack stack3 = imp.createEmptyStack();
        int n = imp.getStackSize() / 3;
        for (int i = 0; i < n; ++i) {
            stack1.addSlice(null, stack.getProcessor(1));
            stack.deleteSlice(1);
            stack2.addSlice(null, stack.getProcessor(1));
            stack.deleteSlice(1);
            stack3.addSlice(null, stack.getProcessor(1));
            stack.deleteSlice(1);
        }
        ImagePlus imp1 = new ImagePlus("Red-" + imp.getTitle(), stack1);
        imp1.getProcessor().resetMinAndMax();
        imp1.show();
        ImagePlus imp2 = new ImagePlus("Green-" + imp.getTitle(), stack2);
        imp2.getProcessor().resetMinAndMax();
        imp2.show();
        ImagePlus imp3 = new ImagePlus("Blue-" + imp.getTitle(), stack3);
        imp3.getProcessor().resetMinAndMax();
        imp3.show();
    }

    public void setSilentMode(boolean mode) {
        this.silentMode = mode;
    }

    static /* synthetic */ File[] access$002(Opener x0, File[] x1) {
        x0.omFiles = x1;
        return x1;
    }
}

