/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.WindowManager;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Frame;

public class ResultsTable {
    public static final int MAX_COLUMNS = 150;
    public static final int COLUMN_NOT_FOUND = -1;
    public static final int COLUMN_IN_USE = -2;
    public static final int TABLE_FULL = -3;
    public static final int AREA = 0;
    public static final int MEAN = 1;
    public static final int STD_DEV = 2;
    public static final int MODE = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int X_CENTROID = 6;
    public static final int Y_CENTROID = 7;
    public static final int X_CENTER_OF_MASS = 8;
    public static final int Y_CENTER_OF_MASS = 9;
    public static final int PERIMETER = 10;
    public static final int ROI_X = 11;
    public static final int ROI_Y = 12;
    public static final int ROI_WIDTH = 13;
    public static final int ROI_HEIGHT = 14;
    public static final int MAJOR = 15;
    public static final int MINOR = 16;
    public static final int ANGLE = 17;
    public static final int CIRCULARITY = 18;
    public static final int FERET = 19;
    public static final int INTEGRATED_DENSITY = 20;
    public static final int MEDIAN = 21;
    public static final int SKEWNESS = 22;
    public static final int KURTOSIS = 23;
    public static final int AREA_FRACTION = 24;
    public static final int SLICE = 25;
    private String[] headings = new String[150];
    private String[] defaultHeadings = new String[]{"Area", "Mean", "StdDev", "Mode", "Min", "Max", "X", "Y", "XM", "YM", "Perim.", "BX", "BY", "Width", "Height", "Major", "Minor", "Angle", "Circ.", "Feret", "IntDen", "Median", "Skew", "Kurt", "%Area", "Slice"};
    private int counter;
    private double[][] columns = new double[150][];
    private String[] rowLabels;
    private int maxRows = 100;
    private int lastColumn = -1;
    private StringBuffer sb;
    private int precision = 3;
    private String rowLabelHeading = "";

    public ResultsTable() {
        for (int i = 0; i < this.defaultHeadings.length; ++i) {
            this.headings[i] = this.defaultHeadings[i];
        }
    }

    public static ResultsTable getResultsTable() {
        return Analyzer.getResultsTable();
    }

    public synchronized void incrementCounter() {
        ++this.counter;
        if (this.counter == this.maxRows) {
            if (this.rowLabels != null) {
                String[] s = new String[this.maxRows * 2];
                System.arraycopy(this.rowLabels, 0, s, 0, this.maxRows);
                this.rowLabels = s;
            }
            for (int i = 0; i <= this.lastColumn; ++i) {
                if (this.columns[i] == null) continue;
                double[] tmp = new double[this.maxRows * 2];
                System.arraycopy(this.columns[i], 0, tmp, 0, this.maxRows);
                this.columns[i] = tmp;
            }
            this.maxRows *= 2;
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public void addValue(int column, double value) {
        if (column < 0 || column >= 150) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.columns[column] == null) {
            this.columns[column] = new double[this.maxRows];
            if (this.headings[column] == null) {
                this.headings[column] = "---";
            }
            if (column > this.lastColumn) {
                this.lastColumn = column;
            }
        }
        this.columns[column][this.counter - 1] = value;
    }

    public void addValue(String column, double value) {
        int index = this.getColumnIndex(column);
        if (index == -1 && (index = this.getFreeColumn(column)) == -3) {
            throw new IllegalArgumentException("table is full");
        }
        this.addValue(index, value);
    }

    public void addLabel(String columnHeading, String label) {
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        this.rowLabels[this.counter - 1] = label;
        if (columnHeading != null) {
            this.rowLabelHeading = columnHeading;
        }
    }

    public void setLabel(String label, int row) {
        if (row < 0 || row >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        if (this.rowLabelHeading.equals("")) {
            this.rowLabelHeading = "Label";
        }
        this.rowLabels[row] = label;
    }

    public void disableRowLabels() {
        this.rowLabels = null;
    }

    public float[] getColumn(int column) {
        if (column < 0 || column >= 150) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        if (this.columns[column] == null) {
            return null;
        }
        float[] data = new float[this.counter];
        for (int i = 0; i < this.counter; ++i) {
            data[i] = (float)this.columns[column][i];
        }
        return data;
    }

    public boolean columnExists(int column) {
        if (column < 0 || column >= 150) {
            return false;
        }
        return this.columns[column] != null;
    }

    public int getColumnIndex(String heading) {
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.headings[i] == null) {
                return -1;
            }
            if (!this.headings[i].equals(heading)) continue;
            return i;
        }
        return -1;
    }

    public int getFreeColumn(String heading) {
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.headings[i] == null) {
                this.columns[i] = new double[this.maxRows];
                this.headings[i] = heading;
                if (i > this.lastColumn) {
                    this.lastColumn = i;
                }
                return i;
            }
            if (!this.headings[i].equals(heading)) continue;
            return -2;
        }
        return -3;
    }

    public double getValueAsDouble(int column, int row) {
        if (this.columns[column] == null) {
            throw new IllegalArgumentException("Column not defined: " + column);
        }
        if (column >= 150 || row >= this.counter) {
            throw new IllegalArgumentException("Index out of range: " + column + "," + row);
        }
        return this.columns[column][row];
    }

    public float getValue(int column, int row) {
        return (float)this.getValueAsDouble(column, row);
    }

    public double getValue(String column, int row) {
        if (row < 0 || row >= this.getCounter()) {
            throw new IllegalArgumentException("Row out of range");
        }
        int col = this.getColumnIndex(column);
        if (col == -1) {
            throw new IllegalArgumentException("\"" + column + "\" column not found");
        }
        return this.getValueAsDouble(col, row);
    }

    public void setValue(String column, int row, double value) {
        int col = this.getColumnIndex(column);
        if (col == -1 && (col = this.getFreeColumn(column)) == -3) {
            throw new IllegalArgumentException("Too many columns (>" + (150 - this.defaultHeadings.length) + ")");
        }
        this.setValue(col, row, value);
    }

    public void setValue(int column, int row, double value) {
        if (column < 0 || column >= 150) {
            throw new IllegalArgumentException("Column out of range: " + column);
        }
        if (row >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.columns[column] == null) {
            this.columns[column] = new double[this.maxRows];
            if (column > this.lastColumn) {
                this.lastColumn = column;
            }
        }
        this.columns[column][row] = value;
    }

    public String getColumnHeadings() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(" \t");
        if (this.rowLabels != null) {
            sb.append(this.rowLabelHeading + "\t");
        }
        for (int i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            String heading = this.headings[i];
            if (heading == null) {
                heading = "---";
            }
            sb.append(heading + "\t");
        }
        return new String(sb);
    }

    public String getColumnHeading(int column) {
        if (column < 0 || column >= 150) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        return this.headings[column];
    }

    public String getRowAsString(int row) {
        if (row < 0 || row >= this.counter) {
            throw new IllegalArgumentException("Row out of range: " + row);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(200);
        } else {
            this.sb.setLength(0);
        }
        this.sb.append(Integer.toString(row + 1));
        this.sb.append("\t");
        if (this.rowLabels != null) {
            if (this.rowLabels[row] != null) {
                this.sb.append(this.rowLabels[row]);
            }
            this.sb.append("\t");
        }
        for (int i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            this.sb.append(this.n(this.columns[i][row]));
        }
        return new String(this.sb);
    }

    public void setHeading(int column, String heading) {
        if (column < 0 || column >= this.headings.length) {
            throw new IllegalArgumentException("Column out of range: " + column);
        }
        this.headings[column] = heading;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    String n(double n) {
        String s = (double)Math.round(n) == n ? IJ.d2s(n, 0) : IJ.d2s(n, this.precision);
        return s + "\t";
    }

    public synchronized void deleteRow(int row) {
        int i;
        if (this.counter == 0 || row > this.counter - 1) {
            return;
        }
        if (this.counter == 1) {
            this.reset();
            return;
        }
        if (this.rowLabels != null) {
            for (i = row; i < this.counter - 1; ++i) {
                this.rowLabels[i] = this.rowLabels[i + 1];
            }
        }
        for (i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            for (int j = row; j < this.counter - 1; ++j) {
                this.columns[i][j] = this.columns[i][j + 1];
            }
        }
        --this.counter;
    }

    public synchronized void reset() {
        this.counter = 0;
        this.maxRows = 100;
        for (int i = 0; i <= this.lastColumn; ++i) {
            this.columns[i] = null;
            this.headings[i] = i < this.defaultHeadings.length ? this.defaultHeadings[i] : null;
        }
        this.lastColumn = -1;
        this.rowLabels = null;
    }

    public void show(String windowTitle) {
        TextPanel tp;
        String tableHeadings = this.getColumnHeadings();
        if (windowTitle.equals("Results")) {
            tp = IJ.getTextPanel();
            if (tp == null) {
                return;
            }
            IJ.setColumnHeadings(tableHeadings);
        } else {
            Frame frame = WindowManager.getFrame(windowTitle);
            TextWindow win = frame != null && frame instanceof TextWindow ? (TextWindow)frame : new TextWindow(windowTitle, "", 300, 200);
            tp = win.getTextPanel();
            tp.setColumnHeadings(tableHeadings);
        }
        int n = this.getCounter();
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n * tableHeadings.length());
            for (int i = 0; i < n; ++i) {
                sb.append(this.getRowAsString(i) + "\n");
            }
            tp.append(new String(sb));
        }
    }

    public String toString() {
        return "ctr=" + this.counter + ", hdr=" + this.getColumnHeadings();
    }
}

