/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FFT
implements PlugIn,
Measurements {
    public static boolean displayRawPS;
    public static boolean displayFHT;
    public static String fileName;
    private ImagePlus imp;
    private String arg;
    private FHT transform;
    private ImageProcessor filter;
    private static boolean processStack;
    private boolean padded;
    private int originalWidth;
    private int originalHeight;
    private int stackSize = 1;
    private int slice = 1;

    public void run(String arg) {
        boolean inverse;
        if (arg.equals("options")) {
            this.showDialog();
            return;
        }
        this.imp = IJ.getImage();
        if (arg.equals("redisplay")) {
            this.redisplayPowerSpectrum();
            return;
        }
        ImageProcessor ip = this.imp.getProcessor();
        Object obj = this.imp.getProperty("FHT");
        FHT fht = obj instanceof FHT ? (FHT)obj : null;
        this.stackSize = this.imp.getStackSize();
        if (fht == null && arg.equals("inverse")) {
            IJ.error("FFT", "Frequency domain image required");
            return;
        }
        if (fht != null) {
            inverse = true;
            this.imp.killRoi();
        } else {
            if (this.imp.getRoi() != null) {
                ip = ip.crop();
            }
            fht = this.newFHT(ip);
            inverse = false;
        }
        if (inverse) {
            this.doInverseTransform(fht, ip);
        } else {
            if (displayRawPS || displayFHT) {
                fileName = this.imp.getTitle();
            }
            this.doForewardTransform(fht, ip);
        }
        IJ.showProgress(1.0);
    }

    void doInverseTransform(FHT fht, ImageProcessor ip) {
        ImagePlus imp2;
        String title;
        fht = fht.getCopy();
        this.doMasking(fht);
        this.showStatus("Inverse transform");
        fht.inverseTransform();
        if (fht.quadrantSwapNeeded) {
            fht.swapQuadrants();
        }
        fht.resetMinAndMax();
        ImageProcessor ip2 = fht;
        if (fht.originalWidth > 0) {
            fht.setRoi(0, 0, fht.originalWidth, fht.originalHeight);
            ip2 = fht.crop();
        }
        int bitDepth = fht.originalBitDepth > 0 ? fht.originalBitDepth : this.imp.getBitDepth();
        switch (bitDepth) {
            case 8: {
                ip2 = ip2.convertToByte(false);
                break;
            }
            case 16: {
                ip2 = ip2.convertToShort(false);
                break;
            }
            case 24: {
                this.showStatus("Setting brightness");
                if (fht.rgb == null || ip2 == null) {
                    IJ.error("FFT", "Unable to set brightness");
                    return;
                }
                ColorProcessor rgb = (ColorProcessor)fht.rgb.duplicate();
                rgb.setBrightness((FloatProcessor)ip2);
                ip2 = rgb;
                fht.rgb = null;
                break;
            }
        }
        if (bitDepth != 24 && fht.originalColorModel != null) {
            ip2.setColorModel(fht.originalColorModel);
        }
        if ((title = this.imp.getTitle()).startsWith("FFT of ")) {
            title = title.substring(7, title.length());
        }
        if ((imp2 = new ImagePlus("Inverse FFT of " + title, ip2)).getWidth() == this.imp.getWidth()) {
            imp2.setCalibration(this.imp.getCalibration());
        }
        imp2.show();
    }

    public void doForewardTransform(FHT fht, ImageProcessor ip) {
        this.showStatus("Foreward transform");
        fht.transform();
        this.showStatus("Calculating power spectrum");
        ImageProcessor ps = fht.getPowerSpectrum();
        ImagePlus imp2 = new ImagePlus("FFT of " + this.imp.getTitle(), ps);
        imp2.show();
        imp2.setProperty("FHT", fht);
        imp2.setCalibration(this.imp.getCalibration());
    }

    FHT newFHT(ImageProcessor ip) {
        FHT fht;
        if (ip instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            FloatProcessor ip2 = ((ColorProcessor)ip).getBrightness();
            fht = new FHT(this.pad(ip2));
            fht.rgb = (ColorProcessor)ip.duplicate();
        } else {
            fht = new FHT(this.pad(ip));
        }
        if (this.padded) {
            fht.originalWidth = this.originalWidth;
            fht.originalHeight = this.originalHeight;
        }
        fht.originalBitDepth = this.imp.getBitDepth();
        fht.originalColorModel = ip.getColorModel();
        return fht;
    }

    ImageProcessor pad(ImageProcessor ip) {
        int i;
        this.originalWidth = ip.getWidth();
        this.originalHeight = ip.getHeight();
        int maxN = Math.max(this.originalWidth, this.originalHeight);
        for (i = 2; i < maxN; i *= 2) {
        }
        if (i == maxN && this.originalWidth == this.originalHeight) {
            this.padded = false;
            return ip;
        }
        maxN = i;
        this.showStatus("Padding to " + maxN + "x" + maxN);
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 2, null);
        ImageProcessor ip2 = ip.createProcessor(maxN, maxN);
        ip2.setValue(stats.mean);
        ip2.fill();
        ip2.insert(ip, 0, 0);
        this.padded = true;
        Undo.reset();
        return ip2;
    }

    void showStatus(String msg) {
        if (this.stackSize > 1) {
            IJ.showStatus("FFT: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(msg);
        }
    }

    void doMasking(FHT ip) {
        if (this.stackSize > 1) {
            return;
        }
        float[] fht = (float[])ip.getPixels();
        ImageProcessor mask = this.imp.getProcessor();
        mask = mask.convertToByte(false);
        ImageStatistics stats = ImageStatistics.getStatistics(mask, 16, null);
        if (stats.histogram[0] == 0 && stats.histogram[255] == 0) {
            return;
        }
        boolean passMode = stats.histogram[255] != 0;
        IJ.showStatus("Masking: " + (passMode ? "pass" : "filter"));
        mask = mask.duplicate();
        if (passMode) {
            this.changeValues(mask, 0, 254, 0);
        } else {
            this.changeValues(mask, 1, 255, 255);
        }
        for (int i = 0; i < 3; ++i) {
            mask.smooth();
        }
        ip.swapQuadrants(mask);
        byte[] maskPixels = (byte[])mask.getPixels();
        for (int i = 0; i < fht.length; ++i) {
            fht[i] = (float)((double)(fht[i] * (float)(maskPixels[i] & 0xFF)) / 255.0);
        }
    }

    void changeValues(ImageProcessor ip, int v1, int v2, int v3) {
        byte[] pixels = (byte[])ip.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            int v = pixels[i] & 0xFF;
            if (v < v1 || v > v2) continue;
            pixels[i] = (byte)v3;
        }
    }

    public void redisplayPowerSpectrum() {
        FHT fht = (FHT)this.imp.getProperty("FHT");
        if (fht == null) {
            IJ.error("FFT", "Frequency domain image required");
            return;
        }
        ImageProcessor ps = fht.getPowerSpectrum();
        this.imp.setProcessor(null, ps);
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("FFT Options");
        gd.addMessage("Display:");
        gd.addCheckbox("Raw 32-bit Power Spectrum", displayRawPS);
        gd.addCheckbox("Fast Hartley Transform", displayFHT);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        displayRawPS = gd.getNextBoolean();
        displayFHT = gd.getNextBoolean();
    }
}

