/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.io.PluginClassLoader;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Macro_Runner
implements PlugIn {
    public void run(String name) {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        if (!threadName.endsWith("Macro$")) {
            thread.setName(threadName + "Macro$");
        }
        String path = null;
        if (name.equals("")) {
            OpenDialog od = new OpenDialog("Run Macro...", path);
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name != null) {
                this.runMacroFile(directory + name, null);
            }
        } else if (name.startsWith("JAR:")) {
            this.runMacroFromJar(name);
        } else {
            path = Menus.getPlugInsPath() + name;
            this.runMacroFile(path, null);
        }
    }

    void runMacroFromJar(String name) {
        name = name.substring(4);
        String macro = null;
        try {
            int n;
            PluginClassLoader pcl = new PluginClassLoader(Menus.getPlugInsPath());
            InputStream is = pcl.getResourceAsStream("/" + name);
            if (is == null) {
                IJ.showMessage("Macro Runner", "Unable to load \"" + name + "\" from jar file");
                return;
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("Macro Runner", msg);
        }
        if (macro != null) {
            this.runMacro(macro, null);
        }
    }

    public String runMacroFile(String name, String arg) {
        File file;
        int size;
        String macrosDir;
        boolean fullPath;
        if (name.startsWith("ij.jar:")) {
            return this.runMacroFromIJJar(name, arg);
        }
        if (name.indexOf(".") == -1) {
            name = name + ".txt";
        }
        String name2 = name;
        boolean bl = fullPath = name.startsWith("/") || name.indexOf(":\\") == 1;
        if (!fullPath && (macrosDir = Menus.getMacrosPath()) != null) {
            name2 = Menus.getMacrosPath() + name;
        }
        if ((size = (int)(file = new File(name2)).length()) <= 0 && !fullPath) {
            file = new File(System.getProperty("user.dir") + File.separator + name);
            size = (int)file.length();
        }
        if (size <= 0) {
            IJ.error("RunMacro", "Macro file not found:\n \n" + name2);
            return null;
        }
        try {
            byte[] buffer = new byte[size];
            FileInputStream in = new FileInputStream(file);
            in.read(buffer, 0, size);
            String macro = new String(buffer, 0, size, "ISO8859_1");
            in.close();
            return this.runMacro(macro, arg);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return null;
        }
    }

    public String runMacro(String macro, String arg) {
        try {
            Interpreter interp = new Interpreter();
            return interp.run(macro, arg);
        }
        catch (Throwable e) {
            Interpreter.abort();
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.unlock();
            }
            String msg = e.getMessage();
            if (e instanceof RuntimeException && msg != null && e.getMessage().equals("Macro canceled")) {
                return null;
            }
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            e.printStackTrace(pw);
            String s = caw.toString();
            if (IJ.isMacintosh()) {
                s = Tools.fixNewLines(s);
            }
            if (s.indexOf("NullPointerException") < 0 || s.indexOf("ij.process") < 0) {
                if (IJ.getInstance() != null) {
                    new TextWindow("Exception", s, 350, 250);
                } else {
                    IJ.log(s);
                }
            }
            return null;
        }
    }

    public String runMacroFromIJJar(String name, String arg) {
        ImageJ ij = IJ.getInstance();
        if (ij == null) {
            return null;
        }
        name = name.substring(7);
        String macro = null;
        try {
            int n;
            InputStream is = ij.getClass().getResourceAsStream("/macros/" + name + ".txt");
            if (is == null) {
                return this.runMacroFile(name, arg);
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("Macro Runner", msg);
        }
        if (macro != null) {
            return this.runMacro(macro, arg);
        }
        return null;
    }
}

