/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.awt.Rectangle;

public class RGBStackConverter
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        int size = imp.getStackSize();
        if (size < 2 || size > 3) {
            IJ.error("2 or 3 slice stack required");
            return;
        }
        int type = imp.getType();
        if (type != 0 && type != 1) {
            IJ.error("8-bit or 16-bit grayscale stack required");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        Undo.reset();
        if (type == 1) {
            this.sixteenBitsToRGB(imp);
        } else {
            ImagePlus imp2 = imp.createImagePlus();
            imp2.setStack(imp.getTitle() + " (RGB)", imp.getStack());
            ImageConverter ic = new ImageConverter(imp2);
            ic.convertRGBStackToRGB();
            if (imp.getWindow() != null) {
                new ImageWindow(imp2);
            }
        }
        imp.unlock();
    }

    void sixteenBitsToRGB(ImagePlus imp) {
        ImageProcessor ip2;
        Rectangle r;
        Roi roi = imp.getRoi();
        if (roi != null) {
            r = roi.getBounds();
            int width = r.width;
            int height = r.height;
        } else {
            r = new Rectangle(0, 0, imp.getWidth(), imp.getHeight());
        }
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(r.width, r.height);
        for (int i = 1; i <= stack1.getSize(); ++i) {
            ImageProcessor ip = stack1.getProcessor(i);
            ip.setRoi(r);
            ip2 = ip.crop();
            stack2.addSlice(null, ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(imp.getTitle() + " (RGB)", stack2);
        ip2 = imp2.getProcessor();
        StackConverter sc = new StackConverter(imp2);
        sc.convertToGray8();
        ImageConverter ic = new ImageConverter(imp2);
        ic.convertRGBStackToRGB();
        imp2.show();
    }
}

