/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class ScaleBar
implements PlugIn {
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static final String[] colors = new String[]{"White", "Black", "Light Gray", "Gray", "Dark Gray", "Red", "Green", "Blue", "Yellow"};
    static final String[] checkboxLabels = new String[]{"Bold Text", "Hide Text"};
    static double barWidth;
    static int defaultBarHeight;
    static int barHeightInPixels;
    static String location;
    static String color;
    static boolean boldText;
    static boolean hideText;
    static int fontSize;
    static boolean labelAll;
    ImagePlus imp;
    double imageWidth;
    double mag;
    int xloc;
    int yloc;
    int barWidthInPixels;
    int roiX = -1;
    int roiY;
    int roiWidth;
    int roiHeight;
    boolean[] checkboxStates = new boolean[2];

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp != null) {
            if (this.showDialog(this.imp) && this.imp.getStackSize() > 1 && labelAll) {
                this.labelSlices(this.imp);
            }
        } else {
            IJ.noImage();
        }
    }

    void labelSlices(ImagePlus imp) {
        int slice = imp.getCurrentSlice();
        for (int i = 1; i <= imp.getStackSize(); ++i) {
            imp.setSlice(i);
            this.drawScaleBar(imp);
        }
        imp.setSlice(slice);
    }

    boolean showDialog(ImagePlus imp) {
        int digits;
        Roi roi = imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            this.roiX = r.x;
            this.roiY = r.y;
            this.roiWidth = r.width;
            this.roiHeight = r.height;
            location = locations[4];
        } else if (location.equals(locations[4])) {
            location = locations[0];
        }
        Calibration cal = imp.getCalibration();
        ImageWindow win = imp.getWindow();
        double d = this.mag = win != null ? win.getCanvas().getMagnification() : 1.0;
        if (this.mag > 1.0) {
            this.mag = 1.0;
        }
        if ((double)fontSize < 12.0 / this.mag) {
            fontSize = (int)(12.0 / this.mag);
        }
        String units = cal.getUnits();
        double pixelWidth = cal.pixelWidth;
        if (pixelWidth == 0.0) {
            pixelWidth = 1.0;
        }
        double scale = 1.0 / pixelWidth;
        this.imageWidth = (double)imp.getWidth() * pixelWidth;
        if (this.roiX > 0 && this.roiWidth > 10) {
            barWidth = (double)this.roiWidth * pixelWidth;
        } else if (barWidth == 0.0 || barWidth > 0.67 * this.imageWidth) {
            barWidth = 80.0 * pixelWidth / this.mag;
            if (barWidth > 0.67 * this.imageWidth) {
                barWidth = 0.67 * this.imageWidth;
            }
            if (barWidth > 5.0) {
                barWidth = (int)barWidth;
            }
        }
        int stackSize = imp.getStackSize();
        int n = digits = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            digits = 2;
        }
        int percent = (int)(barWidth * 100.0 / this.imageWidth);
        if (this.mag < 1.0 && (double)barHeightInPixels < (double)defaultBarHeight / this.mag) {
            barHeightInPixels = (int)((double)defaultBarHeight / this.mag);
        }
        imp.getProcessor().snapshot();
        if (!IJ.macroRunning()) {
            this.updateScalebar();
        }
        BarDialog gd = new BarDialog("Scale Bar");
        gd.addNumericField("Width in " + units + ": ", barWidth, digits);
        gd.addNumericField("Height in pixels: ", barHeightInPixels, 0);
        gd.addNumericField("Font Size: ", fontSize, 0);
        gd.addChoice("Color: ", colors, color);
        gd.addChoice("Location: ", locations, location);
        this.checkboxStates[0] = boldText;
        this.checkboxStates[1] = hideText;
        gd.addCheckboxGroup(1, 2, checkboxLabels, this.checkboxStates);
        if (stackSize > 1) {
            gd.addCheckbox("Label all Slices", labelAll);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            imp.getProcessor().reset();
            imp.updateAndDraw();
            return false;
        }
        barWidth = gd.getNextNumber();
        barHeightInPixels = (int)gd.getNextNumber();
        fontSize = (int)gd.getNextNumber();
        color = gd.getNextChoice();
        location = gd.getNextChoice();
        boldText = gd.getNextBoolean();
        hideText = gd.getNextBoolean();
        if (stackSize > 1) {
            labelAll = gd.getNextBoolean();
        }
        if (IJ.macroRunning()) {
            this.updateScalebar();
        }
        return true;
    }

    void drawScaleBar(ImagePlus imp) {
        int digits;
        if (!this.updateLocation()) {
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        Undo.setup(1, imp);
        Color color = this.getColor();
        ip.setColor(color);
        int x = this.xloc;
        int y = this.yloc;
        ip.setRoi(x, y, this.barWidthInPixels, barHeightInPixels);
        ip.fill();
        ip.resetRoi();
        int fontType = boldText ? 1 : 0;
        ip.setFont(new Font("SansSerif", fontType, fontSize));
        ip.setAntialiasedText(true);
        int n = digits = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            digits = 2;
        }
        String label = IJ.d2s(barWidth, digits) + " " + imp.getCalibration().getUnits();
        x += (this.barWidthInPixels - ip.getStringWidth(label)) / 2;
        y = y + barHeightInPixels + fontSize + fontSize / 4;
        if (!hideText) {
            ip.drawString(label, x, y);
        }
        imp.updateAndDraw();
    }

    boolean updateLocation() {
        Calibration cal = this.imp.getCalibration();
        this.barWidthInPixels = (int)(barWidth / cal.pixelWidth);
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int fraction = 20;
        int x = width - width / fraction - this.barWidthInPixels;
        int y = 0;
        if (location.equals(locations[0])) {
            y = height / fraction;
        } else if (location.equals(locations[1])) {
            y = height - height / fraction - barHeightInPixels - fontSize;
        } else if (location.equals(locations[3])) {
            x = width / fraction;
            y = height / fraction;
        } else if (location.equals(locations[2])) {
            x = width / fraction;
            y = height - height / fraction - barHeightInPixels - fontSize;
        } else {
            if (this.roiX == -1) {
                return false;
            }
            x = this.roiX;
            y = this.roiY;
        }
        this.xloc = x;
        this.yloc = y;
        return true;
    }

    Color getColor() {
        Color c = Color.white;
        if (color.equals(colors[1])) {
            c = Color.black;
        } else if (color.equals(colors[2])) {
            c = Color.lightGray;
        } else if (color.equals(colors[3])) {
            c = Color.gray;
        } else if (color.equals(colors[4])) {
            c = Color.darkGray;
        } else if (color.equals(colors[5])) {
            c = Color.red;
        } else if (color.equals(colors[6])) {
            c = Color.green;
        } else if (color.equals(colors[7])) {
            c = Color.blue;
        } else if (color.equals(colors[8])) {
            c = Color.yellow;
        }
        return c;
    }

    void updateScalebar() {
        this.updateLocation();
        this.imp.getProcessor().reset();
        this.drawScaleBar(this.imp);
    }

    static {
        barHeightInPixels = defaultBarHeight = 3;
        location = locations[0];
        color = colors[0];
        boldText = true;
    }

    class BarDialog
    extends GenericDialog {
        BarDialog(String title) {
            super(title);
        }

        public void textValueChanged(TextEvent e) {
            TextField widthField = (TextField)this.numberField.elementAt(0);
            Double d = this.getValue(widthField.getText());
            if (d == null) {
                return;
            }
            barWidth = d;
            TextField heightField = (TextField)this.numberField.elementAt(1);
            d = this.getValue(heightField.getText());
            if (d == null) {
                return;
            }
            barHeightInPixels = (int)d.doubleValue();
            TextField fontSizeField = (TextField)this.numberField.elementAt(2);
            d = this.getValue(fontSizeField.getText());
            if (d == null) {
                return;
            }
            int size = (int)d.doubleValue();
            if (size > 5) {
                fontSize = size;
            }
            ScaleBar.this.updateScalebar();
        }

        public void itemStateChanged(ItemEvent e) {
            Choice col = (Choice)this.choice.elementAt(0);
            color = col.getSelectedItem();
            Choice loc = (Choice)this.choice.elementAt(1);
            location = loc.getSelectedItem();
            boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            hideText = ((Checkbox)this.checkbox.elementAt(1)).getState();
            ScaleBar.this.updateScalebar();
        }
    }
}

