/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class Binary
implements PlugInFilter {
    String arg;
    ImagePlus imp;
    static int iterations = 1;
    static int count = 1;
    static boolean blackBackground = Prefs.blackBackground;
    int foreground;
    int background;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(Binary.class);
        if (arg.equals("options")) {
            this.showDialog();
            return 4096;
        }
        if (arg.equals("outline") || arg.equals("skel")) {
            if (imp != null && (imp.getType() == 0 || imp.getType() == 3)) {
                ImageStatistics stats = imp.getStatistics();
                if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                    IJ.error("8-bit binary (black and white only) image required.");
                    return 4096;
                }
            }
            return IJ.setupDialog(imp, 67);
        }
        return IJ.setupDialog(imp, 83);
    }

    public void run(ImageProcessor ip) {
        int n = this.foreground = blackBackground ? 255 : 0;
        if (ip.isInvertedLut()) {
            this.foreground = 255 - this.foreground;
        }
        this.background = 255 - this.foreground;
        if (this.arg.equals("erode")) {
            this.erode(ip);
        } else if (this.arg.equals("dilate")) {
            this.dilate(ip);
        } else if (this.arg.equals("open")) {
            this.open(ip);
        } else if (this.arg.equals("close")) {
            this.close(ip);
        } else if (this.arg.equals("outline")) {
            this.outline(ip);
        } else if (this.arg.equals("skel")) {
            this.skeletonize(ip);
        }
    }

    void erode(ImageProcessor ip) {
        for (int i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).erode(count, this.background);
        }
    }

    void dilate(ImageProcessor ip) {
        for (int i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).dilate(count, this.background);
        }
    }

    void open(ImageProcessor ip) {
        int i;
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).erode(count, this.background);
        }
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).dilate(count, this.background);
        }
    }

    void close(ImageProcessor ip) {
        int i;
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).dilate(count, this.background);
        }
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).erode(count, this.background);
        }
    }

    void outline(ImageProcessor ip) {
        if (blackBackground) {
            ip.invert();
        }
        ((ByteProcessor)ip).outline();
        if (blackBackground) {
            ip.invert();
        }
    }

    void skeletonize(ImageProcessor ip) {
        if (blackBackground) {
            ip.invert();
        }
        boolean edgePixels = this.hasEdgePixels(ip);
        ImageProcessor ip2 = this.expand(ip, edgePixels);
        ((ByteProcessor)ip2).skeletonize();
        ip = this.shrink(ip, ip2, edgePixels);
        if (blackBackground) {
            ip.invert();
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Binary Options");
        gd.addNumericField("Iterations (1-25):", iterations, 0, 3, "");
        gd.addNumericField("Count (1-8):", count, 0, 3, "");
        gd.addCheckbox("Black Background", blackBackground);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        Prefs.blackBackground = blackBackground = gd.getNextBoolean();
        if (n > 25) {
            n = 25;
        }
        if (n < 1) {
            n = 1;
        }
        iterations = n;
        count = (int)gd.getNextNumber();
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
    }

    boolean hasEdgePixels(ImageProcessor ip) {
        int y;
        int x;
        int width = ip.getWidth();
        int height = ip.getHeight();
        boolean edgePixels = false;
        for (x = 0; x < width; ++x) {
            if (ip.getPixel(x, 0) != this.foreground) continue;
            edgePixels = true;
        }
        for (x = 0; x < width; ++x) {
            if (ip.getPixel(x, height - 1) != this.foreground) continue;
            edgePixels = true;
        }
        for (y = 0; y < height; ++y) {
            if (ip.getPixel(0, y) != this.foreground) continue;
            edgePixels = true;
        }
        for (y = 0; y < height; ++y) {
            if (ip.getPixel(height - 1, y) != this.foreground) continue;
            edgePixels = true;
        }
        return edgePixels;
    }

    ImageProcessor expand(ImageProcessor ip, boolean hasEdgePixels) {
        if (hasEdgePixels) {
            ImageProcessor ip2 = ip.createProcessor(ip.getWidth() + 2, ip.getHeight() + 2);
            if (this.foreground == 0) {
                ip2.setColor(255);
                ip2.fill();
            }
            ip2.insert(ip, 1, 1);
            return ip2;
        }
        return ip;
    }

    ImageProcessor shrink(ImageProcessor ip, ImageProcessor ip2, boolean hasEdgePixels) {
        if (hasEdgePixels) {
            int width = ip.getWidth();
            int height = ip.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    ip.putPixel(x, y, ip2.getPixel(x + 1, y + 1));
                }
            }
        }
        return ip;
    }
}

