/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class FractalBoxCounter
implements PlugInFilter {
    static String sizes = "2,3,4,6,8,12,16,32,64";
    int[] boxSizes;
    float[] boxCountSums;
    int maxBoxSize;
    int[] counts;
    Rectangle roi;
    int foreground;
    ImagePlus imp;
    int boxSum;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 129;
    }

    public void run(ImageProcessor ip) {
        String s = IJ.getString("Box sizes:", sizes);
        if (s.equals("")) {
            return;
        }
        this.boxSizes = this.s2ints(s);
        if (this.boxSizes == null || this.boxSizes.length < 1) {
            return;
        }
        this.boxCountSums = new float[this.boxSizes.length];
        sizes = s;
        for (int i = 0; i < this.boxSizes.length; ++i) {
            this.maxBoxSize = Math.max(this.maxBoxSize, this.boxSizes[i]);
        }
        this.counts = new int[this.maxBoxSize * this.maxBoxSize + 1];
        this.imp.killRoi();
        ImageStatistics stats = this.imp.getStatistics();
        if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        this.foreground = stats.histogram[0] > stats.histogram[255] ? 255 : 0;
        this.doBoxCounts(ip);
        IJ.register(FractalBoxCounter.class);
    }

    public int[] s2ints(String s) {
        StringTokenizer st = new StringTokenizer(s, ", \t");
        int nInts = st.countTokens();
        int[] ints = new int[nInts];
        for (int i = 0; i < nInts; ++i) {
            try {
                ints[i] = Integer.parseInt(st.nextToken());
                continue;
            }
            catch (NumberFormatException e) {
                IJ.write("" + e);
                return null;
            }
        }
        return ints;
    }

    boolean FindMargins(ImageProcessor ip) {
        if (IJ.debugMode) {
            IJ.log("FindMargins");
        }
        int[] histogram = new int[256];
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int left = -1;
        do {
            if (++left >= width) {
                IJ.error("No non-backround pixels found.");
                return false;
            }
            ip.setRoi(left, 0, 1, height);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        int top = -1;
        do {
            ip.setRoi(left, ++top, width - left, 1);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        int right = width + 1;
        do {
            ip.setRoi(--right - 1, top, 1, height - top);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        int bottom = height + 1;
        do {
            ip.setRoi(left, --bottom - 1, right - left, 1);
        } while ((histogram = ip.getHistogram())[this.foreground] == 0);
        this.roi = new Rectangle(left, top, right - left, bottom - top);
        return true;
    }

    void displayCounts(int size) {
        this.boxSum = 0;
        int maxCount = size * size;
        for (int i = 1; i <= maxCount; ++i) {
            int nBoxes = this.counts[i];
            if (nBoxes == 0) continue;
            this.boxSum += nBoxes;
        }
        IJ.write(size + "\t" + this.boxSum);
    }

    void count(int size, ImageProcessor ip) {
        int[] histogram = new int[256];
        int x = this.roi.x;
        int y = this.roi.y;
        int w = size <= this.roi.width ? size : this.roi.width;
        int h = size <= this.roi.height ? size : this.roi.height;
        int right = this.roi.x + this.roi.width;
        int bottom = this.roi.y + this.roi.height;
        int maxCount = size * size;
        for (int i = 1; i <= maxCount; ++i) {
            this.counts[i] = 0;
        }
        boolean done = false;
        do {
            ip.setRoi(x, y, w, h);
            histogram = ip.getHistogram();
            int n = histogram[this.foreground];
            this.counts[n] = this.counts[n] + 1;
            if ((x += size) + size < right) continue;
            w = right - x;
            if (x < right) continue;
            w = size;
            x = this.roi.x;
            if ((y += size) + size >= bottom) {
                h = bottom - y;
            }
            boolean bl = done = y >= bottom;
        } while (!done);
        this.displayCounts(size);
    }

    void plot() {
        int i;
        int n = this.boxSizes.length;
        float[] sizes = new float[this.boxSizes.length];
        for (int i2 = 0; i2 < n; ++i2) {
            sizes[i2] = (float)Math.log(this.boxSizes[i2]);
        }
        CurveFitter cf = new CurveFitter(Tools.toDouble(sizes), Tools.toDouble(this.boxCountSums));
        cf.doFit(0);
        double[] p = cf.getParams();
        String label = "D=" + IJ.d2s(-p[1], 4);
        float[] px = new float[100];
        float[] py = new float[100];
        double[] a = Tools.getMinMax(sizes);
        double xmin = a[0];
        double xmax = a[1];
        a = Tools.getMinMax(this.boxCountSums);
        double ymin = a[0];
        double ymax = a[1];
        double inc = (xmax - xmin) / 99.0;
        double tmp = xmin;
        for (i = 0; i < 100; ++i) {
            px[i] = (float)tmp;
            tmp += inc;
        }
        for (i = 0; i < 100; ++i) {
            py[i] = (float)CurveFitter.f(0, p, px[i]);
        }
        a = Tools.getMinMax(py);
        ymin = Math.min(ymin, a[0]);
        ymax = Math.max(ymax, a[1]);
        Plot plot = new Plot("Plot", "log(box size)", "log(count)", px, py);
        plot.setLimits(xmin, xmax, ymin, ymax);
        plot.addPoints(sizes, this.boxCountSums, 0);
        plot.addLabel(0.8, 0.2, label);
        plot.show();
        IJ.write("");
        IJ.write(label);
    }

    void doBoxCounts(ImageProcessor ip) {
        if (!this.FindMargins(ip)) {
            return;
        }
        IJ.setColumnHeadings("size\tcount");
        for (int i = 0; i < this.boxSizes.length; ++i) {
            this.count(this.boxSizes[i], ip);
            this.boxCountSums[i] = (float)Math.log(this.boxSum);
        }
        this.plot();
        this.imp.killRoi();
    }
}

