/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class RGBStackSplitter
implements PlugInFilter {
    ImagePlus imp;
    public ImageStack red;
    public ImageStack green;
    public ImageStack blue;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 272;
    }

    public void run(ImageProcessor ip) {
        this.split(this.imp);
    }

    public void split(ImagePlus imp) {
        this.split(imp.getStack(), true);
        String title = imp.getTitle();
        Calibration cal = imp.getCalibration();
        if (!IJ.altKeyDown()) {
            imp.hide();
        }
        ImagePlus rImp = new ImagePlus(title + " (red)", this.red);
        rImp.setCalibration(cal);
        rImp.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus gImp = new ImagePlus(title + " (green)", this.green);
        gImp.setCalibration(cal);
        gImp.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus bImp = new ImagePlus(title + " (blue)", this.blue);
        bImp.setCalibration(cal);
        bImp.show();
    }

    public void split(ImageStack rgb, boolean keepSource) {
        int w = rgb.getWidth();
        int h = rgb.getHeight();
        this.red = new ImageStack(w, h);
        this.green = new ImageStack(w, h);
        this.blue = new ImageStack(w, h);
        int slice = 1;
        int inc = keepSource ? 1 : 0;
        int n = rgb.getSize();
        for (int i = 1; i <= n; ++i) {
            IJ.showStatus(i + "/" + n);
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            ColorProcessor cp = (ColorProcessor)rgb.getProcessor(slice);
            slice += inc;
            cp.getRGB(r, g, b);
            if (!keepSource) {
                rgb.deleteSlice(1);
            }
            this.red.addSlice(null, r);
            this.green.addSlice(null, g);
            this.blue.addSlice(null, b);
            IJ.showProgress((double)i / (double)n);
        }
    }
}

