/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Resizer
implements PlugInFilter,
TextListener,
ItemListener {
    ImagePlus imp;
    private boolean crop;
    private static int newWidth;
    private static int newHeight;
    private static boolean constrain;
    private static boolean interpolate;
    private Vector fields;
    private Vector checkboxes;
    private double origWidth;
    private double origHeight;
    private boolean sizeToHeight;

    public int setup(String arg, ImagePlus imp) {
        this.crop = arg.equals("crop");
        this.imp = imp;
        IJ.register(Resizer.class);
        if (this.crop) {
            return 1183;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isLine()) {
            IJ.error("The Crop and Adjust->Size commands\ndo not work with line selections.");
            return;
        }
        Rectangle r = ip.getRoi();
        this.origWidth = r.width;
        this.origHeight = r.height;
        this.sizeToHeight = false;
        if (this.crop) {
            Rectangle bounds = roi.getBounds();
            newWidth = bounds.width;
            newHeight = bounds.height;
            interpolate = false;
        } else {
            if (newWidth == 0 || newHeight == 0) {
                newWidth = (int)this.origWidth / 2;
                newHeight = (int)this.origHeight / 2;
            }
            if (constrain) {
                newHeight = (int)((double)newWidth * (this.origHeight / this.origWidth));
            }
            GenericDialog gd = new GenericDialog("Resize", IJ.getInstance());
            gd.addNumericField("Width (pixels):", newWidth, 0);
            gd.addNumericField("Height (pixels):", newHeight, 0);
            gd.addCheckbox("Constrain Aspect Ratio", constrain);
            gd.addCheckbox("Interpolate", interpolate);
            gd.addMessage("NOTE: Undo is not available");
            this.fields = gd.getNumericFields();
            for (int i = 0; i < this.fields.size(); ++i) {
                ((TextField)this.fields.elementAt(i)).addTextListener(this);
            }
            this.checkboxes = gd.getCheckboxes();
            ((Checkbox)this.checkboxes.elementAt(0)).addItemListener(this);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            newWidth = (int)gd.getNextNumber();
            newHeight = (int)gd.getNextNumber();
            if (gd.invalidNumber()) {
                IJ.error("Width or height are invalid.");
                return;
            }
            constrain = gd.getNextBoolean();
            interpolate = gd.getNextBoolean();
            if (constrain && newWidth == 0) {
                this.sizeToHeight = true;
            }
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        if (!this.crop && constrain) {
            if (this.sizeToHeight) {
                newWidth = (int)((double)newHeight * (this.origWidth / this.origHeight));
            } else {
                newHeight = (int)((double)newWidth * (this.origHeight / this.origWidth));
            }
        }
        ip.setInterpolate(interpolate);
        int nSlices = this.imp.getStackSize();
        try {
            StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
            ImageStack s2 = sp.resize(newWidth, newHeight);
            int newSize = s2.getSize();
            if (s2.getWidth() > 0 && newSize > 0) {
                boolean restoreRoi;
                boolean bl = restoreRoi = this.crop && roi != null && roi.getType() != 0;
                if (restoreRoi) {
                    this.imp.killRoi();
                }
                this.imp.hide();
                Calibration cal = this.imp.getCalibration();
                if (cal.scaled()) {
                    cal.pixelWidth *= this.origWidth / (double)newWidth;
                    cal.pixelHeight *= this.origHeight / (double)newHeight;
                    this.imp.setCalibration(cal);
                }
                this.imp.setStack(null, s2);
                this.imp.show();
                if (restoreRoi) {
                    this.imp.restoreRoi();
                }
            }
            if (nSlices > 1 && newSize < nSlices) {
                IJ.error("ImageJ ran out of memory causing \nthe last " + (nSlices - newSize) + " slices to be lost.");
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Resize");
        }
    }

    public void textValueChanged(TextEvent e) {
        TextField widthField = (TextField)this.fields.elementAt(0);
        TextField heightField = (TextField)this.fields.elementAt(1);
        int width = (int)Tools.parseDouble(widthField.getText(), -99.0);
        int height = (int)Tools.parseDouble(heightField.getText(), -99.0);
        if (width == -99 || height == -99) {
            return;
        }
        if (constrain) {
            if (width != newWidth) {
                this.sizeToHeight = false;
                newWidth = width;
                this.updateFields();
            } else if (height != newHeight) {
                this.sizeToHeight = true;
                newHeight = height;
                this.updateFields();
            }
        }
    }

    void updateFields() {
        if (this.sizeToHeight) {
            newWidth = (int)((double)newHeight * (this.origWidth / this.origHeight));
            TextField widthField = (TextField)this.fields.elementAt(0);
            widthField.setText("" + newWidth);
        } else {
            newHeight = (int)((double)newWidth * (this.origHeight / this.origWidth));
            TextField heightField = (TextField)this.fields.elementAt(1);
            heightField.setText("" + newHeight);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Checkbox cb = (Checkbox)this.checkboxes.elementAt(0);
        boolean newConstrain = cb.getState();
        if (newConstrain && newConstrain != constrain) {
            this.updateFields();
        }
        constrain = newConstrain;
    }

    static {
        constrain = true;
        interpolate = true;
    }
}

