/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.MessageDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener {
    static final int BUTTONS = 10;
    Panel panel;
    static Frame instance;
    List list;
    Hashtable rois = new Hashtable();
    Roi roiCopy;
    int slice2;
    boolean canceled;
    boolean macro;
    boolean ignoreInterrupts;

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        ImageJ ij = IJ.getInstance();
        this.addKeyListener(ij);
        WindowManager.addWindow(this);
        this.setLayout(new FlowLayout(1, 5, 5));
        int rows = 15;
        boolean allowMultipleSelections = IJ.isMacintosh();
        this.list = new List(rows, allowMultipleSelections);
        this.list.add("012345678901234");
        this.list.addItemListener(this);
        this.list.addKeyListener(ij);
        this.add(this.list);
        this.panel = new Panel();
        int nButtons = IJ.isJava2() ? 10 : 9;
        this.panel.setLayout(new GridLayout(nButtons, 1, 5, 0));
        this.addButton("Add");
        this.addButton("Update");
        this.addButton("Delete");
        this.addButton("Rename");
        this.addButton("Open");
        this.addButton("Save");
        this.addButton("Measure");
        this.addButton("Draw");
        this.addButton("Deselect");
        if (IJ.isJava2()) {
            this.addButton("Combine");
        }
        this.add(this.panel);
        this.pack();
        this.list.remove(0);
        GUI.center(this);
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        b.addKeyListener(IJ.getInstance());
        this.panel.add(b);
    }

    public void actionPerformed(ActionEvent e) {
        int modifiers = e.getModifiers();
        boolean altKeyDown = (modifiers & 8) != 0 || IJ.altKeyDown();
        boolean shiftKeyDown = (modifiers & 1) != 0 || IJ.shiftKeyDown();
        IJ.setKeyUp(18);
        IJ.setKeyUp(16);
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        if (command.equals("Add")) {
            this.add(shiftKeyDown, altKeyDown);
        } else if (command.equals("Update")) {
            this.update();
        } else if (command.equals("Delete")) {
            this.delete(false);
        } else if (command.equals("Rename")) {
            this.rename();
        } else if (command.equals("Open")) {
            this.open(null);
        } else if (command.equals("Save")) {
            this.save();
        } else if (command.equals("Measure")) {
            this.measure();
        } else if (command.equals("Draw")) {
            this.draw();
        } else if (command.equals("Deselect")) {
            this.select(-1);
        } else if (command.equals("Combine")) {
            this.combine();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && WindowManager.getCurrentImage() != null && !this.ignoreInterrupts) {
            int index = 0;
            try {
                index = Integer.parseInt(e.getItem().toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (index < 0) {
                index = 0;
            }
            this.restore(index, true);
        }
    }

    void add(boolean shiftKeyDown, boolean altKeyDown) {
        if (shiftKeyDown) {
            this.addAndDraw(altKeyDown);
        } else if (altKeyDown) {
            this.add(true);
        } else {
            this.add(false);
        }
    }

    boolean add(boolean promptForName) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        String name = roi.getName();
        int slice1 = imp.getCurrentSlice();
        if (name != null && this.roiCopy != null && name.equals(this.roiCopy.getName()) && name.indexOf(45) != -1) {
            Rectangle r1 = roi.getBounds();
            Rectangle r2 = this.roiCopy.getBounds();
            if (r1.x != r2.x || r1.y != r2.y || slice1 != this.slice2) {
                name = null;
            }
        }
        String label = name != null ? name : this.getLabel(imp, roi);
        label = promptForName ? this.getName(label) : this.getUniqueName(label);
        if (label == null) {
            return false;
        }
        this.list.add(label);
        roi.setName(label);
        this.roiCopy = (Roi)roi.clone();
        Calibration cal = imp.getCalibration();
        if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
            Rectangle r = this.roiCopy.getBounds();
            this.roiCopy.setLocation(r.x - (int)cal.xOrigin, r.y - (int)cal.yOrigin);
        }
        this.slice2 = slice1;
        this.rois.put(label, this.roiCopy);
        if (Recorder.record) {
            Recorder.record("roiManager", "Add");
        }
        return true;
    }

    String getLabel(ImagePlus imp, Roi roi) {
        String ys;
        Rectangle r = roi.getBounds();
        int xc = r.x + r.width / 2;
        int yc = r.y + r.height / 2;
        if (xc < 0) {
            xc = 0;
        }
        if (yc < 0) {
            yc = 0;
        }
        int digits = 4;
        String xs = "" + xc;
        if (xs.length() > digits) {
            digits = xs.length();
        }
        if ((ys = "" + yc).length() > digits) {
            digits = ys.length();
        }
        xs = "000" + xc;
        ys = "000" + yc;
        String label = ys.substring(ys.length() - digits) + "-" + xs.substring(xs.length() - digits);
        if (imp.getStackSize() > 1) {
            String zs = "000" + imp.getCurrentSlice();
            label = zs.substring(zs.length() - digits) + "-" + label;
        }
        return label;
    }

    void addAndDraw(boolean altKeyDown) {
        if (altKeyDown ? !this.add(true) : !this.add(false)) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        IJ.run("Draw");
        Undo.setup(5, imp);
        if (Recorder.record) {
            Recorder.record("roiManager", "Add & Draw");
        }
    }

    boolean delete(boolean replacing) {
        int count = this.list.getItemCount();
        if (count == 0) {
            return this.error("The list is empty.");
        }
        int[] index = this.list.getSelectedIndexes();
        if (index.length == 0 || replacing && count > 1) {
            String msg = "Delete all items on the list?";
            if (replacing) {
                msg = "Replace items on the list?";
            }
            this.canceled = false;
            if (!IJ.macroRunning() && !this.macro) {
                YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ROI Manager", msg);
                if (d.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!d.yesPressed()) {
                    return false;
                }
            }
            index = this.getAllIndexes();
        }
        for (int i = count - 1; i >= 0; --i) {
            boolean delete = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                delete = true;
            }
            if (!delete) continue;
            this.rois.remove(this.list.getItem(i));
            this.list.remove(i);
        }
        return true;
    }

    boolean update() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = this.list.getItem(index);
        this.rois.remove(name);
        this.rois.put(name, roi);
        return true;
    }

    boolean rename() {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = this.list.getItem(index);
        String name2 = this.getName(name);
        if (name2 == null) {
            return false;
        }
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        roi.setName(name2);
        this.rois.put(name2, roi);
        this.list.replaceItem(name2, index);
        this.list.select(index);
        return true;
    }

    String getName(String name) {
        GenericDialog gd = new GenericDialog("ROI Manager");
        gd.addStringField("Rename As:", name, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        String name2 = gd.getNextString();
        name2 = this.getUniqueName(name2);
        return name2;
    }

    boolean restore(int index, boolean setSlice) {
        int slice;
        String label = this.list.getItem(index);
        Roi roi = (Roi)this.rois.get(label);
        ImagePlus imp = this.getImage();
        if (imp == null || roi == null) {
            return false;
        }
        if (setSlice && (slice = this.getSliceNumber(label)) >= 1 && slice <= imp.getStackSize()) {
            imp.setSlice(slice);
        }
        Roi roi2 = (Roi)roi.clone();
        Calibration cal = imp.getCalibration();
        if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
            Rectangle r = roi2.getBounds();
            roi2.setLocation(r.x + (int)cal.xOrigin, r.y + (int)cal.yOrigin);
        }
        imp.setRoi(roi2);
        return true;
    }

    int getSliceNumber(String label) {
        int slice = -1;
        if (label.length() > 4 && label.charAt(4) == '-' && label.length() >= 14) {
            slice = (int)Tools.parseDouble(label.substring(0, 4), -1.0);
        }
        return slice;
    }

    void open(String path) {
        Roi roi;
        Macro.setOptions(null);
        String name = null;
        if (path == null) {
            OpenDialog od = new OpenDialog("Open Selection(s)...", "");
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return;
            }
            path = directory + name;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Open", path);
        }
        if (path.endsWith(".zip")) {
            this.openZip(path);
            return;
        }
        Opener o = new Opener();
        if (name == null) {
            name = o.getName(path);
        }
        if ((roi = o.openRoi(path)) != null) {
            if (name.endsWith(".roi")) {
                name = name.substring(0, name.length() - 4);
            }
            name = this.getUniqueName(name);
            this.list.add(name);
            this.rois.put(name, roi);
        }
    }

    void openZip(String path) {
        ZipInputStream in = null;
        int nRois = 0;
        try {
            in = new ZipInputStream(new FileInputStream(path));
            byte[] buf = new byte[1024];
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".roi")) {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    byte[] bytes = out.toByteArray();
                    RoiDecoder rd = new RoiDecoder(bytes, name);
                    Roi roi = rd.getRoi();
                    if (roi != null) {
                        name = name.substring(0, name.length() - 4);
                        name = this.getUniqueName(name);
                        this.list.add(name);
                        this.rois.put(name, roi);
                        ++nRois;
                    }
                }
                entry = in.getNextEntry();
            }
            in.close();
        }
        catch (IOException e) {
            this.error(e.toString());
        }
        if (nRois == 0) {
            this.error("This ZIP archive does not appear to contain \".roi\" files");
        }
    }

    String getUniqueName(String name) {
        String name2 = name;
        int n = 1;
        Roi roi2 = (Roi)this.rois.get(name2);
        while (roi2 != null) {
            roi2 = (Roi)this.rois.get(name2);
            if (roi2 != null) {
                int lastDash = name2.lastIndexOf("-");
                if (lastDash != -1 && name2.length() - lastDash < 5) {
                    name2 = name2.substring(0, lastDash);
                }
                name2 = name2 + "-" + n;
                ++n;
            }
            roi2 = (Roi)this.rois.get(name2);
        }
        return name2;
    }

    boolean save() {
        if (this.list.getItemCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length > 1) {
            return this.saveMultiple(indexes, null);
        }
        String name = this.list.getItem(indexes[0]);
        Macro.setOptions(null);
        SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
        String name2 = sd.getFileName();
        if (name2 == null) {
            return false;
        }
        String dir = sd.getDirectory();
        Roi roi = (Roi)this.rois.get(name);
        this.rois.remove(name);
        if (!name2.endsWith(".roi")) {
            name2 = name2 + ".roi";
        }
        String newName = name2.substring(0, name2.length() - 4);
        this.rois.put(newName, roi);
        roi.setName(newName);
        this.list.replaceItem(newName, indexes[0]);
        if (this.restore(indexes[0], true)) {
            IJ.run("Selection...", "path='" + dir + name2 + "'");
        }
        return true;
    }

    boolean saveMultiple(int[] indexes, String path) {
        Macro.setOptions(null);
        if (path == null) {
            SaveDialog sd = new SaveDialog("Save ROIs...", "RoiSet", ".zip");
            String name = sd.getFileName();
            if (name == null) {
                return false;
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            RoiEncoder re = new RoiEncoder(out);
            for (int i = 0; i < indexes.length; ++i) {
                String label = this.list.getItem(indexes[i]);
                Roi roi = (Roi)this.rois.get(label);
                if (!label.endsWith(".roi")) {
                    label = label + ".roi";
                }
                zos.putNextEntry(new ZipEntry(label));
                re.write(roi);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            this.error("" + e);
            return false;
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Save", path);
        }
        return true;
    }

    boolean measure() {
        String label;
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return false;
        }
        int nLines = 0;
        for (int i = 0; i < indexes.length; ++i) {
            label = this.list.getItem(indexes[i]);
            Roi roi = (Roi)this.rois.get(label);
            if (!roi.isLine()) continue;
            ++nLines;
        }
        if (nLines > 0 && nLines != indexes.length) {
            this.error("All items must be areas or all must be lines.");
            return false;
        }
        int nSlices = 1;
        label = this.list.getItem(indexes[0]);
        if (this.getSliceNumber(label) == -1 || indexes.length == 1) {
            int setup = IJ.setupDialog(imp, 0);
            if (setup == 4096) {
                return false;
            }
            nSlices = setup == 32 ? imp.getStackSize() : 1;
        }
        int currentSlice = imp.getCurrentSlice();
        for (int slice = 1; slice <= nSlices; ++slice) {
            if (nSlices > 1) {
                imp.setSlice(slice);
            }
            for (int i = 0; i < indexes.length && this.restore(indexes[i], nSlices == 1); ++i) {
                IJ.run("Measure");
            }
        }
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Measure");
        }
        return true;
    }

    boolean draw() {
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        Undo.setup(4, imp);
        for (int i = 0; i < indexes.length && this.restore(indexes[i], true); ++i) {
            IJ.run("Draw");
            IJ.run("Select None");
        }
        Undo.setup(5, imp);
        if (Recorder.record) {
            Recorder.record("roiManager", "Draw");
        }
        return true;
    }

    void combine() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.list.getSelectedIndexes();
        if (indexes.length <= 1) {
            indexes = this.getAllIndexes();
        }
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(this.list.getItem(indexes[i]));
            if (roi.isLine() || roi.getType() == 10) continue;
            Calibration cal = imp.getCalibration();
            if (cal.xOrigin != 0.0 || cal.yOrigin != 0.0) {
                roi = (Roi)roi.clone();
                Rectangle r = roi.getBounds();
                roi.setLocation(r.x + (int)cal.xOrigin, r.y + (int)cal.yOrigin);
            }
            if (s1 == null) {
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
                if (s1 != null) continue;
                return;
            }
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            if (s2 == null || !roi.isArea()) continue;
            s1.or(s2);
        }
        if (s1 != null) {
            imp.setRoi(s1);
        }
        if (Recorder.record) {
            Recorder.record("roiManager", "Combine");
        }
    }

    int[] getAllIndexes() {
        int count = this.list.getItemCount();
        int[] indexes = new int[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error("There are no images open.");
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        Macro.abort();
        return false;
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
        this.ignoreInterrupts = false;
    }

    public static RoiManager getInstance() {
        return (RoiManager)instance;
    }

    public Hashtable getROIs() {
        return this.rois;
    }

    public List getList() {
        return this.list;
    }

    public boolean runCommand(String cmd) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        boolean ok = true;
        if (cmd.equals("add")) {
            this.add(IJ.shiftKeyDown(), IJ.altKeyDown());
        } else if (cmd.equals("add & draw")) {
            this.addAndDraw(false);
        } else if (cmd.equals("delete")) {
            this.delete(false);
        } else if (cmd.equals("measure")) {
            this.measure();
        } else if (cmd.equals("draw")) {
            this.draw();
        } else if (cmd.equals("combine")) {
            this.combine();
        } else if (cmd.equals("deselect")) {
            if (IJ.isMacOSX()) {
                this.ignoreInterrupts = true;
            }
            this.select(-1);
        } else if (cmd.equals("reset")) {
            this.list.removeAll();
        } else {
            ok = false;
        }
        this.macro = false;
        return ok;
    }

    public boolean runCommand(String cmd, String path) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        if (cmd.equals("open")) {
            this.open(path);
            this.macro = false;
            return true;
        }
        if (cmd.equals("save")) {
            if (!path.endsWith(".zip")) {
                return this.error("Path must end with '.zip'");
            }
            if (this.list.getItemCount() == 0) {
                return this.error("The selection list is empty.");
            }
            int[] indexes = this.getAllIndexes();
            boolean ok = this.saveMultiple(indexes, path);
            this.macro = false;
            return ok;
        }
        return false;
    }

    public void select(int index) {
        int n = this.list.getItemCount();
        if (index < 0) {
            for (int i = 0; i < n; ++i) {
                if (!this.list.isSelected(i)) continue;
                this.list.deselect(i);
            }
            return;
        }
        boolean mm = this.list.isMultipleMode();
        if (mm) {
            this.list.setMultipleMode(false);
        }
        if (index < n) {
            this.list.select(index);
            this.restore(index, true);
            if (!Interpreter.isBatchMode()) {
                IJ.wait(10);
            }
        }
        if (mm) {
            this.list.setMultipleMode(true);
        }
    }

    public void close() {
        super.close();
        instance = null;
    }
}

