/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PasteController;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.ThresholdPlot;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ThresholdAdjuster
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    static final int RED = 0;
    static final int BLACK_AND_WHITE = 1;
    static final int OVER_UNDER = 2;
    static final String[] modes = new String[]{"Red", "Black & White", "Over/Under"};
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static boolean backgroundToNaN = true;
    static Frame instance;
    static int mode;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Label label1;
    Label label2;
    boolean done;
    boolean invertedLut;
    int lutColor;
    static Choice choice;
    boolean firstActivation;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;

    public ThresholdAdjuster() {
        super("Threshold");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.setLutColor(mode);
        IJ.register(PasteController.class);
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.plot, c);
        this.plot.addKeyListener(this.ij);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.addKeyListener(this.ij);
        this.minSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("       ", 2);
        this.label1.setFont(font);
        this.add((Component)this.label1, c);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.maxSlider, c);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.addKeyListener(this.ij);
        this.maxSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        this.label2 = new Label("       ", 2);
        this.label2.setFont(font);
        this.add((Component)this.label2, c);
        choice = new Choice();
        for (int i = 0; i < modes.length; ++i) {
            choice.addItem(modes[i]);
        }
        choice.select(mode);
        choice.addItemListener(this);
        choice.addKeyListener(this.ij);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 0, 5);
        c.anchor = 10;
        c.fill = 0;
        this.add((Component)choice, c);
        int trim = IJ.isMacOSX() ? 11 : 0;
        this.panel = new Panel();
        this.autoB = new TrimmedButton("Auto", trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.applyB = new TrimmedButton("Apply", trim);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.resetB = new TrimmedButton("Reset", trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", trim);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.panel, c);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.firstActivation = true;
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.show();
        this.thread = new Thread((Runnable)this, "ThresholdAdjuster");
        this.thread.start();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            this.setup(imp);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else {
            this.maxValue = this.maxSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        } else if (b == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    void setLutColor(int mode) {
        switch (mode) {
            case 0: {
                this.lutColor = 0;
                break;
            }
            case 1: {
                this.lutColor = 1;
                break;
            }
            case 2: {
                this.lutColor = 3;
            }
        }
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        mode = choice.getSelectedIndex();
        this.setLutColor(mode);
        this.doStateChange = true;
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        boolean not8Bits;
        int type = imp.getType();
        if (type == 4) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        boolean minMaxChange = false;
        boolean bl = not8Bits = type == 1 || type == 2;
        if (not8Bits) {
            if (ip.getMin() != this.previousMin || ip.getMax() != this.previousMax) {
                minMaxChange = true;
            }
            this.previousMin = ip.getMin();
            this.previousMax = ip.getMax();
        }
        int id = imp.getID();
        if (minMaxChange || id != this.previousImageID || type != this.previousImageType) {
            if (not8Bits && minMaxChange) {
                ip.resetMinAndMax();
                imp.updateAndDraw();
            }
            this.invertedLut = imp.isInvertedLut();
            this.minThreshold = ip.getMinThreshold();
            this.maxThreshold = ip.getMaxThreshold();
            ImageStatistics stats = this.plot.setHistogram(imp);
            if (this.minThreshold == -808080.0) {
                this.autoSetLevels(ip, stats);
            } else {
                this.minThreshold = this.scaleDown(ip, this.minThreshold);
                this.maxThreshold = this.scaleDown(ip, this.maxThreshold);
            }
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            this.updateLabels(imp, ip);
            this.updatePlot();
            this.updateScrollBars();
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousImageType = type;
        return ip;
    }

    void autoSetLevels(ImageProcessor ip, ImageStatistics stats) {
        if (stats == null || stats.histogram == null) {
            this.minThreshold = 85.0;
            this.maxThreshold = 170.0;
            return;
        }
        int threshold = ip.getAutoThreshold(stats.histogram);
        if (stats.max - stats.dmode > stats.dmode - stats.min) {
            this.minThreshold = threshold;
            this.maxThreshold = stats.max;
        } else {
            this.minThreshold = stats.min;
            this.maxThreshold = threshold;
        }
        if (Recorder.record) {
            Recorder.record("setAutoThreshold");
        }
    }

    void scaleUpAndSet(ImageProcessor ip, double minThreshold, double maxThreshold) {
        if (!(ip instanceof ByteProcessor) && minThreshold != -808080.0) {
            double min = ip.getMin();
            double max = ip.getMax();
            if (max > min) {
                minThreshold = min + minThreshold / 255.0 * (max - min);
                maxThreshold = min + maxThreshold / 255.0 * (max - min);
            } else {
                minThreshold = -808080.0;
            }
        }
        ip.setThreshold(minThreshold, maxThreshold, this.lutColor);
    }

    double scaleDown(ImageProcessor ip, double threshold) {
        if (ip instanceof ByteProcessor) {
            return threshold;
        }
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (threshold - min) / (max - min) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return min + threshold / 255.0 * (max - min);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.mode = mode;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        double min = ip.getMinThreshold();
        double max = ip.getMaxThreshold();
        if (min == -808080.0) {
            this.label1.setText("");
            this.label2.setText("");
        } else {
            Calibration cal = imp.getCalibration();
            if (cal.calibrated()) {
                min = cal.getCValue((int)min);
                max = cal.getCValue((int)max);
            }
            if ((double)((int)min) == min && (double)((int)max) == max || ip instanceof ShortProcessor) {
                this.label1.setText("" + (int)min);
                this.label2.setText("" + (int)max);
            } else {
                this.label1.setText("" + IJ.d2s(min, 2));
                this.label2.setText("" + IJ.d2s(max, 2));
            }
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustMinThreshold(ImagePlus imp, ImageProcessor ip, double value) {
        if (IJ.altKeyDown()) {
            double width = this.maxThreshold - this.minThreshold;
            if (width < 1.0) {
                width = 1.0;
            }
            this.minThreshold = value;
            this.maxThreshold = this.minThreshold + width;
            if (this.minThreshold + width > 255.0) {
                this.minThreshold = 255.0 - width;
                this.maxThreshold = this.minThreshold + width;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = value;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imp, ImageProcessor ip, int cvalue) {
        this.maxThreshold = cvalue;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        this.plot.setHistogram(imp);
        ip.resetThreshold();
        this.updateScrollBars();
        if (Recorder.record) {
            Recorder.record("resetThreshold");
        }
    }

    void doSet(ImagePlus imp, ImageProcessor ip) {
        boolean outOfRange;
        double level1 = ip.getMinThreshold();
        double level2 = ip.getMaxThreshold();
        if (level1 == -808080.0) {
            level1 = this.scaleUp(ip, 85.0);
            level2 = this.scaleUp(ip, 170.0);
        }
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        level1 = cal.getCValue(level1);
        level2 = cal.getCValue(level2);
        GenericDialog gd = new GenericDialog("Set Threshold Levels");
        gd.addNumericField("Lower Threshold Level: ", level1, digits);
        gd.addNumericField("Upper Threshold Level: ", level2, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        level1 = gd.getNextNumber();
        level2 = gd.getNextNumber();
        level1 = cal.getRawValue(level1);
        if ((level2 = cal.getRawValue(level2)) < level1) {
            level2 = level1;
        }
        double minDisplay = ip.getMin();
        double maxDisplay = ip.getMax();
        ip.resetMinAndMax();
        double minValue = ip.getMin();
        double maxValue = ip.getMax();
        if (level1 < minValue) {
            level1 = minValue;
        }
        if (level2 > maxValue) {
            level2 = maxValue;
        }
        boolean bl = outOfRange = level1 < minDisplay || level2 > maxDisplay;
        if (outOfRange) {
            this.plot.setHistogram(imp);
        } else {
            ip.setMinAndMax(minDisplay, maxDisplay);
        }
        this.minThreshold = this.scaleDown(ip, level1);
        this.maxThreshold = this.scaleDown(ip, level2);
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
        if (Recorder.record) {
            if (imp.getBitDepth() == 32) {
                Recorder.record("setThreshold", ip.getMinThreshold(), ip.getMaxThreshold());
            } else {
                int min = (int)ip.getMinThreshold();
                int max = (int)ip.getMaxThreshold();
                if (cal.isSigned16Bit()) {
                    min = (int)cal.getCValue(level1);
                    max = (int)cal.getCValue(level2);
                }
                Recorder.record("setThreshold", min, max);
            }
        }
    }

    void changeState(ImagePlus imp, ImageProcessor ip) {
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imp, ImageProcessor ip) {
        ip.resetThreshold();
        this.previousImageID = 0;
        this.setup(imp);
    }

    void apply(ImagePlus imp) {
        try {
            if (imp.getBitDepth() == 32) {
                GenericDialog gd = new GenericDialog("NaN Backround");
                gd.addCheckbox("Set Background Pixels to NaN", backgroundToNaN);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    this.runThresholdCommand();
                    return;
                }
                backgroundToNaN = gd.getNextBoolean();
                if (backgroundToNaN) {
                    IJ.run("NaN Background");
                } else {
                    this.runThresholdCommand();
                }
            } else {
                this.runThresholdCommand();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void runThresholdCommand() {
        Recorder.recordInMacros = true;
        IJ.run("Threshold");
        Recorder.recordInMacros = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ThresholdAdjuster thresholdAdjuster = this;
            synchronized (thresholdAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int min = this.minValue;
        int max = this.maxValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doStateChange) {
            action = 4;
        } else if (this.doSet) {
            action = 7;
        } else if (this.minValue >= 0) {
            action = 5;
        } else if (this.maxValue >= 0) {
            action = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor ip = this.setup(imp);
        if (ip == null) {
            imp.unlock();
            IJ.beep();
            IJ.showStatus("RGB images cannot be thresholded");
            return;
        }
        switch (action) {
            case 0: {
                this.reset(imp, ip);
                break;
            }
            case 1: {
                this.autoThreshold(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp);
                break;
            }
            case 4: {
                this.changeState(imp, ip);
                break;
            }
            case 7: {
                this.doSet(imp, ip);
                break;
            }
            case 5: {
                this.adjustMinThreshold(imp, ip, min);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(imp, ip, max);
            }
        }
        this.updatePlot();
        this.updateLabels(imp, ip);
        ip.setLutAnimation(true);
        imp.updateAndDraw();
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        ThresholdAdjuster thresholdAdjuster = this;
        synchronized (thresholdAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            if (!this.firstActivation) {
                this.previousImageID = 0;
                this.setup(imp);
            }
            this.firstActivation = false;
        }
    }

    static {
        mode = 0;
    }
}

