/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class FloodFiller {
    int maxStackSize = 500;
    int[] stack = new int[this.maxStackSize];
    int stackSize;
    ImageProcessor ip;
    int max;
    boolean isFloat;
    int count = 0;

    public FloodFiller(ImageProcessor ip) {
        this.ip = ip;
        this.isFloat = ip instanceof FloatProcessor;
    }

    public boolean fill(int x, int y) {
        int width = this.ip.getWidth();
        int height = this.ip.getHeight();
        int color = this.ip.getPixel(x, y);
        this.ip.drawLine(x, y, x, y);
        int newColor = this.ip.getPixel(x, y);
        this.ip.putPixel(x, y, color);
        if (color == newColor) {
            return false;
        }
        this.stackSize = 0;
        this.push(x, y);
        int coordinates;
        block0: while ((coordinates = this.pop()) != -1) {
            int i;
            int x1;
            x = coordinates & 0xFFFF;
            y = coordinates >> 16;
            int x2 = x;
            for (x1 = x; this.ip.getPixel(x1, y) == color && x1 >= 0; --x1) {
            }
            ++x1;
            while (this.ip.getPixel(x2, y) == color && x2 < width) {
                ++x2;
            }
            this.ip.drawLine(x1, y, --x2, y);
            boolean inScanLine = false;
            for (i = x1; i <= x2; ++i) {
                if (!inScanLine && y > 0 && this.ip.getPixel(i, y - 1) == color) {
                    this.push(i, y - 1);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || y <= 0 || this.ip.getPixel(i, y - 1) == color) continue;
                inScanLine = false;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i > x2) continue block0;
                if (!inScanLine && y < height - 1 && this.ip.getPixel(i, y + 1) == color) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < height - 1 && this.ip.getPixel(i, y + 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
        return true;
    }

    public void particleAnalyzerFill(int x, int y, double level1, double level2, ImageProcessor mask, Rectangle bounds) {
        int width = this.ip.getWidth();
        int height = this.ip.getHeight();
        mask.setColor(0);
        mask.fill();
        mask.setColor(255);
        this.stackSize = 0;
        this.push(x, y);
        int coordinates;
        block0: while ((coordinates = this.pop()) != -1) {
            int i;
            int x1;
            x = coordinates & 0xFFFF;
            y = coordinates >> 16;
            int x2 = x;
            for (x1 = x; this.inParticle(x1, y, level1, level2) && x1 >= 0; --x1) {
            }
            ++x1;
            while (this.inParticle(x2, y, level1, level2) && x2 < width) {
                ++x2;
            }
            mask.drawLine(x1 - bounds.x, y - bounds.y, --x2 - bounds.x, y - bounds.y);
            this.ip.drawLine(x1, y, x2, y);
            boolean inScanLine = false;
            if (x1 > 0) {
                --x1;
            }
            if (x2 < width - 1) {
                ++x2;
            }
            for (i = x1; i <= x2; ++i) {
                if (!inScanLine && y > 0 && this.inParticle(i, y - 1, level1, level2)) {
                    this.push(i, y - 1);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || y <= 0 || this.inParticle(i, y - 1, level1, level2)) continue;
                inScanLine = false;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i > x2) continue block0;
                if (!inScanLine && y < height - 1 && this.inParticle(i, y + 1, level1, level2)) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < height - 1 && !this.inParticle(i, y + 1, level1, level2)) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
        return;
    }

    final boolean inParticle(int x, int y, double level1, double level2) {
        if (this.isFloat) {
            return (double)this.ip.getPixelValue(x, y) >= level1 && (double)this.ip.getPixelValue(x, y) <= level2;
        }
        return (double)this.ip.getPixel(x, y) >= level1 && (double)this.ip.getPixel(x, y) <= level2;
    }

    final void push(int x, int y) {
        ++this.stackSize;
        if (this.stackSize == this.maxStackSize) {
            int[] newStack = new int[this.maxStackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.maxStackSize);
            this.stack = newStack;
            this.maxStackSize *= 2;
        }
        this.stack[this.stackSize - 1] = x + (y << 16);
    }

    final int pop() {
        if (this.stackSize == 0) {
            return -1;
        }
        int value = this.stack[this.stackSize - 1];
        --this.stackSize;
        return value;
    }
}

