/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import myctapp.PhantomElement;

class CTPhantom {
    public Vector elements = new Vector(7);
    private PhantomElement newelement;
    private PhantomElement currentelement;
    public PhantomInfoArea pinfoArea = new PhantomInfoArea();

    public CTPhantom() {
        this.pinfoArea.updateInfo();
    }

    public void addElement(String type, double w, double h, double d, double x, double y, int alpha) {
        this.newelement = new PhantomElement(type, w, h, d, x, y, alpha);
        this.elements.add(this.newelement);
        this.pinfoArea.updateInfo();
    }

    public PhantomElement getCurrentElement(int index) {
        try {
            this.currentelement = (PhantomElement)this.elements.get(index);
        }
        catch (NoSuchElementException exception) {
            System.out.println("no elements");
        }
        return this.currentelement;
    }

    public void updateCurrentElement(int A, int B, int index) {
        this.currentelement = (PhantomElement)this.elements.remove(index);
        this.currentelement.updateSize(A, B);
        this.elements.add(this.currentelement);
        this.pinfoArea.updateInfo();
    }

    public void savePhantom(String filename) {
        int maxelements = this.elements.size();
        if (filename != null) {
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(filename));
                for (int i = 0; i < maxelements; ++i) {
                    PhantomElement currelement = this.getCurrentElement(i);
                    writer.println(currelement.type);
                    writer.println(currelement.A);
                    writer.println(currelement.B);
                    writer.println(currelement.x);
                    writer.println(currelement.y);
                    writer.println(currelement.rho);
                    writer.println(currelement.alpha);
                }
                System.out.println("Saved " + maxelements + " elements");
                writer.close();
            }
            catch (IOException ioe) {
                System.out.println("I/O Exception in file writing: " + ioe);
                ioe.printStackTrace();
            }
        }
    }

    public void loadPhantom(String filename) {
        int count = 0;
        int noelems = 0;
        int length = 0;
        try {
            File file = new File(filename);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            length = (int)file.length();
            reader.mark(length + 1);
            while (reader.readLine() != null) {
                ++noelems;
            }
            System.out.println(noelems /= 7);
            reader.reset();
            while (count < noelems) {
                String type = reader.readLine();
                int w = Integer.valueOf(reader.readLine());
                int h = Integer.valueOf(reader.readLine());
                int x = Integer.valueOf(reader.readLine());
                int y = Integer.valueOf(reader.readLine());
                double d = Double.valueOf(reader.readLine());
                int a = Integer.valueOf(reader.readLine());
                ++count;
                this.addElement(type, w, h, d, x, y, a);
            }
            System.out.println("Loaded " + count + " elements");
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception in file writing: " + ioe);
        }
    }

    public void CreatePhantomData(String phantomname) {
        if (phantomname == "sheppl") {
            this.addElement("ellipse", 0.46, 0.345, 2.0, 0.0, 0.0, 90);
            this.addElement("ellipse", 0.436, 0.331, -1.2, -0.0092, 0.0, 90);
            this.addElement("ellipse", 0.155, 0.055, -0.8, 0.03, -0.105, 72);
            this.addElement("ellipse", 0.205, 0.08, -0.8, 0.03, 0.105, 108);
            this.addElement("ellipse", 0.125, 0.105, 0.4, 0.175, 0.0, 90);
            this.addElement("ellipse", 0.023, 0.023, 0.4, 0.05, 0.0, 90);
            this.addElement("ellipse", 0.023, 0.023, 0.4, -0.05, 0.0, 90);
            this.addElement("ellipse", 0.0115, 0.023, 0.4, -0.3025, 0.04, 90);
            this.addElement("ellipse", 0.0115, 0.0115, 0.4, -0.3025, 0.0, 90);
            this.addElement("ellipse", 0.023, 0.0115, 0.4, -0.3025, -0.03, 90);
        } else if (phantomname == "test1") {
            this.addElement("ellipse", 0.42, 0.42, 2.0, 0.0, 0.0, 90);
            this.addElement("ellipse", 0.4, 0.4, -0.9, -0.0092, 0.0, 90);
        } else if (phantomname == "test2") {
            this.addElement("ellipse", 0.45, 0.45, 2.0, 0.0, 0.0, 90);
            this.addElement("ellipse", 0.44, 0.44, -1.2, 0.0, 0.0, 90);
            double theta = 90.0;
            double r = 0.36;
            double x = r * Math.cos(theta * Math.PI / 180.0);
            double y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.2, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.2, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.2, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.2, x, y, 90);
            theta = 130.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.15, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.15, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.15, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.15, x, y, 90);
            theta = 170.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.1, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.1, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.1, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.1, x, y, 90);
            theta = 210.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.07, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.07, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.07, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.07, x, y, 90);
            theta = 250.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.05, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.05, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.05, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.05, x, y, 90);
            theta = 300.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.035, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.035, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.035, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.035, x, y, 90);
            theta = 350.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.022, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.022, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.022, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.022, x, y, 90);
            theta = 30.0;
            r = 0.36;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.015, x, y, 90);
            r = 0.28;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.015, x, y, 90);
            r = 0.2;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.015, x, y, 90);
            r = 0.12;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.015, x, y, 90);
        } else if (phantomname == "test3") {
            this.addElement("ellipse", 0.42, 0.42, 2.0, 0.0, 0.0, 90);
            this.addElement("ellipse", 0.4, 0.4, -0.9, -0.0092, 0.0, 90);
            double r = 0.18;
            double theta = 111.0;
            double x = r * Math.cos(theta * Math.PI / 180.0);
            double y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.008, 0.008, 0.1, x, y, 90);
            theta = 119.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.01, 0.01, 0.1, x, y, 90);
            theta = 130.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.015, 0.015, 0.1, x, y, 90);
            theta = 145.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.02, 0.02, 0.1, x, y, 90);
            theta = 165.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.1, x, y, 90);
            theta = 190.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.035, 0.035, 0.1, x, y, 90);
            theta = 230.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.008, 0.008, 0.07, x, y, 90);
            theta = 238.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.01, 0.01, 0.07, x, y, 90);
            theta = 249.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.015, 0.015, 0.07, x, y, 90);
            theta = 264.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.02, 0.02, 0.07, x, y, 90);
            theta = 284.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.07, x, y, 90);
            theta = 309.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.035, 0.035, 0.07, x, y, 90);
            theta = 350.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.008, 0.008, 0.05, x, y, 90);
            theta = 358.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.01, 0.01, 0.05, x, y, 90);
            theta = 9.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.015, 0.015, 0.05, x, y, 90);
            theta = 26.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.02, 0.02, 0.05, x, y, 90);
            theta = 46.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.05, x, y, 90);
            theta = 71.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.035, 0.035, 0.05, x, y, 90);
        } else if (phantomname == "test4") {
            this.addElement("ellipse", 0.42, 0.42, 2.0, 0.0, 0.0, 90);
            this.addElement("ellipse", 0.4, 0.4, -0.9, -0.0092, 0.0, 90);
            double r = 0.14;
            double theta = 88.0;
            double x = r * Math.cos(theta * Math.PI / 180.0);
            double y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.006, 0.006, 0.005, x, y, 90);
            theta = 98.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.008, 0.008, 0.005, x, y, 90);
            theta = 110.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.01, 0.01, 0.005, x, y, 90);
            theta = 126.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.015, 0.015, 0.005, x, y, 90);
            theta = 148.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.02, 0.02, 0.005, x, y, 90);
            theta = 175.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.03, 0.03, 0.005, x, y, 90);
            theta = 210.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.035, 0.035, 0.005, x, y, 90);
            theta = 250.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.04, 0.04, 0.005, x, y, 90);
            theta = 300.0;
            x = r * Math.cos(theta * Math.PI / 180.0);
            y = r * Math.sin(theta * Math.PI / 180.0);
            this.addElement("ellipse", 0.05, 0.05, 0.005, x, y, 90);
        } else if (phantomname == "delta") {
            this.addElement("ellipse", 0.2, 0.2, 2.0, 0.3, 0.0, 0);
        } else if (phantomname == "bars") {
            this.addElement("square", 0.2, 0.2, 0.4, 0.0, 0.0, 0);
        } else if (phantomname == "bead") {
            this.addElement("ellipse", 0.48, 0.48, 0.05, 0.0, 0.0, 0);
            this.addElement("ellipse", 6.0E-4, 6.0E-4, 1.0, -0.01, 0.1, 0);
        }
    }

    class PhantomInfoArea
    extends JPanel {
        int xcoords;
        int ycoords;

        public PhantomInfoArea() {
            this.setPreferredSize(new Dimension(100, 60));
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void updateInfo() {
            this.repaint();
        }

        public void setPanelCoords(int x, int y) {
            this.xcoords = x;
            this.ycoords = y;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setFont(new Font("SansSerif", 0, 9));
            g.drawString("Info Window", 5, 10);
            g.drawString("PHANTOM DATA", 5, 20);
            g.drawString("No. elements:", 5, 30);
            g.drawString("" + CTPhantom.this.elements.size(), 70, 30);
            g.drawString("Coords: " + this.xcoords + "," + this.ycoords, 180, 10);
        }
    }
}

