/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import myctapp.CTPhantom;
import myctapp.Filters;
import myctapp.ImagePanel;
import myctapp.ImageUtils;
import myctapp.Iterative;
import myctapp.PhantomElement;
import myctapp.Utils;

public class CTScanner {
    public int views;
    public int scans;
    public int S;
    public int ang1;
    public int ang2;
    public int numiter;
    public int projstacksize = 1;
    public int numrays;
    public int totalrays;
    public int truncbeamrays;
    public float phi;
    public float stepsize;
    public float v;
    public double muwater;
    public double filtercutoff;
    public double zoom;
    public double rate;
    public double xoffset;
    public double yoffset;
    public double factor;
    public double truncatewidth;
    public double[][] projection;
    public double[][] fprojection;
    public double[][] truncprojection;
    public double[] pleft;
    public double[] pright;
    public double[][] pixels;
    public int outputimgsize;
    public int tagnum;
    boolean fast;
    boolean filtering;
    boolean truncate;
    boolean roicrop;
    boolean displayimgdetails;
    boolean displayroicircle;
    boolean setedgezero;
    boolean animate;
    boolean interrupt;
    boolean keepcurrentextrapwidths;
    public String method;
    public String filtername;
    public String interp;
    public String phantomname;
    public String truncmethod;
    public String noise;
    public double maxval;
    public int animcount;
    public double[][] animimage;
    Object[] projectionstack;
    public double timetaken;

    public CTScanner() {
        this.initialise();
    }

    public CTScanner(double[][] pix) {
        this.initialise();
        this.ProjectfromImage(pix, this.projection);
    }

    public void initialise() {
        this.ang1 = 0;
        this.ang2 = 180;
        this.stepsize = 1.0f;
        this.v = (float)(Math.abs(this.ang2) - this.ang1) / this.stepsize;
        this.views = (int)this.v;
        this.scans = 128;
        this.phi = 0.0f;
        this.outputimgsize = 128;
        this.zoom = 1.0;
        this.xoffset = 0.0;
        this.yoffset = 0.0;
        this.fast = false;
        this.method = "fbp";
        this.filtering = true;
        this.filtername = "ramp";
        this.interp = "linear";
        this.phantomname = "sheppl";
        this.filtercutoff = 1.0;
        this.numiter = 1;
        this.truncate = false;
        this.roicrop = false;
        this.truncatewidth = 0.165;
        this.truncmethod = "simple cos-squared";
        this.displayimgdetails = false;
        this.displayroicircle = false;
        this.noise = "none";
        this.rate = 300.0;
        this.muwater = 0.206;
        this.truncbeamrays = 0;
        this.totalrays = 0;
        this.numrays = 0;
        this.tagnum = 1;
        this.animate = false;
        this.animcount = 0;
        this.factor = 0.7853981633974483;
        this.setedgezero = true;
        this.interrupt = false;
        this.keepcurrentextrapwidths = false;
    }

    public void initialiseprojection() {
        this.projection = new double[this.views][this.scans];
        this.fprojection = new double[this.views][this.scans];
    }

    public void resetviews() {
        this.v = (int)((float)(Math.abs(this.ang2) - this.ang1) / this.stepsize);
        this.views = (int)this.v;
    }

    public double[][] ProjectEllipse(double A, double B, double rho, double x1, double y1, int alpha) {
        int i = 0;
        double[][] proj = new double[this.views][this.scans];
        double[] sintab = new double[this.views];
        double[] costab = new double[this.views];
        double scale = Math.sqrt(2.0) / (double)this.scans;
        this.S = 0;
        double pos = Math.sqrt((x1 /= scale) * x1 + (y1 /= scale) * y1);
        double gamma = Math.atan2(y1, x1);
        Utils.blank(proj, 0.0);
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            sintab[i] = Math.sin((double)Math.abs(this.phi - (float)alpha) * Math.PI / 180.0);
            costab[i] = Math.cos((double)Math.abs(this.phi - (float)alpha) * Math.PI / 180.0);
            ++i;
            this.phi += this.stepsize;
        }
        i = 0;
        System.out.println("Generating projection data.. ");
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            double a2theta = Math.pow(A * costab[i], 2.0) + Math.pow(B * sintab[i], 2.0);
            double boundary = A * costab[i] + B * sintab[i] * 500.0;
            double offset = pos * Math.cos(gamma - (double)(this.phi - (float)alpha) * Math.PI / 180.0);
            this.S = 0;
            while (this.S < this.scans) {
                double N = ((double)(this.S - this.scans / 2) + offset) * scale;
                double val = Math.abs(N) < boundary && a2theta > Math.pow(N, 2.0) ? 2.0 * rho * A * B / a2theta * Math.sqrt(a2theta - Math.pow(N, 2.0)) : 0.0;
                double[] dArray = proj[i];
                int n = this.S++;
                dArray[n] = dArray[n] + val;
            }
            ++i;
            this.phi += this.stepsize;
        }
        return proj;
    }

    public double[][] ProjectSquare(double A, double B, double rho, double x1, double y1, int alpha) {
        int i = 0;
        double[][] proj = new double[this.views][this.scans];
        double[] sintab = new double[this.views];
        double[] costab = new double[this.views];
        this.S = 0;
        double pos = Math.sqrt(x1 * x1 + y1 * y1);
        double gamma = Math.atan2(y1, x1);
        Utils.blank(proj, 0.0);
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            sintab[i] = Math.sin((double)Math.abs(this.phi - (float)alpha) * Math.PI / 180.0);
            costab[i] = Math.cos((double)Math.abs(this.phi - (float)alpha) * Math.PI / 180.0);
            ++i;
            this.phi += this.stepsize;
        }
        i = 0;
        System.out.println("Generating projection data.. ");
        i = 0;
        double scale = 2.0 / (double)this.scans;
        double step = 2.0 / (double)this.scans;
        System.out.println(step);
        for (double x = -1.0; x <= 1.0; x += step) {
            for (double y = -1.0; y <= 1.0; y += step) {
                this.phi = this.ang1;
                while (this.phi < (float)this.ang2) {
                    double N = x * costab[i] - y * sintab[i];
                    double xp1 = N / costab[i] - sintab[i] / costab[i];
                    double xm1 = N / costab[i] + sintab[i] / costab[i];
                    double yp1 = (N - costab[i]) / sintab[i];
                    double val = Math.abs(N) > Math.sqrt(2.0) ? 0.0 : (xp1 > 1.0 ? rho : (xm1 < 1.0 ? 2.0 * rho * A * B * 2.0 / costab[i] : 2.0 * rho * A * B * Math.sqrt(Math.pow(1.0 - xp1, 2.0) + Math.pow(1.0 - yp1, 2.0))));
                    this.S = (int)Math.round(N / 2.0 * scale);
                    this.S += this.scans / 2;
                    double[] dArray = proj[i];
                    int n = this.S;
                    dArray[n] = dArray[n] + val;
                    ++i;
                    this.phi += this.stepsize;
                }
                i = 0;
            }
            System.out.println();
            ++this.S;
        }
        return proj;
    }

    public double[][] ProjectGaussian(double A, double B, double rho, double x1, double y1, int alpha) {
        int i = 0;
        double[][] proj = new double[this.views][this.scans];
        double[] sintab = new double[this.views];
        double[] costab = new double[this.views];
        double[] tantab = new double[this.views];
        double scale = Math.sqrt(2.0) / (double)this.scans;
        this.S = 0;
        double pos = Math.sqrt((x1 /= scale) * x1 + (y1 /= scale) * y1);
        double gamma = Math.atan2(y1, x1);
        double offset = 0.0;
        Utils.blank(proj, 0.0);
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            sintab[i] = Math.sin((double)Math.abs(this.phi - (float)alpha) * Math.PI / 180.0);
            costab[i] = Math.cos((double)Math.abs(this.phi - (float)alpha) * Math.PI / 180.0);
            ++i;
            this.phi += this.stepsize;
        }
        i = 0;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            this.S = 0;
            while (this.S < this.scans) {
                double N = ((double)(this.S - this.scans / 2) + offset) * scale;
                double val = 2.0 * rho * A * B * Math.exp(-N * N / A) * Math.sqrt(Math.PI);
                double[] dArray = proj[i];
                int n = this.S++;
                dArray[n] = dArray[n] + val;
            }
            ++i;
            this.phi += this.stepsize;
        }
        return proj;
    }

    public void ProjectPhantom() {
        int i = 0;
        CTPhantom phant = new CTPhantom();
        phant.CreatePhantomData(this.phantomname);
        String elemtype = "ellipse";
        double A = 0.0;
        double B = 0.0;
        double x = 0.0;
        double y = 0.0;
        double rho = 0.0;
        int alpha = 0;
        this.initialiseprojection();
        int elems = phant.elements.size();
        System.out.println(elems);
        for (int e = 0; e < elems; ++e) {
            try {
                PhantomElement shape = phant.getCurrentElement(e);
                elemtype = shape.type;
                A = shape.A;
                B = shape.B;
                x = shape.x;
                y = shape.y;
                rho = shape.rho;
                alpha = shape.alpha;
                System.out.print(elemtype + " " + A + " " + B + " " + rho + " " + x + " " + y + " " + alpha);
            }
            catch (ArrayIndexOutOfBoundsException evt) {
                System.out.println("NO ELEMENTS TO DISPLAY");
            }
            double[][] projdata = elemtype == "ellipse" ? this.ProjectEllipse(A, B, rho, x, y, alpha) : (elemtype == "square" ? this.ProjectSquare(A, B, rho, x, y, alpha) : this.ProjectGaussian(A, B, rho, x, y, alpha));
            this.phi = this.ang1;
            while (this.phi < (float)this.ang2) {
                this.S = 0;
                while (this.S < this.scans) {
                    double[] dArray = this.projection[i];
                    int n = this.S;
                    dArray[n] = dArray[n] + projdata[i][this.S];
                    ++this.S;
                }
                ++i;
                this.phi += this.stepsize;
            }
            i = 0;
        }
        Utils.normalize2DArray(this.projection, 0.0, 1.0);
        if (this.noise == "addtoproj") {
            Utils.addpoissonnoise(this.projection, this.rate);
            Utils.normalize2DArray(this.projection, 0.0, 1.0);
        }
    }

    public BufferedImage CreatePhantomRaster() {
        int y;
        int x;
        int size = this.outputimgsize;
        CTPhantom phant = new CTPhantom();
        phant.CreatePhantomData(this.phantomname);
        double A = 0.0;
        double B = 0.0;
        double xpos = 0.0;
        double ypos = 0.0;
        double rho = 0.0;
        String elemtype = "ellipse";
        double val = 0.0;
        int alpha = 0;
        double[][] image = new double[size][size];
        int Xcenter = size / 2;
        int Ycenter = size / 2;
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                image[x][y] = 0.0;
            }
        }
        int elems = phant.elements.size();
        for (int e = 0; e < elems; ++e) {
            try {
                PhantomElement shape = phant.getCurrentElement(e);
                elemtype = shape.type;
                A = shape.A;
                B = shape.B;
                xpos = shape.x;
                ypos = shape.y;
                rho = shape.rho;
                alpha = shape.alpha;
                System.out.print(A + " " + B + " " + rho + " " + xpos + " " + ypos + " " + alpha);
                System.out.println();
            }
            catch (ArrayIndexOutOfBoundsException evt) {
                System.out.println("NO ELEMENTS TO DISPLAY");
            }
            System.out.print((A *= (double)size) + " " + (B *= (double)size) + " " + rho + " " + (xpos *= (double)size) + " " + (ypos *= (double)size) + " " + alpha);
            for (x = -Xcenter; x < Xcenter; ++x) {
                for (y = -Ycenter; y < Ycenter; ++y) {
                    double pos;
                    if (alpha != 90) {
                        double x1 = (double)x * Math.cos((double)(alpha - 90) * Math.PI / 180.0) + (double)y * Math.sin((double)(alpha - 90) * Math.PI / 180.0);
                        double y1 = (double)(-x) * Math.sin((double)(alpha - 90) * Math.PI / 180.0) + (double)y * Math.cos((double)(alpha - 90) * Math.PI / 180.0);
                        pos = Math.pow(x1 + xpos, 2.0) / Math.pow(A, 2.0) + Math.pow(y1 + ypos, 2.0) / Math.pow(B, 2.0);
                    } else {
                        pos = Math.pow((double)x + xpos, 2.0) / Math.pow(A, 2.0) + Math.pow((double)y + ypos, 2.0) / Math.pow(B, 2.0);
                    }
                    if (!(pos <= 1.0)) continue;
                    double[] dArray = image[y + Ycenter];
                    int n = x + Xcenter;
                    dArray[n] = dArray[n] + rho;
                }
            }
        }
        if (this.noise == "") {
            Utils.addpoissonnoise(image, this.rate);
        }
        BufferedImage img = this.CreateImagefromArray(image, Utils.getMax(image), 1);
        return img;
    }

    public void ProjectfromImage(double[][] pix) {
        this.initialiseprojection();
        this.projection = this.ForwardProject(pix);
    }

    public double[][] ProjectfromImage(double[][] pix, double[][] proj) {
        this.initialiseprojection();
        proj = this.ForwardProject(pix);
        return proj;
    }

    public void PerformFBP(double[][] proj) {
        this.initialiseprojection();
        this.pixels = this.BackProject(proj, this.outputimgsize);
    }

    public void doBackProjection() {
        this.pixels = this.BackProject(this.projection, this.outputimgsize);
    }

    public void ConverttoHounsfield() {
        for (int y = 0; y < this.pixels[0].length; ++y) {
            for (int x = 0; x < this.pixels.length; ++x) {
                this.pixels[x][y] = (this.pixels[x][y] - this.muwater) / this.muwater * 1000.0;
            }
        }
    }

    public double getScale() {
        double sc = this.zoom * (double)this.outputimgsize * Math.sqrt(2.0) / (double)this.scans;
        return sc;
    }

    public double[][] ForwardProject(double[][] pix) {
        int i = 0;
        double[][] proj = new double[this.views][this.scans];
        double[] sintab = new double[this.views];
        double[] costab = new double[this.views];
        double[] tantab = new double[this.views];
        this.S = 0;
        int inputimgsize = pix[0].length;
        Utils.blank(proj, 0.0);
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            sintab[i] = Math.sin((double)this.phi * Math.PI / 180.0 - 1.5707963267948966);
            costab[i] = Math.cos((double)this.phi * Math.PI / 180.0 - 1.5707963267948966);
            ++i;
            this.phi += this.stepsize;
        }
        int Xcenter = inputimgsize / 2;
        int Ycenter = inputimgsize / 2;
        i = 0;
        if (!this.fast) {
            System.out.println("Using accurate method ");
        }
        double scale = (double)inputimgsize * Math.sqrt(2.0) / (double)this.scans;
        System.out.println("Generating projection data from image pixels.. ");
        int N = 0;
        double val = 0.0;
        double weight = 0.0;
        double sang = Math.sqrt(2.0) / 2.0;
        this.interrupt = false;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2 && !this.interrupt) {
            int y;
            int x;
            double a = -costab[i] / sintab[i];
            double aa = 1.0 / a;
            if (Math.abs(sintab[i]) > sang) {
                this.S = 0;
                while (this.S < this.scans) {
                    N = this.S - this.scans / 2;
                    double b = ((double)N - costab[i] - sintab[i]) / sintab[i];
                    b *= scale;
                    for (x = -Xcenter; x < Xcenter; ++x) {
                        if (this.fast) {
                            y = (int)Math.round(a * (double)x + b);
                            if (y < -Xcenter || y >= Xcenter) continue;
                            val += pix[y + Ycenter][x + Xcenter];
                            continue;
                        }
                        y = (int)Math.round(a * (double)x + b);
                        weight = Math.abs(a * (double)x + b - Math.ceil(a * (double)x + b));
                        if (y < -Xcenter || y + 1 >= Xcenter) continue;
                        val += (1.0 - weight) * pix[y + Ycenter][x + Xcenter] + weight * pix[y + Ycenter][x + Xcenter];
                    }
                    proj[i][this.S] = val / Math.abs(sintab[i]);
                    val = 0.0;
                    ++this.S;
                }
            } else if (Math.abs(sintab[i]) <= sang) {
                this.S = 0;
                while (this.S < this.scans) {
                    N = this.S - this.scans / 2;
                    double bb = ((double)N - costab[i] - sintab[i]) / costab[i];
                    bb *= scale;
                    for (y = -Ycenter; y < Ycenter; ++y) {
                        if (this.fast) {
                            x = (int)Math.round(aa * (double)y + bb);
                            if (x < -Xcenter || x >= Xcenter) continue;
                            val += pix[y + Ycenter][x + Xcenter];
                            continue;
                        }
                        x = (int)Math.round(aa * (double)y + bb);
                        weight = Math.abs(aa * (double)y + bb - Math.ceil(aa * (double)y + bb));
                        if (x < -Xcenter || x + 1 >= Xcenter) continue;
                        val += (1.0 - weight) * pix[y + Ycenter][x + Xcenter] + weight * pix[y + Ycenter][x + Xcenter];
                    }
                    proj[i][this.S] = val / Math.abs(costab[i]);
                    val = 0.0;
                    ++this.S;
                }
            }
            ++i;
            this.phi += this.stepsize;
        }
        i = 0;
        Utils.normalize2DArray(proj, 0.0, 1.0);
        if (this.noise == "addtoproj") {
            Utils.addpoissonnoise(proj, this.rate);
        }
        Utils.normalize2DArray(proj, 0.0, 1.0);
        return proj;
    }

    public double[][] BackProject(double[][] proj, int size) {
        int y;
        int x;
        int sxoffset = 0;
        int syoffset = 0;
        int i = 0;
        double val = 0.0;
        double[][] bpimage = new double[size][size];
        double[] sintab = new double[this.views];
        double[] costab = new double[this.views];
        this.S = 0;
        if (this.filtering && this.method == "fbp") {
            if (this.noise == "reconwithnoise") {
                double[][] nproj = Utils.ArrayCopy(proj);
                Utils.addpoissonnoise(nproj, this.rate);
                this.fprojection = this.Filter(nproj);
            } else {
                System.out.println(proj[0].length);
                this.fprojection = this.Filter(proj);
            }
        } else {
            this.fprojection = proj;
        }
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            sintab[i] = Math.sin((double)this.phi * Math.PI / 180.0);
            costab[i] = Math.cos((double)this.phi * Math.PI / 180.0);
            ++i;
            this.phi += this.stepsize;
        }
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                bpimage[x][y] = 0.0;
            }
        }
        int Xcenter = size / 2;
        int Ycenter = size / 2;
        i = 0;
        double scale = this.zoom * (double)size * Math.sqrt(2.0) / (double)this.scans;
        System.out.println("Performing back projection.. ");
        if (this.xoffset > 0.0) {
            sxoffset = (int)Math.floor(this.xoffset * (double)size * this.zoom);
        }
        if (this.yoffset > 0.0) {
            syoffset = (int)Math.floor(this.yoffset * (double)size * this.zoom);
        }
        this.interrupt = false;
        if (!this.animate) {
            for (x = -Xcenter; x < Xcenter && !this.interrupt; ++x) {
                for (y = -Ycenter; y < Ycenter; ++y) {
                    int x1 = x - sxoffset;
                    int y1 = y - syoffset;
                    if (Math.abs(x1) > Xcenter + Math.abs(sxoffset) || Math.abs(y1) > Ycenter + Math.abs(syoffset)) continue;
                    this.phi = this.ang1;
                    while (this.phi < (float)this.ang2) {
                        double pos = (double)(-x1) * costab[i] + (double)y1 * sintab[i];
                        if (this.interp == "nearest") {
                            this.S = (int)Math.round(pos / scale);
                            this.S += this.scans / 2;
                            if (this.S < this.scans && this.S > 0) {
                                val += this.fprojection[i][this.S];
                            }
                        } else if (this.interp == "linear") {
                            int b;
                            int a;
                            if (pos >= 0.0) {
                                a = (int)Math.floor(pos / scale);
                                b = a + this.scans / 2;
                                if (b < this.scans - 1 && b > 0) {
                                    val = val + this.fprojection[i][b] + (this.fprojection[i][b + 1] - this.fprojection[i][b]) * (pos / scale - (double)a);
                                }
                            } else if (pos < 0.0 && (b = (a = (int)Math.floor(pos / scale)) + this.scans / 2) < this.scans - 1 && b > 0) {
                                val = val + this.fprojection[i][b] + (this.fprojection[i][b] - this.fprojection[i][b + 1]) * (Math.abs(pos / scale) - (double)Math.abs(a));
                            }
                        }
                        ++i;
                        this.phi += this.stepsize;
                    }
                    this.S = 0;
                    i = 0;
                    bpimage[x + Xcenter][y + Ycenter] = val / (double)this.views;
                    val = 0.0;
                }
            }
        } else if (this.animate) {
            i = this.animcount;
            for (x = -Xcenter; x < Xcenter; ++x) {
                for (y = -Ycenter; y < Ycenter; ++y) {
                    int x1 = x - sxoffset;
                    int y1 = y - syoffset;
                    if (Math.abs(x1) <= Xcenter + Math.abs(sxoffset) && Math.abs(y1) <= Ycenter + Math.abs(syoffset)) {
                        double pos = (double)(-x1) * costab[i] + (double)y1 * sintab[i];
                        if (this.interp == "nearest") {
                            this.S = (int)Math.round(pos / scale);
                            this.S += this.scans / 2;
                            if (this.S < this.scans && this.S > 0) {
                                val += this.fprojection[i][this.S];
                            }
                        } else if (this.interp == "linear") {
                            int b;
                            int a;
                            if (pos >= 0.0) {
                                a = (int)Math.floor(pos / scale);
                                b = a + this.scans / 2;
                                if (b < this.scans - 1 && b > 0) {
                                    val = val + this.fprojection[i][b] + (this.fprojection[i][b + 1] - this.fprojection[i][b]) * (pos / scale - (double)a);
                                }
                            } else if (pos < 0.0 && (b = (a = (int)Math.floor(pos / scale)) + this.scans / 2) < this.scans - 1 && b > 0) {
                                val = val + this.fprojection[i][b] + (this.fprojection[i][b] - this.fprojection[i][b + 1]) * (Math.abs(pos / scale) - (double)Math.abs(a));
                            }
                        }
                    }
                    this.S = 0;
                    double[] dArray = this.animimage[x + Xcenter];
                    int n = y + Ycenter;
                    dArray[n] = dArray[n] + val / (double)this.views;
                    val = 0.0;
                }
            }
        }
        if (!this.animate) {
            return bpimage;
        }
        return this.animimage;
    }

    public double[][] Filter(double[][] proj) {
        int pscans;
        double[][] fproj = new double[this.views][this.scans];
        if (Utils.isPow2(this.scans)) {
            pscans = this.scans;
        } else {
            int power = (int)(Math.log(this.scans) / Math.log(2.0)) + 1;
            pscans = (int)Math.pow(2.0, power);
            System.out.println("PSCANS: " + pscans);
        }
        double[] rawdata = new double[pscans * 2];
        double[] idata = new double[pscans * 2];
        double[] pfilter = new double[pscans * 2];
        this.S = 0;
        while (this.S < pscans) {
            idata[this.S] = 0.0;
            ++this.S;
        }
        double[] filter = Filters.filter1(this.filtername, pscans * 2, this.filtercutoff);
        int i = 0;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            this.S = 0;
            while (this.S < this.scans) {
                rawdata[this.S] = proj[i][this.S];
                ++this.S;
            }
            this.S = this.scans;
            while (this.S < pscans * 2) {
                rawdata[this.S] = 0.0;
                ++this.S;
            }
            Filters.FFT(1, pscans * 2, rawdata, idata);
            this.S = 0;
            while (this.S < this.scans * 2) {
                int n = this.S;
                rawdata[n] = rawdata[n] * filter[this.S];
                ++this.S;
            }
            Filters.FFT(0, pscans * 2, rawdata, idata);
            this.S = 0;
            while (this.S < this.scans) {
                fproj[i][this.S] = rawdata[this.S];
                ++this.S;
            }
            this.S = 0;
            while (this.S < pscans * 2) {
                idata[this.S] = 0.0;
                ++this.S;
            }
            ++i;
            this.phi += this.stepsize;
        }
        return fproj;
    }

    public void truncateProjections(double width) {
        this.truncprojection = Utils.ArrayCopy(this.projection);
        int i = 0;
        int radius = (int)Math.ceil(width * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        System.out.println("R= " + radius);
        int s1 = this.scans / 2 - radius;
        System.out.println("S1= " + s1);
        int s2 = this.scans / 2 + radius;
        System.out.println("S2= " + s2);
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            this.S = 0;
            while (this.S <= s1 - 1) {
                this.projection[i][this.S] = 0.0;
                ++this.S;
            }
            this.S = s2 + 1;
            while (this.S < this.scans) {
                this.projection[i][this.S] = 0.0;
                ++this.S;
            }
            ++i;
            this.phi += this.stepsize;
        }
        System.out.println(width);
    }

    public void fixtruncatedProjections(double width) {
        int i = 0;
        int radius = (int)Math.ceil(width * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        int s1 = this.scans / 2 - radius;
        int s2 = this.scans / 2 + radius;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            double p1 = this.projection[i][s1];
            double p2 = this.projection[i][s2];
            this.S = 0;
            while (this.S <= s1) {
                this.projection[i][this.S] = p1;
                ++this.S;
            }
            this.S = s2;
            while (this.S < this.scans) {
                this.projection[i][this.S] = p2;
                ++this.S;
            }
            if (this.truncmethod == "simple cos-squared") {
                if (p1 != 0.0) {
                    this.S = 0;
                    while (this.S < s1) {
                        double[] dArray = this.projection[i];
                        int n = this.S;
                        dArray[n] = dArray[n] - Math.pow(Math.cos(Math.PI * (((double)this.S - p1) / (double)(2 * s1))), 2.0);
                        ++this.S;
                    }
                    this.S = s2;
                    while (this.S < this.scans) {
                        double[] dArray = this.projection[i];
                        int n = this.S;
                        dArray[n] = dArray[n] - (1.0 - Math.pow(Math.cos(Math.PI * (((double)this.S + p2) / (double)s2)), 2.0));
                        ++this.S;
                    }
                }
            } else if (this.truncmethod == "simple square root" && p1 != 0.0) {
                this.S = 0;
                while (this.S < s1) {
                    this.projection[i][this.S] = p1 * Math.pow(((double)this.S - p1) / (double)(2 * s1), 0.5);
                    ++this.S;
                }
                this.S = s2;
                while (this.S < this.scans) {
                    this.projection[i][this.S] = p2 * Math.pow(((double)this.S + p2) / (double)s2, 0.5);
                    ++this.S;
                }
            }
            ++i;
            this.phi += this.stepsize;
        }
    }

    private void replaceouterProjections(double[][] rproj, double width) {
        int i = 0;
        int radius = (int)Math.ceil(width * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        double[] r = new double[this.scans];
        int s1 = this.scans / 2 - radius;
        int s2 = this.scans / 2 + radius;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            double p1 = this.projection[i][s1];
            double p2 = this.projection[i][s2];
            System.out.print("p1= " + p1);
            System.out.println("p2= " + p2 + " ");
            this.S = 0;
            while (this.S < this.scans) {
                r[this.S] = rproj[i][this.S];
                ++this.S;
            }
            Utils.normalize1DArray(r, 0.0, p1);
            this.S = 0;
            while (this.S < s1) {
                this.projection[i][this.S] = r[this.S];
                System.out.print(r[this.S] + ",");
                ++this.S;
            }
            System.out.println();
            Utils.normalize1DArray(r, 0.0, p2);
            this.S = s2 + 1;
            while (this.S < this.scans) {
                this.projection[i][this.S] = r[this.S];
                ++this.S;
            }
            ++i;
            this.phi += this.stepsize;
        }
    }

    private void GetProjectionWidths(double[][] proj) {
        int i = 0;
        this.S = 0;
        int radius = (int)Math.ceil(this.truncatewidth * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        int s1 = this.scans / 2 - radius;
        int s2 = this.scans / 2 + radius;
        this.pleft = new double[this.views];
        this.pright = new double[this.views];
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            this.S = 0;
            while (proj[i][this.S] <= 0.0 && this.S <= s1) {
                if (proj[i][this.S] <= 0.0) {
                    this.pleft[i] = this.S;
                }
                ++this.S;
            }
            this.pleft[i] = this.S;
            this.S = this.scans - 1;
            while (proj[i][this.S] <= 0.0 && this.S >= s2) {
                if (proj[i][this.S] <= 0.0) {
                    this.pright[i] = this.S;
                }
                --this.S;
            }
            this.pright[i] = this.S;
            ++i;
            this.phi += this.stepsize;
        }
        i = 0;
    }

    private void AdaptiveDetrunc(double width) {
        int i = 0;
        int radius = (int)Math.ceil(width * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        int s1 = this.scans / 2 - radius;
        int s2 = this.scans / 2 + radius;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            double W;
            double p1 = this.projection[i][s1];
            double p2 = this.projection[i][s2];
            this.S = 0;
            while (this.S <= s1) {
                this.projection[i][this.S] = p1;
                ++this.S;
            }
            this.S = s2;
            while (this.S < this.scans) {
                this.projection[i][this.S] = p2;
                ++this.S;
            }
            double rad1 = (double)s1 - this.pleft[i];
            double rad2 = this.pright[i] - (double)s2;
            if (this.pleft[i] < (double)s1) {
                this.S = s1;
                while (this.S >= 0) {
                    W = 0.7853981633974483 * ((double)(this.S - s1) / rad1);
                    double[] dArray = this.projection[i];
                    int n = this.S;
                    dArray[n] = dArray[n] - (1.0 - Math.pow(Math.cos(W), 2.0));
                    if (this.setedgezero && (double)this.S < this.pleft[i] && this.S < s1) {
                        this.projection[i][this.S] = 0.0;
                    }
                    if (this.projection[i][this.S] < 0.0) {
                        this.projection[i][this.S] = 0.0;
                    }
                    --this.S;
                }
            }
            if (this.pright[i] > (double)s2) {
                this.S = s2;
                while (this.S < this.scans) {
                    W = 0.7853981633974483 * ((double)(this.S - s2) / rad2);
                    double[] dArray = this.projection[i];
                    int n = this.S;
                    dArray[n] = dArray[n] - (1.0 - Math.pow(Math.cos(W), 2.0));
                    if (this.setedgezero && (double)this.S > this.pright[i] && this.S > s2) {
                        this.projection[i][this.S] = 0.0;
                    }
                    if (this.projection[i][this.S] < 0.0) {
                        this.projection[i][this.S] = 0.0;
                    }
                    ++this.S;
                }
            }
            ++i;
            this.phi += this.stepsize;
        }
    }

    private double[][] performHDTReconstruction() {
        int dscans = this.scans * 2;
        double[][] temppixels = this.BackProject(this.projection, this.outputimgsize);
        double[][] tempproj = new double[this.views][dscans];
        double[][] img = new double[this.outputimgsize][this.outputimgsize];
        for (int iter = 0; iter <= 2; ++iter) {
            this.blankROI(temppixels, this.outputimgsize);
            tempproj = this.ForwardProject(temppixels);
            this.replaceouterProjections(tempproj, this.truncatewidth);
            img = this.BackProject(this.projection, this.outputimgsize);
            temppixels = img;
        }
        return img;
    }

    public short[] CropPixelstoROI(short[] pix, int size) {
        int Xcenter = size / 2;
        int Ycenter = size / 2;
        double scale = this.zoom * (double)size * Math.sqrt(2.0) / (double)this.scans;
        int radius = (int)Math.ceil(this.truncatewidth * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        System.out.println("R= " + radius);
        for (int x = -Xcenter; x < Xcenter; ++x) {
            for (int y = -Ycenter; y < Ycenter; ++y) {
                double val = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
                if (!(val > (double)(radius * 2) * (scale / 2.0))) continue;
                pix[y + Ycenter + (x + Xcenter) * size] = 2000;
            }
        }
        return pix;
    }

    public void DrawROICircle(BufferedImage img) {
        int size = this.outputimgsize;
        int Xcenter = size / 2;
        int Ycenter = size / 2;
        double scale = this.zoom * (double)size * Math.sqrt(2.0) / (double)this.scans;
        int diam = (int)Math.ceil(this.truncatewidth * (double)this.scans * 2.0);
        if (diam % 2 != 0) {
            ++diam;
        }
        double d = (double)diam * scale;
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.draw(new Ellipse2D.Double((double)Xcenter - d / 2.0, (double)Ycenter - d / 2.0, d, d));
    }

    public double[][] blankROI(double[][] pix, int size) {
        int Xcenter = size / 2;
        int Ycenter = size / 2;
        double scale = this.zoom * (double)size * Math.sqrt(2.0) / (double)this.scans;
        int radius = (int)Math.ceil(this.truncatewidth * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        System.out.println("R= " + radius);
        for (int x = -Xcenter; x < Xcenter; ++x) {
            for (int y = -Ycenter; y < Ycenter; ++y) {
                double val = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
                if (!(val < (double)(radius * 2) * (scale / 2.0))) continue;
                pix[x + Xcenter][y + Ycenter] = 0.0;
            }
        }
        return pix;
    }

    public void FindNumRays() {
        int i = 0;
        double[] sintab = new double[this.views];
        double[] costab = new double[this.views];
        this.S = 0;
        int radius = (int)Math.ceil(this.truncatewidth * (double)this.scans);
        if (radius % 2 != 0) {
            ++radius;
        }
        int A = (int)Math.ceil((double)this.scans * 0.05);
        int B = (int)Math.ceil((double)this.scans * 0.1);
        int C = (int)Math.ceil((double)this.scans * 0.15);
        int D = (int)Math.ceil((double)this.scans * 0.2);
        int numA = 0;
        int numB = 0;
        int numC = 0;
        int numD = 0;
        int s1 = this.scans / 2 - radius;
        int s2 = this.scans / 2 + radius;
        int A1 = this.scans / 2 - A;
        int A2 = this.scans / 2 + A;
        int B1 = this.scans / 2 - B;
        int B2 = this.scans / 2 + B;
        int C1 = this.scans / 2 - C;
        int C2 = this.scans / 2 + C;
        int D1 = this.scans / 2 - D;
        int D2 = this.scans / 2 + D;
        this.totalrays = 0;
        this.numrays = 0;
        this.truncbeamrays = 0;
        this.phi = this.ang1;
        while (this.phi < (float)this.ang2) {
            this.S = 0;
            while (this.S < this.scans) {
                ++this.totalrays;
                if (this.projection[i][this.S] > 0.0) {
                    ++this.numrays;
                }
                if (this.truncate && this.S > s1 && this.S < s2 && this.projection[i][this.S] > 0.0) {
                    ++this.truncbeamrays;
                }
                if (this.projection[i][this.S] > 0.0) {
                    if (this.S > A1 && this.S < A2) {
                        ++numA;
                    }
                    if (this.S > B1 && this.S < B2) {
                        ++numB;
                    }
                    if (this.S > C1 && this.S < C2) {
                        ++numC;
                    }
                    if (this.S > D1 && this.S < D2) {
                        ++numD;
                    }
                }
                ++this.S;
            }
            ++i;
            this.phi += this.stepsize;
        }
        i = 0;
        numD -= numC;
        numC -= numB;
        numB -= numA;
        if (this.truncate) {
            double truncrayperc = Utils.round((double)this.truncbeamrays / (double)this.numrays, 2);
        }
    }

    public BufferedImage CreateReconstructedImage() {
        BufferedImage bpimg;
        double startTime = 0.0;
        this.timetaken = 0.0;
        boolean i = false;
        boolean j = false;
        if (this.projection == null) {
            this.ProjectPhantom();
        } else {
            this.scans = this.projection[0].length;
        }
        if (!this.animate) {
            this.FindNumRays();
        }
        if (this.truncate) {
            this.pixels = this.BackProject(this.projection, this.outputimgsize);
            this.maxval = Utils.getMax(this.pixels);
            System.out.println("MAXVAL: " + this.maxval);
            startTime = System.currentTimeMillis();
            if (!this.keepcurrentextrapwidths || this.pleft == null) {
                this.GetProjectionWidths(this.projection);
            }
            this.truncateProjections(this.truncatewidth);
            double[][] roipixels = new double[this.outputimgsize][this.outputimgsize];
            if (this.truncmethod == "simple cos-squared" || this.truncmethod == "simple square root") {
                if (!this.animate) {
                    this.fixtruncatedProjections(this.truncatewidth);
                }
                if (this.method == "fbp") {
                    roipixels = this.BackProject(this.projection, this.outputimgsize);
                } else if (this.method == "iterative") {
                    roipixels = Iterative.PerformART(this);
                }
            } else if (this.truncmethod == "adaptive cos-squared") {
                this.AdaptiveDetrunc(this.truncatewidth);
                roipixels = this.BackProject(this.projection, this.outputimgsize);
            } else if (this.truncmethod == "vangompel") {
                this.fixtruncatedProjections(this.truncatewidth);
                roipixels = this.performROIReconstruction();
                this.maxval = Utils.getMax(roipixels);
            } else if (this.truncmethod == "HDT") {
                this.AdaptiveDetrunc(this.truncatewidth);
                roipixels = this.performHDTReconstruction();
                this.maxval = Utils.getMax(roipixels);
            } else if (this.truncmethod == "none") {
                roipixels = this.BackProject(this.projection, this.outputimgsize);
            }
            bpimg = this.CreateImagefromArray(roipixels, this.maxval, 1);
            this.pixels = roipixels;
            this.timetaken = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        } else if (this.method == "iterative" && !this.truncate) {
            this.pixels = Iterative.PerformART(this);
            this.maxval = Utils.getMax(this.pixels);
            bpimg = this.CreateImagefromArray(this.pixels, this.maxval, 1);
        } else if (this.animate) {
            this.doBackProjection();
            this.maxval = Utils.getMax(this.pixels);
            bpimg = this.CreateImagefromArray(this.pixels, this.maxval, 0);
        } else {
            startTime = System.currentTimeMillis();
            this.pixels = this.BackProject(this.projection, this.outputimgsize);
            this.maxval = Utils.getMax(this.pixels);
            bpimg = this.CreateImagefromArray(this.pixels, this.maxval, 1);
            this.timetaken = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        }
        if (this.displayimgdetails) {
            Graphics2D g = (Graphics2D)bpimg.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font("Arial", 1, 50));
            g.setColor(Color.black);
            g.drawString(Integer.toString(this.tagnum), bpimg.getWidth() / 2 + 2, 42);
            g.setColor(Color.white);
            g.drawString(Integer.toString(this.tagnum), bpimg.getWidth() / 2, 40);
            ++this.tagnum;
        }
        if (this.displayroicircle) {
            this.DrawROICircle(bpimg);
        }
        return bpimg;
    }

    public BufferedImage CreateImagefromArray(double[][] pix, double max, int type) {
        boolean i = false;
        boolean j = false;
        short[] pixelshortArray = new short[pix.length * pix[0].length];
        double min = Utils.getMin(pix);
        Utils.zeronegvals2DArray(pix);
        for (int y = 0; y < pix[0].length; ++y) {
            for (int x = 0; x < pix.length; ++x) {
                int gray = min < 0.0 ? (int)(pix[x][y] * 2000.0 / max) : (int)(pix[x][y] * 2000.0 / max);
                pixelshortArray[x + y * pix.length] = (short)gray;
            }
        }
        if (this.roicrop) {
            pixelshortArray = this.CropPixelstoROI(pixelshortArray, this.outputimgsize);
        }
        BufferedImage img = type == 1 ? ImageUtils.create12bitImage(this.outputimgsize, this.outputimgsize, pixelshortArray) : ImageUtils.getGrayBufferedImage(pixelshortArray, pix.length, pix[0].length, 0, 2000);
        return img;
    }

    public BufferedImage CreateSinogram(String filename) {
        int x = 0;
        int y = 0;
        if (this.projection == null) {
            this.ProjectPhantom();
        }
        if (filename != null) {
            this.loadProjectionsFile(filename);
        }
        double min = Utils.getMin(this.projection);
        System.out.println(min);
        double max = Utils.getMax(this.projection);
        System.out.println(max);
        short[] pixelshortArray = new short[this.projection.length * this.projection[0].length];
        for (x = 0; x < this.projection.length; ++x) {
            for (y = 0; y < this.projection[0].length; ++y) {
                int gray = max > min ? (int)(this.projection[x][y] * 2000.0 / max) : (int)((this.projection[x][y] - min) * 2000.0 / max);
                pixelshortArray[y + x * this.projection[0].length] = (short)gray;
            }
        }
        BufferedImage sinoimg = ImageUtils.create12bitImage(this.projection[0].length, this.projection.length, pixelshortArray);
        return sinoimg;
    }

    public void saveProjectionsFile(String filename) {
        double[][] array = new double[this.views][this.scans];
        array = this.projection;
        try {
            PrintWriter writer = filename == null ? new PrintWriter(new FileWriter("/proj.txt")) : new PrintWriter(new FileWriter(filename));
            writer.println(this.projstacksize);
            writer.println(this.stepsize);
            writer.println(array.length);
            writer.println(array[0].length);
            for (int p = 0; p < this.projstacksize; ++p) {
                if (this.projstacksize > 1) {
                    array = (double[][])this.projectionstack[p];
                }
                for (int y = 0; y < array[0].length; ++y) {
                    for (int x = 0; x < array.length; ++x) {
                        writer.print(array[x][y] + " ");
                    }
                    writer.println();
                }
            }
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception in file writing: " + ioe);
        }
    }

    public void loadProjectionsFile(String filename) {
        int s;
        int v;
        float step;
        BufferedReader reader;
        File file;
        int ps = 1;
        try {
            if (filename == null) {
                file = new File("/proj.txt");
                reader = new BufferedReader(new FileReader(file));
            } else {
                file = new File(filename);
                reader = new BufferedReader(new FileReader(file));
            }
            ps = Integer.valueOf(reader.readLine());
            step = Float.valueOf(reader.readLine()).floatValue();
            v = Integer.valueOf(reader.readLine());
            s = Integer.valueOf(reader.readLine());
            System.out.println("projstacksize=" + ps);
            System.out.println("v=" + v);
            System.out.println("s=" + s);
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception " + ioe);
            s = 0;
            v = 0;
            step = 0.0f;
        }
        double[][] array = new double[v][s];
        this.projstacksize = ps;
        this.views = v;
        this.scans = s;
        this.stepsize = step;
        try {
            if (filename == null) {
                file = new File("/proj.txt");
                reader = new BufferedReader(new FileReader(file));
            } else {
                file = new File(filename);
                reader = new BufferedReader(new FileReader(file));
            }
            reader.readLine();
            reader.readLine();
            reader.readLine();
            reader.readLine();
            String aLine = new String();
            for (int p = 0; p < ps; ++p) {
                for (int y = 0; y < array[0].length; ++y) {
                    aLine = reader.readLine();
                    StringTokenizer st = new StringTokenizer(aLine);
                    for (int x = 0; x < array.length; ++x) {
                        String str = st.nextToken();
                        array[x][y] = Double.parseDouble(str);
                    }
                }
            }
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception " + ioe);
        }
        this.initialiseprojection();
        this.projection = array;
    }

    public void importProjections(ImagePlus inputimg, boolean incols, int ps) {
        int s;
        int v;
        int type = inputimg.getType();
        this.projstacksize = ps;
        if (ps > 1) {
            this.projectionstack = new Object[ps];
        }
        ImageProcessor inputip = inputimg.getProcessor();
        if (incols) {
            v = inputip.getWidth();
            s = inputip.getHeight();
        } else {
            s = inputip.getWidth();
            v = inputip.getHeight();
        }
        System.out.println("Importing projection data as image \n");
        this.views = v;
        this.scans = s;
        this.stepsize = 180 / v;
        System.out.println("Scans= " + s + " ");
        System.out.println("Views= " + v + "\n");
        System.out.println("Stepsize= " + this.stepsize + "\n ");
        for (int p = 0; p < ps; ++p) {
            int y;
            int x;
            this.projection = new double[v][s];
            if (type == 1) {
                if (ps > 1) {
                    System.out.println("data " + p + "\n");
                } else {
                    inputip = (ShortProcessor)inputimg.getProcessor();
                }
                short[] sarray = (short[])inputip.getPixels();
                if (incols) {
                    System.out.println("incols");
                    System.out.println("incols " + p + "\n");
                    for (x = 0; x < this.projection[0].length; ++x) {
                        for (y = 0; y < this.projection.length; ++y) {
                            this.projection[y][x] = sarray[y + x * this.projection.length] & 0xFFFF;
                        }
                    }
                    continue;
                }
                System.out.println("inrows");
                System.out.println("inrows " + p + "\n");
                for (x = 0; x < this.projection[0].length; ++x) {
                    for (y = 0; y < this.projection.length; ++y) {
                        this.projection[y][x] = sarray[x + y * this.projection[0].length] & 0xFFFF;
                    }
                }
                continue;
            }
            if (ps > 1) {
                System.out.println("data " + p + "\n");
            } else {
                inputip = (ByteProcessor)inputimg.getProcessor();
            }
            byte[] barray = (byte[])inputip.getPixels();
            if (incols) {
                for (x = 0; x < this.projection[0].length; ++x) {
                    for (y = 0; y < this.projection.length; ++y) {
                        this.projection[y][x] = barray[y + x * this.projection.length] & 0xFF;
                    }
                }
                continue;
            }
            for (x = 0; x < this.projection[0].length; ++x) {
                for (y = 0; y < this.projection.length; ++y) {
                    this.projection[y][x] = barray[x + y * this.projection[0].length] & 0xFF;
                }
            }
        }
    }

    public void fanrebin(double[][] proj) {
    }

    private void applyGaussiantoProjections(double[][] arr, String choice) {
        block5: {
            double[] gauss;
            int i;
            block4: {
                i = 0;
                gauss = this.CreateGaussian(this.scans);
                if (choice != "multiply") break block4;
                this.phi = this.ang1;
                while (this.phi < (float)this.ang2) {
                    this.S = 0;
                    while (this.S < this.scans) {
                        arr[i][this.S] = arr[i][this.S] * gauss[this.S];
                        ++this.S;
                    }
                    ++i;
                    this.phi += this.stepsize;
                }
                break block5;
            }
            if (choice != "divide") break block5;
            this.phi = this.ang1;
            while (this.phi < (float)this.ang2) {
                this.S = 0;
                while (this.S < this.scans) {
                    arr[i][this.S] = arr[i][this.S] / gauss[this.S];
                    ++this.S;
                }
                ++i;
                this.phi += this.stepsize;
            }
        }
    }

    public double[] CreateGaussian(int scans) {
        double[] gauss = new double[scans];
        double width = scans * 2 / 6;
        double sigma = width / 2.3548;
        double half = (scans - 1) / 2;
        for (int i = 0; i < scans; ++i) {
            gauss[i] = 1.0 / (Math.sqrt(Math.PI * 2) * sigma) * Math.exp(-Math.pow((double)i - half, 2.0) / (2.0 * Math.pow(sigma, 2.0)));
        }
        Utils.normalize1DArray(gauss, 0.0, 1.0);
        return gauss;
    }

    public double[][] Create2DGaussian(int size) {
        double[][] gauss = new double[size][size];
        int Xcenter = size / 2;
        int Ycenter = size / 2;
        double width = size * 4 / 6;
        double sigma = width / 2.3548;
        for (int x = -Xcenter; x < Xcenter; ++x) {
            for (int y = -Ycenter; y < Ycenter; ++y) {
                gauss[y + Ycenter][x + Xcenter] = 1.0 / (Math.PI * 2 * Math.pow(sigma, 2.0)) * Math.exp(-(Math.pow(x, 2.0) + Math.pow(y, 2.0)) / (2.0 * Math.pow(sigma, 2.0)));
            }
        }
        Utils.normalize2DArray(gauss, 0.0, 1.0);
        return gauss;
    }

    private double[][] performROIReconstruction() {
        this.applyGaussiantoProjections(this.projection, "multiply");
        double[][] temppixels = this.BackProject(this.projection, this.outputimgsize * 3 / 2);
        double[][] gaussian = this.Create2DGaussian(this.outputimgsize * 3 / 2);
        temppixels = Utils.multiply2Darrays(temppixels, gaussian);
        double[][] tempproj = new double[this.views][this.scans * 2];
        this.scans *= 2;
        tempproj = this.ProjectfromImage(temppixels, tempproj);
        this.applyGaussiantoProjections(tempproj, "divide");
        double[][] img = this.BackProject(tempproj, this.outputimgsize);
        gaussian = this.Create2DGaussian(this.outputimgsize);
        img = Utils.divide2Darrays(img, gaussian);
        this.scans /= 2;
        return img;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
        }
        CTScanner scanner = new CTScanner();
        scanner.scans = 1024;
        scanner.views = 225;
        scanner.outputimgsize = 512;
        scanner.phantomname = "test4";
        scanner.filtername = "hann";
        scanner.filtercutoff = 1.0;
        scanner.zoom = 1.4;
        scanner.truncmethod = "adaptive cos-squared";
        scanner.displayimgdetails = true;
        scanner.noise = "reconwithnoise";
        scanner.rate = 650.0;
        scanner.tagnum = 1;
        boolean i = false;
        int numsims = 10;
        for (double t = 0.14; t <= 0.14; t += 0.01) {
            i = true;
            scanner.ProjectPhantom();
            scanner.truncatewidth = Utils.round(t, 2);
            BufferedImage img = scanner.CreateReconstructedImage();
            String filename = "C:\\Program Files\\Java\\projects\\lowcontrast_test3\\test4_full";
            ImagePanel imgpanel = new ImagePanel();
            imgpanel.loadBufferedImage(img);
            imgpanel.setPixelData();
            imgpanel.lowerwinlvl = 978;
            imgpanel.upperwinlvl = 1220;
            imgpanel.PerformWindowing();
            Utils.saveanImage(filename, imgpanel.windowedImage);
        }
    }
}

