/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import myctapp.Filters;
import myctapp.InternalImageFrame;
import myctapp.Utils;

public class DataFrame
extends InternalImageFrame
implements PropertyChangeListener {
    JPanel main;
    JPanel dpanel;
    LogArea lpanel;
    LogArea fftlpanel;
    Vector data;
    JButton button;
    JComboBox cmbFunc;
    JComboBox trigFunc;
    double[] test;
    double[] ffttest;
    int current;
    int s = 128;
    double freq = 1.0;
    double gswidth = 0.1;
    JFormattedTextField gwidthField;
    JFormattedTextField freqField;
    JFormattedTextField samplesField;
    JFormattedTextField zoomField;
    Color[] myColors;
    int choice = 1;
    double zoom = 1.0;
    boolean absfft = true;

    public DataFrame() {
        this.setPreferredSize(new Dimension(100, 80));
        this.setFont(new Font("SansSerif", 0, 10));
        this.setBackground(Color.white);
        this.setTitle("Data Grapher");
        this.data = new Vector(4);
        this.createColors();
    }

    public void setupPanels() {
        Font theMainFont = new Font("SansSerif", 0, 11);
        UIManager.put("InternalFrame.activeTitleBackground", Color.yellow);
        UIManager.put("Button.font", theMainFont);
        UIManager.put("Label.font", theMainFont);
        UIManager.put("ComboBox.font", theMainFont);
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        ArrayGraphPanel gpanel = new ArrayGraphPanel();
        gpanel.fft = false;
        ArrayGraphPanel fftgpanel = new ArrayGraphPanel();
        fftgpanel.fft = true;
        final ArraysComboBox arrlistbox = new ArraysComboBox();
        arrlistbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DataFrame.this.current = arrlistbox.getSelectedIndex();
                if (DataFrame.this.current >= 0) {
                    DataFrame.this.test = (double[])DataFrame.this.data.get(DataFrame.this.current);
                    DataFrame.this.lpanel.updatecurrdata(DataFrame.this.test);
                    DataFrame.this.fftlpanel.updatecurrdata(DataFrame.this.test);
                    System.out.println(DataFrame.this.current);
                }
            }
        });
        this.lpanel = new LogArea();
        this.lpanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fftlpanel = new LogArea();
        this.fftlpanel.fft = true;
        this.fftlpanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel widgetspanel = new JPanel();
        widgetspanel.setMinimumSize(new Dimension(200, 10));
        widgetspanel.setMaximumSize(new Dimension(600, 30));
        widgetspanel.setBorder(new EtchedBorder());
        this.button = new JButton("Load Data");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFrame frame = new JFrame();
                FileDialog fd = new FileDialog((Frame)frame, "Load Data");
                fd.show();
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                double[] temp = Utils.importArrayData(path);
                if (temp.length < DataFrame.this.s && DataFrame.this.current > 0) {
                    temp = DataFrame.this.pad(temp);
                }
                DataFrame.this.data.add(temp);
                if (DataFrame.this.current <= 0) {
                    DataFrame.this.s = temp.length;
                    DataFrame.this.samplesField.setValue(new Integer(DataFrame.this.s));
                }
                arrlistbox.update();
                DataFrame.this.lpanel.updatecurrdata(temp);
                DataFrame.this.fftlpanel.updatecurrdata(temp);
                DataFrame.this.repaint();
            }
        });
        widgetspanel.add(this.button);
        this.button = new JButton("Diff");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    DataFrame.this.test = (double[])DataFrame.this.data.get(DataFrame.this.current);
                    DataFrame.this.Differentiate();
                    DataFrame.this.lpanel.updatecurrdata(DataFrame.this.test);
                    DataFrame.this.fftlpanel.updatecurrdata(DataFrame.this.test);
                    DataFrame.this.repaint();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        widgetspanel.add(this.button);
        this.cmbFunc = new JComboBox();
        this.cmbFunc.addItem("ABSFFT");
        this.cmbFunc.addItem("FFT");
        this.cmbFunc.addItem("IFFT");
        this.cmbFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String s = (String)DataFrame.this.cmbFunc.getSelectedItem();
                try {
                    if (s == "FFT") {
                        DataFrame.this.absfft = false;
                        DataFrame.this.choice = 1;
                    } else if (s == "IFFT") {
                        DataFrame.this.choice = 0;
                    } else if (s == "ABSFFT") {
                        DataFrame.this.absfft = true;
                    }
                    DataFrame.this.lpanel.updatecurrdata(DataFrame.this.test);
                    DataFrame.this.fftlpanel.updatecurrdata(DataFrame.this.test);
                    DataFrame.this.repaint();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        widgetspanel.add(this.cmbFunc);
        this.trigFunc = new JComboBox();
        this.trigFunc.addItem("sin");
        this.trigFunc.addItem("cos");
        this.trigFunc.addItem("gauss");
        this.trigFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String s = (String)DataFrame.this.trigFunc.getSelectedItem();
                DataFrame.this.addData(s);
                DataFrame.this.lpanel.updatecurrdata(DataFrame.this.test);
                DataFrame.this.fftlpanel.updatecurrdata(DataFrame.this.test);
                arrlistbox.update();
                DataFrame.this.repaint();
            }
        });
        widgetspanel.add(this.trigFunc);
        arrlistbox.update();
        widgetspanel.add(arrlistbox);
        this.button = new JButton("Del Data");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DataFrame.this.data.remove(DataFrame.this.current);
                arrlistbox.update();
                DataFrame.this.repaint();
            }
        });
        widgetspanel.add(this.button);
        main.add(widgetspanel);
        JPanel entrypanel = new JPanel();
        entrypanel.setMinimumSize(new Dimension(400, 20));
        entrypanel.setMaximumSize(new Dimension(400, 50));
        NumberFormat format = NumberFormat.getNumberInstance();
        JLabel gwidthLabel = new JLabel("Gs. Width");
        this.gwidthField = new JFormattedTextField(format);
        this.gwidthField.setValue(new Double(0.1));
        this.gwidthField.setColumns(3);
        this.gwidthField.addPropertyChangeListener("value", this);
        gwidthLabel.setLabelFor(this.gwidthField);
        entrypanel.add(gwidthLabel);
        entrypanel.add(this.gwidthField);
        JLabel freqLabel = new JLabel("Func Freq");
        this.freqField = new JFormattedTextField(format);
        this.freqField.setValue(new Integer(1));
        this.freqField.setColumns(3);
        this.freqField.addPropertyChangeListener("value", this);
        freqLabel.setLabelFor(this.freqField);
        entrypanel.add(freqLabel);
        entrypanel.add(this.freqField);
        JLabel samplesLabel = new JLabel("No Samples");
        this.samplesField = new JFormattedTextField(format);
        this.samplesField.setValue(new Integer(128));
        this.samplesField.setColumns(3);
        this.samplesField.addPropertyChangeListener("value", this);
        samplesLabel.setLabelFor(this.samplesField);
        entrypanel.add(samplesLabel);
        entrypanel.add(this.samplesField);
        JLabel zoomLabel = new JLabel("Zoom");
        this.zoomField = new JFormattedTextField(format);
        this.zoomField.setValue(new Integer(1));
        this.zoomField.setColumns(3);
        this.zoomField.addPropertyChangeListener("value", this);
        zoomLabel.setLabelFor(this.zoomField);
        entrypanel.add(zoomLabel);
        entrypanel.add(this.zoomField);
        main.add(entrypanel);
        main.add(Box.createRigidArea(new Dimension(0, 6)));
        Container container = this.getContentPane();
        main.add(gpanel);
        main.add(Box.createRigidArea(new Dimension(0, 6)));
        main.add(fftgpanel);
        JPanel bottompanel = new JPanel();
        bottompanel.setMinimumSize(new Dimension(400, 60));
        bottompanel.setMaximumSize(new Dimension(1000, 75));
        bottompanel.add(this.lpanel);
        bottompanel.add(this.fftlpanel);
        bottompanel.setBorder(new EtchedBorder());
        JPanel buttpanel = new JPanel();
        buttpanel.setLayout(new GridLayout(2, 1));
        buttpanel.setMinimumSize(new Dimension(30, 50));
        buttpanel.setMaximumSize(new Dimension(90, 65));
        this.button = new JButton("Copy");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DataFrame.this.repaint();
            }
        });
        buttpanel.add(this.button);
        this.button = new JButton("Clear");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DataFrame.this.data.clear();
                arrlistbox.update();
                DataFrame.this.repaint();
            }
        });
        buttpanel.add(this.button);
        bottompanel.add(buttpanel);
        main.add(bottompanel);
        container.add(main);
    }

    public double[] pad(double[] data) {
        int x;
        double[] res = new double[this.s];
        int l = data.length;
        for (x = 0; x < l; ++x) {
            res[x] = data[x];
        }
        for (x = l; x < this.s; ++x) {
            res[x] = 0.0;
        }
        return res;
    }

    public void createColors() {
        this.myColors = new Color[25];
        for (int i = 1; i < 25; ++i) {
            int rd = (int)(255.0 * Math.random());
            int gr = (int)(200.0 * Math.random());
            int bl = (int)(200.0 * Math.random());
            this.myColors[i] = new Color(rd, gr, bl);
        }
    }

    public void makeData(double[] data) {
        this.s = data.length;
        this.test = new double[this.s];
        for (int i = 0; i < this.s; ++i) {
            this.test[i] = data[i];
        }
    }

    public void Differentiate() {
        for (int x = 0; x < this.s - 1; ++x) {
            this.test[x] = this.test[x + 1] - this.test[x];
        }
        this.test[this.s - 1] = 0.0;
    }

    public void getFFT(double[] data, int ch) {
        double[] idata = new double[this.s];
        if (ch == 1) {
            for (int i = 0; i < this.s; ++i) {
                idata[i] = 0.0;
            }
            Filters.FFT(1, this.s, data, idata);
        } else if (ch == 0) {
            Filters.FFT(0, this.s, data, idata);
        }
        if (this.absfft) {
            for (int x = 0; x < this.s; ++x) {
                data[x] = Math.abs(data[x]);
            }
        }
    }

    public double[] fsinX(double f) {
        double[] temp = new double[this.s];
        for (int x = 0; x < this.s; ++x) {
            double t = (double)x * 180.0 / (double)this.s;
            temp[x] = Math.sin(Math.toRadians(2.0 * t * f));
        }
        return temp;
    }

    public double[] fcosX(double f) {
        double[] temp = new double[this.s];
        for (int x = 0; x < this.s; ++x) {
            double t = (double)x * 180.0 / (double)this.s;
            temp[x] = Math.cos(Math.toRadians(2.0 * t * f));
        }
        return temp;
    }

    public double[] fgaussianX() {
        double[] gauss = new double[this.s];
        double width = (double)this.s * this.gswidth;
        double sigma = width / 2.3548;
        double half = (this.s - 1) / 2;
        for (int i = 0; i < this.s; ++i) {
            gauss[i] = 1.0 / (Math.sqrt(Math.PI * 2) * sigma) * Math.exp(-Math.pow((double)i - half, 2.0) / (2.0 * Math.pow(sigma, 2.0)));
        }
        return gauss;
    }

    public void addData(String func) {
        if (func == "sin") {
            this.test = this.fsinX(this.freq);
        } else if (func == "cos") {
            this.test = this.fcosX(this.freq);
        } else if (func == "gauss") {
            this.test = this.fgaussianX();
        }
        this.data.add(this.test);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.gray);
        g.setColor(Color.black);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.freqField) {
            this.freq = ((Number)this.freqField.getValue()).doubleValue();
        } else if (source == this.samplesField) {
            this.s = ((Number)this.samplesField.getValue()).intValue();
        } else if (source == this.zoomField) {
            this.zoom = ((Number)this.zoomField.getValue()).doubleValue();
            this.repaint();
        } else if (source == this.gwidthField) {
            this.gswidth = ((Number)this.gwidthField.getValue()).doubleValue();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataFrame app = new DataFrame();
                app.setDefaultCloseOperation(3);
                app.pack();
                app.setVisible(true);
            }
        });
    }

    class LogArea
    extends JPanel {
        JTextArea ta;
        JScrollPane sp;
        boolean fft = false;

        public LogArea() {
            this.setPreferredSize(new Dimension(180, 80));
            this.setMinimumSize(new Dimension(70, 80));
            this.setMaximumSize(new Dimension(300, 80));
            this.setFont(new Font("Monospaced", 0, 11));
            this.ta = new JTextArea(10, 25);
            JScrollPane sp = new JScrollPane(this.ta);
            sp.setPreferredSize(new Dimension(175, 70));
            sp.setHorizontalScrollBarPolicy(31);
            this.add(sp);
        }

        public void updatecurrdata(int[] data) {
            this.ta.setText("");
            for (int i = 0; i < data.length; ++i) {
                this.ta.append(Integer.toString(data[i]) + "\n");
            }
            this.ta.setCaretPosition(this.ta.getText().length());
        }

        public void updatecurrdata(double[] data) {
            this.ta.setText("");
            double[] fftdata = new double[data.length];
            if (this.fft) {
                int i;
                for (i = 0; i < DataFrame.this.s; ++i) {
                    fftdata[i] = data[i];
                }
                DataFrame.this.getFFT(fftdata, DataFrame.this.choice);
                for (i = 0; i < data.length; ++i) {
                    this.ta.append(Double.toString(fftdata[i]) + "\n");
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    this.ta.append(Double.toString(data[i]) + "\n");
                }
            }
            this.ta.setCaretPosition(this.ta.getText().length());
        }
    }

    class ArrayGraphPanel
    extends JPanel {
        int y;
        boolean fft;

        ArrayGraphPanel() {
        }

        public void ArrayGraphPanel() {
        }

        public void normalizeData(double[] data, int y) {
            double min = Utils.getMin(data);
            double max = Utils.getMax(data);
            for (int i = 0; i < DataFrame.this.s; ++i) {
                data[i] = data[i] * (double)y / (max - min);
            }
        }

        double f(double x) {
            if (this.fft) {
                return DataFrame.this.ffttest[(int)x];
            }
            return DataFrame.this.test[(int)x];
        }

        public void paintComponent(Graphics g) {
            this.setBackground(Color.white);
            super.paintComponent(g);
            Line2D.Double line = null;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.gray);
            Line2D.Double lCoordX = new Line2D.Double(0.0, this.getSize().height / 2, this.getSize().width, this.getSize().height / 2);
            Line2D.Double lCoordY = new Line2D.Double(6.0, 0.0, 6.0, this.getSize().width);
            g2.draw(lCoordX);
            g2.draw(lCoordY);
            int xr = 50;
            for (int i = 10; i < this.getSize().width - 15; i += 10) {
                g2.drawLine(i, this.getSize().height / 2 - 2, i, this.getSize().height / 2 + 2);
                xr += 50;
            }
            int xl = -50;
            for (int i = -10; i > -this.getSize().width + 15; i -= 10) {
                g2.drawLine(i, this.getSize().height / 2 - 2, i, this.getSize().height / 2 + 2);
                xl -= 50;
            }
            int yu = -50;
            for (int i = -10; i > -this.getSize().height + 15; i -= 10) {
                g2.drawLine(4, i, 8, i);
                yu -= 50;
            }
            int yd = 50;
            for (int i = 10; i < this.getSize().height + 15; i += 10) {
                g2.drawLine(4, i, 8, i);
                yd += 50;
            }
            if (DataFrame.this.test != null && DataFrame.this.current >= 0) {
                g2.drawString("0", 20, this.getSize().height / 2 + 15);
                g2.drawString(Integer.toString(DataFrame.this.test.length), this.getSize().width - 25, this.getSize().height / 2 + 15);
                int elems = DataFrame.this.data.size();
                for (int e = 0; e < elems; ++e) {
                    if (this.fft) {
                        DataFrame.this.test = (double[])DataFrame.this.data.get(e);
                        DataFrame.this.ffttest = new double[DataFrame.this.test.length];
                        for (int i = 0; i < DataFrame.this.s; ++i) {
                            DataFrame.this.ffttest[i] = DataFrame.this.test[i];
                        }
                        DataFrame.this.getFFT(DataFrame.this.ffttest, DataFrame.this.choice);
                    } else {
                        DataFrame.this.test = (double[])DataFrame.this.data.get(e);
                    }
                    g2.setPaint(DataFrame.this.myColors[e + 1]);
                    for (int x = 0; x < DataFrame.this.s - 1; ++x) {
                        this.y = this.getSize().height / 2;
                        if (this.fft) {
                            this.normalizeData(DataFrame.this.ffttest, this.y - 6);
                        } else {
                            this.normalizeData(DataFrame.this.test, this.y - 6);
                        }
                        double scale = this.getSize().width / DataFrame.this.s;
                        double r = (double)(this.getSize().width / DataFrame.this.s) * DataFrame.this.zoom;
                        line = new Line2D.Double((double)x * r + 6.0, this.y - (int)this.f(x), (double)x * r + r + 6.0, this.y - (int)this.f(x + 1));
                        g2.draw(line);
                    }
                }
                DataFrame.this.test = (double[])DataFrame.this.data.get(DataFrame.this.current);
            }
            g2.setPaint(Color.black);
            if (this.fft) {
                g2.drawString("FFT", 20, 15);
            }
        }
    }

    class ArraysComboBox
    extends JComboBox {
        double[] temp;

        ArraysComboBox() {
        }

        public void ArraysComboBox() {
        }

        public void update() {
            try {
                this.removeAllItems();
                int elems = DataFrame.this.data.size();
                for (int e = 0; e < elems; ++e) {
                    this.addItem("data" + e);
                }
                DataFrame.this.current = DataFrame.this.data.indexOf(DataFrame.this.data.lastElement());
                this.setSelectedIndex(DataFrame.this.current);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }
}

