/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import myctapp.CTPhantom;
import myctapp.PhantomElement;

class DrawPanel
extends JPanel {
    private int x;
    private int y;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int houns;
    public CTPhantom phantom;
    private PhantomElement currshape;
    private boolean elementadded = false;
    private Ellipse2D FOV;

    public void setupPanel(String path) {
        this.setPreferredSize(new Dimension(512, 512));
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.phantom = new CTPhantom();
        if (path != null) {
            this.loadPhant(path);
        }
        this.houns = 0;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                DrawPanel.this.x1 = event.getX();
                DrawPanel.this.y1 = event.getY();
                DrawPanel.this.repaint();
            }

            public void mouseReleased(MouseEvent event) {
                DrawPanel.this.x2 = event.getX();
                DrawPanel.this.y2 = event.getY();
                String s = JOptionPane.showInputDialog(null, "Enter a greyscale value: (0-255)", "Customized Dialog", -1);
                double d = Double.parseDouble(s);
                int px = DrawPanel.this.x1;
                int py = DrawPanel.this.y1;
                int alpha = 0;
                if (DrawPanel.this.x1 > DrawPanel.this.x2) {
                    px = DrawPanel.this.x2;
                }
                if (DrawPanel.this.y1 > DrawPanel.this.y2) {
                    py = DrawPanel.this.y2;
                }
                DrawPanel.this.phantom.addElement("ellipse", Math.abs(DrawPanel.this.x1 - DrawPanel.this.x2), Math.abs(DrawPanel.this.y1 - DrawPanel.this.y2), d, px, py, alpha);
                DrawPanel.this.elementadded = true;
                DrawPanel.this.x1 = (DrawPanel.this.x2 = (DrawPanel.this.y1 = (DrawPanel.this.y2 = 0)));
                DrawPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent event) {
                DrawPanel.this.x = event.getX();
                DrawPanel.this.y = event.getY();
                DrawPanel.this.phantom.pinfoArea.setPanelCoords(DrawPanel.this.x, DrawPanel.this.y);
                DrawPanel.this.repaint();
            }

            public void mouseDragged(MouseEvent event) {
                DrawPanel.this.x2 = event.getX();
                DrawPanel.this.y2 = event.getY();
                DrawPanel.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AlphaComposite ac = AlphaComposite.getInstance(3);
        g2.setComposite(ac);
        this.FOV = new Ellipse2D.Float(0.0f, 0.0f, 512.0f, 512.0f);
        g2.setClip(this.FOV);
        g2.setColor(Color.black);
        g2.fill(this.FOV);
        if (this.elementadded) {
            int size = this.phantom.elements.size();
            for (int i = 0; i < size; ++i) {
                try {
                    this.currshape = this.phantom.getCurrentElement(i);
                    int d = (int)this.currshape.rho;
                    g2.setColor(new Color(d, d, d));
                    g2.fill(new Ellipse2D.Double(this.currshape.x, this.currshape.y, this.currshape.A, this.currshape.B));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("NO ELEMENTS TO DISPLAY");
                }
            }
        }
        g2.setStroke(new BasicStroke(1.0f));
        Color shade = new Color(55, 55, 235);
        g2.setColor(shade);
        g2.fill(new Ellipse2D.Double(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2)));
    }

    public DrawPanel() {
        this.setupPanel(null);
    }

    public DrawPanel(String path) {
        this.setupPanel(path);
    }

    public void savePhant(String path) {
        this.phantom.savePhantom(path);
    }

    public void loadPhant(String path) {
        this.phantom.loadPhantom(path);
        this.elementadded = true;
        this.repaint();
    }

    public void savePhantomAsImage(String path) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            BufferedImage mBufferedImage = DrawPanel.createComponentImage(this);
            ImageIO.write((RenderedImage)mBufferedImage, "png", out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static BufferedImage createComponentImage(Component component) {
        BufferedImage image = (BufferedImage)component.createImage(component.getWidth(), component.getHeight());
        Graphics graphics = image.getGraphics();
        if (graphics != null) {
            component.paintAll(graphics);
            component.update(graphics);
        }
        return image;
    }
}

