/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import myctapp.CTScanner;
import myctapp.Filters;
import myctapp.GraphicsFrame;
import myctapp.Utils;

class FilterGraphPanel
extends JPanel {
    int showfft;
    static int y;
    boolean nocheck = false;
    static int s;
    static double[] test;
    static double[] ffttest;
    static double[] ramlak;
    static double[] shepplogan;
    static double[] hamming;
    static double[] hann;
    static double[] cosine;
    static double[] blackman;

    FilterGraphPanel() {
    }

    public void FilterGraphPanel() {
    }

    public static void makeData(CTScanner scanner) {
        y = 100;
        s = scanner.scans;
        test = new double[s];
        for (int i = 0; i < s; ++i) {
            FilterGraphPanel.test[i] = scanner.projection[45][i];
        }
        FilterGraphPanel.normalizeData(test, y);
    }

    public static void makefilterData(CTScanner scanner) {
        y = 100;
        s = scanner.scans;
        test = new double[s];
        double c = scanner.filtercutoff;
        ramlak = Filters.filter1("ramp", s, c);
        shepplogan = Filters.filter1("shepplogan", s, c);
        hamming = Filters.filter1("hamming", s, c);
        hann = Filters.filter1("hann", s, c);
        cosine = Filters.filter1("cosine", s, c);
        blackman = Filters.filter1("blackman", s, c);
        for (int i = 0; i < s; ++i) {
            double freq = 1 / s;
            double pi = Math.PI;
            FilterGraphPanel.test[i] = Math.cos(2.0 * pi * (double)i * 0.1);
        }
        FilterGraphPanel.normalizeData(test, y);
        FilterGraphPanel.normalizeData(ramlak, y);
        FilterGraphPanel.normalizeData(shepplogan, y);
        FilterGraphPanel.normalizeData(hamming, y);
        FilterGraphPanel.normalizeData(hann, y);
        FilterGraphPanel.normalizeData(cosine, y);
        FilterGraphPanel.normalizeData(blackman, y);
    }

    public static void normalizeData(double[] data, int y) {
        double min = Utils.getMin(data);
        double max = Utils.getMax(data);
        for (int i = 0; i < s; ++i) {
            if (!(max > min)) continue;
            data[i] = data[i] * (double)y / (max - min);
        }
    }

    double fSqrt(double x) {
        return -Math.sqrt(x);
    }

    double fTanX(double x) {
        return -Math.tan(0.01 * x) * (double)this.getSize().height / 2.0;
    }

    double f(double x) {
        if (this.nocheck) {
            return GraphicsFrame.a * test[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("test")) {
            GraphicsFrame.lblNameFunc.setText("test");
            return GraphicsFrame.a * test[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("ramlak")) {
            GraphicsFrame.lblNameFunc.setText("ramlak");
            return GraphicsFrame.a * ramlak[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("shepp-logan")) {
            GraphicsFrame.lblNameFunc.setText("shepp-logan");
            return GraphicsFrame.a * shepplogan[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("hamming")) {
            GraphicsFrame.lblNameFunc.setText("hamming");
            return GraphicsFrame.a * hamming[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("hann")) {
            GraphicsFrame.lblNameFunc.setText("hann");
            return GraphicsFrame.a * hann[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("cosine")) {
            GraphicsFrame.lblNameFunc.setText("cosine");
            return GraphicsFrame.a * cosine[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("blackman")) {
            GraphicsFrame.lblNameFunc.setText("blackman");
            return GraphicsFrame.a * blackman[(int)x];
        }
        return GraphicsFrame.a * test[(int)x];
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Line2D.Double line = null;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.gray);
        Line2D.Double lCoordX = new Line2D.Double(0.0, this.getSize().height / 2, this.getSize().width, this.getSize().height / 2);
        Line2D.Double lCoordY = new Line2D.Double(this.getSize().width / 2, 0.0, this.getSize().width / 2, this.getSize().width);
        g2.draw(lCoordX);
        g2.draw(lCoordY);
        g2.drawString("0", this.getSize().width / 2 - 10, this.getSize().height / 2 + 15);
        g2.translate(this.getSize().width / 2, this.getSize().height / 2);
        int xr = 50;
        for (int i = 10; i < this.getSize().width - 15; i += 10) {
            g2.drawLine(i, -2, i, 2);
            xr += 50;
        }
        int xl = -50;
        for (int i = -10; i > -this.getSize().width + 15; i -= 10) {
            g2.drawLine(i, -2, i, 2);
            xl -= 50;
        }
        int yu = -50;
        for (int i = -10; i > -this.getSize().height + 15; i -= 10) {
            g2.drawLine(-2, i, 2, i);
            yu -= 50;
        }
        int yd = 50;
        for (int i = 10; i < this.getSize().height + 15; i += 10) {
            g2.drawLine(-2, i, 2, i);
            yd += 50;
        }
        for (int x = -s / 2; x < s / 2 - 1; ++x) {
            g2.setPaint(Color.red);
            line = new Line2D.Double(x * 2, -((int)this.f(x + s / 2)), x * 2 + 1, -((int)this.f(x + s / 2 + 1)));
            g2.draw(line);
        }
    }
}

