/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import myctapp.Utils;

public class Filters {
    public static double[] filter1(String filtname, int scans, double cutoff) {
        int i = 0;
        int Width = scans / 2;
        double tau = (double)Width * cutoff;
        double[] filter = new double[scans];
        double PI = Math.PI;
        filter[0] = 0.0;
        if (filtname == "ramp") {
            for (i = 1; i <= Width; ++i) {
                filter[scans - i] = filter[i] = PI * (double)i;
            }
        } else if (filtname == "shepplogan") {
            for (i = 1; i <= Width; ++i) {
                filter[scans - i] = filter[i] = PI * (double)i * (Math.sin(PI * (double)i / (double)Width / 2.0) / (PI * (double)i / (double)Width / 2.0));
            }
        } else if (filtname == "hamming") {
            for (i = 1; i <= Width; ++i) {
                if ((double)i <= tau) {
                    filter[scans - i] = filter[i] = PI * (double)i * (0.54 + 0.46 * Math.cos(PI * (double)i / tau));
                    continue;
                }
                filter[i] = 0.0;
                filter[scans - i] = 0.0;
            }
        } else if (filtname == "hann") {
            for (i = 1; i <= Width; ++i) {
                if ((double)i <= tau) {
                    filter[scans - i] = filter[i] = PI * (double)i * (1.0 + Math.cos(PI * (double)i / tau));
                    continue;
                }
                filter[i] = 0.0;
                filter[scans - i] = 0.0;
            }
        } else if (filtname == "cosine") {
            for (i = 1; i <= Width; ++i) {
                if ((double)i <= tau) {
                    filter[scans - i] = filter[i] = PI * (double)i * Math.cos(PI * (double)i / tau / 2.0);
                    continue;
                }
                filter[i] = 0.0;
                filter[scans - i] = 0.0;
            }
        } else if (filtname == "blackman") {
            for (i = 1; i <= Width; ++i) {
                if ((double)i <= tau) {
                    filter[scans - i] = filter[i] = PI * (double)i * (0.42 + 0.5 * Math.cos(PI * (double)i / tau - 1.0) + 0.08 * Math.cos(2.0 * PI * (double)i / tau - 1.0));
                    continue;
                }
                filter[i] = 0.0;
                filter[scans - i] = 0.0;
            }
        }
        Filters.setRange1DArray(filter, 0, 1);
        return filter;
    }

    public static double[] ramlak(int width) {
        int n = -(width - 1) / 2;
        double[] filter = new double[width];
        for (int tap = 1; tap < width; ++tap) {
            filter[tap] = n == 0 ? 78.53981633974483 : (n % 2 == 1 || n % 2 == -1 ? -1.0 / (Math.PI * (double)n * (double)n) * 100.0 : 0.0);
            ++n;
        }
        System.out.println();
        Filters.normalizeData(filter, 1);
        double[] idata = new double[width];
        Filters.FFT(1, width, filter, idata);
        return filter;
    }

    public static double[] shepplogan(int width) {
        int n = 0;
        double[] filter = new double[width];
        n = -(width - 1) / 2;
        for (int tap = 1; tap < width; ++tap) {
            filter[tap] = -2.0 / (Math.PI * (double)(4 * n * n - 1)) * 100.0;
            ++n;
        }
        System.out.println();
        return filter;
    }

    public static double[] convolve(double[] data, int dataLen, double[] operator, int operatorLen) {
        double[] output = new double[dataLen];
        for (int i = 0; i < dataLen - operatorLen; ++i) {
            output[i] = 0.0;
            for (int j = operatorLen - 1; j >= 0; --j) {
                int n = i;
                output[n] = output[n] + data[i + j] * operator[j];
            }
        }
        return output;
    }

    public static double[] convolve(double[] x, double[] h, int delay) {
        int min = Math.min(x.length, h.length) - 1;
        double[] y = new double[x.length + h.length - 1];
        for (int i = 0; i < y.length; ++i) {
            y[i] = 0.0;
            for (int k = 0; k <= min; ++k) {
                if (i - k + delay >= x.length || i - k + delay < 0) continue;
                int n = i;
                y[n] = y[n] + h[k] * x[i - k + delay];
            }
        }
        return y;
    }

    public static double[] dft(double[] data, double[] idata, int dataLen) {
        double[] spectrum = new double[dataLen];
        double delF = 1.0 / (double)dataLen;
        for (int i = 0; i < dataLen; ++i) {
            double freq = (double)i * delF;
            double real = 0.0;
            double imag = 0.0;
            for (int j = 0; j < dataLen; ++j) {
                real += data[j] * Math.cos(Math.PI * 2 * freq * (double)j);
                imag += data[j] * Math.sin(Math.PI * 2 * freq * (double)j);
            }
            spectrum[i] = Math.sqrt(real * real + imag * imag);
            idata[i] = -imag;
        }
        return spectrum;
    }

    public static double[] idft(double[] data, double[] idata, int dataLen) {
        int i;
        double[] spectrum = new double[dataLen];
        for (i = 0; i < dataLen; ++i) {
            idata[i] = -idata[i];
        }
        spectrum = Filters.dft(data, idata, dataLen);
        i = 0;
        while (i < dataLen) {
            idata[i] = -idata[i];
            int n = i++;
            spectrum[n] = spectrum[n] / (double)dataLen;
        }
        return spectrum;
    }

    public static void FFT(int dir, int s, double[] x, double[] y) {
        int i;
        int m = (int)(Math.log(s) / Math.log(2.0));
        double[] spectrum = new double[s];
        int n = 1;
        for (i = 0; i < m; ++i) {
            n *= 2;
        }
        int i2 = n >> 1;
        int j = 0;
        for (i = 0; i < n - 1; ++i) {
            int k;
            if (i < j) {
                double tx = x[i];
                double ty = y[i];
                x[i] = x[j];
                y[i] = y[j];
                x[j] = tx;
                y[j] = ty;
            }
            for (k = i2; k <= j; j -= k, k >>= 1) {
            }
            j += k;
        }
        double c1 = -1.0;
        double c2 = 0.0;
        int l2 = 1;
        for (int l = 0; l < m; ++l) {
            int l1 = l2;
            l2 <<= 1;
            double u1 = 1.0;
            double u2 = 0.0;
            for (j = 0; j < l1; ++j) {
                for (i = j; i < n; i += l2) {
                    int i1 = i + l1;
                    double t1 = u1 * x[i1] - u2 * y[i1];
                    double t2 = u1 * y[i1] + u2 * x[i1];
                    x[i1] = x[i] - t1;
                    y[i1] = y[i] - t2;
                    int n2 = i;
                    x[n2] = x[n2] + t1;
                    int n3 = i;
                    y[n3] = y[n3] + t2;
                }
                double z = u1 * c1 - u2 * c2;
                u2 = u1 * c2 + u2 * c1;
                u1 = z;
            }
            c2 = Math.sqrt((1.0 - c1) / 2.0);
            if (dir == 1) {
                c2 = -c2;
            }
            c1 = Math.sqrt((1.0 + c1) / 2.0);
        }
        if (dir == 1) {
            i = 0;
            while (i < n) {
                int n4 = i;
                x[n4] = x[n4] / (double)n;
                int n5 = i++;
                y[n5] = y[n5] / (double)n;
            }
        }
    }

    public static void normalizeData(double[] data, int y) {
        double min = Utils.getMin(data);
        double max = Utils.getMax(data);
        int s = data.length;
        for (int i = 0; i < s; ++i) {
            if (!(max > min)) continue;
            data[i] = data[i] * (double)y / (max - min);
        }
    }

    public static double[] setRange1DArray(double[] data, int min, int max) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[i] > (double)max ? (double)max : (data[i] < (double)min ? (double)min : data[i]);
        }
        return result;
    }

    public static void main(String[] args) {
        int n = 128;
        int m = 128;
        double[] testdata = new double[n];
        double[] ftestdata = new double[n * 2];
        double[] temp = new double[n * 2];
        double[] filt1 = Filters.filter1("ramp", n, 1.0);
        double[] filt2 = Filters.shepplogan(n);
        int i = 0;
        for (i = 0; i < n; ++i) {
            testdata[i] = Math.cos((double)i * Math.PI / 180.0);
        }
        System.out.println();
        for (i = 0; i < n; ++i) {
            System.out.print(filt1[i] + ",");
        }
        System.out.println();
    }
}

