/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import myctapp.CTScanner;
import myctapp.Filters;
import myctapp.GraphicsFrame;
import myctapp.Utils;

class GraphPanel
extends JPanel {
    int c = 1;
    int y;
    double[][] proj;
    double[][] fproj;
    int s;
    int v;
    int a1;
    int a2;
    double cutoff;
    double truncwidth;
    boolean trunc;
    float step;
    double[] projdata;
    double[] fprojdata;
    String filtname;
    boolean showinfo;

    GraphPanel() {
        this.y = this.getSize().height;
        this.showinfo = false;
    }

    public void GraphPanel() {
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(300, 200));
        this.setMaximumSize(new Dimension(600, 450));
    }

    public void setData(CTScanner scanner, int choice) {
        this.c = choice;
        this.s = scanner.scans;
        this.v = scanner.views;
        this.a1 = scanner.ang1;
        this.a2 = scanner.ang2;
        this.step = scanner.stepsize;
        this.cutoff = scanner.filtercutoff;
        this.filtname = scanner.filtername;
        this.trunc = scanner.truncate;
        this.truncwidth = scanner.truncatewidth;
        if (this.c == 1) {
            this.proj = scanner.projection;
            this.projdata = new double[this.s];
        } else if (this.c == 2) {
            this.fproj = scanner.fprojection;
            this.fprojdata = new double[this.s];
        }
    }

    public void update(int v) {
        this.y = 70;
        float phi = 0.0f;
        int j = v;
        try {
            Thread.sleep(40L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (int i = 0; i < this.s; ++i) {
            if (this.c == 1) {
                this.projdata[i] = this.proj[j][i];
                continue;
            }
            if (this.c != 2) continue;
            this.fprojdata[i] = this.fproj[j][i];
        }
        System.out.println();
        if (this.c == 1) {
            this.normalizeData(this.projdata, this.y);
        } else if (this.c == 2) {
            this.normalizeData(this.fprojdata, this.y);
        }
        this.repaint();
    }

    public void normalizeData(double[] data, int y) {
        double min = Utils.getMin(data);
        double max = Utils.getMax(data);
        for (int i = 0; i < this.s; ++i) {
            if (!(max > min)) continue;
            data[i] = data[i] * (double)y / (max - min);
        }
    }

    double f(double x) {
        double[] idata = new double[this.s];
        for (int i = 0; i < this.s; ++i) {
            idata[i] = 0.0;
        }
        if (this.c == 1) {
            if (GraphicsFrame.cmbFunc.getSelectedItem().equals("freq")) {
                Filters.FFT(1, this.s, this.projdata, idata);
                Utils.normalize1DArray(this.projdata, 0.0, 1.0);
            }
            return GraphicsFrame.a * this.projdata[(int)x];
        }
        if (GraphicsFrame.cmbFunc.getSelectedItem().equals("freq")) {
            Filters.FFT(1, this.s, this.fprojdata, idata);
            Utils.normalize1DArray(this.fprojdata, 0.0, 1.0);
        }
        return GraphicsFrame.a * this.fprojdata[(int)x];
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Line2D.Double line = null;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.gray);
        Line2D.Double lCoordX = this.c == 1 ? new Line2D.Double(0.0, this.getSize().height - 5, this.getSize().width, this.getSize().height - 5) : new Line2D.Double(0.0, this.getSize().height / 2, this.getSize().width, this.getSize().height / 2);
        Line2D.Double lCoordY = new Line2D.Double(this.getSize().width / 2, 0.0, this.getSize().width / 2, this.getSize().width);
        g2.draw(lCoordX);
        g2.draw(lCoordY);
        if (this.showinfo) {
            if (this.c == 1) {
                g2.drawString("UNFILTERED", this.getSize().width / 2 - 160, this.getSize().height - 15);
                if (this.trunc) {
                    g2.drawString("truncated at", this.getSize().width / 2 + 140, this.getSize().height - 25);
                    g2.drawString(Double.toString(this.truncwidth), this.getSize().width / 2 + 140, this.getSize().height - 15);
                }
            } else {
                g2.drawString("FILTERED", this.getSize().width / 2 - 160, this.getSize().height - 15);
                g2.drawString(this.filtname, this.getSize().width / 2 + 140, this.getSize().height - 15);
                g2.drawString("cutoff: " + this.cutoff, this.getSize().width / 2 + 140, this.getSize().height - 25);
            }
        }
        if (this.c == 1) {
            g2.translate(this.getSize().width / 2, this.getSize().height - 15);
        } else {
            g2.translate(this.getSize().width / 2, this.getSize().height / 2);
        }
        for (int x = -this.s / 2; x < this.s / 2 - 1; ++x) {
            g2.setPaint(Color.black);
            line = new Line2D.Double((double)(x * 2) * GraphicsFrame.b, -((int)this.f(x + this.s / 2)), (double)(x * 2) * GraphicsFrame.b + 2.0 * GraphicsFrame.b, -((int)this.f(x + this.s / 2 + 1)));
            g2.draw(line);
        }
    }
}

