/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import myctapp.CTScanner;
import myctapp.FilterGraphPanel;
import myctapp.GraphPanel;
import myctapp.ImagePanel;

class GraphicsFrame
extends JInternalFrame {
    public static String sFunction;
    public static JComboBox cmbFunc;
    public static JLabel lblNameFunc;
    public static JTextField txtInputY;
    public static JTextField txtInputX;
    public static JLabel lblFunc;
    public static JTextField txtInputRight;
    public JLabel lblZero;
    public JLabel lblScans;
    public JLabel lblViews;
    public JLabel lblcurrview;
    public static JButton btnBuildFunc;
    public static JButton replotFunc;
    public static double a;
    public static double b;
    public int v = 0;
    public double[] filter;

    public GraphicsFrame(CTScanner scanner, int choice) {
        this.setSize(500, 500);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setMaximizable(true);
        this.setClosable(true);
        this.setVisible(true);
        if (choice == 0) {
            this.setTitle("Visualise Projections");
            this.createBProjGraphs(scanner);
        } else if (choice == 1) {
            this.setTitle("Filter Graph");
            this.createFilterGraphs(scanner);
        }
    }

    void createBProjGraphs(CTScanner scanner) {
        BufferedImage img;
        Font theMainFont = new Font("SansSerif", 0, 11);
        UIManager.put("Button.font", theMainFont);
        UIManager.put("Label.font", theMainFont);
        UIManager.put("ComboBox.font", theMainFont);
        JPanel pTB = new JPanel();
        pTB.setLayout(new BoxLayout(pTB, 0));
        ImagePanel bpPanel1 = new ImagePanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawString("PREVIEW", 10, 10);
            }
        };
        bpPanel1.setBackground(Color.black);
        int tmp = scanner.outputimgsize;
        scanner.outputimgsize = 40;
        if (scanner.animate) {
            scanner.animate = false;
            img = scanner.CreateReconstructedImage();
            scanner.animate = true;
        } else {
            img = scanner.CreateReconstructedImage();
        }
        scanner.outputimgsize = tmp;
        bpPanel1.loadBufferedImage(img);
        final GraphPanel bpPanel2 = new GraphPanel();
        bpPanel2.setBackground(Color.white);
        final GraphPanel bpPanel3 = new GraphPanel();
        bpPanel3.setBackground(Color.white);
        final ImagePanel sinogrampanel = new ImagePanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawString("SINOGRAM", 10, 10);
            }
        };
        sinogrampanel.setBackground(Color.black);
        sinogrampanel.loadSinogram(scanner);
        bpPanel2.setData(scanner, 1);
        bpPanel3.setData(scanner, 2);
        pTB.add(bpPanel1);
        pTB.add(Box.createRigidArea(new Dimension(6, 0)));
        pTB.add(sinogrampanel);
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.add(pTB);
        main.add(Box.createRigidArea(new Dimension(0, 6)));
        main.add(bpPanel2);
        main.add(Box.createRigidArea(new Dimension(0, 6)));
        main.add(bpPanel3);
        this.lblScans = new JLabel("Scans: " + scanner.scans);
        this.lblViews = new JLabel("Views: " + scanner.views);
        final double step = scanner.stepsize;
        this.v = 0;
        this.lblcurrview = new JLabel("\u0398=" + (double)this.v * step);
        JPanel widgetsPanel = new JPanel();
        widgetsPanel.setMaximumSize(new Dimension(350, 30));
        btnBuildFunc = new JButton("Next");
        bpPanel2.update(this.v);
        bpPanel3.update(this.v);
        btnBuildFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphicsFrame.this.v = GraphicsFrame.this.v >= 180 ? 0 : ++GraphicsFrame.this.v;
                bpPanel2.update(GraphicsFrame.this.v);
                bpPanel3.update(GraphicsFrame.this.v);
                Graphics2D gs = (Graphics2D)sinogrampanel.getGraphics();
                gs.setColor(Color.blue);
                gs.drawLine(0, GraphicsFrame.this.v, sinogrampanel.getWidth(), GraphicsFrame.this.v);
                DecimalFormat df1 = new DecimalFormat("##.00");
                GraphicsFrame.this.lblcurrview.setText("\u0398=" + df1.format((double)GraphicsFrame.this.v * step));
                GraphicsFrame.this.repaint();
            }
        });
        cmbFunc = new JComboBox();
        cmbFunc.addItem("spatial");
        cmbFunc.addItem("freq");
        cmbFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphicsFrame.this.repaint();
            }
        });
        JLabel lblXMag = new JLabel("  X Mag:");
        txtInputX = new JTextField("1", 2);
        widgetsPanel.add(lblXMag);
        widgetsPanel.add(txtInputX);
        JLabel lblYMag = new JLabel("  Y Mag:");
        txtInputY = new JTextField("1", 2);
        widgetsPanel.add(lblYMag);
        widgetsPanel.add(txtInputY);
        replotFunc = new JButton("Replot");
        replotFunc.setMaximumSize(new Dimension(100, 25));
        replotFunc.setSize(new Dimension(100, 25));
        replotFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                a = Double.parseDouble(txtInputY.getText());
                b = Double.parseDouble(txtInputX.getText());
                GraphicsFrame.this.repaint();
            }
        });
        widgetsPanel.add(replotFunc);
        widgetsPanel.add(cmbFunc);
        widgetsPanel.add(btnBuildFunc);
        widgetsPanel.add(this.lblScans);
        widgetsPanel.add(this.lblViews);
        widgetsPanel.add(this.lblcurrview);
        main.add(widgetsPanel);
        Container contentPane = this.getContentPane();
        contentPane.add(main);
    }

    void createFilterGraphs(CTScanner scanner) {
        sFunction = new String("filter");
        cmbFunc = new JComboBox();
        cmbFunc.addItem("test");
        cmbFunc.addItem("ramlak");
        cmbFunc.addItem("shepp-logan");
        cmbFunc.addItem("hamming");
        cmbFunc.addItem("hann");
        cmbFunc.addItem("cosine");
        cmbFunc.addItem("blackman");
        cmbFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GraphicsFrame.this.repaint();
            }
        });
        lblNameFunc = new JLabel(" ");
        JLabel lblYMag = new JLabel("  Y Mag:");
        txtInputY = new JTextField("1", 5);
        btnBuildFunc = new JButton("Replot");
        btnBuildFunc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                a = Double.parseDouble(txtInputY.getText());
                GraphicsFrame.this.repaint();
            }
        });
        FilterGraphPanel imgPanel = new FilterGraphPanel();
        imgPanel.setBackground(Color.black);
        imgPanel.showfft = 0;
        FilterGraphPanel imgPanel2 = new FilterGraphPanel();
        imgPanel2.setBackground(Color.black);
        FilterGraphPanel.makefilterData(scanner);
        imgPanel2.showfft = 1;
        JPanel pTB = new JPanel();
        pTB.setLayout(new BoxLayout(pTB, 1));
        cmbFunc.setMaximumSize(new Dimension(120, 25));
        pTB.add(cmbFunc);
        pTB.add(imgPanel);
        pTB.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel widgetsPanel = new JPanel();
        widgetsPanel.add(lblNameFunc);
        widgetsPanel.add(lblYMag);
        widgetsPanel.setMaximumSize(new Dimension(300, 30));
        widgetsPanel.add(txtInputY);
        widgetsPanel.add(btnBuildFunc);
        pTB.add(widgetsPanel);
        Container contentPane = this.getContentPane();
        contentPane.add(pTB);
    }

    static {
        a = 1.0;
        b = 1.0;
    }
}

