/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import myctapp.ImageUtils;

public class Histogram {
    private BufferedImage image;
    public HPanel histpanel;

    public Histogram(BufferedImage image) {
        this.setImage(image);
        this.histpanel = new HPanel();
    }

    public Histogram(int[][] data) {
        BufferedImage image = ImageUtils.CreateImagefromIntArray(data);
        this.setImage(image);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public int[][] getPixels(BufferedImage image) {
        int[][] pixels;
        block5: {
            int ih;
            int iw;
            block4: {
                iw = image.getWidth(null);
                ih = image.getHeight(null);
                pixels = new int[iw][ih];
                if (image.getType() != 10) break block4;
                DataBufferByte db = (DataBufferByte)image.getRaster().getDataBuffer();
                byte[] pixelarray = db.getData();
                for (int x = 0; x < iw; ++x) {
                    for (int y = 0; y < ih; ++y) {
                        pixels[x][y] = pixelarray[x + y * iw] & 0xFF;
                    }
                }
                break block5;
            }
            if (image.getType() != 11) break block5;
            DataBufferUShort db = (DataBufferUShort)image.getRaster().getDataBuffer();
            short[] pixelarray = db.getData();
            for (int x = 0; x < iw; ++x) {
                for (int y = 0; y < ih; ++y) {
                    pixels[x][y] = pixelarray[x + y * iw] & 0xFFFF;
                }
            }
        }
        return pixels;
    }

    public int[] getHistogram() {
        int iw = this.image.getWidth(null);
        int ih = this.image.getHeight(null);
        int[] histogram = this.image.getType() == 10 ? new int[256] : new int[2001];
        int[][] pixels = this.getPixels(this.image);
        for (int x = 0; x < pixels.length; ++x) {
            for (int y = 0; y < pixels[0].length; ++y) {
                int n = pixels[x][y];
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public double[] getNormHistogram() {
        double[] normHistogram;
        int[] histogram = this.getHistogram();
        int sum = this.image.getHeight() * this.image.getWidth();
        if (this.image.getType() == 10) {
            normHistogram = new double[256];
            for (int n = 0; n < 256; ++n) {
                normHistogram[n] = (double)histogram[n] / (double)sum;
            }
        } else {
            normHistogram = new double[2001];
            for (int n = 0; n < 2000; ++n) {
                normHistogram[n] = (double)histogram[n] / (double)sum;
            }
        }
        return normHistogram;
    }

    public void draw(Graphics g, int x, int y, int height, int space) {
    }

    public BufferedImage makeHistEqualizedImg() {
        int v;
        int[] sum;
        double[] normHistogram = this.getNormHistogram();
        int[][] data = this.getPixels(this.image);
        double s = 0.0;
        if (this.image.getType() == 11) {
            sum = new int[2001];
            for (v = 0; v < 2000; ++v) {
                sum[v] = (int)((s += normHistogram[v]) * 255.0 + 0.5);
            }
        } else {
            sum = new int[256];
            for (v = 0; v < 256; ++v) {
                sum[v] = (int)((s += normHistogram[v]) * 255.0 + 0.5);
            }
        }
        int[][] data2 = data;
        for (int x = 0; x < data.length; ++x) {
            for (int y = 0; y < data[0].length; ++y) {
                data2[x][y] = sum[data[x][y]];
            }
        }
        BufferedImage image = ImageUtils.CreateImagefromIntArray(data2);
        return image;
    }

    public void equalizeHistogram() {
        this.setImage(this.makeHistEqualizedImg());
    }

    public class HPanel
    extends JPanel {
        public HPanel() {
            this.setPreferredSize(new Dimension(356, 200));
            this.setBackground(new Color(241, 244, 180));
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            double[] normHistogram = Histogram.this.getNormHistogram();
            int height = this.getHeight() * 3 / 4;
            int x = 20;
            int y = 20;
            int space = 0;
            int len = Histogram.this.image.getType() == 10 ? 255 : 2000;
            double max = 0.0;
            for (int j = 0; j < len; ++j) {
                if (!(normHistogram[j] > max)) continue;
                max = normHistogram[j];
            }
            g.setFont(new Font("SansSerif", 0, 11));
            g.drawString("" + (double)((int)(max * 100.0)) / 10.0 + "%", x, y + 7);
            g.drawLine((x += 30) - 2, y + height + 2, x - 2, y);
            g.drawLine(x - 2, y, x - 4, y);
            g.drawLine(x - 2, y + height, x + (space + 1) * 257 - 1, y + height);
            g.drawLine(x + (space + 1) * 256, y + height + 2, x + (space + 1) * 256, y + height);
            g.drawString(Integer.toString(len), x + (space + 1) * 256 - 8, y + height + 11);
            g.drawLine(x + (space + 1) * 128, y + height + 2, x + (space + 1) * 128, y + height);
            g.drawString(Integer.toString(len / 2), x + (space + 1) * 128 - 8, y + height + 11);
            Color shade = new Color(10, 10, 180);
            g.setColor(shade);
            boolean j = false;
            if (len == 255) {
                for (int i = 0; i < len; ++i) {
                    g.drawLine(x + (i + 1) * (space + 1), y + height, x + (i + 1) * (space + 1), y + (int)((double)height - normHistogram[i] / max * (double)height));
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    g.drawLine(x + (int)((double)i * 0.1275 + 1.0) * (space + 1), y + height, x + (int)((double)i * 0.1275 + 1.0) * (space + 1), y + (int)((double)height - normHistogram[i] / max * (double)height));
                }
            }
        }
    }
}

