/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;

public class ImageOps {
    public static BufferedImageOp thresholdOp(int low, int high) {
        byte[] threshold = new byte[256];
        for (int j = 0; j < 256; ++j) {
            threshold[j] = j > high ? -1 : (j < low ? 0 : (int)j);
        }
        LookupOp Op = new LookupOp(new ByteLookupTable(0, threshold), null);
        return Op;
    }

    public static ConvolveOp blurOp() {
        float ninth = 0.11111111f;
        float[] blurKernel = new float[]{ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth};
        ConvolveOp Op = new ConvolveOp(new Kernel(3, 3, blurKernel));
        return Op;
    }

    public static ConvolveOp sharpenOp() {
        float[] sharpKernel = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        ConvolveOp Op = new ConvolveOp(new Kernel(3, 3, sharpKernel), 1, null);
        return Op;
    }

    public static ConvolveOp edgeOp() {
        float[] edgeKernel = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        ConvolveOp Op = new ConvolveOp(new Kernel(3, 3, edgeKernel));
        return Op;
    }

    public static BufferedImageOp invertOp() {
        byte[] invert = new byte[256];
        for (int i = 0; i < 256; ++i) {
            invert[i] = (byte)(255 - i);
        }
        LookupOp Op = new LookupOp(new ByteLookupTable(0, invert), null);
        return Op;
    }

    public static BufferedImageOp rescaleOp(float scaleFactor) {
        RescaleOp Op = new RescaleOp(scaleFactor, 0.0f, null);
        return Op;
    }

    public static BufferedImageOp colorconvertOp() {
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp Op = new ColorConvertOp(cs, null);
        return Op;
    }

    public static BufferedImageOp zoomOp(double multiple) {
        AffineTransformOp Op = new AffineTransformOp(AffineTransform.getScaleInstance(multiple, multiple), 2);
        return Op;
    }
}

