/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import myctapp.BufferedImageCreator;
import myctapp.CTScanner;
import myctapp.Histogram;
import myctapp.ImageUtils;
import myctapp.InfoPanel;
import myctapp.MyFFT;
import myctapp.SwingWorker;
import myctapp.Utils;

public class ImagePanel
extends JPanel {
    private int x;
    private int y;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private Point p1;
    private Point p2;
    private double imageratio;
    private double panelratio;
    private double magnification = 1.0;
    public static String selectiontype;
    public ProgressPanel bpprogresspanel;
    public static InfoPanel imageinfopanel;
    public BufferedImage mBufferedImage;
    public BufferedImage windowedImage;
    public ImagePlus ijimage;
    public Object[] imgstack;
    Object[] datastack;
    public int stacksize;
    public int[][] pixels;
    public int lowerwinlvl;
    public int upperwinlvl;
    public boolean windowing;
    public boolean closed;
    public boolean finished;
    public boolean displayroicircle = false;
    public static final int ONE_SECOND = 1000;
    long dt = 0L;
    long startTime = 0L;

    public ImagePanel() {
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.windowing = true;
        this.closed = false;
        this.lowerwinlvl = 0;
        this.upperwinlvl = 255;
        this.imageratio = 1.0;
        this.p1 = new Point(0, 0);
        this.p2 = new Point(0, 0);
        this.pixels = null;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                ImagePanel.this.x1 = event.getX();
                ImagePanel.this.y1 = event.getY();
            }

            public void mouseReleased(MouseEvent event) {
                ImagePanel.this.x2 = event.getX();
                ImagePanel.this.y2 = event.getY();
                ImagePanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent event) {
                ImagePanel.this.x = event.getX();
                ImagePanel.this.y = event.getY();
                int pxval = 0;
                double actualval = 0.0;
                Point p = new Point(0, 0);
                p = ImagePanel.this.getPixelCoords(ImagePanel.this.x, ImagePanel.this.y);
                try {
                    pxval = ImagePanel.this.getPixel(p.x, p.y);
                    if (ImagePanel.this.pixels != null) {
                        actualval = ImagePanel.this.pixels[p.x][p.y] - 1000;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    // empty catch block
                }
                imageinfopanel.updateInfo(ImagePanel.this.x, ImagePanel.this.y, p.x, p.y, pxval, actualval);
                ImagePanel.this.repaint();
            }

            public void mouseDragged(MouseEvent event) {
                ImagePanel.this.x2 = event.getX();
                ImagePanel.this.y2 = event.getY();
                ImagePanel.this.p1 = ImagePanel.this.getPixelCoords(ImagePanel.this.x1, ImagePanel.this.y1);
                ImagePanel.this.p2 = ImagePanel.this.getPixelCoords(ImagePanel.this.x2, ImagePanel.this.y2);
                imageinfopanel.updateDragInfo(((ImagePanel)ImagePanel.this).p1.x, ((ImagePanel)ImagePanel.this).p1.y, ((ImagePanel)ImagePanel.this).p2.x, ((ImagePanel)ImagePanel.this).p2.y);
                ImagePanel.this.repaint();
            }
        });
    }

    public int getImageType() {
        return this.mBufferedImage.getType();
    }

    public void setMagnification(double magnification) {
        this.magnification = magnification;
    }

    public double getMagnification() {
        return this.magnification;
    }

    public double getPixelPanelScale() {
        double scale = 1.0;
        try {
            this.panelratio = (double)this.getWidth() / (double)this.getHeight();
            scale = this.panelratio <= 1.0 ? (double)this.getWidth() / (double)this.mBufferedImage.getWidth() : (double)this.getHeight() / (double)this.mBufferedImage.getHeight();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return scale;
    }

    public Point getPixelCoords(int x, int y) {
        Point p = new Point(0, 0);
        double s = this.getPixelPanelScale();
        try {
            if (this.panelratio <= 1.0) {
                p.x = (int)((double)x / s);
                p.y = (int)((double)y / s) - ((int)Math.floor((double)this.getHeight() / s) - this.mBufferedImage.getHeight()) / 2;
            } else {
                p.y = (int)((double)y / s);
                p.x = (int)((double)x / s) - ((int)Math.floor((double)this.getWidth() / s) - this.mBufferedImage.getWidth()) / 2;
            }
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        return p;
    }

    public int getPixel(int x, int y) {
        int val = 0;
        try {
            if (this.mBufferedImage.getType() == 10) {
                DataBufferByte db = (DataBufferByte)this.mBufferedImage.getRaster().getDataBuffer();
                byte[] pixelarray = db.getData();
                val = pixelarray[x + y * this.mBufferedImage.getWidth()] & 0xFF;
            } else if (this.mBufferedImage.getType() == 11) {
                DataBufferUShort db = (DataBufferUShort)this.mBufferedImage.getRaster().getDataBuffer();
                short[] pixelarray = db.getData();
                val = pixelarray[x + y * this.mBufferedImage.getWidth()] & 0xFFFF;
            }
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        return val;
    }

    public int[][] getSelectionPixels() {
        BufferedImage subimg = this.getImageSelection();
        int iw = subimg.getWidth(null);
        int ih = subimg.getHeight(null);
        int[][] pix = new int[iw][ih];
        try {
            if (this.mBufferedImage.getType() == 10) {
                DataBufferByte db = (DataBufferByte)subimg.getRaster().getDataBuffer();
                byte[] pixelarray = db.getData();
                for (int x = 0; x < iw; ++x) {
                    for (int y = 0; y < ih; ++y) {
                        pix[x][y] = pixelarray[x + y * iw] & 0xFF;
                    }
                }
            } else if (this.mBufferedImage.getType() == 11) {
                DataBufferUShort db = (DataBufferUShort)this.mBufferedImage.getRaster().getDataBuffer();
                short[] pixelarray = db.getData();
                for (int x = 0; x < iw; ++x) {
                    for (int y = 0; y < ih; ++y) {
                        pix[x][y] = pixelarray[x + y * iw] & 0xFFFF;
                    }
                }
            }
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        return pix;
    }

    public BufferedImage getImageSelection() {
        int w = Math.abs(this.p1.x - this.p2.x);
        int h = Math.abs(this.p1.y - this.p2.y);
        BufferedImage img = this.mBufferedImage.getSubimage(Math.min(this.p1.x, this.p2.x), Math.min(this.p1.y, this.p2.y), w, h);
        BufferedImage newimg = this.mBufferedImage.getType() == 10 ? new BufferedImage(w, h, 10) : (this.mBufferedImage.getType() == 11 ? new BufferedImage(w, h, 11) : new BufferedImage(w, h, 1));
        newimg.createGraphics().drawImage((Image)img, 0, 0, null);
        return newimg;
    }

    public double[][] getSelectionData() {
        int w = Math.abs(this.p1.x - this.p2.x);
        int h = Math.abs(this.p1.y - this.p2.y);
        this.x1 = Math.min(this.p1.x, this.p2.x);
        this.y1 = Math.min(this.p1.y, this.p2.y);
        double[][] sdata = new double[w][h];
        try {
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    sdata[x][y] = this.pixels[x + this.x1][y + this.y1];
                }
            }
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        return sdata;
    }

    public void setPixelData() {
        this.setPixelData(this.mBufferedImage);
    }

    public BufferedImage setPixelData(BufferedImage img) {
        this.pixels = ImageUtils.getBuffImagePixels(img);
        this.upperwinlvl = img.getType() == 11 ? 2000 : 255;
        return img;
    }

    private void zoomImage() {
    }

    public void loadBufferedImage(BufferedImage img) {
        this.mBufferedImage = img;
        this.setPixelData();
        this.ijimage = this.createImagePlus(img);
        this.PerformWindowing();
        this.repaint();
    }

    public void loadImagePlus(ImagePlus img) {
        this.ijimage = img;
        this.mBufferedImage = BufferedImageCreator.create(img, 0);
        this.setPixelData();
        this.PerformWindowing();
        this.repaint();
    }

    public ImagePlus createImagePlus(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        ShortProcessor ip = new ShortProcessor(w, h);
        ImagePlus imp = new ImagePlus("temp", ip);
        short[] sarray = new short[w * h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                sarray[i + j * w] = (short)this.pixels[i][j];
            }
        }
        ((ImageProcessor)ip).setPixels(sarray);
        return imp;
    }

    public void saveImagePlus() {
        this.ijimage = this.createImagePlus(this.mBufferedImage);
        FileSaver fs = new FileSaver(this.ijimage);
        fs.save();
    }

    public void saveImage(String fileName) {
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            ImageTypeSpecifier imTy = param.getDestinationType();
            ImageTypeSpecifier imTySp = ImageTypeSpecifier.createFromRenderedImage(this.mBufferedImage);
            param.setDestinationType(imTySp);
            System.out.println("Found writer " + writer);
            File file = new File(fileName + ".png");
            FileImageOutputStream ios = new FileImageOutputStream(file);
            writer.setOutput(ios);
            writer.write(this.mBufferedImage);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void importIJStack(ImagePlus img) {
        int stsize = this.stacksize = img.getStackSize();
        System.out.println(stsize);
        this.imgstack = new Object[stsize];
        this.datastack = new Object[stsize];
        for (int st = 0; st < stsize; ++st) {
            BufferedImage buffimg = BufferedImageCreator.create(img, st);
            this.imgstack[st] = buffimg;
        }
        this.windowing = false;
        this.getCurrentImageinStack(0);
    }

    public void getCurrentImageinStack(int st) {
        this.mBufferedImage = (BufferedImage)this.imgstack[st];
        if (this.windowing) {
            this.setPixelData();
            this.PerformWindowing();
        }
        this.repaint();
    }

    public void setStackSize(int st) {
        this.stacksize = st;
    }

    public int getStackSize() {
        return this.stacksize;
    }

    public BufferedImage getBufferedImage() {
        return this.mBufferedImage;
    }

    public void ApplyChanges() {
        this.mBufferedImage = this.windowedImage;
        this.setPixelData(this.windowedImage);
    }

    public int getImageBitDepth() {
        ColorModel cm = this.mBufferedImage.getColorModel();
        int bpp = cm.getPixelSize();
        return bpp;
    }

    public void loadImage(String fileName) {
        try {
            File file = new File(fileName);
            this.mBufferedImage = ImageIO.read(file);
            ColorModel cm = this.mBufferedImage.getColorModel();
            int bpp = cm.getPixelSize();
            String formatName = ImagePanel.getFormatName(file);
            System.out.println("Image is of type " + formatName);
            System.out.println("Depth is " + bpp + " bits");
            System.out.println("Size: " + this.mBufferedImage.getWidth() + "x" + this.mBufferedImage.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.PerformWindowing();
        this.repaint();
    }

    public void loadSinogram(final CTScanner ctscanner) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ImagePanel.this.mBufferedImage = ctscanner.CreateSinogram(null);
                return ImagePanel.this.mBufferedImage;
            }

            public void finished() {
                ImagePanel.this.setPixelData();
                ImagePanel.this.PerformWindowing();
                ImagePanel.this.repaint();
            }
        };
        worker.start();
    }

    public void loadSinogram(final CTScanner ctscanner, final String path) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ImagePanel.this.mBufferedImage = ctscanner.CreateSinogram(path);
                return ImagePanel.this.mBufferedImage;
            }

            public void finished() {
                ImagePanel.this.setPixelData();
                ImagePanel.this.PerformWindowing();
                ImagePanel.this.repaint();
            }
        };
        worker.start();
    }

    public void loadBPImage(final CTScanner ctscanner) {
        this.bpprogresspanel = new ProgressPanel();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ImagePanel.this.startTime = System.currentTimeMillis();
                if (ctscanner.method == "fbp") {
                    ImagePanel.this.bpprogresspanel.append("Performing back projection.. ");
                    if (ctscanner.filtering) {
                        ImagePanel.this.bpprogresspanel.append("Using " + ctscanner.filtername + " Filter \n");
                        if (ctscanner.filtername == "hamming" || ctscanner.filtername == "hann") {
                            ImagePanel.this.bpprogresspanel.append("Cutoff at " + ctscanner.filtercutoff + "\n");
                        }
                    }
                    if (ctscanner.truncate) {
                        ImagePanel.this.bpprogresspanel.append("Using truncated data at " + ctscanner.truncatewidth + " \n");
                    }
                } else {
                    ImagePanel.this.bpprogresspanel.append("Performing iterative reconstruction.. ");
                    ImagePanel.this.bpprogresspanel.append(ctscanner.numiter + " iterations \n");
                }
                if (ctscanner.animate) {
                    float stepsize = ctscanner.stepsize;
                    int ang1 = ctscanner.ang1;
                    int ang2 = ctscanner.ang2;
                    int s = ctscanner.outputimgsize;
                    ctscanner.animimage = new double[s][s];
                    for (int v = 0; v < ctscanner.views && !ImagePanel.this.closed; ++v) {
                        ImagePanel.this.mBufferedImage = ctscanner.CreateReconstructedImage();
                        ImagePanel.this.windowing = false;
                        ImagePanel.this.repaint();
                        ++ctscanner.animcount;
                    }
                    double maxval = Utils.getMax(ctscanner.pixels);
                    ImagePanel.this.mBufferedImage = ctscanner.CreateImagefromArray(ctscanner.pixels, maxval, 1);
                    ctscanner.animcount = 0;
                } else {
                    ImagePanel.this.mBufferedImage = ctscanner.CreateReconstructedImage();
                }
                return ImagePanel.this.mBufferedImage;
            }

            public void finished() {
                ImagePanel.this.finished = true;
                ImagePanel.this.bpprogresspanel.append("time taken: " + ctscanner.timetaken + " seconds\n");
                ImagePanel.this.bpprogresspanel.produceSummary(ctscanner.outputimgsize, ctscanner.views, ctscanner.scans, ctscanner.stepsize);
                ctscanner.animcount = 0;
                ImagePanel.this.setPixelData();
                ImagePanel.this.PerformWindowing();
                ImagePanel.this.repaint();
            }
        };
        worker.start();
    }

    public void ReprojectImage(final CTScanner ctscanner) {
        this.bpprogresspanel = new ProgressPanel();
        this.finished = false;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                if (ImagePanel.this.ijimage != null) {
                    int type = ImagePanel.this.ijimage.getType();
                    if (type == 0) {
                        ImagePanel.this.bpprogresspanel.append("Input Image is 8 bit gray");
                    }
                    if (type == 1) {
                        ImagePanel.this.bpprogresspanel.append("Input Image is 16 bit gray");
                    }
                    if (type == 3) {
                        ImagePanel.this.bpprogresspanel.append("Input Image is 8 bit color");
                    }
                    if (type == 4) {
                        ImagePanel.this.bpprogresspanel.append("Input Image is RGB color");
                    }
                    ImagePanel.this.bpprogresspanel.append(" Size: " + ImagePanel.this.mBufferedImage.getWidth() + "x" + ImagePanel.this.mBufferedImage.getHeight() + "\n");
                }
                double[][] pix = ImagePanel.this.getdoubleBuffImagePixels();
                System.out.println();
                ImagePanel.this.bpprogresspanel.append("Generating projection data from image pixels..\n");
                ctscanner.ProjectfromImage(pix);
                if (ctscanner.method == "fbp") {
                    ImagePanel.this.bpprogresspanel.append("Performing back projection.. ");
                    if (ctscanner.filtering) {
                        ImagePanel.this.bpprogresspanel.append("Using " + ctscanner.filtername + " Filter \n");
                        if (ctscanner.filtername == "hamming" || ctscanner.filtername == "hann") {
                            ImagePanel.this.bpprogresspanel.append("Cutoff at " + ctscanner.filtercutoff + "\n");
                        }
                    }
                    if (ctscanner.truncate) {
                        ImagePanel.this.bpprogresspanel.append("Using truncated data at " + ctscanner.truncatewidth + " \n");
                    }
                } else {
                    ImagePanel.this.bpprogresspanel.append("Performing iterative reconstruction.. \n");
                }
                ImagePanel.this.mBufferedImage = ctscanner.CreateReconstructedImage();
                return ImagePanel.this.mBufferedImage;
            }

            public void finished() {
                ImagePanel.this.finished = true;
                ImagePanel.this.bpprogresspanel.produceSummary(ctscanner.outputimgsize, ctscanner.views, ctscanner.scans, ctscanner.stepsize);
                ImagePanel.this.ijimage = null;
                ImagePanel.this.setPixelData();
                ImagePanel.this.PerformWindowing();
                ImagePanel.this.repaint();
            }
        };
        worker.start();
    }

    public int[][] getBuffImagePixels() {
        int[][] pix = ImageUtils.getBuffImagePixels(this.mBufferedImage);
        return pix;
    }

    public double[][] getdoubleBuffImagePixels() {
        double[][] pix = ImageUtils.getdoubleBuffImagePixels(this.mBufferedImage);
        return pix;
    }

    public void PerformImageop(BufferedImageOp op) {
        this.windowedImage = op.filter(this.windowedImage, null);
        this.repaint();
    }

    public void EqImageHistogram() {
        Histogram hist = new Histogram(this.mBufferedImage);
        this.windowedImage = hist.makeHistEqualizedImg();
        this.repaint();
    }

    public void PerformWindowing() {
        this.windowing = true;
        if (this.pixels == null) {
            this.setPixelData();
        }
        int iw = this.mBufferedImage.getWidth();
        int ih = this.mBufferedImage.getHeight();
        int winwidth = this.upperwinlvl - this.lowerwinlvl;
        if (this.getImageType() == 11 || this.getImageType() == 10) {
            this.windowedImage = new BufferedImage(iw, ih, 10);
            WritableRaster wraster = this.windowedImage.getRaster();
            for (int x = 0; x < iw; ++x) {
                for (int y = 0; y < ih; ++y) {
                    int val = this.pixels[x][y];
                    if (val <= this.lowerwinlvl) {
                        wraster.setSample(x, y, 0, 0);
                        continue;
                    }
                    if (val >= this.upperwinlvl) {
                        wraster.setSample(x, y, 0, 255);
                        continue;
                    }
                    int newval = (val - this.lowerwinlvl) * 256 / winwidth;
                    wraster.setSample(x, y, 0, newval);
                }
            }
        } else {
            this.windowedImage = new BufferedImage(iw, ih, 1);
            this.windowedImage.createGraphics().drawImage((Image)this.mBufferedImage, 0, 0, null);
        }
        this.repaint();
    }

    public void WindowingOff() {
        this.windowing = false;
        this.repaint();
    }

    public void getWindowLevels(int low, int upp) {
        low = this.lowerwinlvl;
        upp = this.upperwinlvl;
    }

    public void resetWindowLevels() {
        this.lowerwinlvl = 0;
        this.upperwinlvl = 255;
    }

    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        super.paintComponent(g);
        if (this.mBufferedImage == null) {
            return;
        }
        Insets insets = this.getInsets();
        this.imageratio = (double)this.mBufferedImage.getWidth() / (double)this.mBufferedImage.getHeight();
        if (this.imageratio >= 1.0) {
            w = this.getWidth();
            h = (int)((double)w / this.imageratio);
            insets.top = this.getHeight() / 2 - h / 2;
            insets.left = this.getInsets().left;
            if (h > this.getHeight()) {
                h = this.getHeight();
                w = (int)((double)h * this.imageratio);
                insets.left = this.getWidth() / 2 - w / 2;
                insets.top = this.getInsets().top;
            }
        } else if (this.imageratio < 1.0) {
            h = this.getHeight();
            w = (int)((double)h * this.imageratio);
            insets.left = this.getWidth() / 2 - w / 2;
            insets.top = this.getInsets().top;
            if (w > this.getWidth()) {
                w = this.getWidth();
                h = (int)((double)w / this.imageratio);
                insets.top = this.getHeight() / 2 - h / 2;
                insets.left = this.getInsets().left;
            }
        }
        if (this.windowing) {
            try {
                g.drawImage(this.windowedImage, insets.left, insets.top, w, h, null);
            }
            catch (NullPointerException ne) {}
        } else {
            g.drawImage(this.mBufferedImage, insets.left, insets.top, w, h, null);
        }
        g.setColor(Color.yellow);
        if (this.x1 != this.x2) {
            g.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
        }
    }

    private static String getFormatName(Object o) {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(o);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            iis.close();
            return reader.getFormatName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BufferedImage FFTImage(BufferedImage img) {
        int iw = img.getWidth(null);
        int ih = img.getHeight(null);
        double[] pixels = ImageUtils.getbuffImage1DPixels(img);
        int[] newpixels = new int[iw * ih];
        MyFFT myfft = new MyFFT();
        newpixels = myfft.forward2dFFT(pixels, iw, ih);
        img = Utils.CreateImagefrom1DintArray(newpixels, iw, ih);
        this.repaint();
        return img;
    }

    public void FFTCurrentImage() {
        this.windowedImage = this.FFTImage(this.mBufferedImage);
        this.repaint();
    }

    public void ScaleImage() {
        this.mBufferedImage = ImageUtils.Scale(this.ijimage);
        this.repaint();
    }

    public class ProgressPanel
    extends JTextArea {
        public ProgressPanel() {
            super(5, 1);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            this.setFont(new Font("Monospaced", 0, 11));
            this.setBackground(Color.white);
        }

        public void produceSummary(int size, int v, int s, float step) {
            String strsize = Integer.toString(size);
            this.append("Completed:  views used: " + v + " scans: " + s + " step size:" + step + "\n");
            this.append("Image is " + strsize + "x" + strsize);
            this.setCaretPosition(this.getText().length());
        }

        public void updatecoords(int x, int y) {
            this.append(Integer.toString(x) + ", ");
            this.append(Integer.toString(y) + "\n");
            this.setCaretPosition(this.getText().length());
        }

        public void updateproj(int p, int s) {
            this.append("phi:" + Integer.toString(p) + " ");
            this.append("scan:" + Integer.toString(s));
            this.setCaretPosition(this.getText().length());
        }
    }
}

