/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import myctapp.BufferedImageCreator;
import myctapp.Utils;

public class ImageUtils {
    public static double[][] getImagePlusPixels(ImagePlus imp) {
        double[][] pix;
        block12: {
            short[] spixels;
            int type;
            block11: {
                ByteProcessor bip;
                type = imp.getType();
                int w = 0;
                int h = 0;
                ImageProcessor ip = imp.getProcessor();
                int stacksize = imp.getStackSize();
                byte[] bpixels = new byte[w * h];
                spixels = new short[w * h];
                if (imp.getType() == 0) {
                    bip = (ByteProcessor)ip;
                    bpixels = (byte[])bip.getPixels();
                    w = bip.getWidth();
                    h = bip.getHeight();
                } else if (imp.getType() == 1) {
                    ShortProcessor sip = (ShortProcessor)ip;
                    spixels = (short[])sip.getPixels();
                    w = sip.getWidth();
                    h = sip.getHeight();
                } else if (imp.getType() == 3) {
                    ImageConverter conv = new ImageConverter(imp);
                    ImageConverter.setDoScaling(true);
                    conv.convertToGray8();
                    bip = (ByteProcessor)imp.getProcessor();
                    bpixels = (byte[])bip.getPixels();
                    w = bip.getWidth();
                    h = bip.getHeight();
                } else if (imp.getType() == 4) {
                    ColorProcessor cp = new ColorProcessor(imp.getImage());
                    imp.setProcessor(null, cp.convertToByte(true));
                    bip = (ByteProcessor)imp.getProcessor();
                    bpixels = (byte[])bip.getPixels();
                    w = bip.getWidth();
                    h = bip.getHeight();
                }
                pix = new double[w][h];
                if (type != 0) break block11;
                for (int x = 0; x < pix[0].length; ++x) {
                    for (int y = 0; y < pix.length; ++y) {
                        pix[x][y] = bpixels[y + x * pix.length] & 0xFF;
                    }
                }
                break block12;
            }
            if (type != 1) break block12;
            for (int x = 0; x < pix[0].length; ++x) {
                for (int y = 0; y < pix.length; ++y) {
                    pix[x][y] = spixels[y + x * pix.length] & 0xFFFF;
                }
            }
        }
        return pix;
    }

    public static int[][] getBuffImagePixels(BufferedImage img) {
        int iw = img.getWidth(null);
        int ih = img.getHeight(null);
        int[][] pix = new int[iw][ih];
        if (img.getType() == 11) {
            DataBufferUShort db = (DataBufferUShort)img.getRaster().getDataBuffer();
            short[] pixelarray = db.getData();
            for (int x = 0; x < pix.length; ++x) {
                for (int y = 0; y < pix[0].length; ++y) {
                    pix[x][y] = pixelarray[x + y * pix.length] & 0xFFFF;
                }
            }
        } else if (img.getType() == 1) {
            DataBufferInt db = (DataBufferInt)img.getRaster().getDataBuffer();
            int[] pixelarray = db.getData();
            for (int x = 0; x < pix.length; ++x) {
                for (int y = 0; y < pix[0].length; ++y) {
                    pix[x][y] = pixelarray[x + y * pix.length];
                }
            }
        } else {
            DataBufferByte db = (DataBufferByte)img.getRaster().getDataBuffer();
            byte[] pixelarray = db.getData();
            for (int x = 0; x < pix.length; ++x) {
                for (int y = 0; y < pix[0].length; ++y) {
                    pix[x][y] = pixelarray[x + y * pix.length] & 0xFF;
                }
            }
        }
        return pix;
    }

    public static double[][] getdoubleBuffImagePixels(BufferedImage img) {
        int iw = img.getWidth(null);
        int ih = img.getHeight(null);
        double[][] pix = new double[iw][ih];
        if (img.getType() == 11) {
            DataBufferUShort db = (DataBufferUShort)img.getRaster().getDataBuffer();
            short[] pixelarray = db.getData();
            for (int x = 0; x < pix.length; ++x) {
                for (int y = 0; y < pix[0].length; ++y) {
                    pix[x][y] = pixelarray[x + y * pix.length] & 0xFFFF;
                }
            }
        } else if (img.getType() == 1) {
            DataBufferInt db = (DataBufferInt)img.getRaster().getDataBuffer();
            int[] pixelarray = db.getData();
            for (int x = 0; x < pix.length; ++x) {
                for (int y = 0; y < pix[0].length; ++y) {
                    pix[x][y] = pixelarray[x + y * pix.length] & 0xFF;
                }
            }
        } else {
            DataBufferByte db = (DataBufferByte)img.getRaster().getDataBuffer();
            byte[] pixelarray = db.getData();
            for (int x = 0; x < pix.length; ++x) {
                for (int y = 0; y < pix[0].length; ++y) {
                    pix[x][y] = pixelarray[x + y * pix.length] & 0xFF;
                }
            }
        }
        return pix;
    }

    public static double[] getbuffImage1DPixels(BufferedImage img) {
        ColorModel cm = img.getColorModel();
        int bpp = cm.getPixelSize();
        int iw = img.getWidth(null);
        int ih = img.getHeight(null);
        double[] pixels = new double[iw * ih];
        DataBufferByte db = (DataBufferByte)img.getRaster().getDataBuffer();
        byte[] pixelarray = db.getData();
        for (int x = 0; x < pixels.length; ++x) {
            pixels[x] = pixelarray[x] & 0xFF;
        }
        return pixels;
    }

    public static void toGrayBytes(byte[] grayBytes, short[] shortBuffer, int imgMin, int imgMax) {
        boolean displayMin = false;
        int displayMax = 255;
        float displayRatio = 255.0f / (float)(imgMax - imgMin);
        for (int i = 0; i < shortBuffer.length; ++i) {
            short in = shortBuffer[i];
            int out = in < imgMin ? 0 : (in > imgMax ? 255 : (int)((float)(in - imgMin) * displayRatio));
            grayBytes[i] = (byte)out;
        }
    }

    public static BufferedImage getGrayBufferedImage(short[] buf, int width, int height, int imgMin, int imgMax) {
        if (buf.length != width * height) {
            throw new IllegalArgumentException(width + " * " + height + " != " + buf.length);
        }
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        ImageUtils.toGrayBytes(data, buf, imgMin, imgMax);
        return image;
    }

    public static BufferedImage create12bitImage(int imageWidth, int imageHeight, short[] data) {
        DataBufferUShort dbuff = new DataBufferUShort(data, imageWidth);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ComponentColorModel cm = new ComponentColorModel(cs, new int[]{16}, false, false, 1, 1);
        int[] band = new int[]{0};
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(dbuff.getDataType(), imageWidth, imageHeight, 1, imageWidth, band);
        WritableRaster raster = Raster.createWritableRaster(sm, dbuff, new Point(0, 0));
        return new BufferedImage(cm, raster, false, null);
    }

    public static BufferedImage CreateImagefromIntArray(int[][] pixels) {
        boolean i = false;
        boolean j = false;
        short[] pixelshortArray = new short[pixels.length * pixels[0].length];
        int min = Utils.getMin(pixels);
        int max = Utils.getMax(pixels);
        System.out.println("rescaling output image: ");
        for (int x = 0; x < pixels[0].length; ++x) {
            for (int y = 0; y < pixels.length; ++y) {
                int gray = pixels[x][y];
                pixelshortArray[x + y * pixels.length] = gray < 0 ? (short)0 : (short)gray;
            }
        }
        BufferedImage img = ImageUtils.getGrayBufferedImage(pixelshortArray, pixels.length, pixels[0].length, 0, 255);
        return img;
    }

    static BufferedImage convert(BufferedImage image, int type) {
        if (image.getType() == type) {
            return image;
        }
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), type);
        Graphics2D g = result.createGraphics();
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static BufferedImage Scale(ImagePlus ijimg) {
        WindowManager.setTempCurrentImage(ijimg);
        IJ.runPlugIn("ij.plugin.filter.Scaler", "");
        BufferedImage img = BufferedImageCreator.create(ijimg, 0);
        return img;
    }
}

