/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import ij.ImagePlus;
import ij.io.Opener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import myctapp.CTScanner;
import myctapp.ImagePanel;

public class InternalImageFrame
extends JInternalFrame {
    static int openFrameCount = 0;
    static final int xOffset = 30;
    static final int yOffset = 30;
    public int PANELTYPE;
    public ImagePanel imagepanel;
    public JSlider stackslider;
    private JLabel label;

    public InternalImageFrame() {
        super("Frame#" + ++openFrameCount, true, true, true, true);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setMaximizable(true);
        this.setClosable(true);
        this.setIconifiable(true);
        this.pack();
        this.setVisible(true);
        this.setLocation(30 * openFrameCount, 30 * openFrameCount);
    }

    public InternalImageFrame(String path, int ptype, CTScanner ctscanner) {
        super("Frame#" + ++openFrameCount, true, true, true, true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        this.imagepanel = new ImagePanel();
        container.add((Component)this.imagepanel, "Center");
        this.pack();
        this.setVisible(true);
        this.setLocation(30 * openFrameCount, 30 * openFrameCount);
        if (ptype == 2) {
            Opener op = new Opener();
            ImagePlus imp = op.openImage(path);
            this.imagepanel.loadImagePlus(imp);
            this.PANELTYPE = 2;
        } else if (ptype == 3) {
            if (path == null) {
                this.imagepanel.loadSinogram(ctscanner);
            } else {
                this.imagepanel.loadSinogram(ctscanner, path);
            }
            this.PANELTYPE = 3;
        } else if (ptype == 4) {
            this.imagepanel.loadBPImage(ctscanner);
            JScrollPane scrollingResult = new JScrollPane(this.imagepanel.bpprogresspanel);
            scrollingResult.setPreferredSize(new Dimension(200, 60));
            container.add((Component)scrollingResult, "South");
            this.PANELTYPE = 4;
        } else if (ptype == 5) {
            Opener op = new Opener();
            ImagePlus imp = op.openImage(path);
            this.imagepanel.loadImagePlus(imp);
            this.imagepanel.ReprojectImage(ctscanner);
            JScrollPane scrollingResult = new JScrollPane(this.imagepanel.bpprogresspanel);
            scrollingResult.setPreferredSize(new Dimension(200, 60));
            container.add((Component)scrollingResult, "South");
            this.PANELTYPE = 5;
        } else if (ptype == 6) {
            ctscanner.ProjectPhantom();
            this.imagepanel.loadBPImage(ctscanner);
            JScrollPane scrollingResult = new JScrollPane(this.imagepanel.bpprogresspanel);
            scrollingResult.setPreferredSize(new Dimension(200, 60));
            container.add((Component)scrollingResult, "South");
            this.PANELTYPE = 6;
        }
    }

    public InternalImageFrame(ImagePlus imp) {
        super("Frame#" + ++openFrameCount, true, true, true, true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        this.imagepanel = new ImagePanel();
        int stsize = imp.getStackSize();
        if (stsize > 1) {
            this.stackslider = new JSlider(0, 0, stsize - 1, 0);
            this.stackslider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    JSlider slider = (JSlider)evt.getSource();
                    if (slider.getValueIsAdjusting()) {
                        int value1 = slider.getValue();
                        try {
                            InternalImageFrame.this.imagepanel.getCurrentImageinStack(value1);
                        }
                        catch (NullPointerException s) {
                            // empty catch block
                        }
                    }
                }
            });
            this.add((Component)this.stackslider, "North");
            this.imagepanel.importIJStack(imp);
            this.imagepanel.setStackSize(stsize);
            this.PANELTYPE = 8;
        } else {
            this.imagepanel.loadImagePlus(imp);
            this.PANELTYPE = 2;
        }
        container.add((Component)this.imagepanel, "Center");
        this.pack();
        this.setVisible(true);
        this.setLocation(30 * openFrameCount, 30 * openFrameCount);
    }

    public void AddPanelsandDisplay() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        JScrollPane scrollingResult = new JScrollPane(this.imagepanel.bpprogresspanel);
        scrollingResult.setPreferredSize(new Dimension(200, 60));
        container.add((Component)scrollingResult, "South");
        this.PANELTYPE = 5;
        container.add((Component)this.imagepanel, "Center");
        this.pack();
        this.setVisible(true);
        this.setLocation(30 * openFrameCount, 30 * openFrameCount);
    }

    public InternalImageFrame CreateCopy() {
        InternalImageFrame copy = new InternalImageFrame();
        copy.imagepanel = new ImagePanel();
        if (this.imagepanel.ijimage != null) {
            copy.imagepanel.loadImagePlus(this.imagepanel.ijimage);
        } else {
            copy.imagepanel.loadBufferedImage(this.imagepanel.getBufferedImage());
        }
        return copy;
    }
}

