/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.image.BufferedImage;
import myctapp.CTScanner;
import myctapp.Utils;

public class Iterative {
    private static int views;
    private static int scans;
    private static float phi;
    private static int ang1;
    private static int ang2;
    private static float stepsize;
    private static boolean fast;
    private static String noise;
    private static double rate;
    public static int outputimgsize;
    public static int numiter;

    public static void InitialiseData(CTScanner c) {
        views = c.views;
        scans = c.scans;
        phi = c.phi;
        ang1 = c.ang1;
        ang2 = c.ang2;
        stepsize = c.stepsize;
        fast = c.fast;
        noise = c.noise;
        rate = c.rate;
        outputimgsize = c.outputimgsize;
        numiter = c.numiter;
    }

    public static double[][] FindWeights(double[][] pix) {
        int i = 0;
        int j = 0;
        int S = 0;
        int ang = 0;
        double[][] proj = new double[views][scans];
        double[] sintab = new double[views];
        double[] costab = new double[views];
        int inputimgsize = pix[0].length;
        for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
            sintab[ang] = Math.sin((double)phi * Math.PI / 180.0 - 1.5707963267948966);
            costab[ang] = Math.cos((double)phi * Math.PI / 180.0 - 1.5707963267948966);
            ++ang;
        }
        int Xcenter = inputimgsize / 2;
        int Ycenter = inputimgsize / 2;
        i = 0;
        double scale = (double)inputimgsize * 1.42 / (double)scans;
        System.out.println("Getting weights from image pixels.. ");
        boolean N = false;
        double val = 0.0;
        double weight = 0.0;
        double bw = 1 / scans;
        double sang = Math.sqrt(2.0) / 2.0;
        double[][] W = new double[views * scans][inputimgsize];
        boolean w_index = false;
        for (i = 0; i < views * scans; ++i) {
            boolean x = false;
            boolean y = false;
            double pos = ((double)x * sintab[ang] - (double)y * costab[ang]) / scale;
            for (S = 0; S < scans; ++S) {
                W[i][j] = 0.0;
            }
            ++j;
            ++ang;
            j = 0;
        }
        ang = 0;
        i = 0;
        Utils.outputdoubleArray(W);
        return W;
    }

    public static double[][] PerformART(CTScanner c) {
        Iterative.InitialiseData(c);
        double lambda = 1.0;
        int outputimgsize = c.outputimgsize;
        double[][] proj = c.projection;
        int i = 0;
        double val = 0.0;
        int S = 0;
        int N = 0;
        double[] sintab = new double[views];
        double[] costab = new double[views];
        double[] sintab1 = new double[views];
        double[] costab1 = new double[views];
        for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
            sintab[i] = Math.sin((double)phi * Math.PI / 180.0 - 1.5707963267948966);
            costab[i] = Math.cos((double)phi * Math.PI / 180.0 - 1.5707963267948966);
            ++i;
        }
        i = 0;
        for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
            sintab1[i] = Math.sin((double)phi * Math.PI / 180.0);
            costab1[i] = Math.cos((double)phi * Math.PI / 180.0);
            ++i;
        }
        i = 0;
        int Xcenter = outputimgsize / 2;
        int Ycenter = outputimgsize / 2;
        double scale = (double)outputimgsize * 1.42 / (double)scans;
        double sang = Math.sqrt(2.0) / 2.0;
        double weight = 0.0;
        double[][] W = new double[views][scans];
        double[][] pix = new double[outputimgsize][outputimgsize];
        double[][] temppixels = new double[outputimgsize][outputimgsize];
        double[] diff = new double[scans];
        double[] guess = new double[scans];
        double[] ww = new double[scans];
        pix = c.BackProject(proj, outputimgsize);
        double m = Utils.getMax(pix);
        System.out.println("M=" + m);
        Utils.blank(W, 1.0);
        for (int j = 1; j <= numiter; ++j) {
            System.out.println("Iteration " + j);
            lambda /= (double)numiter;
            for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
                int y;
                int x;
                System.out.println("phi= " + phi);
                double a = -costab[i] / sintab[i];
                double aa = 1.0 / a;
                if (Math.abs(sintab[i]) > sang) {
                    for (S = 0; S < scans; ++S) {
                        N = S - scans / 2;
                        double b = ((double)N - costab[i] - sintab[i]) / sintab[i];
                        b *= scale;
                        for (x = -Xcenter; x < Xcenter; ++x) {
                            if (fast) {
                                y = (int)Math.round(a * (double)x + b);
                                if (y < -Xcenter || y >= Xcenter) continue;
                                val += pix[x + Xcenter][y + Ycenter];
                                double[] dArray = W[i];
                                int n = S;
                                dArray[n] = dArray[n] + 1.0;
                                continue;
                            }
                            y = (int)Math.round(a * (double)x + b);
                            weight = Math.abs(a * (double)x + b - Math.ceil(a * (double)x + b));
                            if (y < -Xcenter || y + 1 >= Xcenter) continue;
                            val += (1.0 - weight) * pix[x + Xcenter][y + Ycenter] + weight * pix[x + Xcenter][y + Ycenter + 1];
                            double[] dArray = W[i];
                            int n = S;
                            dArray[n] = dArray[n] + 1.0;
                        }
                        guess[S] = val /= W[i][S];
                        val = 0.0;
                    }
                }
                if (Math.abs(sintab[i]) <= sang) {
                    for (S = 0; S < scans; ++S) {
                        N = S - scans / 2;
                        double bb = ((double)N - costab[i] - sintab[i]) / costab[i];
                        bb *= scale;
                        for (y = -Ycenter; y < Ycenter; ++y) {
                            x = (int)Math.round(aa * (double)y + bb);
                            if (fast) {
                                if (x < -Xcenter || x >= Xcenter) continue;
                                val += pix[x + Xcenter][y + Ycenter];
                                double[] dArray = W[i];
                                int n = S;
                                dArray[n] = dArray[n] + 1.0;
                                continue;
                            }
                            weight = Math.abs(aa * (double)y + bb - Math.ceil(aa * (double)y + bb));
                            if (x < -Xcenter || x + 1 >= Xcenter) continue;
                            val += (1.0 - weight) * pix[x + Xcenter][y + Ycenter] + weight * pix[x + Xcenter + 1][y + Ycenter];
                            double[] dArray = W[i];
                            int n = S;
                            dArray[n] = dArray[n] + 1.0;
                        }
                        guess[S] = val /= W[i][S];
                        val = 0.0;
                    }
                }
                System.out.println();
                for (S = 0; S < scans; ++S) {
                    ww[S] = W[i][S];
                }
                Utils.normalize1DArray(ww, 0.0, 2.0);
                S = 0;
                double st = sintab1[i];
                double ct = costab1[i];
                for (x = -Xcenter; x < Xcenter; ++x) {
                    for (y = -Ycenter; y < Ycenter; ++y) {
                        double pos = (double)x * st - (double)y * ct;
                        S = (int)Math.round(pos / scale);
                        weight = Math.abs((double)((int)Math.round(pos)) - pos);
                        if (weight > 1.0) {
                            weight = 0.0;
                        }
                        if ((S += scans / 2) > 0 && S < scans && weight > 0.0 && weight < 1.0) {
                            diff[S] = (proj[i][S] - guess[S]) / ww[S] * (1.0 - weight);
                            double[] dArray = pix[x + Xcenter];
                            int n = y + Ycenter;
                            dArray[n] = dArray[n] + diff[S];
                        }
                        if (!(pix[x + Xcenter][y + Ycenter] < 0.0)) continue;
                        pix[x + Xcenter][y + Ycenter] = 0.0;
                    }
                }
                System.out.println();
                ++i;
            }
            i = 0;
        }
        return pix;
    }

    public static double[][] PerformMLEM(CTScanner c) {
        Iterative.InitialiseData(c);
        double[][] proj = c.projection;
        int i = 0;
        int S = 0;
        double[][] tempproj = new double[views][scans];
        double[][] projratio = new double[views][scans];
        double[][] W = new double[views][scans];
        double[] ww = new double[scans];
        double[][] pixels = new double[outputimgsize][outputimgsize];
        double[][] correction = new double[outputimgsize][outputimgsize];
        double[][] gauss = c.Create2DGaussian(outputimgsize);
        double[] sintab1 = new double[views];
        double[] costab1 = new double[views];
        for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
            sintab1[i] = Math.sin((double)phi * Math.PI / 180.0);
            costab1[i] = Math.cos((double)phi * Math.PI / 180.0);
            ++i;
        }
        i = 0;
        Utils.blank(pixels, 1.0);
        int Xcenter = outputimgsize / 2;
        int Ycenter = outputimgsize / 2;
        double scale = (double)outputimgsize * 1.42 / (double)scans;
        for (int j = 1; j <= numiter; ++j) {
            System.out.println("Iteration " + j);
            tempproj = c.ForwardProject(pixels);
            for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
                for (S = 0; S < scans; ++S) {
                    double err = proj[i][S] / tempproj[i][S];
                    projratio[i][S] = err > 0.0 ? err : 0.0;
                    System.out.print(projratio[i][S] + " ");
                }
                ++i;
            }
            i = 0;
            for (phi = (float)ang1; phi < (float)ang2; phi += stepsize) {
                for (int x = -Xcenter; x < Xcenter; ++x) {
                    for (int y = -Ycenter; y < Ycenter; ++y) {
                        double pos = (double)x * sintab1[i] - (double)y * costab1[i];
                        S = (int)Math.round(pos / scale);
                        double weight = Math.abs((double)((int)Math.round(pos)) - pos);
                        if ((S += scans / 2) <= 0 || S >= scans) continue;
                        double[] dArray = correction[x + Xcenter];
                        int n = y + Ycenter;
                        dArray[n] = dArray[n] + projratio[i][S] * (1.0 - weight);
                    }
                }
                ++i;
            }
            i = 0;
            Utils.normalize2DArray(correction, 0.0, 1.0);
            pixels = Utils.multiply2Darrays(pixels, correction);
        }
        return pixels;
    }

    public static void main(String[] args) {
        CTScanner c = new CTScanner();
        c.scans = 128;
        c.numiter = 2;
        c.outputimgsize = 64;
        c.ProjectPhantom();
        double[][] est = Iterative.PerformMLEM(c);
        double max = Utils.getMax(est);
        BufferedImage img = c.CreateImagefromArray(est, max, 0);
        String filename = "C:\\temp\\testimg_" + numiter;
        Utils.saveanImage(filename, img);
    }
}

