/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import ij.IJ;
import ij.ImagePlus;
import ij.io.Opener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.text.html.HTMLDocument;
import myctapp.CTScanner;
import myctapp.CustomDialog;
import myctapp.DataFrame;
import myctapp.GraphicsFrame;
import myctapp.Histogram;
import myctapp.ImageOps;
import myctapp.ImagePanel;
import myctapp.ImageUtils;
import myctapp.InfoPanel;
import myctapp.InternalDrawFrame;
import myctapp.InternalImageFrame;
import myctapp.MemoryMonitor;
import myctapp.SwingWorker;
import myctapp.Utils;
import myctapp.gui.GradientPanel;
import myctapp.gui.MDIDesktopPane;
import myctapp.gui.MThumbSlider;
import myctapp.gui.SplashWindow;
import myctapp.gui.SpringUtilities;
import myctapp.gui.WindowMenu;

public class MyApp
extends JFrame
implements ActionListener,
ChangeListener,
PropertyChangeListener,
ItemListener {
    private MDIDesktopPane theDesktop;
    private JScrollPane scrollPane;
    private FrameListener frameListener;
    private JPanel widgetPanel;
    private JPanel textfieldPanel;
    private JPanel windowingPanel;
    private JPanel winPanel;
    private JPanel sliderPanel;
    private GradientPanel gradientPanel;
    private InfoPanel imginfoPanel;
    private InternalImageFrame currentframe;
    private JLabel scansLabel;
    private JLabel viewsLabel;
    private JLabel stepsizeLabel;
    private JLabel imgsizeLabel;
    private JLabel zoomLabel;
    private JLabel xoffsetLabel;
    private JLabel yoffsetLabel;
    private JLabel lowerlevelLabel;
    private JLabel upperlevelLabel;
    private JLabel bitdepthLabel;
    private JFormattedTextField scansField;
    private JFormattedTextField viewsField;
    private JFormattedTextField stepsizeField;
    private JFormattedTextField imgsizeField;
    private JFormattedTextField zoomField;
    private JFormattedTextField xoffsetField;
    private JFormattedTextField yoffsetField;
    private JFormattedTextField lowerlevelField;
    private JFormattedTextField upperlevelField;
    private JFormattedTextField bitdepthField;
    private NumberFormat scansFormat;
    private NumberFormat viewsFormat;
    private NumberFormat stepsizeFormat;
    private NumberFormat imgsizeFormat;
    private NumberFormat zoomFormat;
    private NumberFormat offsetFormat;
    private NumberFormat lowerlevelFormat;
    private NumberFormat upperlevelFormat;
    private JCheckBoxMenuItem filtercheckbox;
    private JCheckBoxMenuItem truncatecheckbox;
    private JCheckBoxMenuItem ROIcropcheckbox;
    private JCheckBoxMenuItem ROIcirclecheckbox;
    private JCheckBoxMenuItem setedgezerocheckbox;
    private JCheckBoxMenuItem animatecheckbox;
    private JCheckBoxMenuItem keepcurrentextrapwidthscheckbox;
    private static String scansString = "Scans: ";
    private static String viewsString = "Views: ";
    private static String stepsizeString = "\u0398 Step:";
    private static String imgsizeString = "Img Size:";
    private static String zoomString = "Zoom:";
    private static String xoffsetString = "X-Offset:";
    private static String yoffsetString = "Y-Offset: ";
    private MThumbSlider mSlider1;
    private MThumbSlider mSlider2;
    private JToolBar imagetoolBar;
    private JToolBar filetoolBar;
    private Action openimageAction;
    private Action saveimageAction;
    private Action quitAction;
    private Action blurAction;
    private Action sharpenAction;
    private Action invertAction;
    private Action brightenAction;
    private Action darkenAction;
    private Action greyscaleAction;
    private Action scaleAction;
    private Action loadPhantomAction;
    private Action savePhantomAction;
    private Action createSinogramAction;
    private Action loadSinogramAction;
    private Action projPhantomAction;
    private Action drawCustomPhantomAction;
    private Action loadProjAction;
    private Action saveProjAction;
    private Action copyAction;
    private Action pasteasimageAction;
    private Action createBPImageAction;
    private Action createProjfromImageAction;
    private Action importProjAction;
    private Action exportProjAction;
    private Action showhistogramAction;
    private Action eqhistimageAction;
    private Action fftimageAction;
    private Action addimagesAction;
    private Action subimagesAction;
    private Action divimagesAction;
    private Action findmseAction;
    private JProgressBar progressBar;
    private MemoryMonitor memmonitor;
    private static Font theMainFont;
    private static Font smallFont;
    private BufferedImage clipboardImage;
    private double[][] clipboarddata;
    private int upper;
    private int lower;
    private static CTScanner ctscanner;
    static final String INT_TITLE = "Enter a value";
    static final String PREFERREDLOOKANDFEELNAME = "javax.swing.plaf.metal.MetalLookAndFeel";
    protected String curLF = "javax.swing.plaf.metal.MetalLookAndFeel";
    protected JRadioButton previousButton;
    JInternalFrame theFrame;

    private JMenuBar createMenuBar() {
        theMainFont = new Font("SansSerif", 0, 11);
        smallFont = new Font("SansSerif", 0, 10);
        UIManager.put("MenuBar.font", theMainFont);
        UIManager.put("Menu.font", theMainFont);
        UIManager.put("MenuItem.font", theMainFont);
        UIManager.put("RadioButton.font", theMainFont);
        UIManager.put("RadioButtonMenuItem.font", theMainFont);
        UIManager.put("CheckBoxMenuItem.font", theMainFont);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setOpaque(true);
        menuBar.setMargin(new Insets(0, 0, 20, 0));
        menuBar.setPreferredSize(new Dimension(300, 20));
        JMenu filemenu = new JMenu("File");
        filemenu.setMnemonic(70);
        menuBar.add(filemenu);
        JMenuItem menuItem = new JMenuItem(this.loadProjAction);
        filemenu.add(menuItem);
        menuItem = new JMenuItem(this.saveProjAction);
        filemenu.add(menuItem);
        menuItem = new JMenuItem(this.importProjAction);
        filemenu.add(menuItem);
        menuItem = new JMenuItem(this.openimageAction);
        filemenu.add(menuItem);
        menuItem = new JMenuItem(this.saveimageAction);
        filemenu.add(menuItem);
        JMenu Prefmenu = new JMenu("Preferences");
        AbstractAction setLNFAction = new AbstractAction("Set LNF", null){

            public void actionPerformed(ActionEvent evt) {
                MyApp.this.LNFSwitcher();
            }
        };
        menuItem = new JMenuItem(setLNFAction);
        Prefmenu.add(menuItem);
        filemenu.add(Prefmenu);
        menuItem = new JMenuItem(this.quitAction);
        filemenu.add(menuItem);
        JMenu imagemenu = new JMenu("Image");
        menuBar.add(imagemenu);
        JMenu imageFiltersMenu = new JMenu("Filters");
        menuItem = new JMenuItem(this.blurAction);
        imageFiltersMenu.add(menuItem);
        menuItem = new JMenuItem(this.sharpenAction);
        imageFiltersMenu.add(menuItem);
        imagemenu.add(imageFiltersMenu);
        JMenu imageHistogramMenu = new JMenu("Histogram");
        menuItem = new JMenuItem(this.showhistogramAction);
        imageHistogramMenu.add(menuItem);
        menuItem = new JMenuItem(this.eqhistimageAction);
        imageHistogramMenu.add(menuItem);
        imagemenu.add(imageHistogramMenu);
        JMenu imageArithmeticMenu = new JMenu("Arithemtic");
        menuItem = new JMenuItem(this.addimagesAction);
        imageArithmeticMenu.add(menuItem);
        menuItem = new JMenuItem(this.subimagesAction);
        imageArithmeticMenu.add(menuItem);
        menuItem = new JMenuItem(this.divimagesAction);
        imageArithmeticMenu.add(menuItem);
        imagemenu.add(imageArithmeticMenu);
        menuItem = new JMenuItem(this.findmseAction);
        imageArithmeticMenu.add(menuItem);
        imagemenu.add(imageArithmeticMenu);
        JMenu imageFFTMenu = new JMenu("FFT");
        menuItem = new JMenuItem(this.fftimageAction);
        imageFFTMenu.add(menuItem);
        imagemenu.add(imageFFTMenu);
        menuItem = new JMenuItem(this.invertAction);
        imagemenu.add(menuItem);
        menuItem = new JMenuItem(this.brightenAction);
        imagemenu.add(menuItem);
        menuItem = new JMenuItem(this.darkenAction);
        imagemenu.add(menuItem);
        JMenu phantommenu = new JMenu("Phantom");
        menuBar.add(phantommenu);
        this.createPhantomMenu(phantommenu);
        JMenu settingsmenu = new JMenu("Settings");
        menuBar.add(settingsmenu);
        this.createSettingsMenu(settingsmenu);
        JMenu toolsmenu = new JMenu("Tools");
        menuBar.add(toolsmenu);
        this.createToolsMenu(toolsmenu);
        menuBar.add(new WindowMenu(this.theDesktop));
        JMenu helpmenu = new JMenu("Help");
        menuBar.add(helpmenu);
        menuItem = new JMenuItem("Manual");
        menuItem.setActionCommand("manual");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String tempLine;
                    String path = MyApp.class.getResource("MyApp.class").toString();
                    path = path.substring(path.indexOf(47) + 1, path.indexOf("!/") - 4);
                    System.out.println(path);
                    FileInputStream inputStream = new FileInputStream(path + "\\help.html");
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    BufferedReader br = new BufferedReader(reader);
                    StringBuffer strb = new StringBuffer();
                    while ((tempLine = br.readLine()) != null) {
                        strb.append(tempLine);
                    }
                    JEditorPane pane = new JEditorPane();
                    pane.setEditable(false);
                    JScrollPane scrollPane = new JScrollPane(pane);
                    HTMLDocument htmlDoc = new HTMLDocument();
                    pane.setDocument(htmlDoc);
                    pane.setContentType("text/html");
                    pane.setText(strb.toString());
                    InternalImageFrame frame = new InternalImageFrame();
                    frame.getContentPane().add(scrollPane);
                    MyApp.this.theDesktop.add(frame);
                }
                catch (IOException ie) {
                    System.out.println("Oops- an IOException happened.");
                }
            }
        });
        helpmenu.add(menuItem);
        menuItem = new JMenuItem("About");
        menuItem.setActionCommand("help");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MyApp.this.displaySplash();
            }
        });
        helpmenu.add(menuItem);
        return menuBar;
    }

    private void createActions() {
        this.loadProjAction = new LoadProjAction("Load Proj File", MyApp.createIcon("open"), "Load proj file", new Integer(72));
        this.saveProjAction = new SaveProjAction("Save Current Projs.", MyApp.createIcon("save"), "Save current projections to file", new Integer(80));
        this.importProjAction = new ImportProjAction("Import Proj. Data", MyApp.createIcon("open"), "Import projection data from Image", new Integer(82));
        this.projPhantomAction = new ProjPhantomAction("Proj Phantom", "Back proj dummmy phantom", new Integer(78));
        this.createSinogramAction = new CreateSinogramAction("Sinogram", "Display the Sinogram for current projection", new Integer(71));
        this.loadSinogramAction = new LoadSinogramAction("Load Sinogram", "Load a Sinogram from projections file", new Integer(68));
        this.createBPImageAction = new CreateBPImageAction("Back Project", "Display the Back Projection", new Integer(65));
        this.createProjfromImageAction = new CreateProjfromImageAction("Reproject Image", "Create Projection data from an Image", new Integer(69));
        this.drawCustomPhantomAction = new DrawCustomPhantomAction("Draw Custom Phantom", MyApp.createIcon("draw"), "Draw an object from ellipses", new Integer(74));
        this.openimageAction = new OpenImageAction("Open Image", MyApp.createIcon("open"), "Open an image", new Integer(79));
        this.saveimageAction = new SaveImageAction("Save Image", MyApp.createIcon("save"), "Save image", new Integer(83));
        this.quitAction = new QuitAction("Quit", "Quit Application", new Integer(81));
        this.blurAction = new BlurAction("Blur", MyApp.createIcon("blur"), "Blur image", new Integer(49));
        this.sharpenAction = new SharpenAction("Sharpen", MyApp.createIcon("sharpen"), "Sharpen image", new Integer(50));
        this.invertAction = new InvertAction("Invert", MyApp.createIcon("invert"), "Negative image", new Integer(51));
        this.brightenAction = new BrightenAction("Brighten", MyApp.createIcon("brighten"), "Brighten image", new Integer(52));
        this.darkenAction = new DarkenAction("Darken", MyApp.createIcon("darken"), "Darken image", new Integer(53));
        this.greyscaleAction = new GreyScaleAction("Greyscale", MyApp.createIcon("greyscale"), "Convert to greyscale", new Integer(54));
        this.scaleAction = new ScaleAction("Scale", MyApp.createIcon("scale"), "Scale Image", new Integer(55));
        this.showhistogramAction = new showHistogramAction("View Histogram", MyApp.createIcon("histogram"), "Display Histogram", new Integer(77));
        this.eqhistimageAction = new eqHistImageAction("Eq Histogram", MyApp.createIcon("eq_histogram"), "Eq Histogram", new Integer(76));
        this.addimagesAction = new addImagesAction("Add", MyApp.createIcon("add_images"), "Add Images", new Integer(87));
        this.subimagesAction = new subImagesAction("Subtract", MyApp.createIcon("sub_images"), "Subtract Images", new Integer(89));
        this.divimagesAction = new divImagesAction("Divide", MyApp.createIcon("divide"), "Divide Images", new Integer(90));
        this.findmseAction = new findMSEAction("Find MSE", MyApp.createIcon("MSE"), "Divide Images", new Integer(88));
        this.fftimageAction = new FFTImageAction("FFT", MyApp.createIcon("fft"), "Find Image FFT", new Integer(84));
    }

    private void createToolsMenu(JMenu rootMenu) {
        JMenu SelectionMenu = new JMenu("Selection");
        this.copyAction = new CopySelectionAction("Copy", MyApp.createIcon("copy"), "Copy Selection", new Integer(67));
        this.pasteasimageAction = new PasteasImageAction("Paste as Image", MyApp.createIcon("paste"), "Paste Selection", new Integer(86));
        AbstractAction findMeanaction = new AbstractAction("Measure"){

            public void actionPerformed(ActionEvent evt) {
                InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
                if (frame1.PANELTYPE >= 2) {
                    int[][] temppixels = frame1.imagepanel.getSelectionPixels();
                    double[][] tempdata = frame1.imagepanel.getSelectionData();
                    double mean = Utils.getAverage2DIntArray(temppixels);
                    double min = Utils.getMin(temppixels);
                    double max = Utils.getMax(temppixels);
                    double stdev = Utils.round(Utils.getStDev2DIntArray(temppixels), 2);
                    double datamean = Utils.round(Utils.getAverage2DDoubleArray(tempdata), 3);
                    double datamin = Utils.round(Utils.getMin(tempdata), 3);
                    double datamax = Utils.round(Utils.getMax(tempdata), 3);
                    double datastdev = Utils.round(Utils.getStDev2DDoubleArray(tempdata), 3);
                    JOptionPane.showInternalMessageDialog(MyApp.this.theDesktop, "Mean: " + mean + " Min: " + min + " Max: " + max + " St. Dev: " + stdev + "\n" + "Data Mean: " + datamean + " Min: " + datamin + " Max: " + datamax + " St. Dev: " + datastdev, "Measurements", -1);
                }
            }
        };
        JMenuItem menuItem = new JMenuItem(this.copyAction);
        SelectionMenu.add(menuItem);
        menuItem = new JMenuItem(this.pasteasimageAction);
        SelectionMenu.add(menuItem);
        SelectionMenu.add(new JSeparator());
        menuItem = new JMenuItem(findMeanaction);
        SelectionMenu.add(menuItem);
        rootMenu.add(SelectionMenu);
        AbstractAction FindNumRaysAction = new AbstractAction("Show ray data"){

            public void actionPerformed(ActionEvent evt) {
                double truncrayperc = Utils.round((double)ctscanner.truncbeamrays / (double)ctscanner.numrays, 2);
                JOptionPane.showInternalMessageDialog(MyApp.this.theDesktop, "Total rays: " + ctscanner.totalrays + "\n" + "Full rays through object: " + ctscanner.numrays + "\n" + "Trunc rays through object: " + ctscanner.truncbeamrays + "  (" + truncrayperc + ")", "Ray Data", -1);
            }
        };
        menuItem = new JMenuItem(FindNumRaysAction);
        rootMenu.add(menuItem);
        AbstractAction GraphDataAction = new AbstractAction("Graph Data"){

            public void actionPerformed(ActionEvent evt) {
                DataFrame frame = new DataFrame();
                frame.setupPanels();
                frame.pack();
                frame.setVisible(true);
                MyApp.this.theDesktop.add(frame);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
        menuItem = new JMenuItem(GraphDataAction);
        rootMenu.add(menuItem);
    }

    private void createSettingsMenu(JMenu rootMenu) {
        AbstractAction setFBPaction = new AbstractAction("FBP"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.method = "fbp";
            }
        };
        AbstractAction setIterativeaction = new AbstractAction("Iterative"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.method = "iterative";
            }
        };
        AbstractAction setnumitersaction = new AbstractAction("Set No. Iterations"){

            public void actionPerformed(ActionEvent evt) {
                String f = (String)JOptionPane.showInternalInputDialog(MyApp.this.theDesktop, "Enter value", "Set No. Iterations", 3, null, null, Integer.toString(ctscanner.numiter));
                try {
                    ctscanner.numiter = f == null ? ctscanner.numiter : Integer.parseInt(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        AbstractAction setfastaction = new AbstractAction("Fast"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.fast = true;
            }
        };
        AbstractAction setaccaction = new AbstractAction("Accurate"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.fast = false;
            }
        };
        AbstractAction setfiltcutoffaction = new AbstractAction("Set Filter Cut-Off"){

            public void actionPerformed(ActionEvent evt) {
                String f = (String)JOptionPane.showInternalInputDialog(MyApp.this.theDesktop, "Enter cutoff value", "Set Filter Cut-Off", 3, null, null, Double.toString(ctscanner.filtercutoff));
                try {
                    ctscanner.filtercutoff = f == null ? ctscanner.filtercutoff : Double.parseDouble(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        AbstractAction displaygraphaction = new AbstractAction("Graph Filters"){

            public void actionPerformed(ActionEvent event) {
                GraphicsFrame graphframe = new GraphicsFrame(ctscanner, 1);
                MyApp.this.theDesktop.add(graphframe);
                try {
                    graphframe.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
        AbstractAction setrampaction = new AbstractAction("Simple Ramp"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.filtername = "ramp";
            }
        };
        AbstractAction setshepplaction = new AbstractAction("Shepp-Logan"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.filtername = "shepplogan";
            }
        };
        AbstractAction sethammingaction = new AbstractAction("Hamming"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.filtername = "hamming";
            }
        };
        AbstractAction sethannaction = new AbstractAction("Hann"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.filtername = "hann";
            }
        };
        AbstractAction setcosineaction = new AbstractAction("Cosine"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.filtername = "cosine";
            }
        };
        AbstractAction setgaussianaction = new AbstractAction("Blackman"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.filtername = "blackman";
            }
        };
        AbstractAction setinterpnearestaction = new AbstractAction("Nearest"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.interp = "nearest";
            }
        };
        AbstractAction setinterplinearaction = new AbstractAction("Linear"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.interp = "linear";
            }
        };
        JMenu ReconstrMethodMenu = new JMenu("Method");
        JRadioButtonMenuItem FBPButton = new JRadioButtonMenuItem(setFBPaction);
        FBPButton.setSelected(true);
        JRadioButtonMenuItem IterativeButton = new JRadioButtonMenuItem(setIterativeaction);
        IterativeButton.setSelected(false);
        ButtonGroup groupm = new ButtonGroup();
        groupm.add(FBPButton);
        groupm.add(IterativeButton);
        ReconstrMethodMenu.add(FBPButton);
        ReconstrMethodMenu.add(IterativeButton);
        FBPButton.addActionListener(this);
        IterativeButton.addActionListener(this);
        JMenuItem setnumitersButton = new JMenuItem(setnumitersaction);
        setnumitersButton.setSelected(true);
        ReconstrMethodMenu.add(new JSeparator());
        ReconstrMethodMenu.add(setnumitersButton);
        JMenu ProjSpeedMenu = new JMenu("Reprojection");
        JRadioButtonMenuItem fastButton = new JRadioButtonMenuItem(setfastaction);
        fastButton.setSelected(false);
        JRadioButtonMenuItem accButton = new JRadioButtonMenuItem(setaccaction);
        accButton.setSelected(true);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(fastButton);
        group1.add(accButton);
        ProjSpeedMenu.add(fastButton);
        ProjSpeedMenu.add(accButton);
        fastButton.addActionListener(this);
        accButton.addActionListener(this);
        JMenu FilterMenu = new JMenu("Filter");
        this.filtercheckbox = new JCheckBoxMenuItem("Filtering");
        if (MyApp.ctscanner.filtering) {
            this.filtercheckbox.setSelected(true);
        }
        this.filtercheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (MyApp.this.filtercheckbox.isSelected()) {
                    ctscanner.filtering = true;
                }
                if (!MyApp.this.filtercheckbox.isSelected()) {
                    ctscanner.filtering = false;
                }
            }
        });
        JMenuItem setfiltcutoffButton = new JMenuItem(setfiltcutoffaction);
        setfiltcutoffButton.setSelected(true);
        JMenuItem displaygraphButton = new JMenuItem(displaygraphaction);
        displaygraphButton.setSelected(true);
        JRadioButtonMenuItem rampButton = new JRadioButtonMenuItem(setrampaction);
        rampButton.setSelected(true);
        JRadioButtonMenuItem shepplButton = new JRadioButtonMenuItem(setshepplaction);
        shepplButton.setSelected(false);
        JRadioButtonMenuItem hammingButton = new JRadioButtonMenuItem(sethammingaction);
        hammingButton.setSelected(false);
        JRadioButtonMenuItem hannButton = new JRadioButtonMenuItem(sethannaction);
        hannButton.setSelected(false);
        JRadioButtonMenuItem cosineButton = new JRadioButtonMenuItem(setcosineaction);
        cosineButton.setSelected(false);
        JRadioButtonMenuItem gaussianButton = new JRadioButtonMenuItem(setgaussianaction);
        gaussianButton.setSelected(false);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(rampButton);
        group2.add(hammingButton);
        group2.add(shepplButton);
        group2.add(hannButton);
        group2.add(cosineButton);
        group2.add(gaussianButton);
        FilterMenu.add(this.filtercheckbox);
        FilterMenu.add(setfiltcutoffButton);
        FilterMenu.add(displaygraphButton);
        FilterMenu.add(new JSeparator());
        FilterMenu.add(rampButton);
        FilterMenu.add(shepplButton);
        FilterMenu.add(hammingButton);
        FilterMenu.add(hannButton);
        FilterMenu.add(cosineButton);
        FilterMenu.add(gaussianButton);
        JMenu InterpMenu = new JMenu("Interpolation");
        JRadioButtonMenuItem interp1Button = new JRadioButtonMenuItem(setinterpnearestaction);
        interp1Button.setSelected(false);
        JRadioButtonMenuItem interp2Button = new JRadioButtonMenuItem(setinterplinearaction);
        interp2Button.setSelected(true);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(interp1Button);
        group3.add(interp2Button);
        InterpMenu.add(interp1Button);
        InterpMenu.add(interp2Button);
        JMenu NoiseMenu = new JMenu("Noise");
        JRadioButtonMenuItem nonoisebutton = new JRadioButtonMenuItem("No Noise");
        JRadioButtonMenuItem addnoisebutton = new JRadioButtonMenuItem("Add Noise to Data");
        JRadioButtonMenuItem addnoisereconbutton = new JRadioButtonMenuItem("Reconstruct with Noise");
        nonoisebutton.setSelected(true);
        addnoisebutton.setSelected(false);
        addnoisereconbutton.setSelected(false);
        nonoisebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ctscanner.noise = "none";
            }
        });
        addnoisebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ctscanner.noise = "addtoproj";
            }
        });
        addnoisereconbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ctscanner.noise = "reconwithnoise";
                System.out.println("***" + ctscanner.noise);
            }
        });
        ButtonGroup noisegrp = new ButtonGroup();
        noisegrp.add(nonoisebutton);
        noisegrp.add(addnoisebutton);
        noisegrp.add(addnoisereconbutton);
        NoiseMenu.add(nonoisebutton);
        NoiseMenu.add(addnoisebutton);
        NoiseMenu.add(addnoisereconbutton);
        AbstractAction setnoiselevelaction = new AbstractAction("Set Count Rate"){

            public void actionPerformed(ActionEvent evt) {
                String f = (String)JOptionPane.showInternalInputDialog(MyApp.this.theDesktop, "Enter Counts ", "Set Count Rate", 3, null, null, Double.toString(ctscanner.rate));
                try {
                    ctscanner.rate = f == null ? ctscanner.rate : Double.parseDouble(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        NoiseMenu.add(new JSeparator());
        JMenuItem setnoiselevelButton = new JMenuItem(setnoiselevelaction);
        setnoiselevelButton.setSelected(true);
        NoiseMenu.add(setnoiselevelButton);
        JMenu ROIMenu = new JMenu("ROI");
        this.truncatecheckbox = new JCheckBoxMenuItem("Truncate");
        this.truncatecheckbox.addItemListener(this);
        if (MyApp.ctscanner.truncate) {
            this.truncatecheckbox.setSelected(true);
        }
        this.ROIcropcheckbox = new JCheckBoxMenuItem("Crop to ROI");
        if (MyApp.ctscanner.roicrop) {
            this.ROIcropcheckbox.setSelected(true);
        }
        this.ROIcropcheckbox.addItemListener(this);
        this.ROIcirclecheckbox = new JCheckBoxMenuItem("Add ROI outline");
        if (MyApp.ctscanner.displayroicircle) {
            this.ROIcirclecheckbox.setSelected(true);
        }
        this.ROIcirclecheckbox.addItemListener(this);
        AbstractAction settruncatewidthaction = new AbstractAction("Set ROI Radius"){

            public void actionPerformed(ActionEvent evt) {
                String f = (String)JOptionPane.showInternalInputDialog(MyApp.this.theDesktop, "Enter ROI Width (0 to .5)", "Set ROI Radius", 3, null, null, Double.toString(ctscanner.truncatewidth));
                try {
                    ctscanner.truncatewidth = f == null ? ctscanner.truncatewidth : Double.parseDouble(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        JMenuItem settruncatewidthButton = new JMenuItem(settruncatewidthaction);
        settruncatewidthButton.setSelected(true);
        AbstractAction setfactoraction = new AbstractAction("Set extrap factor"){

            public void actionPerformed(ActionEvent evt) {
                String f = (String)JOptionPane.showInternalInputDialog(MyApp.this.theDesktop, "Enter factor ", "Set factor", 3, null, null, Double.toString(ctscanner.factor));
                try {
                    ctscanner.factor = f == null ? ctscanner.factor : Double.parseDouble(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        JMenuItem setfactorButton = new JMenuItem(setfactoraction);
        setfactorButton.setSelected(true);
        this.keepcurrentextrapwidthscheckbox = new JCheckBoxMenuItem("Use Current Extrap Widths");
        if (MyApp.ctscanner.keepcurrentextrapwidths) {
            this.keepcurrentextrapwidthscheckbox.setSelected(true);
        }
        this.keepcurrentextrapwidthscheckbox.addItemListener(this);
        this.setedgezerocheckbox = new JCheckBoxMenuItem("Set Edge to Zero");
        if (MyApp.ctscanner.setedgezero) {
            this.setedgezerocheckbox.setSelected(true);
        }
        this.setedgezerocheckbox.addItemListener(this);
        AbstractAction truncatemethod0action = new AbstractAction("none"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.truncmethod = "none";
            }
        };
        AbstractAction truncatemethod1action = new AbstractAction("simple cos-squared"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.truncmethod = "simple cos-squared";
            }
        };
        AbstractAction truncatemethod2action = new AbstractAction("adaptive cos-squared"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.truncmethod = "adaptive cos-squared";
            }
        };
        AbstractAction truncatemethod5action = new AbstractAction("simple square root"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.truncmethod = "simple square root";
            }
        };
        AbstractAction truncatemethod3action = new AbstractAction("vangompel"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.truncmethod = "vangompel";
            }
        };
        AbstractAction truncatemethod4action = new AbstractAction("HDT"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.truncmethod = "HDT";
            }
        };
        JMenu truncatemethodMenu = new JMenu("Method");
        JRadioButtonMenuItem truncatemethod0Button = new JRadioButtonMenuItem(truncatemethod0action);
        truncatemethod0Button.setSelected(false);
        JRadioButtonMenuItem truncatemethod1Button = new JRadioButtonMenuItem(truncatemethod1action);
        truncatemethod1Button.setSelected(true);
        JRadioButtonMenuItem truncatemethod2Button = new JRadioButtonMenuItem(truncatemethod2action);
        truncatemethod2Button.setSelected(false);
        JRadioButtonMenuItem truncatemethod5Button = new JRadioButtonMenuItem(truncatemethod5action);
        truncatemethod5Button.setSelected(false);
        JRadioButtonMenuItem truncatemethod3Button = new JRadioButtonMenuItem(truncatemethod3action);
        truncatemethod3Button.setSelected(false);
        JRadioButtonMenuItem truncatemethod4Button = new JRadioButtonMenuItem(truncatemethod4action);
        truncatemethod4Button.setSelected(false);
        ButtonGroup truncgrp = new ButtonGroup();
        truncgrp.add(truncatemethod0Button);
        truncgrp.add(truncatemethod1Button);
        truncgrp.add(truncatemethod2Button);
        truncgrp.add(truncatemethod3Button);
        truncgrp.add(truncatemethod4Button);
        truncgrp.add(truncatemethod5Button);
        truncatemethodMenu.add(truncatemethod0Button);
        truncatemethodMenu.add(truncatemethod1Button);
        truncatemethodMenu.add(truncatemethod2Button);
        truncatemethodMenu.add(truncatemethod3Button);
        truncatemethodMenu.add(truncatemethod4Button);
        truncatemethodMenu.add(truncatemethod5Button);
        ROIMenu.add(this.truncatecheckbox);
        ROIMenu.add(this.ROIcropcheckbox);
        ROIMenu.add(this.ROIcirclecheckbox);
        ROIMenu.add(settruncatewidthButton);
        ROIMenu.add(setfactorButton);
        ROIMenu.add(this.setedgezerocheckbox);
        ROIMenu.add(this.keepcurrentextrapwidthscheckbox);
        ROIMenu.add(new JSeparator());
        ROIMenu.add(truncatemethodMenu);
        JMenu AnimateMenu = new JMenu("Animate");
        this.animatecheckbox = new JCheckBoxMenuItem("Animate Back Proj.");
        if (MyApp.ctscanner.animate) {
            this.animatecheckbox.setSelected(true);
        }
        this.animatecheckbox.addItemListener(this);
        AnimateMenu.add(this.animatecheckbox);
        rootMenu.add(ReconstrMethodMenu);
        rootMenu.add(ProjSpeedMenu);
        rootMenu.add(FilterMenu);
        rootMenu.add(InterpMenu);
        rootMenu.add(NoiseMenu);
        rootMenu.add(ROIMenu);
        rootMenu.add(AnimateMenu);
    }

    private void createPhantomMenu(JMenu rootMenu) {
        AbstractAction phantomrasterizeAction = new AbstractAction("Phantom Image"){

            public void actionPerformed(ActionEvent evt) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        InternalImageFrame frame = new InternalImageFrame();
                        BufferedImage phtimg = ctscanner.CreatePhantomRaster();
                        Container container = frame.getContentPane();
                        ImagePanel panel = new ImagePanel();
                        panel.loadBufferedImage(phtimg);
                        frame.PANELTYPE = 2;
                        container.add((Component)panel, "Center");
                        frame.imagepanel = panel;
                        frame.pack();
                        frame.setVisible(true);
                        MyApp.this.theDesktop.add(frame);
                        try {
                            frame.setSelected(true);
                        }
                        catch (PropertyVetoException s) {
                            // empty catch block
                        }
                        return phtimg;
                    }

                    public void finished() {
                    }
                };
                worker.start();
            }
        };
        AbstractAction shepplogphantomAction = new AbstractAction("SheppLogan"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "sheppl";
            }
        };
        AbstractAction test1phantomAction = new AbstractAction("Test Object1"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "test1";
            }
        };
        AbstractAction test2phantomAction = new AbstractAction("Test Object2"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "test2";
            }
        };
        AbstractAction test3phantomAction = new AbstractAction("Test Object3"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "test3";
            }
        };
        AbstractAction test4phantomAction = new AbstractAction("Test Object4"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "test4";
            }
        };
        AbstractAction deltaphantomAction = new AbstractAction("Delta Func."){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "delta";
            }
        };
        AbstractAction dotsphantomAction = new AbstractAction("Bead"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "bead";
            }
        };
        AbstractAction barphantomAction = new AbstractAction("Bars"){

            public void actionPerformed(ActionEvent evt) {
                ctscanner.phantomname = "bars";
            }
        };
        JMenu selectPhantomMenu = new JMenu("Select");
        JRadioButtonMenuItem shepplogphantomButton = new JRadioButtonMenuItem(shepplogphantomAction);
        shepplogphantomButton.setSelected(true);
        JRadioButtonMenuItem test1phantomButton = new JRadioButtonMenuItem(test1phantomAction);
        test1phantomButton.setSelected(false);
        JRadioButtonMenuItem test2phantomButton = new JRadioButtonMenuItem(test2phantomAction);
        test2phantomButton.setSelected(false);
        JRadioButtonMenuItem test3phantomButton = new JRadioButtonMenuItem(test3phantomAction);
        test3phantomButton.setSelected(false);
        JRadioButtonMenuItem test4phantomButton = new JRadioButtonMenuItem(test4phantomAction);
        test4phantomButton.setSelected(false);
        JRadioButtonMenuItem deltaphantomButton = new JRadioButtonMenuItem(deltaphantomAction);
        deltaphantomButton.setSelected(false);
        JRadioButtonMenuItem dotsphantomButton = new JRadioButtonMenuItem(dotsphantomAction);
        dotsphantomButton.setSelected(false);
        JRadioButtonMenuItem barphantomButton = new JRadioButtonMenuItem(barphantomAction);
        barphantomButton.setSelected(false);
        selectPhantomMenu.add(shepplogphantomButton);
        selectPhantomMenu.add(test1phantomButton);
        selectPhantomMenu.add(test2phantomButton);
        selectPhantomMenu.add(test3phantomButton);
        selectPhantomMenu.add(test4phantomButton);
        selectPhantomMenu.add(deltaphantomButton);
        selectPhantomMenu.add(dotsphantomButton);
        selectPhantomMenu.add(barphantomButton);
        ButtonGroup groupph = new ButtonGroup();
        groupph.add(shepplogphantomButton);
        groupph.add(test1phantomButton);
        groupph.add(test2phantomButton);
        groupph.add(test3phantomButton);
        groupph.add(test4phantomButton);
        groupph.add(deltaphantomButton);
        groupph.add(dotsphantomButton);
        groupph.add(barphantomButton);
        rootMenu.add(selectPhantomMenu);
        JMenuItem projectphantomButton = new JMenuItem(this.projPhantomAction);
        rootMenu.add(projectphantomButton);
        JMenuItem phantomrasterizeButton = new JMenuItem(phantomrasterizeAction);
        rootMenu.add(phantomrasterizeButton);
        rootMenu.add(new JSeparator());
        JMenuItem drawCustomPhantomButton = new JMenuItem(this.drawCustomPhantomAction);
        rootMenu.add(drawCustomPhantomButton);
    }

    protected static ImageIcon createIcon(String imageName) {
        String imgLocation = "images/" + imageName + ".png";
        URL imageURL = MyApp.class.getResource(imgLocation);
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    private void createimageToolBar() {
        ImageIcon icon;
        JButton button = null;
        this.imagetoolBar = new JToolBar("Image Tools", 0);
        button = new JButton(this.openimageAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.saveimageAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.blurAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.sharpenAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.invertAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.brightenAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.darkenAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.greyscaleAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.scaleAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        this.imagetoolBar.addSeparator();
        button = new JButton(this.addimagesAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.subimagesAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.divimagesAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton(this.showhistogramAction);
        if (button.getIcon() != null) {
            button.setText("");
        }
        this.imagetoolBar.add(button);
        button = new JButton("gauss");
        if (button.getIcon() != null) {
            button.setText("gauss");
            icon = new ImageIcon("gauss.png");
            button.setIcon(icon);
        }
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InternalImageFrame frame = new InternalImageFrame();
                Container container = frame.getContentPane();
                ImagePanel panel = new ImagePanel();
                double[][] temp = ctscanner.Create2DGaussian(256);
                BufferedImage img = ctscanner.CreateImagefromArray(temp, Utils.getMax(temp), 0);
                panel.loadBufferedImage(img);
                frame.PANELTYPE = 2;
                container.add((Component)panel, "Center");
                frame.imagepanel = panel;
                frame.pack();
                frame.setVisible(true);
                MyApp.this.theDesktop.add(frame);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
            }
        });
        this.imagetoolBar.add(button);
        button = new JButton("Apply");
        if (button.getIcon() != null) {
            button.setText("apply");
            icon = new ImageIcon("gauss.png");
            button.setIcon(icon);
        }
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JInternalFrame frame = MyApp.this.theDesktop.getSelectedFrame();
                String cls = frame.getClass().getName();
                if (cls == "myctapp.InternalImageFrame") {
                    InternalImageFrame currframe = (InternalImageFrame)frame;
                    currframe.imagepanel.ApplyChanges();
                }
            }
        });
        this.imagetoolBar.add(button);
    }

    private void createtextfieldPanel() {
        this.textfieldPanel = new JPanel();
        SpringLayout layout = new SpringLayout();
        this.textfieldPanel.setLayout(layout);
        this.scansFormat = NumberFormat.getNumberInstance();
        this.scansLabel = new JLabel(scansString);
        this.scansLabel.setFont(theMainFont);
        this.scansField = new JFormattedTextField(this.scansFormat);
        this.scansField.setValue(new Integer(MyApp.ctscanner.scans));
        this.scansField.setColumns(3);
        this.scansField.addPropertyChangeListener("value", this);
        this.scansLabel.setLabelFor(this.scansField);
        this.textfieldPanel.add(this.scansLabel);
        this.textfieldPanel.add(this.scansField);
        this.stepsizeFormat = NumberFormat.getNumberInstance();
        this.stepsizeLabel = new JLabel(stepsizeString);
        this.stepsizeLabel.setFont(theMainFont);
        this.stepsizeField = new JFormattedTextField(this.stepsizeFormat);
        this.stepsizeField.setValue(new Float(MyApp.ctscanner.stepsize));
        this.stepsizeField.setColumns(3);
        this.stepsizeField.addPropertyChangeListener("value", this);
        this.stepsizeLabel.setLabelFor(this.stepsizeField);
        this.textfieldPanel.add(this.stepsizeLabel);
        this.textfieldPanel.add(this.stepsizeField);
        this.viewsFormat = NumberFormat.getNumberInstance();
        this.viewsLabel = new JLabel(viewsString);
        this.viewsLabel.setFont(theMainFont);
        this.viewsField = new JFormattedTextField(this.viewsFormat);
        this.viewsField.setValue(new Integer(MyApp.ctscanner.views));
        this.viewsField.setColumns(3);
        this.viewsField.setEditable(false);
        this.viewsField.addPropertyChangeListener("value", this);
        this.viewsLabel.setLabelFor(this.viewsField);
        this.textfieldPanel.add(this.viewsLabel);
        this.textfieldPanel.add(this.viewsField);
        this.imgsizeFormat = NumberFormat.getNumberInstance();
        this.imgsizeLabel = new JLabel(imgsizeString);
        this.imgsizeLabel.setFont(theMainFont);
        this.imgsizeField = new JFormattedTextField(this.imgsizeFormat);
        this.imgsizeField.setValue(new Integer(MyApp.ctscanner.outputimgsize));
        this.imgsizeField.setColumns(3);
        this.imgsizeField.addPropertyChangeListener("value", this);
        this.imgsizeLabel.setLabelFor(this.imgsizeField);
        this.textfieldPanel.add(this.imgsizeLabel);
        this.textfieldPanel.add(this.imgsizeField);
        this.zoomFormat = NumberFormat.getNumberInstance();
        this.zoomLabel = new JLabel(zoomString);
        this.zoomLabel.setFont(theMainFont);
        this.zoomField = new JFormattedTextField(this.zoomFormat);
        this.zoomField.setValue(new Double(MyApp.ctscanner.zoom));
        this.zoomField.setColumns(3);
        this.zoomField.addPropertyChangeListener("value", this);
        this.zoomLabel.setLabelFor(this.zoomField);
        this.textfieldPanel.add(this.zoomLabel);
        this.textfieldPanel.add(this.zoomField);
        this.offsetFormat = NumberFormat.getNumberInstance();
        this.xoffsetLabel = new JLabel(xoffsetString);
        this.xoffsetLabel.setFont(smallFont);
        this.xoffsetField = new JFormattedTextField(this.offsetFormat);
        this.xoffsetField.setFont(smallFont);
        this.xoffsetField.setValue(new Double(MyApp.ctscanner.xoffset));
        this.xoffsetField.setColumns(3);
        this.xoffsetField.addPropertyChangeListener("value", this);
        this.xoffsetLabel.setLabelFor(this.xoffsetField);
        this.yoffsetLabel = new JLabel(yoffsetString);
        this.yoffsetLabel.setFont(smallFont);
        this.yoffsetField = new JFormattedTextField(this.offsetFormat);
        this.yoffsetField.setFont(smallFont);
        this.yoffsetField.setValue(new Double(MyApp.ctscanner.yoffset));
        this.yoffsetField.setColumns(3);
        this.yoffsetField.addPropertyChangeListener("value", this);
        this.yoffsetLabel.setLabelFor(this.yoffsetField);
        this.textfieldPanel.add(this.xoffsetLabel);
        this.textfieldPanel.add(this.yoffsetLabel);
        this.textfieldPanel.add(this.xoffsetField);
        this.textfieldPanel.add(this.yoffsetField);
        SpringUtilities.makeCompactGrid(this.textfieldPanel, 7, 2, 2, 2, 2, 2);
    }

    private void createSliders() {
        int n = 2;
        this.mSlider1 = new MThumbSlider(n);
        this.mSlider1.setOrientation(1);
        this.mSlider1.setMinimum(0);
        this.mSlider1.setMaximum(2000);
        this.mSlider1.setValueAt(0, 0);
        this.mSlider1.setValueAt(2000, 1);
        this.mSlider1.setPaintTicks(true);
        this.mSlider1.setMajorTickSpacing(512);
        this.mSlider1.setMinorTickSpacing(128);
        this.mSlider1.setFillColorAt(Color.black, 0);
        this.mSlider1.setFillColorAt(new Color(103, 104, 156), 1);
        this.mSlider1.setTrackFillColor(Color.white);
        this.mSlider1.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.mSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MThumbSlider mSlider = (MThumbSlider)evt.getSource();
                if (!mSlider.getValueIsAdjusting()) {
                    int value1 = mSlider.getValueAt(0);
                    int value2 = mSlider.getValueAt(1);
                    System.out.println("val1: " + value1);
                    System.out.println("val2: " + value2);
                    try {
                        InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
                        currframe.imagepanel.lowerwinlvl = value1;
                        currframe.imagepanel.upperwinlvl = value2;
                        MyApp.this.lowerlevelField.setValue(new Integer(value1));
                        MyApp.this.upperlevelField.setValue(new Integer(value2));
                        currframe.imagepanel.PerformWindowing();
                    }
                    catch (NullPointerException s) {
                        // empty catch block
                    }
                }
            }
        });
        this.sliderPanel = new JPanel();
        this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 0));
        this.sliderPanel.setBorder(new EtchedBorder());
        this.sliderPanel.setPreferredSize(new Dimension(50, 155));
        this.sliderPanel.setMaximumSize(new Dimension(50, 155));
        this.mSlider1.setAlignmentX(0.0f);
        this.mSlider1.setPreferredSize(new Dimension(45, 145));
        this.mSlider1.setMinimumSize(new Dimension(40, 145));
        this.mSlider1.setMaximumSize(this.sliderPanel.getPreferredSize());
        this.sliderPanel.add(this.mSlider1);
    }

    private void createwindowingPanel() {
        this.winPanel = new JPanel();
        this.winPanel.setPreferredSize(new Dimension(40, 155));
        SpringLayout layout = new SpringLayout();
        this.winPanel.setLayout(layout);
        JPanel thumbPanel = new JPanel();
        this.winPanel.add(thumbPanel);
        thumbPanel.setPreferredSize(new Dimension(35, 25));
        JLabel templabel = new JLabel("depth:");
        templabel.setFont(smallFont);
        this.winPanel.add(templabel);
        NumberFormat numFormat = NumberFormat.getNumberInstance();
        this.bitdepthField = new JFormattedTextField(numFormat);
        this.bitdepthField.setPreferredSize(new Dimension(10, 8));
        this.bitdepthField.setFont(smallFont);
        this.bitdepthField.setValue(new Integer(0));
        this.bitdepthField.setColumns(2);
        this.bitdepthField.setEditable(false);
        this.bitdepthField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.winPanel.add(this.bitdepthField);
        this.upperlevelFormat = NumberFormat.getNumberInstance();
        this.upperlevelLabel = new JLabel("upper");
        this.upperlevelLabel.setFont(smallFont);
        this.upperlevelField = new JFormattedTextField(this.upperlevelFormat);
        this.upperlevelField.setValue(new Integer(2000));
        this.upperlevelField.setEditable(false);
        this.upperlevelField.setColumns(4);
        this.upperlevelField.setFont(smallFont);
        this.upperlevelField.setBackground(new Color(255, 255, 155));
        this.upperlevelField.addPropertyChangeListener("value", this);
        this.upperlevelLabel.setLabelFor(this.upperlevelField);
        this.winPanel.add(this.upperlevelLabel);
        this.winPanel.add(this.upperlevelField);
        this.lowerlevelFormat = NumberFormat.getNumberInstance();
        this.lowerlevelLabel = new JLabel("lower");
        this.lowerlevelLabel.setFont(smallFont);
        this.lowerlevelField = new JFormattedTextField(this.lowerlevelFormat);
        this.lowerlevelField.setValue(new Integer(0));
        this.lowerlevelField.setEditable(false);
        this.lowerlevelField.setColumns(4);
        this.lowerlevelField.setFont(smallFont);
        this.lowerlevelField.setBackground(new Color(255, 255, 155));
        this.lowerlevelField.addPropertyChangeListener("value", this);
        this.lowerlevelLabel.setLabelFor(this.lowerlevelField);
        this.winPanel.add(this.lowerlevelLabel);
        this.winPanel.add(this.lowerlevelField);
        JButton resetwinlvlbutton = new JButton("reset");
        resetwinlvlbutton.setMargin(new Insets(0, 0, 2, 0));
        resetwinlvlbutton.setSize(new Dimension(25, 22));
        this.winPanel.add(resetwinlvlbutton);
        resetwinlvlbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
                    currframe.imagepanel.resetWindowLevels();
                    currframe.imagepanel.PerformWindowing();
                    if (currframe.imagepanel.getStackSize() > 1) {
                        currframe.imagepanel.windowing = false;
                    }
                    if (currframe.imagepanel.getImageType() == 11) {
                        MyApp.this.lowerlevelField.setValue(new Integer(0));
                        MyApp.this.upperlevelField.setValue(new Integer(2000));
                        MyApp.this.mSlider1.setMaximum(2000);
                    } else {
                        MyApp.this.lowerlevelField.setValue(new Integer(0));
                        MyApp.this.upperlevelField.setValue(new Integer(255));
                        MyApp.this.mSlider1.setMaximum(255);
                    }
                    MyApp.this.mSlider1.ResetThumbs();
                    MyApp.this.mSlider1.repaint();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        SpringUtilities.makeCompactGrid(this.winPanel, 8, 1, 2, 2, 1, 1);
        this.windowingPanel = new JPanel();
        this.windowingPanel.setLayout(new BorderLayout());
        this.windowingPanel.setBorder(BorderFactory.createTitledBorder("Window Lvl"));
        this.createSliders();
        this.windowingPanel.add((Component)this.sliderPanel, "West");
        this.windowingPanel.add((Component)this.winPanel, "East");
    }

    private void createInfoPanel() {
        this.imginfoPanel = ImagePanel.imageinfopanel = new InfoPanel();
    }

    private void createwidgetPanel() {
        Font theMainFont = new Font("SansSerif", 0, 11);
        UIManager.put("Button.font", theMainFont);
        UIManager.put("Label.font", theMainFont);
        UIManager.put("JCheckBox.font", theMainFont);
        this.widgetPanel = new JPanel();
        this.widgetPanel.setPreferredSize(new Dimension(100, 300));
        FlowLayout thelayout = new FlowLayout(1, 2, 2);
        this.widgetPanel.setLayout(thelayout);
        JButton projphantomButton = new JButton(this.projPhantomAction);
        projphantomButton.setPreferredSize(new Dimension(100, 26));
        projphantomButton.setMargin(new Insets(0, 0, 2, 0));
        JButton openimagebutton = new JButton(this.openimageAction);
        openimagebutton.setPreferredSize(new Dimension(100, 26));
        openimagebutton.setMargin(new Insets(0, 0, 2, 0));
        JButton createsinogramButton = new JButton(this.createSinogramAction);
        createsinogramButton.setPreferredSize(new Dimension(100, 26));
        createsinogramButton.setMargin(new Insets(0, 0, 2, 0));
        JButton loadsinogramButton = new JButton(this.loadSinogramAction);
        loadsinogramButton.setPreferredSize(new Dimension(100, 26));
        loadsinogramButton.setMargin(new Insets(0, 0, 2, 0));
        JButton createBPImageButton = new JButton(this.createBPImageAction);
        createBPImageButton.setPreferredSize(new Dimension(100, 26));
        createBPImageButton.setMargin(new Insets(0, 0, 2, 0));
        JButton createProjfromImageButton = new JButton(this.createProjfromImageAction);
        createProjfromImageButton.setPreferredSize(new Dimension(100, 26));
        createProjfromImageButton.setMargin(new Insets(0, 0, 2, 0));
        JButton displayprojButton = new JButton("Visualize");
        displayprojButton.setPreferredSize(new Dimension(100, 26));
        JButton quitButton = new JButton(this.quitAction);
        quitButton.setPreferredSize(new Dimension(100, 30));
        displayprojButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GraphicsFrame graphframe = new GraphicsFrame(ctscanner, 0);
                MyApp.this.theDesktop.add(graphframe);
                try {
                    graphframe.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        this.widgetPanel.add(projphantomButton);
        this.widgetPanel.add(openimagebutton);
        this.widgetPanel.add(createsinogramButton);
        this.widgetPanel.add(loadsinogramButton);
        this.widgetPanel.add(createBPImageButton);
        this.widgetPanel.add(createProjfromImageButton);
        this.widgetPanel.add(displayprojButton);
        this.createtextfieldPanel();
        this.widgetPanel.add(this.textfieldPanel);
        this.createwindowingPanel();
        this.widgetPanel.add(this.windowingPanel);
        this.createInfoPanel();
        this.widgetPanel.add(this.imginfoPanel);
        this.widgetPanel.add(quitButton);
    }

    private void createGUI() {
        ctscanner = new CTScanner();
        this.theDesktop = new MDIDesktopPane();
        this.theDesktop.setBackground(new Color(102, 100, 165));
        this.frameListener = new FrameListener();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.theDesktop);
        this.getContentPane().add(this.scrollPane);
        this.setJMenuBar(this.createMenuBar());
        this.createwidgetPanel();
        this.getContentPane().add((Component)this.widgetPanel, "After");
        this.createimageToolBar();
        this.getContentPane().add((Component)this.imagetoolBar, "Last");
    }

    public MyApp() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MyApp.this.setDefaultCloseOperation(3);
                MyApp.this.createActions();
                MyApp.this.createGUI();
                MyApp.this.pack();
                MyApp.this.setVisible(true);
                MyApp.this.setTitle("LearnCT");
            }
        });
    }

    public void UpdateWindowingPanel(InternalImageFrame frame) {
        try {
            int type = frame.imagepanel.getImageType();
            if (frame.imagepanel.getImageType() == 11) {
                this.lowerlevelField.setValue(new Integer(0));
                this.upperlevelField.setValue(new Integer(2095));
                this.mSlider1.setMaximum(2095);
            } else {
                this.lowerlevelField.setValue(new Integer(0));
                this.upperlevelField.setValue(new Integer(255));
                this.mSlider1.setMaximum(255);
            }
            this.bitdepthField.setValue(new Integer(type));
            this.winPanel.repaint();
            this.lower = frame.imagepanel.lowerwinlvl;
            this.lowerlevelField.setValue(new Integer(this.lower));
            this.mSlider1.setValueAt(this.lower, 0);
            this.upper = frame.imagepanel.upperwinlvl;
            this.upperlevelField.setValue(new Integer(this.upper));
            this.mSlider1.setValueAt(this.upper, 1);
            this.sliderPanel.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if ("quit".equals(e.getActionCommand())) {
            this.quit();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.memmonitor.surf.stop();
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.filtercheckbox) {
            if (this.filtercheckbox.isSelected()) {
                MyApp.ctscanner.filtering = true;
            }
            if (!this.filtercheckbox.isSelected()) {
                MyApp.ctscanner.filtering = false;
            }
        } else if (source == this.truncatecheckbox) {
            if (this.truncatecheckbox.isSelected()) {
                MyApp.ctscanner.truncate = true;
            }
            if (!this.truncatecheckbox.isSelected()) {
                MyApp.ctscanner.truncate = false;
            }
        } else if (source == this.ROIcropcheckbox) {
            if (this.ROIcropcheckbox.isSelected()) {
                MyApp.ctscanner.roicrop = true;
            }
            if (!this.ROIcropcheckbox.isSelected()) {
                MyApp.ctscanner.roicrop = false;
            }
        } else if (source == this.ROIcirclecheckbox) {
            if (this.ROIcirclecheckbox.isSelected()) {
                MyApp.ctscanner.displayroicircle = true;
            }
            if (!this.ROIcirclecheckbox.isSelected()) {
                MyApp.ctscanner.displayroicircle = false;
            }
        } else if (source == this.setedgezerocheckbox) {
            if (this.setedgezerocheckbox.isSelected()) {
                MyApp.ctscanner.setedgezero = true;
            }
            if (!this.setedgezerocheckbox.isSelected()) {
                MyApp.ctscanner.setedgezero = false;
            }
        } else if (source == this.keepcurrentextrapwidthscheckbox) {
            if (this.keepcurrentextrapwidthscheckbox.isSelected()) {
                MyApp.ctscanner.keepcurrentextrapwidths = true;
            }
            if (!this.keepcurrentextrapwidthscheckbox.isSelected()) {
                MyApp.ctscanner.keepcurrentextrapwidths = false;
            }
        } else if (source == this.animatecheckbox) {
            if (this.animatecheckbox.isSelected()) {
                MyApp.ctscanner.animate = true;
            }
            if (!this.animatecheckbox.isSelected()) {
                MyApp.ctscanner.animate = false;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.scansField) {
            MyApp.ctscanner.scans = ((Number)this.scansField.getValue()).intValue();
            System.out.println(MyApp.ctscanner.scans);
        } else if (source == this.stepsizeField) {
            MyApp.ctscanner.stepsize = ((Number)this.stepsizeField.getValue()).floatValue();
            ctscanner.resetviews();
            this.viewsField.setValue(new Integer(MyApp.ctscanner.views));
            System.out.println(MyApp.ctscanner.stepsize);
        } else if (source == this.imgsizeField) {
            int outputimgsize;
            MyApp.ctscanner.outputimgsize = outputimgsize = ((Number)this.imgsizeField.getValue()).intValue();
            System.out.println(MyApp.ctscanner.outputimgsize);
        } else if (source == this.zoomField) {
            double zoom;
            MyApp.ctscanner.zoom = zoom = ((Number)this.zoomField.getValue()).doubleValue();
            System.out.println(MyApp.ctscanner.zoom);
        } else if (source == this.xoffsetField) {
            double xoffset;
            MyApp.ctscanner.xoffset = xoffset = ((Number)this.xoffsetField.getValue()).doubleValue();
            System.out.println(MyApp.ctscanner.xoffset);
        } else if (source == this.yoffsetField) {
            double yoffset;
            MyApp.ctscanner.yoffset = yoffset = ((Number)this.yoffsetField.getValue()).doubleValue();
            System.out.println(MyApp.ctscanner.yoffset);
        } else if (source == this.lowerlevelField) {
            this.lower = ((Number)this.lowerlevelField.getValue()).intValue();
        } else if (source == this.upperlevelField) {
            this.upper = ((Number)this.upperlevelField.getValue()).intValue();
        }
    }

    public double getDoublefromDialog(String prompt) {
        Object[] commentArray = new Object[]{prompt, "", ""};
        Object[] options = new Object[]{"OK", "Cancel"};
        String inputValue = "";
        boolean validResponse = false;
        double response = 1.0;
        while (!validResponse) {
            JOptionPane optionPane = new JOptionPane(commentArray, -1, 2, null, options, options[0]);
            optionPane.setWantsInput(true);
            JDialog dialog = optionPane.createDialog(null, INT_TITLE);
            dialog.pack();
            dialog.setVisible(true);
            String result = (String)optionPane.getInputValue();
            try {
                response = Double.parseDouble(result);
                response = Double.parseDouble(result);
                validResponse = true;
            }
            catch (NumberFormatException exception) {
                if (result.equals("uninitializedValue")) {
                    result = "";
                }
                commentArray[1] = "Invalid int: " + result;
                commentArray[2] = "Enter a valid integer";
            }
        }
        return response;
    }

    protected void quit() {
        System.exit(0);
    }

    public void displaySplash() {
        Frame splashFrame = null;
        URL imageURL = MyApp.class.getResource("images/splash.png");
        if (imageURL != null) {
            splashFrame = SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        } else {
            System.err.println("Splash image not found");
        }
    }

    public void LNFSwitcher() {
        this.theFrame = new JInternalFrame("LNF Switcher");
        this.theFrame.setDefaultCloseOperation(3);
        this.theFrame.pack();
        this.theDesktop.add(this.theFrame);
        this.theFrame.setVisible(true);
        Container cp = this.theFrame.getContentPane();
        cp.setLayout(new FlowLayout());
        ButtonGroup bg = new ButtonGroup();
        JRadioButton bJava = new JRadioButton("Java");
        bJava.addActionListener(new LNFSetter(PREFERREDLOOKANDFEELNAME, bJava));
        bg.add(bJava);
        cp.add(bJava);
        JRadioButton bMSW = new JRadioButton("MS-Windows");
        bMSW.addActionListener(new LNFSetter("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", bMSW));
        bg.add(bMSW);
        cp.add(bMSW);
        JRadioButton bMotif = new JRadioButton("Motif");
        bMotif.addActionListener(new LNFSetter("com.sun.java.swing.plaf.motif.MotifLookAndFeel", bMotif));
        bg.add(bMotif);
        cp.add(bMotif);
        String defaultLookAndFeel = UIManager.getSystemLookAndFeelClassName();
        JRadioButton bDefault = new JRadioButton("Default");
        bDefault.addActionListener(new LNFSetter(defaultLookAndFeel, bDefault));
        bg.add(bDefault);
        cp.add(bDefault);
        this.previousButton = bDefault;
        this.previousButton.setSelected(true);
        this.theFrame.pack();
        this.theFrame.setVisible(true);
    }

    public static void main(String[] args) {
        MyApp theapp = new MyApp();
        MyApp.setDefaultLookAndFeelDecorated(true);
    }

    static /* synthetic */ double[][] access$902(MyApp x0, double[][] x1) {
        x0.clipboarddata = x1;
        return x1;
    }

    class LNFSetter
    implements ActionListener {
        String theLNFName;
        JRadioButton thisButton;

        LNFSetter(String lnfName, JRadioButton me) {
            this.theLNFName = lnfName;
            this.thisButton = me;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.theLNFName);
                SwingUtilities.updateComponentTreeUI(MyApp.this.theFrame);
                MyApp.this.theFrame.pack();
            }
            catch (Exception evt) {
                JOptionPane.showMessageDialog(null, "setLookAndFeel didn't work: " + evt, "UI Failure", 1);
                MyApp.this.previousButton.setSelected(true);
            }
            MyApp.this.previousButton = this.thisButton;
        }
    }

    class FrameListener
    implements InternalFrameListener {
        FrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)e.getInternalFrame();
            MyApp.this.UpdateWindowingPanel(currframe);
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)e.getInternalFrame();
            currframe.imagepanel.closed = true;
            ctscanner.animcount = 0;
            ctscanner.interrupt = true;
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            InternalImageFrame frame = (InternalImageFrame)e.getInternalFrame();
            if (frame.PANELTYPE == 2) {
                int confirm = JOptionPane.showOptionDialog(frame, "Save Image " + frame.getTitle() + "?", "Close Confirmation", 0, 3, null, null, null);
                if (confirm == 0) {
                    frame.imagepanel.saveImage(frame.getTitle());
                } else if (confirm == 1) {
                    // empty if block
                }
            }
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        public void internalFrameIconified(InternalFrameEvent e) {
        }

        public void internalFrameOpened(InternalFrameEvent e) {
        }
    }

    class FFTImageAction
    extends AbstractAction {
        public FFTImageAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame.PANELTYPE >= 2) {
                frame.imagepanel.FFTCurrentImage();
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    class eqHistImageAction
    extends AbstractAction {
        public eqHistImageAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame.PANELTYPE >= 2) {
                frame.imagepanel.EqImageHistogram();
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    class showHistogramAction
    extends AbstractAction {
        public showHistogramAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame1.PANELTYPE >= 2) {
                BufferedImage img = frame1.imagepanel.getBufferedImage();
                Histogram hist = new Histogram(img);
                InternalImageFrame frame = new InternalImageFrame();
                Container container = frame.getContentPane();
                container.add((Component)hist.histpanel, "Center");
                frame.pack();
                frame.setResizable(false);
                frame.setMaximizable(false);
                frame.setVisible(true);
                MyApp.this.theDesktop.add(frame);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
            }
        }
    }

    class findMSEAction
    extends AbstractAction {
        public findMSEAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame1.PANELTYPE >= 2) {
                int[][] image1 = frame1.imagepanel.getBuffImagePixels();
                FileDialog fd = new FileDialog(MyApp.this);
                fd.setTitle("Select the Other Image");
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                InternalImageFrame frame2 = new InternalImageFrame(path, 2, ctscanner);
                MyApp.this.theDesktop.add(frame2);
                try {
                    frame2.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
                int[][] image2 = frame2.imagepanel.getBuffImagePixels();
                double mse = 0.0;
                mse = Utils.getMSE2DintArrays(image1, image2);
                double temp = 255.0 / Math.sqrt(mse);
                double psnr = 20.0 * (Math.log(temp) / Math.log(10.0));
                System.out.println("MSE=" + mse);
                System.out.println("PSNR=" + psnr);
                JOptionPane.showInternalMessageDialog(MyApp.this.theDesktop, "MSE: " + mse + "\n" + "PSNR: " + psnr + "\n", "Error Metrics", -1);
            }
        }
    }

    class divImagesAction
    extends AbstractAction {
        public divImagesAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame1.PANELTYPE >= 2) {
                int[][] image1 = frame1.imagepanel.getBuffImagePixels();
                FileDialog fd = new FileDialog(MyApp.this);
                fd.setTitle("Select Image to Divide");
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                InternalImageFrame frame2 = new InternalImageFrame(path, 2, ctscanner);
                MyApp.this.theDesktop.add(frame2);
                try {
                    frame2.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
                int[][] image2 = frame2.imagepanel.getBuffImagePixels();
                double[][] newimage = Utils.divide2Dintarrays(image1, image2);
                InternalImageFrame frame = new InternalImageFrame();
                Container container = frame.getContentPane();
                ImagePanel panel = new ImagePanel();
                BufferedImage img = ctscanner.CreateImagefromArray(newimage, Utils.getMax(newimage), 0);
                panel.loadBufferedImage(img);
                frame.PANELTYPE = 2;
                container.add((Component)panel, "Center");
                frame.imagepanel = panel;
                frame.pack();
                frame.setVisible(true);
                MyApp.this.theDesktop.add(frame);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
            }
        }
    }

    class subImagesAction
    extends AbstractAction {
        public subImagesAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame1.PANELTYPE >= 2) {
                int[][] image1 = frame1.imagepanel.getBuffImagePixels();
                FileDialog fd = new FileDialog(MyApp.this);
                fd.setTitle("Select Image to Subtract");
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                InternalImageFrame frame2 = new InternalImageFrame(path, 2, ctscanner);
                MyApp.this.theDesktop.add(frame2);
                try {
                    frame2.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
                int[][] image2 = frame2.imagepanel.getBuffImagePixels();
                int[][] newimage = Utils.subtract2DintArrays(image1, image2);
                newimage = Utils.setRange2DintArray(newimage, 0, 255);
                InternalImageFrame frame = new InternalImageFrame();
                Container container = frame.getContentPane();
                ImagePanel panel = new ImagePanel();
                BufferedImage img = ImageUtils.CreateImagefromIntArray(newimage);
                panel.loadBufferedImage(img);
                frame.PANELTYPE = 2;
                container.add((Component)panel, "Center");
                frame.imagepanel = panel;
                frame.pack();
                frame.setVisible(true);
                MyApp.this.theDesktop.add(frame);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
            }
        }
    }

    class addImagesAction
    extends AbstractAction {
        public addImagesAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame1.PANELTYPE >= 2) {
                int[][] image1 = frame1.imagepanel.getBuffImagePixels();
                FileDialog fd = new FileDialog(MyApp.this);
                fd.setTitle("Select Image to Add");
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                InternalImageFrame frame2 = new InternalImageFrame(path, 2, ctscanner);
                MyApp.this.theDesktop.add(frame2);
                try {
                    frame2.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
                int[][] image2 = frame2.imagepanel.getBuffImagePixels();
                int[][] newimage = Utils.add2DintArrays(image1, image2);
                newimage = Utils.setRange2DintArray(newimage, 0, 255);
                InternalImageFrame frame = new InternalImageFrame();
                Container container = frame.getContentPane();
                ImagePanel panel = new ImagePanel();
                BufferedImage img = ImageUtils.CreateImagefromIntArray(newimage);
                panel.loadBufferedImage(img);
                frame.PANELTYPE = 2;
                container.add((Component)panel, "Center");
                frame.imagepanel = panel;
                frame.pack();
                frame.setVisible(true);
                MyApp.this.theDesktop.add(frame);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException s) {
                    // empty catch block
                }
            }
        }
    }

    class ScaleAction
    extends AbstractAction {
        public ScaleAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            String key = "Scale";
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            currframe.imagepanel.ScaleImage();
        }
    }

    class GreyScaleAction
    extends AbstractAction {
        public GreyScaleAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            try {
                if (currframe.PANELTYPE >= 2) {
                    String key = "Greyscale";
                    BufferedImageOp op = ImageOps.colorconvertOp();
                    currframe.imagepanel.PerformImageop(op);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class DarkenAction
    extends AbstractAction {
        public DarkenAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            try {
                if (currframe.PANELTYPE >= 2) {
                    String key = "Darken";
                    BufferedImageOp op = ImageOps.rescaleOp(0.9f);
                    currframe.imagepanel.PerformImageop(op);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class BrightenAction
    extends AbstractAction {
        public BrightenAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            try {
                if (currframe.PANELTYPE >= 2) {
                    String key = "Brighten";
                    BufferedImageOp op = ImageOps.rescaleOp(1.2f);
                    currframe.imagepanel.PerformImageop(op);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class InvertAction
    extends AbstractAction {
        public InvertAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            try {
                if (currframe.PANELTYPE >= 2) {
                    String key = "Invert";
                    BufferedImageOp op = ImageOps.invertOp();
                    currframe.imagepanel.PerformImageop(op);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class SharpenAction
    extends AbstractAction {
        public SharpenAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            try {
                if (currframe.PANELTYPE >= 2) {
                    String key = "Sharpen";
                    ConvolveOp op = ImageOps.sharpenOp();
                    currframe.imagepanel.PerformImageop(op);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class BlurAction
    extends AbstractAction {
        public BlurAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame currframe = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            try {
                if (currframe.PANELTYPE >= 2) {
                    String key = "Sharpen";
                    ConvolveOp op = ImageOps.blurOp();
                    currframe.imagepanel.PerformImageop(op);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class QuitAction
    extends AbstractAction {
        public QuitAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            MyApp.this.quit();
        }
    }

    class SaveImageAction
    extends AbstractAction {
        public SaveImageAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame currframe;
            JInternalFrame frame = MyApp.this.theDesktop.getSelectedFrame();
            String cls = frame.getClass().getName();
            if (cls == "myctapp.InternalImageFrame") {
                currframe = (InternalImageFrame)frame;
                currframe.imagepanel.saveImagePlus();
            }
            if (cls == "myctapp.InternalDrawFrame") {
                currframe = (InternalDrawFrame)frame;
                FileDialog fd = new FileDialog((Frame)MyApp.this, "Save Phantom", 1);
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                ((InternalDrawFrame)currframe).drawpanel.savePhantomAsImage(path);
            }
        }
    }

    class OpenImageAction
    extends AbstractAction {
        public OpenImageAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fd = new FileDialog(MyApp.this);
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return;
            }
            String path = fd.getDirectory() + fd.getFile();
            ImagePlus imp = IJ.openImage(path);
            InternalImageFrame frame = new InternalImageFrame(imp);
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException s) {
                // empty catch block
            }
        }
    }

    class CreateProjfromImageAction
    extends AbstractAction {
        public CreateProjfromImageAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            int choice = 1;
            InternalImageFrame newframe = new InternalImageFrame();
            if (MyApp.this.theDesktop.getSelectedFrame() != null && (choice = JOptionPane.showInternalOptionDialog(MyApp.this.theDesktop, "Reproject Current Image?", "Reprojection", 0, 3, null, null, null)) == 0) {
                try {
                    JInternalFrame frame = MyApp.this.theDesktop.getSelectedFrame();
                    String cls = frame.getClass().getName();
                    if (cls == "myctapp.InternalImageFrame") {
                        InternalImageFrame currframe = (InternalImageFrame)frame;
                        newframe = currframe.CreateCopy();
                        BufferedImage img = currframe.imagepanel.getBufferedImage();
                        if (currframe.imagepanel.getStackSize() > 1) {
                            newframe.imagepanel.ReprojectImage(ctscanner);
                            newframe.AddPanelsandDisplay();
                        } else {
                            newframe.imagepanel.ReprojectImage(ctscanner);
                            newframe.AddPanelsandDisplay();
                        }
                    }
                }
                catch (NullPointerException n) {
                    // empty catch block
                }
            }
            if (MyApp.this.theDesktop.getSelectedFrame() == null || choice == 1) {
                FileDialog fd = new FileDialog(MyApp.this);
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                newframe = new InternalImageFrame(path, 5, ctscanner);
            }
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            ctscanner.resetviews();
            MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            MyApp.this.theDesktop.add(newframe);
            try {
                newframe.setSelected(true);
            }
            catch (PropertyVetoException s) {
                // empty catch block
            }
        }
    }

    class CreateBPImageAction
    extends AbstractAction {
        public CreateBPImageAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame = new InternalImageFrame(null, 4, ctscanner);
            frame.addInternalFrameListener(MyApp.this.frameListener);
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            if (ctscanner.projection == null) {
                MyApp.this.stepsizeField.setValue(new Float(ctscanner.stepsize));
                MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            }
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    class LoadSinogramAction
    extends AbstractAction {
        public LoadSinogramAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fd = new FileDialog(MyApp.this);
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return;
            }
            String path = fd.getDirectory() + fd.getFile();
            InternalImageFrame frame = new InternalImageFrame(path, 3, ctscanner);
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException s) {
                // empty catch block
            }
        }
    }

    class CreateSinogramAction
    extends AbstractAction {
        public CreateSinogramAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame = new InternalImageFrame(null, 3, ctscanner);
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    class DrawCustomPhantomAction
    extends AbstractAction {
        public DrawCustomPhantomAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalDrawFrame frame = new InternalDrawFrame();
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    class ImportProjAction
    extends AbstractAction {
        public ImportProjAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fd = new FileDialog(MyApp.this);
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return;
            }
            String path = fd.getDirectory() + fd.getFile();
            Opener op = new Opener();
            ImagePlus imp = op.openImage(path);
            CustomDialog importdialog = new CustomDialog(MyApp.this, true, "Data bins in cols or rows?");
            boolean incols = importdialog.getAnswer();
            ctscanner.importProjections(imp, incols, 1);
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            MyApp.this.stepsizeField.setValue(new Float(ctscanner.stepsize));
            MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            InternalImageFrame frame = new InternalImageFrame(null, 3, ctscanner);
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException s) {
                // empty catch block
            }
        }
    }

    class SaveProjAction
    extends AbstractAction {
        public SaveProjAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fd = new FileDialog((Frame)MyApp.this, "Save Phantom", 1);
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return;
            }
            String path = fd.getDirectory() + fd.getFile();
            ctscanner.saveProjectionsFile(path);
        }
    }

    class LoadProjAction
    extends AbstractAction {
        public LoadProjAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fd = new FileDialog(MyApp.this);
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return;
            }
            String path = fd.getDirectory() + fd.getFile();
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            ctscanner.loadProjectionsFile(path);
        }
    }

    class ProjPhantomAction
    extends AbstractAction {
        public ProjPhantomAction(String text, String desc, Integer mnemonic) {
            super(text);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame = new InternalImageFrame(null, 6, ctscanner);
            frame.addInternalFrameListener(MyApp.this.frameListener);
            MyApp.this.scansField.setValue(new Integer(ctscanner.scans));
            ctscanner.resetviews();
            MyApp.this.viewsField.setValue(new Integer(ctscanner.views));
            MyApp.this.theDesktop.add(frame);
            MyApp.this.winPanel.repaint();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    class SavePhantomAction
    extends AbstractAction {
        public SavePhantomAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InternalDrawFrame currframe = (InternalDrawFrame)MyApp.this.theDesktop.getSelectedFrame();
                FileDialog fd = new FileDialog((Frame)MyApp.this, "Save Phantom", 1);
                fd.setVisible(true);
                if (fd.getFile() == null) {
                    return;
                }
                String path = fd.getDirectory() + fd.getFile();
                currframe.drawpanel.savePhant(path);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    class LoadPhantomAction
    extends AbstractAction {
        public LoadPhantomAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fd = new FileDialog(MyApp.this);
            fd.setVisible(true);
            if (fd.getFile() == null) {
                return;
            }
            String path = fd.getDirectory() + fd.getFile();
            InternalImageFrame frame = new InternalImageFrame(path, 2, ctscanner);
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException s) {
                // empty catch block
            }
        }
    }

    class PasteasImageAction
    extends AbstractAction {
        public PasteasImageAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame = new InternalImageFrame();
            Container container = frame.getContentPane();
            ImagePanel panel = new ImagePanel();
            panel.loadBufferedImage(MyApp.this.clipboardImage);
            panel.PerformWindowing();
            frame.PANELTYPE = 2;
            container.add((Component)panel, "Center");
            frame.imagepanel = panel;
            frame.pack();
            frame.setVisible(true);
            MyApp.this.theDesktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException s) {
                // empty catch block
            }
        }
    }

    class CopySelectionAction
    extends AbstractAction {
        public CopySelectionAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
            InternalImageFrame frame1 = (InternalImageFrame)MyApp.this.theDesktop.getSelectedFrame();
            if (frame1.imagepanel.pixels == null) {
                frame1.imagepanel.setPixelData();
            }
            MyApp.this.clipboardImage = frame1.imagepanel.getImageSelection();
            MyApp.access$902(MyApp.this, frame1.imagepanel.getSelectionData());
        }
    }
}

