/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

public class MyFFT {
    private final int FORWARD_FFT = -1;
    private final int REVERSE_FFT = 1;
    private double direction = -1.0;
    static final double twoPI = Math.PI * 2;
    private int N;
    private int numBits;
    private int width;
    private int height;
    private double minPSD = 9999999.0;
    private double maxPSD = -9999999.0;
    public boolean DisplayLogPSD = false;
    double[][] cR_r;
    double[][] cR_i;
    double[] r_data = null;
    double[] i_data = null;
    double[] mag = null;

    public void myfft() {
        this.init();
    }

    private void init() {
        this.minPSD = 9999999.0;
        this.maxPSD = -9999999.0;
    }

    public int[] psd() {
        double[] magnitudeR = this.magnitudeSpectrum(this.cR_r, this.cR_i);
        double scaleFactor = 100.0;
        System.out.println("Max psd = " + this.maxPSD);
        scaleFactor = 255.0 / Math.log(1.0 + this.maxPSD);
        System.out.println("Scalefactor = " + scaleFactor);
        for (int i = 0; i < this.N; ++i) {
            magnitudeR[i] = scaleFactor * Math.log(1.0 + magnitudeR[i]);
        }
        System.out.println("Minimum PSD value: " + this.minPSD);
        this.mag = magnitudeR;
        System.out.println(this.mag.length);
        return this.pad(this.mag, this.mag.length);
    }

    public int[] pad(double[] pixels, int w) {
        int[] ip = new int[w];
        for (int i = 0; i < w; ++i) {
            int val;
            ip[i] = val = (int)pixels[i];
        }
        return ip;
    }

    public int[] forward2dFFT(double[] imageData_R, int imageWidth, int imageHeight) {
        int i;
        this.init();
        this.width = imageWidth;
        this.height = imageHeight;
        this.cR_r = new double[this.height][this.width];
        this.cR_i = new double[this.height][this.width];
        this.N = this.width * this.height;
        this.numBits = (int)(Math.log(this.width) / Math.log(2.0));
        this.copydoubleToComplex(this.cR_r, this.cR_i, imageData_R);
        for (i = 0; i < this.height; ++i) {
            this.forwardFFT(this.cR_r[i], this.cR_i[i]);
        }
        System.out.println("FFT on rows:");
        this.cR_r = this.Rotate90(this.cR_r);
        this.cR_i = this.Rotate90(this.cR_i);
        System.out.println("Rotate 90 degrees CW:");
        for (i = 0; i < this.height; ++i) {
            this.forwardFFT(this.cR_r[i], this.cR_i[i]);
        }
        System.out.println("Triple FFT on columns:");
        return this.psd();
    }

    public int[] reverse2dFFT(double[] newmag) {
        int i;
        this.init();
        this.N = this.width * this.height;
        this.numBits = (int)(Math.log(this.width) / Math.log(2.0));
        for (i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                double pscale = newmag[i * this.height + j] / this.mag[i * this.height + j];
                this.cR_r[i][j] = this.cR_r[i][j] * pscale * (double)0.9f;
                this.cR_i[i][j] = this.cR_i[i][j] * pscale * (double)0.9f;
            }
            this.reverseFFT(this.cR_r[i], this.cR_i[i]);
        }
        System.out.println("IFFT on rows:");
        this.cR_r = this.Rotate90(this.cR_r);
        this.cR_i = this.Rotate90(this.cR_i);
        System.out.println("Rotate 90 degrees CW:");
        for (i = 0; i < this.height; ++i) {
            this.reverseFFT(this.cR_r[i], this.cR_i[i]);
        }
        System.out.println("IFFT on columns:");
        this.rotateInPlace180(this.cR_r);
        this.rotateInPlace180(this.cR_i);
        double[] realR = this.magnitudeSpectrum(this.cR_r, this.cR_i);
        return this.pad(realR, realR.length);
    }

    public void swap(int i) {
        int j = this.bitr(i);
        String js = Integer.toBinaryString(j);
        String is = Integer.toBinaryString(i);
        double tempr = this.r_data[j];
        this.r_data[j] = this.r_data[i];
        this.r_data[i] = tempr;
        tempr = this.i_data[j];
        this.i_data[j] = this.i_data[i];
        this.i_data[i] = tempr;
    }

    public void swapInt(int i, int j) {
        int ti = i - 1;
        int tj = j - 1;
        double tempr = this.r_data[tj];
        this.r_data[tj] = this.r_data[ti];
        this.r_data[ti] = tempr;
        tempr = this.i_data[tj];
        this.i_data[tj] = this.i_data[ti];
        this.i_data[ti] = tempr;
    }

    double getMaxValue(double[] in) {
        double max = -9.9E29;
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] > max)) continue;
            max = in[i];
        }
        return max;
    }

    void bitReverse2() {
        int n = this.r_data.length;
        int j = 1;
        for (int i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                this.swapInt(i, j);
            }
            for (k = n / 2; k >= 1 && k < j; j -= k, k /= 2) {
            }
            j += k;
        }
    }

    void bitReverse() {
        int n = this.r_data.length;
        int j = 1;
        for (int i = 1; i < n; ++i) {
            if (i < j) {
                this.swap(i);
            }
            j = this.bitr(i);
        }
    }

    int bitr(int j) {
        int ans = 0;
        for (int i = 0; i < this.numBits; ++i) {
            ans = (ans << 1) + (j & 1);
            j >>= 1;
        }
        return ans;
    }

    public void forwardFFT(double[] in_r, double[] in_i) {
        this.direction = -1.0;
        this.fft(in_r, in_i);
    }

    public void reverseFFT(double[] in_r, double[] in_i) {
        this.direction = 1.0;
        this.fft(in_r, in_i);
    }

    public void fft(double[] in_r, double[] in_i) {
        int length;
        int n = length = 1 << this.numBits;
        this.r_data = in_r;
        this.i_data = in_i;
        this.bitReverse2();
        for (int m = 1; m <= this.numBits; ++m) {
            int localN = 1 << m;
            double Wjk_r = 1.0;
            double Wjk_i = 0.0;
            double theta = Math.PI * 2 / (double)localN;
            double Wj_r = Math.cos(theta);
            double Wj_i = this.direction * Math.sin(theta);
            int nby2 = localN / 2;
            for (int j = 0; j < nby2; ++j) {
                for (int k = j; k < n; k += localN) {
                    int id = k + nby2;
                    double tempr = Wjk_r * this.r_data[id] - Wjk_i * this.i_data[id];
                    double tempi = Wjk_r * this.i_data[id] + Wjk_i * this.r_data[id];
                    this.r_data[id] = this.r_data[k] - tempr;
                    this.i_data[id] = this.i_data[k] - tempi;
                    int n2 = k;
                    this.r_data[n2] = this.r_data[n2] + tempr;
                    int n3 = k;
                    this.i_data[n3] = this.i_data[n3] + tempi;
                }
                double wtemp = Wjk_r;
                Wjk_r = Wj_r * Wjk_r - Wj_i * Wjk_i;
                Wjk_i = Wj_r * Wjk_i + Wj_i * wtemp;
            }
        }
    }

    public double[][] getRedReal() {
        return this.cR_r;
    }

    public double[][] getRedImaginary() {
        return this.cR_i;
    }

    private void copy2dArray(double[][] dst, double[][] src) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                dst[i][j] = src[i][j];
            }
        }
    }

    private void copydoubleToComplex(double[][] dst_r, double[][] dst_i, double[] imageData) {
        int k = 0;
        double alternateSign = 1.0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                alternateSign = (i + j) % 2 == 0 ? -1.0 : 1.0;
                dst_r[i][j] = imageData[k++] * alternateSign / (double)this.N;
                dst_i[i][j] = 0.0;
            }
        }
    }

    private void copyShortToComplex(double[][] dst_r, double[][] dst_i, short[] imageData) {
        int k = 0;
        double alternateSign = 1.0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                alternateSign = (i + j) % 2 == 0 ? -1.0 : 1.0;
                dst_r[i][j] = (double)imageData[k++] * alternateSign / (double)this.N;
                dst_i[i][j] = 0.0;
            }
        }
    }

    private double[][] Rotate90(double[][] in) {
        double[][] out = new double[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                out[i][j] = in[this.height - j - 1][i];
            }
        }
        return out;
    }

    private double[] flatten(double[][] in) {
        double[] out = new double[this.height * this.width];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                out[i * this.height + j] = in[i][j];
            }
        }
        return out;
    }

    private double[][] raise(double[] in) {
        double[][] out = new double[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                out[i][j] = in[i * this.height + j];
            }
        }
        return out;
    }

    private void rotateInPlace180(double[][] in) {
        for (int i = 0; i < this.height / 2; ++i) {
            for (int j = 0; j < this.width; ++j) {
                double temp = in[i][j];
                in[i][j] = in[this.height - i - 1][this.width - j - 1];
                in[this.height - i - 1][this.width - j - 1] = temp;
            }
        }
    }

    private double[] copyRealTodouble(double[][] in_r) {
        double[] f_data = new double[this.N];
        int k = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                f_data[k++] = in_r[i][j];
            }
        }
        return f_data;
    }

    private double[] magnitudeSpectrum(double[][] in_r, double[][] in_i) {
        double[] mag = new double[this.N];
        int k = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                mag[k] = Math.sqrt(in_r[i][j] * in_r[i][j] + in_i[i][j] * in_i[i][j]);
                if (this.minPSD > mag[k]) {
                    this.minPSD = mag[k];
                }
                if (this.maxPSD < mag[k]) {
                    this.maxPSD = mag[k];
                }
                ++k;
            }
        }
        return mag;
    }

    public double[] magnitudeSpectrum(double[] in_r, double[] in_i) {
        this.N = in_r.length;
        double[] mag = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            mag[i] = Math.sqrt(in_r[i] * in_r[i] + in_i[i] * in_i[i]);
            if (!(this.minPSD > mag[i])) continue;
            this.minPSD = mag[i];
        }
        return mag;
    }
}

