/*
 * Decompiled with CFR 0.152.
 */
package myctapp;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import myctapp.Poisson;

public class Utils {
    public static void blank(double[][] data, double value) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = value;
            }
        }
    }

    public static double getMin(double[] data) {
        double min = data[0];
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    public static double getMax(double[] data) {
        double max = data[0];
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public static int getMin(int[] data) {
        int min = data[0];
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= min) continue;
            min = data[i];
        }
        return min;
    }

    public static int getMax(int[] data) {
        int max = data[0];
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= max) continue;
            max = data[i];
        }
        return max;
    }

    public static int getMin(int[][] data) {
        int min = data[0][0];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (data[i][j] >= min) continue;
                min = data[i][j];
            }
        }
        return min;
    }

    public static int getMax(int[][] data) {
        int max = data[0][0];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (data[i][j] <= max) continue;
                max = data[i][j];
            }
        }
        return max;
    }

    public static double getMin(double[][] data) {
        double min = data[0][0];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (!(data[i][j] < min)) continue;
                min = data[i][j];
            }
        }
        return min;
    }

    public static double getMax(double[][] data) {
        double max = data[0][0];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (!(data[i][j] > max)) continue;
                max = data[i][j];
            }
        }
        return max;
    }

    public static void outputintArray(int[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                System.out.print(data[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void outputdoubleArray(double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                System.out.print(data[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void outputintArrayValues(int[][] data, int size, int x, int y) {
        if (x + size > data.length) {
            x = data.length - size;
        }
        if (y + size > data[0].length) {
            y = data[0].length - size;
        }
        for (int i = x; i < x + size; ++i) {
            for (int j = y; j < y + size; ++j) {
                System.out.print(data[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static double[][] multiply2Darrays(double[][] data1, double[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] * data2[i][j];
            }
        }
        return result;
    }

    public static int[][] multiply2Dintarrays(int[][] data1, int[][] data2) {
        int[][] result = new int[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] * data2[i][j];
            }
        }
        return result;
    }

    public static double[][] multiplyIntDoubleArrays(int[][] data1, double[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = (double)data1[i][j] * data2[i][j];
            }
        }
        return result;
    }

    public static double[][] divide2Darrays(double[][] data1, double[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] == 0.0 ? 0.0 : data1[i][j] / data2[i][j];
            }
        }
        return result;
    }

    public static double[][] divide2Dintarrays(int[][] data1, int[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data2[i][j] == 0 ? 0.0 : (double)(data1[i][j] / data2[i][j]);
            }
        }
        return result;
    }

    public static double[][] divideIntDoubleArrays(int[][] data1, double[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = (double)data1[i][j] / data2[i][j];
            }
        }
        return result;
    }

    public static double[][] subtract2DArrays(double[][] data1, double[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] - data2[i][j];
            }
        }
        return result;
    }

    public static int[][] subtract2DintArrays(int[][] data1, int[][] data2) {
        int[][] result = new int[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] - data2[i][j];
            }
        }
        return result;
    }

    public static double[][] add2DArrays(double[][] data1, double[][] data2) {
        double[][] result = new double[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] + data2[i][j];
            }
        }
        return result;
    }

    public static int[][] add2DintArrays(int[][] data1, int[][] data2) {
        int[][] result = new int[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data1[i][j] + data2[i][j];
            }
        }
        return result;
    }

    public static int[][] setRange2DintArray(int[][] data, int min, int max) {
        int[][] result = new int[data.length][data[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = data[i][j] > max ? max : (data[i][j] < min ? min : data[i][j]);
            }
        }
        return result;
    }

    public static void normalize2DArray(double[][] data, double min, double max) {
        double datamax = Utils.getMax(data);
        Utils.zeronegvals2DArray(data);
        double datamin = 0.0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = (data[i][j] - datamin) * max / datamax;
            }
        }
    }

    public static void normalize2DArray(double[][] data, double min, double max, boolean neg) {
        int j;
        int i;
        double datamin;
        double datamax = Utils.getMax(data);
        System.out.println("MAX:" + datamax);
        if (neg) {
            datamin = Utils.getMin(data);
            for (i = 0; i < data.length; ++i) {
                j = 0;
                while (j < data[0].length) {
                    double[] dArray = data[i];
                    int n = j++;
                    dArray[n] = dArray[n] + datamin;
                }
            }
            datamin = 0.0;
        } else {
            Utils.zeronegvals2DArray(data);
            datamin = 0.0;
        }
        for (i = 0; i < data.length; ++i) {
            for (j = 0; j < data[0].length; ++j) {
                data[i][j] = (data[i][j] - datamin) * max / datamax;
            }
        }
    }

    public static void normalize1DArray(double[] data, double min, double max) {
        double datamax = Utils.getMax(data);
        double datamin = 0.0;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] - datamin) * max / datamax;
        }
    }

    public static void zeronegvals2DArray(double[][] data) {
        double datamin = Utils.getMin(data);
        if (datamin < 0.0) {
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[0].length; ++j) {
                    if (!(data[i][j] < 0.0)) continue;
                    data[i][j] = 0.0;
                }
            }
        }
    }

    public static double getAverage1DArray(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        double average = sum / (double)data.length;
        return average;
    }

    public static double getAverage2DIntArray(int[][] data) {
        int sum = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                sum += data[i][j];
            }
        }
        double result = sum / (data.length * data[0].length);
        return result;
    }

    public static double getAverage2DDoubleArray(double[][] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                sum += data[i][j];
            }
        }
        double result = sum / (double)(data.length * data[0].length);
        return result;
    }

    public static double getMSE2DintArrays(int[][] data1, int[][] data2) {
        double sum = 0.0;
        double mse = 0.0;
        int[][] result = new int[data1.length][data1[0].length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[0].length; ++j) {
                result[i][j] = Math.abs(data1[i][j] - data2[i][j]);
                sum += Math.pow(result[i][j], 2.0);
            }
        }
        mse = sum / (double)(result.length * result.length);
        sum = 0.0;
        return mse;
    }

    public static double getPSNR2DintArrays(int[][] data1, int[][] data2) {
        double psnr = 0.0;
        double mse = 0.0;
        mse = Utils.getMSE2DintArrays(data1, data2);
        double temp = 255.0 / Math.sqrt(mse);
        psnr = 20.0 * (Math.log(temp) / Math.log(10.0));
        return psnr;
    }

    public static BufferedImage CreateImagefrom1DintArray(int[] pixels, int iw, int ih) {
        boolean i = false;
        boolean j = false;
        short[] pixelshortArray = new short[iw * ih];
        int max = Utils.getMax(pixels);
        int min = Utils.getMin(pixels);
        for (int x = 0; x < pixels.length; ++x) {
            int n = x;
            pixelshortArray[n] = (short)(pixelshortArray[n] + min);
            pixelshortArray[x] = max == 0 ? (short)(pixels[x] * 255) : (short)(pixels[x] * 255 / max);
        }
        BufferedImage bpimg = Utils.getGrayBufferedImage(pixelshortArray, iw, ih, 0, 255);
        return bpimg;
    }

    public static void toGrayBytes(byte[] grayBytes, short[] shortBuffer, int imgMin, int imgMax) {
        boolean displayMin = false;
        int displayMax = 255;
        float displayRatio = 255.0f / (float)(imgMax - imgMin);
        for (int i = 0; i < shortBuffer.length; ++i) {
            short in = shortBuffer[i];
            int out = in < imgMin ? 0 : (in > imgMax ? 255 : (int)((float)(in - imgMin) * displayRatio));
            grayBytes[i] = (byte)out;
        }
    }

    public static BufferedImage getGrayBufferedImage(short[] buf, int width, int height, int imgMin, int imgMax) {
        if (buf.length != width * height) {
            throw new IllegalArgumentException(width + " * " + height + " != " + buf.length);
        }
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        Utils.toGrayBytes(data, buf, imgMin, imgMax);
        return image;
    }

    public static double getStDev2DIntArray(int[][] data) {
        double mean = 0.0;
        int n = data.length * data[0].length;
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                mean += (double)data[i][j];
            }
        }
        mean /= (double)n;
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                double v = (double)data[i][j] - mean;
                sum += v * v;
            }
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static double getStDev2DDoubleArray(double[][] data) {
        double mean = 0.0;
        int n = data.length * data[0].length;
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                mean += data[i][j];
            }
        }
        mean /= (double)n;
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                double v = data[i][j] - mean;
                sum += v * v;
            }
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static double stdevFast(double[] data) {
        double mean = 0.0;
        int n = data.length;
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < n; ++i) {
            mean += data[i];
        }
        mean /= (double)n;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = data[i] - mean;
            sum += v * v;
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static double round(double a, int b) {
        long tempB;
        double tempA = a * Math.pow(10.0, b);
        int diff = (int)(10.0 * (tempA - (double)(tempB = (long)tempA)));
        if (diff >= 5) {
            tempB = (long)(tempA += 1.0);
        }
        tempA = (double)tempB / Math.pow(10.0, b);
        return tempA;
    }

    public static int pow2(int power) {
        return 1 << power;
    }

    public static boolean isPow2(int value) {
        return value == (int)Utils.roundPow2(value);
    }

    public static double roundPow2(double value) {
        double power = Math.log(value) / Math.log(2.0);
        int intPower = (int)Math.round(power);
        return Utils.pow2(intPower);
    }

    public static double factorial(double n) {
        if (n < 0.0 || n - (double)((int)n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 1.0;
        int nn = (int)n;
        for (int i = 1; i <= nn; ++i) {
            f *= (double)i;
        }
        return f;
    }

    public static double[] importArrayData(String filename) {
        int size = 0;
        double[] data = new double[size];
        try {
            if (filename == null) {
                size = 10;
                data = new double[size];
            } else {
                String s;
                File file = new File(filename);
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while (reader.readLine() != null) {
                    ++size;
                }
                System.out.println(size);
                data = new double[size];
                reader.close();
                reader = new BufferedReader(new FileReader(file));
                int i = 0;
                while ((s = reader.readLine()) != null) {
                    String[] sdata = s.split("\\s");
                    data[i] = Float.valueOf(sdata[1]).intValue();
                    System.out.println(i + 1 + "  " + data[i]);
                    ++i;
                }
                reader.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception " + ioe);
        }
        return data;
    }

    public static void addpoissonnoise(double[][] data, double rate) {
        double noise = 0.0;
        int j = 0;
        int w = data.length;
        int h = data[0].length;
        Poisson p = new Poisson("p", rate);
        double max = Utils.getMax(data);
        double counts = rate;
        double time = 100.0;
        for (int i = 0; i < w; ++i) {
            j = 0;
            while (j < h) {
                if (data[i][j] == 0.0) {
                    noise = 0.0;
                } else {
                    counts = rate * data[i][j] / max;
                    noise = data[i][j] * (rate - p.sample()) / rate;
                    noise /= time;
                }
                if (data[i][j] != 0.0) {
                    // empty if block
                }
                double[] dArray = data[i];
                int n = j++;
                dArray[n] = dArray[n] + noise;
            }
        }
    }

    public static double[][] ArrayCopy(double[][] data) {
        int j = 0;
        int w = data.length;
        int h = data[0].length;
        double[][] result = new double[w][h];
        for (int i = 0; i < w; ++i) {
            for (j = 0; j < h; ++j) {
                result[i][j] = data[i][j];
            }
        }
        return result;
    }

    public static void saveanImage(String fileName, BufferedImage img) {
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            ImageTypeSpecifier imTy = param.getDestinationType();
            ImageTypeSpecifier imTySp = ImageTypeSpecifier.createFromRenderedImage(img);
            param.setDestinationType(imTySp);
            System.out.println("Found writer " + writer);
            File file = new File(fileName + ".png");
            FileImageOutputStream ios = new FileImageOutputStream(file);
            writer.setOutput(ios);
            writer.write(img);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

