/*
 * Decompiled with CFR 0.152.
 */
package myctapp.gui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JSlider;
import myctapp.gui.AssistantUIManager;
import myctapp.gui.MetalMThumbSliderUI;

public class MThumbSlider
extends JSlider {
    protected int thumbNum;
    protected BoundedRangeModel[] sliderModels;
    protected Icon[] thumbRenderers;
    protected Color[] fillColors;
    protected Color trackFillColor;
    private static final String uiClassID = "MThumbSliderUI";

    public MThumbSlider(int n) {
        this.createThumbs(n);
        this.updateUI();
    }

    protected void createThumbs(int n) {
        this.thumbNum = n;
        this.sliderModels = new BoundedRangeModel[n];
        this.thumbRenderers = new Icon[n];
        this.fillColors = new Color[n];
        for (int i = 0; i < n; ++i) {
            this.sliderModels[i] = new DefaultBoundedRangeModel(200, 0, 0, 2000);
            this.thumbRenderers[i] = null;
            this.fillColors[i] = null;
        }
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI(AssistantUIManager.createUI(this));
        this.setUI(new MetalMThumbSliderUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getThumbNum() {
        return this.thumbNum;
    }

    public int getValueAt(int index) {
        return this.getModelAt(index).getValue();
    }

    public void setValueAt(int n, int index) {
        this.getModelAt(index).setValue(n);
        this.validate();
    }

    public void ResetThumbs() {
        this.getModelAt(0).setValue(this.getMinimum());
        this.getModelAt(1).setValue(this.getMaximum());
        Graphics g = this.getGraphics();
        this.update(g);
        this.validate();
    }

    public int getMinimum() {
        return this.getModelAt(0).getMinimum();
    }

    public int getMaximum() {
        return this.getModelAt(0).getMaximum();
    }

    public BoundedRangeModel getModelAt(int index) {
        return this.sliderModels[index];
    }

    public Icon getThumbRendererAt(int index) {
        return this.thumbRenderers[index];
    }

    public void setThumbRendererAt(Icon icon, int index) {
        this.thumbRenderers[index] = icon;
    }

    public Color getFillColorAt(int index) {
        return this.fillColors[index];
    }

    public void setFillColorAt(Color color, int index) {
        this.fillColors[index] = color;
    }

    public Color getTrackFillColor() {
        return this.trackFillColor;
    }

    public void setTrackFillColor(Color color) {
        this.trackFillColor = color;
    }
}

