/*
 * Decompiled with CFR 0.152.
 */
package myctapp.gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;
import myctapp.gui.MThumbSlider;
import myctapp.gui.MThumbSliderAdditional;

public class MThumbSliderAdditionalUI {
    MThumbSlider mSlider;
    BasicSliderUI ui;
    Rectangle[] thumbRects;
    int thumbNum;
    private transient boolean isDragging;
    Icon thumbRenderer;
    Rectangle trackRect;
    ChangeHandler changeHandler;
    TrackListener trackListener;
    private static Rectangle unionRect = new Rectangle();

    public MThumbSliderAdditionalUI(BasicSliderUI ui) {
        this.ui = ui;
    }

    public void installUI(JComponent c) {
        this.mSlider = (MThumbSlider)c;
        this.thumbNum = this.mSlider.getThumbNum();
        this.thumbRects = new Rectangle[this.thumbNum];
        for (int i = 0; i < this.thumbNum; ++i) {
            this.thumbRects[i] = new Rectangle();
        }
        this.isDragging = false;
        this.trackListener = new TrackListener(this.mSlider);
        this.changeHandler = new ChangeHandler();
    }

    public void uninstallUI(JComponent c) {
        this.thumbRects = null;
        this.trackListener = null;
        this.changeHandler = null;
    }

    protected void calculateThumbsSize() {
        Dimension size = ((MThumbSliderAdditional)((Object)this.ui)).getThumbSize();
        for (int i = 0; i < this.thumbNum; ++i) {
            this.thumbRects[i].setSize(size.width, size.height);
        }
    }

    protected void calculateThumbsLocation() {
        for (int i = 0; i < this.thumbNum; ++i) {
            if (this.mSlider.getSnapToTicks()) {
                int tickSpacing = this.mSlider.getMinorTickSpacing();
                if (tickSpacing == 0) {
                    tickSpacing = this.mSlider.getMajorTickSpacing();
                }
                if (tickSpacing != 0) {
                    int sliderValue;
                    int snappedValue = sliderValue = this.mSlider.getValueAt(i);
                    int min = this.mSlider.getMinimum();
                    if ((sliderValue - min) % tickSpacing != 0) {
                        float temp = (float)(sliderValue - min) / (float)tickSpacing;
                        int whichTick = Math.round(temp);
                        snappedValue = min + whichTick * tickSpacing;
                        this.mSlider.setValueAt(snappedValue, i);
                    }
                }
            }
            this.trackRect = this.getTrackRect();
            if (this.mSlider.getOrientation() == 0) {
                int value = this.mSlider.getValueAt(i);
                int valuePosition = ((MThumbSliderAdditional)((Object)this.ui)).xPositionForValue(value);
                this.thumbRects[i].x = valuePosition - this.thumbRects[i].width / 2;
                this.thumbRects[i].y = this.trackRect.y;
                continue;
            }
            int valuePosition = ((MThumbSliderAdditional)((Object)this.ui)).yPositionForValue(this.mSlider.getValueAt(i));
            this.thumbRects[i].x = this.trackRect.x;
            this.thumbRects[i].y = valuePosition - this.thumbRects[i].height / 2;
        }
    }

    public int getThumbNum() {
        return this.thumbNum;
    }

    public Rectangle[] getThumbRects() {
        return this.thumbRects;
    }

    public void setThumbLocationAt(int x, int y, int index) {
        Rectangle rect = this.thumbRects[index];
        unionRect.setBounds(rect);
        rect.setLocation(x, y);
        SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, unionRect);
        this.mSlider.repaint(MThumbSliderAdditionalUI.unionRect.x, MThumbSliderAdditionalUI.unionRect.y, MThumbSliderAdditionalUI.unionRect.width, MThumbSliderAdditionalUI.unionRect.height);
    }

    public Rectangle getTrackRect() {
        return ((MThumbSliderAdditional)((Object)this.ui)).getTrackRect();
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        protected Rectangle adjustingThumbRect = null;
        protected int adjustingThumbIndex;
        protected MThumbSlider slider;
        protected Rectangle trackRect;

        TrackListener(MThumbSlider slider) {
            this.slider = slider;
        }

        public void mousePressed(MouseEvent e) {
            if (!this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            this.slider.requestFocus();
            for (int i = 0; i < MThumbSliderAdditionalUI.this.thumbNum; ++i) {
                Rectangle rect = MThumbSliderAdditionalUI.this.thumbRects[i];
                if (!rect.contains(this.currentMouseX, this.currentMouseY)) continue;
                switch (this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - rect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - rect.x;
                    }
                }
                MThumbSliderAdditionalUI.this.isDragging = true;
                this.slider.setValueIsAdjusting(true);
                this.adjustingThumbRect = rect;
                this.adjustingThumbIndex = i;
                return;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!(this.slider.isEnabled() && MThumbSliderAdditionalUI.this.isDragging && this.slider.getValueIsAdjusting() && this.adjustingThumbRect != null)) {
                return;
            }
            int thumbMiddle = 0;
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            Rectangle rect = MThumbSliderAdditionalUI.this.thumbRects[this.adjustingThumbIndex];
            this.trackRect = MThumbSliderAdditionalUI.this.getTrackRect();
            switch (this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = rect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = this.trackRect.y;
                    int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    MThumbSliderAdditionalUI.this.setThumbLocationAt(rect.x, thumbTop, this.adjustingThumbIndex);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForYPosition(thumbMiddle), this.adjustingThumbIndex);
                    break;
                }
                case 0: {
                    int halfThumbWidth = rect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = this.trackRect.x;
                    int trackRight = this.trackRect.x + (this.trackRect.width - 1);
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, this.adjustingThumbIndex);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), this.adjustingThumbIndex);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            MThumbSliderAdditionalUI.this.isDragging = false;
            MThumbSliderAdditionalUI.this.mSlider.setValueIsAdjusting(false);
            MThumbSliderAdditionalUI.this.mSlider.repaint();
        }

        public boolean shouldScroll(int direction) {
            return false;
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            if (!MThumbSliderAdditionalUI.this.isDragging) {
                MThumbSliderAdditionalUI.this.calculateThumbsLocation();
                MThumbSliderAdditionalUI.this.mSlider.repaint();
            }
        }
    }
}

