/*
 * Decompiled with CFR 0.152.
 */
package myctapp.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSliderUI;
import myctapp.gui.MThumbSlider;
import myctapp.gui.MThumbSliderAdditional;
import myctapp.gui.MThumbSliderAdditionalUI;

public class MetalMThumbSliderUI
extends MetalSliderUI
implements MThumbSliderAdditional {
    MThumbSliderAdditionalUI additonalUi;
    MouseInputAdapter mThumbTrackListener;
    Icon thumbRenderer;

    public static ComponentUI createUI(JComponent c) {
        return new MetalMThumbSliderUI((JSlider)c);
    }

    public MetalMThumbSliderUI() {
    }

    public MetalMThumbSliderUI(JSlider b) {
    }

    public void installUI(JComponent c) {
        this.additonalUi = new MThumbSliderAdditionalUI(this);
        this.additonalUi.installUI(c);
        this.mThumbTrackListener = this.createMThumbTrackListener((JSlider)c);
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.additonalUi.uninstallUI(c);
        this.additonalUi = null;
        this.mThumbTrackListener = null;
    }

    protected MouseInputAdapter createMThumbTrackListener(JSlider slider) {
        return this.additonalUi.trackListener;
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return null;
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return this.additonalUi.changeHandler;
    }

    protected void installListeners(JSlider slider) {
        slider.addMouseListener(this.mThumbTrackListener);
        slider.addMouseMotionListener(this.mThumbTrackListener);
        slider.addFocusListener(this.focusListener);
        slider.addComponentListener(this.componentListener);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        slider.getModel().addChangeListener(this.changeListener);
    }

    protected void uninstallListeners(JSlider slider) {
        slider.removeMouseListener(this.mThumbTrackListener);
        slider.removeMouseMotionListener(this.mThumbTrackListener);
        slider.removeFocusListener(this.focusListener);
        slider.removeComponentListener(this.componentListener);
        slider.removePropertyChangeListener(this.propertyChangeListener);
        slider.getModel().removeChangeListener(this.changeListener);
    }

    protected void calculateGeometry() {
        super.calculateGeometry();
        this.additonalUi.calculateThumbsSize();
        this.additonalUi.calculateThumbsLocation();
    }

    protected void calculateThumbLocation() {
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle clip = g.getClipBounds();
        Rectangle[] thumbRects = this.additonalUi.getThumbRects();
        this.thumbRect = thumbRects[0];
        int thumbNum = this.additonalUi.getThumbNum();
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            boolean filledSlider_tmp = this.filledSlider;
            this.filledSlider = false;
            this.paintTrack(g);
            this.filledSlider = filledSlider_tmp;
            if (this.filledSlider) {
                int maxPosition;
                Rectangle maxThumbRect;
                g.translate(this.trackRect.x, this.trackRect.y);
                Point t1 = new Point(0, 0);
                Point t2 = new Point(0, 0);
                this.thumbRect = maxThumbRect = new Rectangle(this.thumbRect);
                if (this.slider.getOrientation() == 0) {
                    t2.y = this.trackRect.height - 1 - this.getThumbOverhang();
                    t1.y = t2.y - (this.getTrackWidth() - 1);
                    t2.x = this.trackRect.width - 1;
                    maxPosition = this.xPositionForValue(this.slider.getMaximum());
                    this.thumbRect.x = maxPosition - this.thumbRect.width / 2 - 2;
                    this.thumbRect.y = this.trackRect.y;
                } else {
                    t1.x = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                    t2.x = this.trackRect.width - this.getThumbOverhang() - 1;
                    t2.y = this.trackRect.height - 1;
                    maxPosition = this.yPositionForValue(this.slider.getMaximum());
                    this.thumbRect.x = this.trackRect.x;
                    this.thumbRect.y = maxPosition - this.thumbRect.height / 2 - 2;
                }
                Color fillColor = ((MThumbSlider)this.slider).getTrackFillColor();
                if (fillColor == null) {
                    fillColor = MetalLookAndFeel.getControlShadow();
                }
                this.fillTrack(g, t1, t2, fillColor);
                for (int i = thumbNum - 1; 0 <= i; --i) {
                    this.thumbRect = thumbRects[i];
                    fillColor = ((MThumbSlider)this.slider).getFillColorAt(i);
                    if (fillColor == null) {
                        fillColor = MetalLookAndFeel.getControlShadow();
                    }
                    this.fillTrack(g, t1, t2, fillColor);
                }
                g.translate(-this.trackRect.x, -this.trackRect.y);
            }
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        for (int i = thumbNum - 1; 0 <= i; --i) {
            if (!clip.intersects(thumbRects[i])) continue;
            this.thumbRect = thumbRects[i];
            this.thumbRenderer = ((MThumbSlider)this.slider).getThumbRendererAt(i);
            if (this.thumbRenderer == null) {
                this.thumbRenderer = this.slider.getOrientation() == 0 ? horizThumbIcon : vertThumbIcon;
            }
            this.paintThumb(g);
        }
    }

    public void paintThumb(Graphics g) {
        this.thumbRenderer.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
    }

    public void fillTrack(Graphics g, Point t1, Point t2, Color fillColor) {
        int middleOfThumb = 0;
        if (this.slider.getOrientation() == 0) {
            middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - this.trackRect.x;
            if (this.slider.isEnabled()) {
                g.setColor(fillColor);
                g.fillRect(t1.x + 2, t1.y + 2, middleOfThumb - t1.x - 1, t2.y - t1.y - 3);
                g.setColor(fillColor.brighter());
                g.drawLine(t1.x + 1, t1.y + 1, middleOfThumb, t1.y + 1);
                g.drawLine(t1.x + 1, t1.y + 1, t1.x + 1, t2.y - 2);
            } else {
                g.setColor(fillColor);
                g.fillRect(t1.x, t1.y, middleOfThumb - t1.x + 2, t2.y - t1.y);
            }
        } else {
            middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - this.trackRect.y;
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getBackground());
                g.drawLine(t1.x + 1, middleOfThumb, t2.x - 2, middleOfThumb);
                g.drawLine(t1.x + 1, middleOfThumb, t1.x + 1, t2.y - 2);
                g.setColor(fillColor);
                g.fillRect(t1.x + 2, middleOfThumb + 1, t2.x - t1.x - 3, t2.y - 2 - middleOfThumb);
            } else {
                g.setColor(fillColor);
                g.fillRect(t1.x, middleOfThumb + 2, t2.x - 1 - t1.x, t2.y - t1.y);
            }
        }
    }

    public void scrollByBlock(int direction) {
    }

    public void scrollByUnit(int direction) {
    }

    public Rectangle getTrackRect() {
        return this.trackRect;
    }

    public Dimension getThumbSize() {
        return super.getThumbSize();
    }

    public int xPositionForValue(int value) {
        return super.xPositionForValue(value);
    }

    public int yPositionForValue(int value) {
        return super.yPositionForValue(value);
    }
}

