/*
 * Decompiled with CFR 0.152.
 */
package com.vk;

import com.vk.Complex;

public class CMath {
    public static Complex neg(Complex complex) {
        return new Complex(-complex.real(), -complex.imag());
    }

    public static Complex conjg(Complex complex) {
        return new Complex(complex.real(), -complex.imag());
    }

    public static Complex add(Complex complex, double d) {
        return new Complex(complex.real() + d, complex.imag());
    }

    public static Complex mul(Complex complex, double d) {
        return new Complex(complex.real() * d, complex.imag() * d);
    }

    public static Complex add(Complex complex, Complex complex2) {
        double d = complex.real() + complex2.real();
        double d2 = complex.imag() + complex2.imag();
        return new Complex(d, d2);
    }

    public static Complex sub(Complex complex, Complex complex2) {
        double d = complex.real() - complex2.real();
        double d2 = complex.imag() - complex2.imag();
        return new Complex(d, d2);
    }

    public static Complex mul(Complex complex, Complex complex2) {
        double d = complex.real();
        double d2 = complex.imag();
        double d3 = complex2.real();
        double d4 = complex2.imag();
        double d5 = d * d3 - d2 * d4;
        double d6 = d * d4 + d2 * d3;
        return new Complex(d5, d6);
    }

    public static Complex div(Complex complex, Complex complex2) {
        double d = complex.real();
        double d2 = complex.imag();
        double d3 = complex2.real();
        double d4 = complex2.imag();
        double d5 = d * d3 + d2 * d4;
        double d6 = d2 * d3 - d * d4;
        d = d3 * d3 + d4 * d4;
        return new Complex(d5 /= d, d6 /= d);
    }

    public static Complex exp(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        d2 = Math.exp(d);
        return new Complex(d3 *= d2, d4 *= d2);
    }

    public static Complex cos(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double d3 = Math.cos(d);
        double d4 = -Math.sin(d);
        d = Math.exp(d2);
        return new Complex(d3 *= (d + 1.0 / d) / 2.0, d4 *= (d - 1.0 / d) / 2.0);
    }

    public static Complex sin(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        d = Math.exp(d2);
        return new Complex(d3 *= (d + 1.0 / d) / 2.0, d4 *= (d - 1.0 / d) / 2.0);
    }

    public static Complex tan(Complex complex) {
        return CMath.div(CMath.sin(complex), CMath.cos(complex));
    }

    public static Complex pow(Complex complex, double d) {
        double d2 = Math.pow(complex.abs(), d);
        double d3 = complex.phase() * d;
        double d4 = d2 * Math.cos(d3);
        double d5 = d2 * Math.sin(d3);
        return new Complex(d4, d5);
    }

    public static Complex log(Complex complex) {
        double d = Math.log(complex.abs());
        double d2 = complex.phase();
        return new Complex(d, d2);
    }

    public static Complex[] fft(Complex[] complexArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = Math.abs(n);
        int n7 = 1;
        for (n5 = 0; n5 < n6; ++n5) {
            n7 *= 2;
        }
        Complex[] complexArray2 = new Complex[n7];
        for (n5 = 0; n5 < n7; ++n5) {
            complexArray2[n5] = complexArray[n5];
        }
        Complex[] complexArray3 = new Complex[n7];
        Complex[] complexArray4 = new Complex[n7 / 2];
        int[] nArray = new int[n7];
        nArray[0] = 1;
        int n8 = 1;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n5 = 0; n5 < n8; ++n5) {
                n3 = n5 + n8;
                nArray[n3] = nArray[n5] * 2;
                nArray[n5] = nArray[n3] - 1;
            }
            n8 *= 2;
        }
        Complex complex = CMath.exp(new Complex(0.0, Math.PI * 2 / (double)n7));
        n8 /= 2;
        complexArray4[0] = complex;
        for (n5 = 1; n5 < n8; ++n5) {
            complexArray4[n5] = CMath.mul(complexArray4[n5 - 1], complex);
        }
        for (n5 = 0; n5 < n7; ++n5) {
            n2 = nArray[n5] - 1;
            complexArray3[n2] = complexArray2[n5];
        }
        for (n5 = 0; n5 < n8; ++n5) {
            n2 = n5 * 2 + 1;
            n4 = n2 - 1;
            complexArray2[n5] = CMath.add(complexArray3[n4], complexArray3[n2]);
            complexArray2[n5 + n8] = CMath.sub(complexArray3[n4], complexArray3[n2]);
        }
        int n9 = n8;
        for (n5 = 1; n5 < n6; ++n5) {
            n2 = n9 + 2;
            n9 /= 2;
            for (n3 = n2; n3 <= n7; n3 += 2) {
                n4 = (n3 - 1) / (n2 - 2);
                complex = complexArray4[(n4 *= n9) - 1];
                if (n < 0) {
                    complex = CMath.conjg(complex);
                }
                int n10 = n3 - 1;
                complexArray2[n10] = CMath.mul(complexArray2[n10], complex);
            }
            for (n4 = 0; n4 < n7; ++n4) {
                complexArray3[n4] = complexArray2[n4];
            }
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * 2 + 1;
                n4 = n2 - 1;
                complexArray2[n3] = CMath.add(complexArray3[n4], complexArray3[n2]);
                complexArray2[n3 + n8] = CMath.sub(complexArray3[n4], complexArray3[n2]);
            }
        }
        return complexArray2;
    }

    public static Complex bj0(Complex complex) {
        double d = 0.6366197723675814;
        double d2 = 0.7853981633974483;
        Complex complex2 = new Complex(0.0, 0.0);
        Complex complex3 = new Complex(1.0, 0.0);
        double[] dArray = new double[]{4.9337872517941336E20, -1.1791576291076106E20, 6.382059341072356E18, -1.3676203530881714E17, 1.434354939140344E15, -8.085222034853794E12, 2.507158285536882E10, -4.050412371833133E7, 26857.86856980015};
        double[] dArray2 = new double[]{4.9337872517941336E20, 5.428918384092285E18, 3.0246356167094628E16, 1.1277567396797984E14, 3.1230431149412134E11, 6.69998767298224E8, 1114636.0984629854, 1363.0636523289706, 1.0};
        double[] dArray3 = new double[]{5393485.083869439, 1.233238476817638E7, 8413041.45655044, 2016135.2830499837, 153982.65326239113, 2485.271928957404, 0.0};
        double[] dArray4 = new double[]{5393485.083869439, 1.233831022786325E7, 8426449.050629796, 2025066.801570134, 156001.7276940031, 2615.7007369208395, 1.0};
        double[] dArray5 = new double[]{-3984.6173575952225, -10381.416987484641, -8239.066313485606, -2365.956170779108, -226.2630641933704, -4.887199395841262, 0.0};
        double[] dArray6 = new double[]{255015.51088609424, 666745.4239319827, 533291.3634216897, 156021.32066792916, 15704.891915153956, 408.7714673983499, 1.0};
        if (complex.abs() > 8.0) {
            int n;
            Complex complex4 = CMath.mul(complex, complex);
            Complex complex5 = CMath.mul(complex3, 64.0);
            complex4 = CMath.div(complex5, complex4);
            Complex complex6 = complex2;
            Complex complex7 = complex2;
            for (n = 6; n >= 0; --n) {
                complex6 = CMath.mul(complex6, complex4);
                complex6 = CMath.add(complex6, dArray3[n]);
                complex7 = CMath.mul(complex7, complex4);
                complex7 = CMath.add(complex7, dArray4[n]);
            }
            Complex complex8 = CMath.div(complex6, complex7);
            complex6 = complex2;
            complex7 = complex2;
            for (n = 6; n >= 0; --n) {
                complex6 = CMath.mul(complex6, complex4);
                complex6 = CMath.add(complex6, dArray5[n]);
                complex7 = CMath.mul(complex7, complex4);
                complex7 = CMath.add(complex7, dArray6[n]);
            }
            complex5 = CMath.div(complex6, complex7);
            complex5 = CMath.mul(complex5, 8.0);
            Complex complex9 = CMath.div(complex5, complex);
            complex5 = CMath.mul(complex3, d2);
            complex6 = CMath.sub(complex, complex5);
            complex5 = CMath.mul(complex3, d);
            complex5 = CMath.div(complex5, complex);
            complex5 = CMath.pow(complex5, 0.5);
            complex7 = CMath.sin(complex6);
            complex7 = CMath.mul(complex9, complex7);
            complex6 = CMath.cos(complex6);
            complex6 = CMath.mul(complex8, complex6);
            complex7 = CMath.sub(complex6, complex7);
            complex5 = CMath.mul(complex5, complex7);
            return complex5;
        }
        Complex complex10 = CMath.mul(complex, complex);
        Complex complex11 = complex2;
        Complex complex12 = complex2;
        for (int i = 8; i >= 0; --i) {
            complex11 = CMath.mul(complex10, complex11);
            complex11 = CMath.add(complex11, dArray[i]);
            complex12 = CMath.mul(complex10, complex12);
            complex12 = CMath.add(complex12, dArray2[i]);
        }
        Complex complex13 = CMath.div(complex11, complex12);
        return complex13;
    }

    public static Complex bj1(Complex complex) {
        double d = 0.6366197723675814;
        double d2 = 0.7853981633974483;
        Complex complex2 = new Complex(0.0, 0.0);
        Complex complex3 = new Complex(1.0, 0.0);
        double[] dArray = new double[]{5.811993540016061E20, -6.672106568924916E19, 2.3164335806340024E18, -3.588817569910106E16, 2.9087952638347756E14, -1.3229834803321265E12, 3.4132341823017006E9, -4695753.530642996, 2701.1227108923235};
        double[] dArray2 = new double[]{1.1623987080032122E21, 1.185770712190321E19, 6.092061398917522E16, 2.0816612213076075E14, 5.2437102621676495E11, 1.013863514358674E9, 1501793.5949985855, 1606.9315734814877, 1.0};
        double[] dArray3 = new double[]{-4435757.816794128, -9942246.505077641, -6603373.248364939, -1523529.3511811374, -109824.05543459347, -1611.6166443246102, 0.0};
        double[] dArray4 = new double[]{-4435757.816794128, -9934124.389934586, -6585339.4797230875, -1511809.5066341609, -107263.8599110382, -1455.0094401904962, 1.0};
        double[] dArray5 = new double[]{33220.913409857225, 85145.1606753357, 66178.83658127084, 18494.262873223866, 1706.375429020768, 35.26513384663603, 0.0};
        double[] dArray6 = new double[]{708712.8194102874, 1819458.0422439973, 1419460.669603721, 400294.43582266977, 37890.2297457722, 863.8367769604992, 1.0};
        Complex complex4 = complex;
        if (complex4.abs() > 8.0) {
            int n;
            Complex complex5 = CMath.mul(complex, complex);
            Complex complex6 = CMath.mul(complex3, 64.0);
            complex5 = CMath.div(complex6, complex5);
            Complex complex7 = complex2;
            Complex complex8 = complex2;
            for (n = 6; n >= 0; --n) {
                complex7 = CMath.mul(complex7, complex5);
                complex7 = CMath.add(complex7, dArray3[n]);
                complex8 = CMath.mul(complex8, complex5);
                complex8 = CMath.add(complex8, dArray4[n]);
            }
            Complex complex9 = CMath.div(complex7, complex8);
            complex7 = complex2;
            complex8 = complex2;
            for (n = 6; n >= 0; --n) {
                complex7 = CMath.mul(complex7, complex5);
                complex7 = CMath.add(complex7, dArray5[n]);
                complex8 = CMath.mul(complex8, complex5);
                complex8 = CMath.add(complex8, dArray6[n]);
            }
            complex6 = CMath.div(complex7, complex8);
            complex6 = CMath.mul(complex6, 8.0);
            Complex complex10 = CMath.div(complex6, complex);
            complex6 = CMath.mul(complex3, 3.0 * d2);
            complex7 = CMath.sub(complex4, complex6);
            complex6 = CMath.mul(complex3, d);
            complex6 = CMath.div(complex6, complex4);
            complex6 = CMath.pow(complex6, 0.5);
            complex8 = CMath.sin(complex7);
            complex8 = CMath.mul(complex10, complex8);
            complex7 = CMath.cos(complex7);
            complex7 = CMath.mul(complex9, complex7);
            complex8 = CMath.sub(complex7, complex8);
            complex6 = CMath.mul(complex6, complex8);
            return complex6;
        }
        Complex complex11 = CMath.mul(complex4, complex4);
        Complex complex12 = complex2;
        Complex complex13 = complex2;
        for (int i = 8; i >= 0; --i) {
            complex12 = CMath.mul(complex11, complex12);
            complex12 = CMath.add(complex12, dArray[i]);
            complex13 = CMath.mul(complex11, complex13);
            complex13 = CMath.add(complex13, dArray2[i]);
        }
        Complex complex14 = CMath.div(complex12, complex13);
        complex14 = CMath.mul(complex, complex14);
        return complex14;
    }
}

