/*
 * Decompiled with CFR 0.152.
 */
package com.vk;

import java.io.BufferedWriter;

public class HexWriter {
    private int initCap;
    private int[] data;
    private int pos = 0;

    public HexWriter(int n) {
        if (n < 16) {
            n = 16;
        }
        this.data = new int[n];
        this.initCap = n;
        this.pos = 0;
    }

    public void putValue(int n) {
        this.data[this.pos] = n;
        if (++this.pos >= this.data.length) {
            this.realloc();
        }
    }

    public void newLine() {
        this.data[this.pos] = -1;
        if (++this.pos >= this.data.length) {
            this.realloc();
        }
    }

    private void realloc() {
        int n = this.data.length * 3 / 2;
        int[] nArray = new int[n];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        this.data = nArray;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.pos; ++i) {
            if (this.data[i] < 0) continue;
            ++n;
        }
        return n;
    }

    public void writeAll(BufferedWriter bufferedWriter, int n) throws Exception {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(3072);
        String string = null;
        for (int i = 0; i < this.pos; ++i) {
            int n2;
            int n3 = this.data[i];
            if (bl) {
                stringBuffer.append('<');
                bl = false;
            }
            if (n3 >= 0) {
                if (n >= 4) {
                    this.writeHex(stringBuffer, n3 >> 24 & 0xFF);
                }
                if (n >= 3) {
                    this.writeHex(stringBuffer, n3 >> 16 & 0xFF);
                }
                if (n >= 2) {
                    this.writeHex(stringBuffer, n3 >> 8 & 0xFF);
                }
                this.writeHex(stringBuffer, n3 & 0xFF);
                continue;
            }
            stringBuffer.append('>');
            String string2 = stringBuffer.toString();
            if (string2.equals("<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>")) {
                n2 = 10;
            }
            if (string2.equals(string)) {
                bufferedWriter.write("<>");
            } else {
                if (!string2.startsWith("<")) {
                    n2 = 10;
                }
                bufferedWriter.write(string2);
                string = string2;
            }
            bufferedWriter.newLine();
            bl = true;
            stringBuffer.delete(0, stringBuffer.length());
        }
    }

    private void writeHex(StringBuffer stringBuffer, int n) throws Exception {
        String string = Integer.toHexString(n);
        if (string.length() < 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    public void clear() {
        this.data = new int[this.initCap];
        this.pos = 0;
    }
}

