/*
 * Decompiled with CFR 0.152.
 */
package com.vk;

import com.vk.HexWriter;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Img2eps {
    private File input;
    private File output;
    private boolean indexed;
    private BufferedImage img;
    private Vector sortedColors = new Vector();
    private int repeatMark;
    private int lastPixel = -1;
    private int sequenceLen = 1;
    private HexWriter hw;
    private int resolution;
    private double scale = 1.0;
    private BufferedWriter fw;
    private int n;
    private int mod;

    public Img2eps(String string, String string2, int n) throws Exception {
        this.input = new File(string);
        this.output = new File(string2);
        this.mod = n;
        this.doConversion();
    }

    public void doConversion() throws Exception {
        this.img = ImageIO.read(this.input);
        if (this.img != null) {
            int n = this.countUniqueColors();
            this.indexed = n <= 255;
            this.repeatMark = this.indexed ? 255 : 1;
            this.compressContent();
            FileWriter fileWriter = new FileWriter(this.output);
            this.fw = new BufferedWriter(fileWriter);
            this.writeProlog();
            if (this.indexed) {
                this.hw.writeAll(this.fw, 1);
            } else {
                this.hw.writeAll(this.fw, 3);
            }
            this.writeEpilog();
            this.fw.close();
            fileWriter.close();
        } else {
            Img2eps.usage();
        }
    }

    private int countUniqueColors() {
        Integer n;
        int n2;
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        int n3 = this.img.getHeight();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.img.getWidth();
            for (int i = 0; i < n4; ++i) {
                n = new Integer(this.img.getRGB(i, n2) & 0xFFFFFF);
                Integer n5 = (Integer)hashtable.get(n);
                if (n5 == null) {
                    hashtable.put(n, new Integer(1));
                    continue;
                }
                hashtable.put(n, new Integer(n5 + 1));
            }
            if (hashtable.size() > 1024) break;
        }
        if ((n2 = hashtable.size()) <= 255) {
            Set set = hashtable.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                n = (Integer)entry.getKey();
                this.sortedColors.add(n);
            }
        }
        hashtable.clear();
        return n2;
    }

    private void compressContent() throws Exception {
        this.hw = new HexWriter(4096);
        int n = this.img.getHeight();
        for (int i = 0; i < n; ++i) {
            int n2 = this.img.getWidth();
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = this.img.getRGB(j, i) & 0xFFFFFF;
                if (this.indexed) {
                    n3 = this.sortedColors.indexOf(new Integer(n4));
                    if (n3 < 0) {
                        throw new Exception("Internal error!");
                    }
                } else {
                    n3 = n4;
                    if (n3 == 1) {
                        n3 = 0;
                    }
                }
                this.putToCache(n3);
            }
            this.endCaching();
        }
    }

    private void putToCache(int n) throws Exception {
        if (this.lastPixel == -1) {
            this.lastPixel = n;
            return;
        }
        if (n != this.lastPixel) {
            if (this.sequenceLen <= 1) {
                this.hw.putValue(this.lastPixel);
            } else {
                if (this.sequenceLen >= 4) {
                    this.hw.putValue(this.repeatMark);
                    if (this.indexed) {
                        this.hw.putValue(this.sequenceLen >> 8 & 0xFF);
                        this.hw.putValue(this.sequenceLen & 0xFF);
                    } else {
                        this.hw.putValue(this.sequenceLen);
                    }
                    this.hw.putValue(this.lastPixel);
                } else {
                    for (int i = 0; i < this.sequenceLen; ++i) {
                        this.hw.putValue(this.lastPixel);
                    }
                }
                this.sequenceLen = 1;
            }
            this.lastPixel = n;
        } else {
            ++this.sequenceLen;
        }
    }

    private void endCaching() throws Exception {
        if (this.sequenceLen <= 1) {
            this.hw.putValue(this.lastPixel);
        } else if (this.sequenceLen >= 4) {
            this.hw.putValue(this.repeatMark);
            if (this.indexed) {
                this.hw.putValue(this.sequenceLen >> 8 & 0xFF);
                this.hw.putValue(this.sequenceLen & 0xFF);
            } else {
                this.hw.putValue(this.sequenceLen);
            }
            this.hw.putValue(this.lastPixel);
        } else {
            for (int i = 0; i < this.sequenceLen; ++i) {
                this.hw.putValue(this.lastPixel);
            }
        }
        this.sequenceLen = 1;
        this.lastPixel = -1;
        this.hw.newLine();
    }

    private void wr(String string) throws Exception {
        this.fw.write(string);
        this.fw.newLine();
    }

    private String twoDig(int n) {
        String string = Integer.toString(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    private String today() {
        Calendar calendar = Calendar.getInstance();
        return "" + calendar.get(1) + "-" + this.twoDig(calendar.get(2) + 1) + "-" + this.twoDig(calendar.get(5)) + " " + this.twoDig(calendar.get(11)) + ":" + this.twoDig(calendar.get(12)) + ":" + this.twoDig(calendar.get(13));
    }

    private void writeProlog() throws Exception {
        int n = this.img.getWidth();
        int n2 = this.img.getHeight();
        if (this.mod == 0) {
            this.wr("%!PS-Adobe-2.0 EPSF-2.0");
            this.wr("%%Creator: (Img2eps, written by Petr Slechta, modified by Victor Kohn)");
            this.wr("%%CreationDate: (" + this.today() + ")");
            this.wr("%%BoundingBox: 0 0 " + n + " " + n2);
        }
        if (this.indexed) {
            this.wr("/pall [");
            int n3 = this.sortedColors.size();
            for (int i = 0; i < n3; ++i) {
                if (i > 0 && i % 8 == 0) {
                    this.fw.newLine();
                }
                Integer n4 = (Integer)this.sortedColors.get(i);
                String string = Integer.toHexString(n4);
                while (string.length() < 6) {
                    string = "0" + string;
                }
                this.fw.write("<" + string + ">");
            }
            this.fw.newLine();
            this.wr("] def");
        }
        this.wr("/img [");
    }

    private void writeEpilog() throws Exception {
        int n = this.img.getWidth();
        int n2 = this.img.getHeight();
        this.wr("] def");
        this.wr("/lineLen " + n + " 3 mul def  /lineNo 0 def");
        this.wr("/coded 0 def  /codedPos 0 def  /codedMaxPos 0 def");
        if (this.indexed) {
            this.wr("/rd {coded codedPos get  /codedPos codedPos 1 add def} bind def");
        } else {
            this.wr("/rd {coded codedPos 3 getinterval  /codedPos codedPos 3 add def} bind def");
        }
        this.wr("/pixels 0 def  /pixelsPos 0 def");
        if (this.indexed) {
            this.wr("/wr{pall exch get /rgbColor exch def  pixels pixelsPos rgbColor putinterval");
        } else {
            this.wr("/wr{pixels exch pixelsPos exch putinterval");
        }
        this.wr("  /pixelsPos pixelsPos 3 add def} bind def ");
        if (!this.indexed) {
            this.wr("/bin2int {/origStr exch def  origStr 0 get 65536 mul  origStr 1 get 256 mul  origStr 2 get  add  add} bind def");
        }
        this.wr("/pixels lineLen string def");
        this.wr("/decodeLine{/pixelsPos 0 def  /coded img lineNo get def  /codedPos 0 def  /codedMaxPos coded length def");
        this.wr("  {codedPos codedMaxPos eq {/lineNo lineNo 1 add def  pixels exit} if");
        this.wr("    /what rd def");
        if (this.indexed) {
            this.wr("    what 255 eq");
        } else {
            this.wr("    what 0 get 0 eq    what 1 get 0 eq    what 2 get 1 eq    and    and");
        }
        if (this.indexed) {
            this.wr("    {1 1 rd 256 mul rd add");
        } else {
            this.wr("    {1 1 rd bin2int");
        }
        this.wr("      /what rd def  {pop what wr}bind for");
        this.wr("    }{what wr} ifelse");
        this.wr("  } bind loop");
        this.wr("} bind def");
        int n3 = n;
        int n4 = n2;
        this.wr("  gsave");
        this.wr("  " + n3 + " " + n4 + " scale");
        this.wr("  " + n + " " + n2 + " 8 [" + n + " 0 0 -" + n2 + " 0 " + n2 + "] { decodeLine } false 3 colorimage");
        this.wr("  grestore");
        if (this.mod == 0) {
            this.wr("%%Trailer");
        }
    }

    private static void usage() {
        Img2eps.fileFormats();
    }

    private static void fileFormats() {
        System.out.println("Image file format is not supported!");
        System.out.println("Supported file formats:");
        String[] stringArray = ImageIO.getReaderFormatNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            System.out.println("  " + stringArray[i]);
        }
        System.out.println();
    }
}

