/*
 * Decompiled with CFR 0.152.
 */
package com.vk;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;

public class PlaySound
implements Runnable {
    final int bufSize = 16384;
    int num = 0;
    String errStr;
    Vector sounds = new Vector();
    Thread thread;
    Object currentSound;
    Sequencer sequencer;
    Synthesizer synthesizer;
    MidiChannel[] channels;
    int[] val;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public PlaySound(String[] stringArray, int[] nArray) {
        this.val = nArray;
        this.loadJuke(stringArray);
        this.open();
    }

    private void loadJuke(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                this.addSound(file);
            }
        }
        catch (SecurityException securityException) {
            this.reportStatus(securityException.toString());
        }
        catch (Exception exception) {
            this.reportStatus(exception.toString());
        }
    }

    private void addSound(File file) {
        String string = file.getName();
        if (string.endsWith(".au") || string.endsWith(".AU") || string.endsWith(".rmf") || string.endsWith(".RMF") || string.endsWith(".mid") || string.endsWith(".MID") || string.endsWith(".wav") || string.endsWith(".WAV") || string.endsWith(".aif") || string.endsWith(".AIF") || string.endsWith(".aiff") || string.endsWith(".AIFF")) {
            this.sounds.add(file);
        }
    }

    private void open() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer instanceof Synthesizer) {
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
                this.channels = this.synthesizer.getChannels();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void reportStatus(String string) {
        this.errStr = string;
        if (this.errStr != null) {
            System.out.println(this.errStr);
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("Juke");
        this.thread.setPriority(10);
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public void run() {
        while (true) {
            block6: {
                if (this.num < this.sounds.size() && this.thread != null) {
                    if (this.loadSound(this.sounds.get(this.num))) {
                        this.playSound();
                    }
                    try {
                        Thread.sleep(222L);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                    ++this.num;
                    continue;
                }
            }
            this.num = 0;
            if (this.val[2] == 0) {
                this.thread = null;
            }
            if (this.thread == null) break;
        }
        this.thread = null;
        this.currentSound = null;
    }

    private boolean loadSound(Object object) {
        Object object2;
        if (object instanceof File) {
            try {
                this.currentSound = AudioSystem.getAudioInputStream((File)object);
            }
            catch (Exception exception) {
                try {
                    object2 = new FileInputStream((File)object);
                    this.currentSound = new BufferedInputStream((InputStream)object2, 1024);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    this.currentSound = null;
                    return false;
                }
            }
        }
        if (this.sequencer == null) {
            this.currentSound = null;
            return false;
        }
        if (this.currentSound instanceof AudioInputStream) {
            try {
                Object object3;
                AudioInputStream audioInputStream = (AudioInputStream)this.currentSound;
                object2 = audioInputStream.getFormat();
                if (((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ULAW || ((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ALAW) {
                    object3 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object2).getSampleRate(), ((AudioFormat)object2).getSampleSizeInBits() * 2, ((AudioFormat)object2).getChannels(), ((AudioFormat)object2).getFrameSize() * 2, ((AudioFormat)object2).getFrameRate(), true);
                    audioInputStream = AudioSystem.getAudioInputStream((AudioFormat)object3, audioInputStream);
                    object2 = object3;
                }
                object3 = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = PlaySound.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * ((AudioFormat)object2).getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine((Line.Info)object3);
                clip.open(audioInputStream);
                this.currentSound = clip;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentSound = null;
                return false;
            }
        }
        if (this.currentSound instanceof BufferedInputStream) {
            try {
                this.sequencer.open();
                this.sequencer.setSequence((BufferedInputStream)this.currentSound);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.out.println("Unsupported audio file.");
                this.currentSound = null;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentSound = null;
                return false;
            }
        }
        return true;
    }

    private void playSound() {
        this.setGain();
        this.setPan();
        int n = this.val[3];
        if (this.currentSound instanceof BufferedInputStream && this.thread != null) {
            this.sequencer.start();
            while (this.sequencer.isRunning() && this.thread != null) {
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            this.sequencer.stop();
            this.sequencer.close();
        } else if (this.currentSound instanceof Clip && this.thread != null) {
            Clip clip = (Clip)this.currentSound;
            clip.start();
            while (clip.isActive() && this.thread != null) {
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            clip.stop();
            clip.close();
        }
        this.currentSound = null;
    }

    private void setPan() {
        int n = this.val[0];
        if (this.currentSound instanceof Clip) {
            try {
                Clip clip = (Clip)this.currentSound;
                FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.PAN);
                floatControl.setValue((float)n / 100.0f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.currentSound instanceof BufferedInputStream) {
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].controlChange(10, (int)(((double)n + 100.0) / 200.0 * 127.0));
            }
        }
    }

    private void setGain() {
        double d = (double)this.val[1] / 100.0;
        if (this.currentSound instanceof Clip) {
            try {
                Clip clip = (Clip)this.currentSound;
                FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                float f = (float)(Math.log(d == 0.0 ? 1.0E-4 : d) / Math.log(10.0) * 20.0);
                floatControl.setValue(f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.currentSound instanceof BufferedInputStream) {
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].controlChange(7, (int)(d * 127.0));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

