/*
 * Decompiled with CFR 0.152.
 */
package com.vk;

import com.vk.MyPro;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SoundFrame
extends JDialog
implements ActionListener {
    protected boolean ru;
    TargetDataLine line;
    ByteArrayOutputStream out;
    AudioFormat format;
    TimeMon tm = new TimeMon();
    int sr;
    int ss;
    int ch;
    int mo;
    int ifsx;
    int ifsy;
    int ivs1;
    int ivs2;
    int p3;
    int p4;
    double sec;
    String wdir;
    String fin;
    String fie;
    String txt;
    Container pcont;
    Box hbox;
    Box vbox;
    JButton hlp;
    JButton sta;
    JButton sto;
    JButton exi;
    JLabel lab;
    JTextField inpf;
    JTextField inpt;
    AudioFileFormat.Type afft;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    public SoundFrame(String string, int n, int n2, int n3, int[] nArray) {
        this.setLocation(n, n2);
        this.setResizable(false);
        this.setModal(true);
        this.pcont = this.getContentPane();
        this.vbox = Box.createVerticalBox();
        this.ifsx = 30;
        this.ifsy = 20;
        this.ivs1 = 10;
        this.ivs2 = 20;
        this.sr = nArray[0];
        this.ss = nArray[1];
        this.ch = nArray[2];
        this.p3 = nArray[3];
        this.p4 = nArray[4];
        this.wdir = string;
        this.mo = n3;
        if (this.p3 < 1 || this.p3 > 3) {
            this.p3 = 1;
        }
        switch (this.mo) {
            case 1: {
                this.setTitle("Record Sound to File");
                switch (this.p3) {
                    case 1: {
                        this.afft = AudioFileFormat.Type.WAVE;
                        this.fie = ".wav";
                        break;
                    }
                    case 2: {
                        this.afft = AudioFileFormat.Type.AU;
                        this.fie = ".au";
                        break;
                    }
                    case 3: {
                        this.afft = AudioFileFormat.Type.AIFF;
                        this.fie = ".aif";
                    }
                }
                this.hbox = Box.createHorizontalBox();
                this.lab = new JLabel("File name:      ");
                this.hbox.add(this.lab);
                this.inpf = new JTextField("untitled");
                this.hbox.add(this.inpf);
                this.vbox.add(this.hbox);
                this.vbox.add(Box.createVerticalStrut(this.ivs1));
                this.hbox = Box.createHorizontalBox();
                this.lab = new JLabel("Time of recording ( sec. ) :      ");
                this.hbox.add(this.lab);
                this.inpt = new JTextField(" ");
                this.hbox.add(this.inpt);
                this.vbox.add(this.hbox);
                this.vbox.add(Box.createVerticalStrut(this.ivs2));
                this.hbox = Box.createHorizontalBox();
                this.hlp = new JButton("Help");
                this.hlp.setEnabled(true);
                this.hlp.setActionCommand("help");
                this.hlp.addActionListener(this);
                this.hbox.add(this.hlp);
                this.sta = new JButton("Start");
                this.sta.setEnabled(true);
                this.sta.setActionCommand("start");
                this.sta.addActionListener(this);
                this.hbox.add(this.sta);
                this.sto = new JButton("Stop");
                this.sto.setEnabled(false);
                this.sto.setActionCommand("stop");
                this.sto.addActionListener(this);
                this.hbox.add(this.sto);
                this.exi = new JButton("Exit");
                this.exi.setEnabled(true);
                this.exi.setActionCommand("exit");
                this.exi.addActionListener(this);
                this.hbox.add(this.exi);
                this.vbox.add(this.hbox);
                this.pcont.add(Box.createVerticalStrut(this.ifsy), "North");
                this.pcont.add(Box.createHorizontalStrut(this.ifsx), "West");
                this.pcont.add((Component)this.vbox, "Center");
                this.pcont.add(Box.createHorizontalStrut(this.ifsx), "East");
                this.pcont.add(Box.createVerticalStrut(this.ifsy), "South");
                this.pack();
                this.setVisible(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("help".equals(actionEvent.getActionCommand())) {
            JOptionPane.showMessageDialog(MyPro.parent(), MyPro.txt, "Help Info", 1);
        } else if ("start".equals(actionEvent.getActionCommand())) {
            this.sta.setEnabled(false);
            this.sto.setEnabled(true);
            this.exi.setEnabled(false);
            this.hlp.setEnabled(false);
            this.captureAudio();
            this.tm.start();
        } else if ("stop".equals(actionEvent.getActionCommand())) {
            this.sta.setEnabled(true);
            this.sto.setEnabled(false);
            this.exi.setEnabled(true);
            this.hlp.setEnabled(true);
            this.ru = false;
            this.tm.stop();
        } else if ("exit".equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void captureAudio() {
        try {
            this.format = this.getFormat();
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = SoundFrame.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, this.format);
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(this.format);
            this.line.start();
            Runnable runnable = new Runnable(){
                int bufSize;
                byte[] buf;
                {
                    this.bufSize = (int)SoundFrame.this.format.getSampleRate() * SoundFrame.this.format.getFrameSize();
                    this.buf = new byte[this.bufSize];
                }

                public void run() {
                    SoundFrame.this.out = new ByteArrayOutputStream();
                    SoundFrame.this.ru = true;
                    try {
                        while (SoundFrame.this.ru) {
                            int n = SoundFrame.this.line.read(this.buf, 0, this.buf.length);
                            if (n <= 0) continue;
                            if (SoundFrame.this.p4 != 100) {
                                int n2;
                                int n3;
                                if (SoundFrame.this.format.getFrameSize() == 1) {
                                    for (n3 = 0; n3 < n; ++n3) {
                                        n2 = this.buf[n3];
                                        if (n2 < 0) {
                                            n2 = (short)(n2 + 256);
                                        }
                                        if ((n2 = (short)(n2 * SoundFrame.this.p4 / 100)) > 255) {
                                            n2 = 255;
                                        }
                                        if (n2 > 127) {
                                            n2 = (short)(n2 - 256);
                                        }
                                        this.buf[n3] = (byte)n2;
                                    }
                                }
                                if (SoundFrame.this.format.getFrameSize() == 2) {
                                    for (n3 = 0; n3 < n; n3 += 2) {
                                        n2 = this.buf[n3];
                                        if (n2 < 0) {
                                            n2 = (short)(n2 + 256);
                                        }
                                        int n4 = n2 * 256;
                                        n2 = this.buf[n3 + 1];
                                        if (n2 < 0) {
                                            n2 = (short)(n2 + 256);
                                        }
                                        n4 += n2;
                                        n4 = n4 * SoundFrame.this.p4 / 100;
                                        n2 = (short)(n4 / 256);
                                        short s = (short)(n4 - n2 * 256);
                                        if (n2 > 127) {
                                            n2 = (short)(n2 - 256);
                                        }
                                        this.buf[n3] = (byte)n2;
                                        if (s > 127) {
                                            s = (short)(s - 256);
                                        }
                                        this.buf[n3 + 1] = (byte)s;
                                    }
                                }
                            }
                            SoundFrame.this.out.write(this.buf, 0, n);
                        }
                        SoundFrame.this.line.stop();
                        SoundFrame.this.line.close();
                        SoundFrame.this.out.flush();
                        SoundFrame.this.out.close();
                        SoundFrame.this.fin = SoundFrame.this.inpf.getText().trim() + SoundFrame.this.fie;
                        if (SoundFrame.this.wdir != null) {
                            SoundFrame.this.fin = SoundFrame.this.wdir + "/" + SoundFrame.this.fin;
                        }
                        SoundFrame.this.saveToFile(SoundFrame.this.fin, SoundFrame.this.afft);
                    }
                    catch (IOException iOException) {
                        System.err.println("I/O problems: " + iOException);
                        return;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("Line unavailable: " + lineUnavailableException);
            return;
        }
    }

    private AudioFormat getFormat() {
        float f = this.sr;
        int n = this.ss;
        int n2 = this.ch;
        boolean bl = true;
        boolean bl2 = true;
        return new AudioFormat(f, n, n2, bl, bl2);
    }

    private void saveToFile(String string, AudioFileFormat.Type type) {
        byte[] byArray = this.out.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.format = this.getFormat();
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, this.format, byArray.length / this.format.getFrameSize());
        if (audioInputStream == null) {
            return;
        }
        File file = new File(string);
        try {
            if (AudioSystem.write(audioInputStream, type, file) == -1) {
                throw new IOException("Problems writing to file");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TimeMon
    implements Runnable {
        private Thread thread;

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            SoundFrame.this.sec = 0.0;
            SoundFrame.this.inpt.setText(String.valueOf(SoundFrame.this.sec));
            block4: while (SoundFrame.this.ru) {
                if (SoundFrame.this.line != null && SoundFrame.this.line.isActive()) {
                    long l = SoundFrame.this.line.getMicrosecondPosition() / 1000L;
                    SoundFrame.this.sec = (double)l / 1000.0;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    break;
                }
                SoundFrame.this.inpt.setText(String.valueOf(SoundFrame.this.sec));
                while (SoundFrame.this.line != null && !SoundFrame.this.line.isActive()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        continue block4;
                    }
                }
            }
        }
    }
}

