/*
 * Decompiled with CFR 0.152.
 */
package ru.amprograms.spellChecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import ru.amprograms.spellChecker.Alphabet;
import ru.amprograms.spellChecker.DicLoader;
import ru.amprograms.spellChecker.LineParser;
import ru.amprograms.spellChecker.Word;

public class DictinaryCreator {
    private HashSet<String> words = null;
    private File setFile = null;

    public DictinaryCreator(File file) throws IOException {
        this.setFile = file;
        this.words = DicLoader.loadSet(this.setFile);
    }

    public void save() throws IOException {
        DicLoader.saveSet(this.words, this.setFile);
    }

    public void loadBook(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                DictinaryCreator.parseLine(line, this.words);
            }
        }
        finally {
            in.close();
        }
    }

    public static void parseLine(String line, HashSet<String> set) {
        LineParser parser = new LineParser();
        parser.setString(line);
        Word w = parser.nextWord();
        while (w != null) {
            if (Alphabet.hasLetters(w.getWord())) {
                set.add(w.getWord().toUpperCase().trim());
            }
            w = parser.nextWord();
        }
    }

    public static void removeWords(String line, HashSet<String> set) {
        String[] sa;
        String[] stringArray = sa = line.split("\\W");
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            set.remove(s.toUpperCase().trim());
            ++n2;
        }
        LineParser parser = new LineParser();
        parser.setString(line);
        Word w = parser.nextWord();
        while (w != null) {
            if (Alphabet.hasLetters(w.getWord())) {
                set.remove(w.getWord().toUpperCase().trim());
            }
            w = parser.nextWord();
        }
    }
}

