/*
 * Decompiled with CFR 0.152.
 */
package ru.amprograms.spellChecker;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import ru.amprograms.spellChecker.Alphabet;
import ru.amprograms.spellChecker.LineParser;
import ru.amprograms.spellChecker.Word;
import ru.amprograms.spellChecker.WrongComponent;

public class SpellChecker {
    public static final String delimiters = "\n ,.;:(){}[]!?-\\|/><+=_*&^%$#@\u00ab\"\u00bb\u2026\u201e\u201c\u201d";
    public static final String delimitersRegEx = "\\W";
    private static Logger log = null;
    private HashSet<String> dic = null;
    private LineParser parser = null;
    private JTextComponent component = null;
    private Highlighter.HighlightPainter painter = null;
    private DocListener dl = null;
    private boolean checkEnabled = true;

    public static void setLogger(Logger logger) {
        log = logger;
    }

    public SpellChecker(HashSet<String> dic, JTextComponent component) {
        this.dic = dic;
        this.parser = new LineParser();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(-13108));
        this.component = component;
        this.dl = new DocListener();
        component.getDocument().addDocumentListener(this.dl);
    }

    public void removeDocListener() {
        this.component.getDocument().removeDocumentListener(this.dl);
    }

    public void setDocListener(JTextComponent component) throws WrongComponent {
        if (component != this.component) {
            throw new WrongComponent();
        }
        component.getDocument().removeDocumentListener(this.dl);
        component.getDocument().addDocumentListener(this.dl);
    }

    public boolean check(String str) {
        if (Alphabet.hasLetters(str)) {
            return this.dic.contains(str.toUpperCase().trim());
        }
        return true;
    }

    public static int getDelimeterIndex(String str, int fromIndex) {
        int i = fromIndex;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (delimiters.indexOf(c) >= 0) {
                return i;
            }
            ++i;
        }
        return str.length();
    }

    private int getDelimeterIndexDesc(String str, int fromIndex) {
        int i = fromIndex - 1;
        while (i >= 0) {
            char c = str.charAt(i);
            if (delimiters.indexOf(c) >= 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void checkText() throws BadLocationException {
        int b = 0;
        int e = this.component.getDocument().getLength();
        String s = this.component.getDocument().getText(b, e);
        this.parser.setString(s);
        Word w = this.parser.nextWord();
        while (w != null) {
            this.processWord(w, b);
            w = this.parser.nextWord();
        }
    }

    private void check(DocumentEvent event) throws BadLocationException {
        int b = 0;
        int e = event.getDocument().getLength();
        String ds = event.getDocument().getText(b, e);
        b = this.getDelimeterIndexDesc(ds, event.getOffset()) + 1;
        e = SpellChecker.getDelimeterIndex(ds, event.getOffset() + event.getLength());
        String s = event.getDocument().getText(b, e - b);
        this.parser.setString(s);
        Word w = this.parser.nextWord();
        while (w != null) {
            this.processWord(w, b);
            w = this.parser.nextWord();
        }
    }

    private void processWord(Word word, int offset) {
        ArrayList<Highlighter.Highlight> a = this.getHighlights(word.getStart() + offset, word.getEnd() + offset);
        for (Highlighter.Highlight h : a) {
            this.removeHighlight(h);
        }
        if (!this.check(word.getWord())) {
            this.AddHighlight(word, offset);
        }
    }

    private synchronized void removeHighlight(Highlighter.Highlight h) {
        this.component.getHighlighter().removeHighlight(h);
    }

    private synchronized void AddHighlight(Word word, int offset) {
        block2: {
            try {
                this.component.getHighlighter().addHighlight(word.getStart() + offset, word.getEnd() + offset, this.painter);
            }
            catch (BadLocationException e) {
                if (log == null) break block2;
                log.log(Level.WARNING, "add highlight", e);
            }
        }
    }

    private ArrayList<Highlighter.Highlight> getHighlights(int begin, int end) {
        ArrayList<Highlighter.Highlight> array = new ArrayList<Highlighter.Highlight>();
        Highlighter.Highlight[] ha = this.component.getHighlighter().getHighlights();
        int i = 0;
        while (i < ha.length) {
            Highlighter.Highlight h = ha[i];
            int b = h.getStartOffset();
            int e = h.getEndOffset();
            if (b >= begin && b <= end || e >= begin && e <= end || begin >= b && begin <= e || end >= b && end <= e) {
                array.add(h);
            }
            ++i;
        }
        return array;
    }

    public boolean isCheckEnabled() {
        return this.checkEnabled;
    }

    public void setCheckEnabled(boolean checkEnabled) throws BadLocationException {
        this.checkEnabled = checkEnabled;
        if (checkEnabled) {
            this.checkText();
        } else {
            this.removeSelection();
        }
    }

    private void removeSelection() {
        Highlighter.Highlight[] a;
        Highlighter.Highlight[] highlightArray = a = this.component.getHighlighter().getHighlights();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Highlighter.Highlight h = highlightArray[n2];
            this.component.getHighlighter().removeHighlight(h);
            ++n2;
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        private void ch(DocumentEvent event) {
            final DocumentEvent e = event;
            Runnable thread = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            SpellChecker.this.check(e);
                        }
                        catch (BadLocationException e2) {
                            if (log == null) break block2;
                            log.log(Level.WARNING, "check", e2);
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(thread);
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            if (SpellChecker.this.checkEnabled) {
                this.ch(arg0);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            if (SpellChecker.this.checkEnabled) {
                this.ch(arg0);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            if (SpellChecker.this.checkEnabled) {
                this.ch(arg0);
            }
        }
    }
}

