/*
 * Decompiled with CFR 0.152.
 */
package ru.amprograms.spellChecker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import ru.amprograms.spellChecker.DicIsNull;
import ru.amprograms.spellChecker.DicLoader;
import ru.amprograms.spellChecker.DictinaryCreator;
import ru.amprograms.spellChecker.SpellChecker;

public class SpellFacade {
    private static HashSet<String> dic = null;
    private static File file = null;
    private static ArrayList<SpellChecker> checkers = new ArrayList();

    public static void loadDic(File fileDic) throws IOException {
        dic = DicLoader.loadSet(fileDic);
        file = fileDic;
    }

    public static SpellChecker addSpellChecker(JTextComponent component) throws DicIsNull {
        if (dic != null) {
            SpellChecker sc = new SpellChecker(dic, component);
            checkers.add(sc);
            return sc;
        }
        throw new DicIsNull();
    }

    public static void removeSpellChecker(SpellChecker spellChecker) {
        spellChecker.removeDocListener();
        checkers.remove(spellChecker);
    }

    public static void addWords(String words) throws DicIsNull, IOException, BadLocationException {
        if (dic != null) {
            DictinaryCreator.parseLine(words, dic);
            DicLoader.saveSet(dic, file);
            for (SpellChecker spellChecker : checkers) {
                spellChecker.checkText();
            }
        } else {
            throw new DicIsNull();
        }
    }

    public static void removeWords(String words) throws DicIsNull, IOException, BadLocationException {
        if (dic != null) {
            DictinaryCreator.removeWords(words, dic);
            DicLoader.saveSet(dic, file);
            for (SpellChecker spellChecker : checkers) {
                spellChecker.checkText();
            }
        } else {
            throw new DicIsNull();
        }
    }

    public static void setCheckEnabled(boolean checkEnabled) throws BadLocationException {
        for (SpellChecker spellChecker : checkers) {
            if (spellChecker.isCheckEnabled() == checkEnabled) continue;
            spellChecker.setCheckEnabled(checkEnabled);
        }
    }
}

